/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DHTTransport;
import edu.jas.util.DHTTransportClear;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DHTBroadcaster<K>
extends Thread {
    private static final Logger logger = LogManager.getLogger(DHTBroadcaster.class);
    private final SocketChannel channel;
    private final List<DHTBroadcaster<K>> bcaster;
    private final SortedMap<K, DHTTransport> theList;
    volatile boolean goon = true;

    public DHTBroadcaster(SocketChannel socketChannel, List<DHTBroadcaster<K>> list, SortedMap<K, DHTTransport> sortedMap) {
        this.channel = socketChannel;
        this.bcaster = list;
        this.theList = sortedMap;
    }

    public void closeChannel() {
        this.channel.close();
    }

    public void sendChannel(DHTTransport dHTTransport) throws IOException {
        if (this.goon) {
            this.channel.send(dHTTransport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(DHTTransport dHTTransport) {
        if (logger.isDebugEnabled()) {
            logger.debug("broadcast = " + dHTTransport);
        }
        DHTTransport dHTTransport2 = null;
        if (dHTTransport == null) {
            return;
        }
        dHTTransport2 = dHTTransport;
        Object k = null;
        Object object = this.theList;
        synchronized (object) {
            try {
                if (!(dHTTransport instanceof DHTTransportClear)) {
                    k = dHTTransport2.key();
                    this.theList.put(k, dHTTransport2);
                }
            }
            catch (IOException iOException) {
                logger.warn("IO exception: tc.key() not ok " + dHTTransport2);
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.warn("CNF exception: tc.key() not ok " + dHTTransport2);
                classNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                logger.warn("exception: tc.key() not ok " + dHTTransport2);
                exception.printStackTrace();
            }
        }
        logger.info("sending key=" + k + " to " + this.bcaster.size() + " nodes");
        object = null;
        Object object2 = this.bcaster;
        synchronized (object2) {
            object = new ArrayList<DHTBroadcaster<K>>(this.bcaster);
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            DHTBroadcaster dHTBroadcaster = (DHTBroadcaster)object2.next();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("bcasting to " + dHTBroadcaster);
                }
                dHTBroadcaster.sendChannel(dHTTransport2);
            }
            catch (IOException iOException) {
                logger.info("bcaster, IOexception " + iOException);
                List<DHTBroadcaster<K>> list = this.bcaster;
                synchronized (list) {
                    this.bcaster.remove(dHTBroadcaster);
                }
                try {
                    dHTBroadcaster.goon = false;
                    dHTBroadcaster.closeChannel();
                    while (dHTBroadcaster.isAlive()) {
                        dHTBroadcaster.interrupt();
                        dHTBroadcaster.join(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                logger.info("bcaster.remove() " + dHTBroadcaster);
            }
            catch (Exception exception) {
                logger.info("bcaster, exception " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.goon = true;
        while (this.goon) {
            try {
                Object object2;
                logger.debug("trying to receive");
                object = this.channel.receive();
                if (this.isInterrupted()) {
                    this.goon = false;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("received = " + object);
                }
                if (!(object instanceof DHTTransport)) {
                    logger.warn("wrong object type: " + object);
                    this.goon = false;
                    break;
                }
                if (object instanceof DHTTransportClear) {
                    logger.info("receive, clear");
                    object2 = this.theList;
                    synchronized (object2) {
                        this.theList.clear();
                        this.theList.notifyAll();
                    }
                }
                object2 = (DHTTransport)object;
                this.broadcast((DHTTransport)object2);
                if (!this.isInterrupted()) continue;
                this.goon = false;
            }
            catch (IOException iOException) {
                this.goon = false;
                logger.info("receive, IO exception " + iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.goon = false;
                logger.info("receive, CNF exception " + classNotFoundException);
                classNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                this.goon = false;
                logger.info("receive, exception " + exception);
                exception.printStackTrace();
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("ending " + this);
        }
        object = this.bcaster;
        synchronized (object) {
            this.bcaster.remove(this);
        }
        this.channel.close();
    }

    @Override
    public String toString() {
        return "DHTBroadcaster(" + this.channel + "," + this.bcaster.size() + ")";
    }
}

