/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DHTTransport;
import edu.jas.util.DHTTransportClear;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DHTListener<K, V>
extends Thread {
    private static final Logger logger = LogManager.getLogger(DHTListener.class);
    private static final boolean debug = logger.isDebugEnabled();
    private final SocketChannel channel;
    private final SortedMap<K, V> theList;
    private boolean goon;

    DHTListener(SocketChannel socketChannel, SortedMap<K, V> sortedMap) {
        this.channel = socketChannel;
        this.theList = sortedMap;
        this.goon = true;
    }

    boolean isDone() {
        return !this.goon;
    }

    void setDone() {
        this.goon = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("running ");
        while (this.goon) {
            DHTTransport dHTTransport = null;
            Object object = null;
            try {
                SortedMap<K, V> sortedMap;
                object = this.channel.receive();
                if (debug) {
                    logger.debug("receive(" + object + ")");
                }
                if (this.isInterrupted()) {
                    this.goon = false;
                    break;
                }
                if (object == null) {
                    this.goon = false;
                    break;
                }
                if (object instanceof DHTTransportClear) {
                    logger.debug("receive, clear");
                    sortedMap = this.theList;
                    synchronized (sortedMap) {
                        this.theList.clear();
                        this.theList.notifyAll();
                        continue;
                    }
                }
                if (!(object instanceof DHTTransport) || (sortedMap = (dHTTransport = (DHTTransport)object).key()) == null) continue;
                logger.info("receive, put(key=" + sortedMap + ")");
                Object v = dHTTransport.value();
                SortedMap<K, V> sortedMap2 = this.theList;
                synchronized (sortedMap2) {
                    this.theList.put(sortedMap, v);
                    this.theList.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.goon = false;
                logger.info("receive, IO exception " + iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.goon = false;
                logger.info("receive, CNF exception " + classNotFoundException);
                classNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                this.goon = false;
                logger.info("receive, exception " + exception);
                exception.printStackTrace();
            }
        }
    }
}

