/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.Ideal;
import edu.jas.gbufd.MultiplicativeSet;
import edu.jas.gbufd.MultiplicativeSetSquarefree;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Condition<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(Condition.class);
    public final Ideal<C> zero;
    public final MultiplicativeSet<C> nonZero;

    public Condition(GenPolynomialRing<C> genPolynomialRing) {
        this(new Ideal<C>(genPolynomialRing), new MultiplicativeSetSquarefree<C>(genPolynomialRing));
    }

    public Condition(Ideal<C> ideal) {
        this(ideal, new MultiplicativeSetSquarefree(ideal.list.ring));
    }

    public Condition(MultiplicativeSet<C> multiplicativeSet) {
        this(new Ideal(multiplicativeSet.ring), multiplicativeSet);
    }

    public Condition(Ideal<C> ideal, MultiplicativeSet<C> multiplicativeSet) {
        if (ideal == null || multiplicativeSet == null) {
            throw new IllegalArgumentException("only for non null condition parts");
        }
        this.zero = ideal;
        this.nonZero = multiplicativeSet;
    }

    public String toString() {
        return "Condition[ 0 == " + this.zero.getList().toString() + ", 0 != " + this.nonZero.mset.toString() + " ]";
    }

    public String toScript() {
        return "Condition[ 0 == " + this.zero.getList().toString() + ", 0 != " + this.nonZero.mset.toString() + " ]";
    }

    public boolean equals(Object object) {
        Condition condition = null;
        try {
            condition = (Condition)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (condition == null) {
            return false;
        }
        if (!this.zero.equals(condition.zero)) {
            return false;
        }
        return this.nonZero.equals(condition.nonZero);
    }

    public int hashCode() {
        int n = this.zero.getList().hashCode();
        n <<= 17;
        return n += this.nonZero.hashCode();
    }

    public boolean isEmpty() {
        return this.zero.isZERO() && this.nonZero.isEmpty();
    }

    public boolean isContradictory() {
        if (this.zero.isZERO()) {
            return false;
        }
        boolean bl = this.zero.isONE();
        if (bl) {
            logger.info("contradiction zero.isONE(): " + this);
            return bl;
        }
        for (GenPolynomial<C> genPolynomial : this.zero.getList()) {
            bl = this.nonZero.contains(genPolynomial);
            if (!bl) continue;
            logger.info("contradiction nonZero.contains(zero): " + this + ", pol = " + genPolynomial);
            return bl;
        }
        for (GenPolynomial<C> genPolynomial : this.nonZero.mset) {
            bl = this.zero.contains(genPolynomial);
            if (!bl) continue;
            logger.info("contradiction zero.contains(nonZero): " + this + ", pol = " + genPolynomial);
            return bl;
        }
        return false;
    }

    public Condition<C> extendZero(GenPolynomial<C> genPolynomial) {
        genPolynomial = genPolynomial.monic();
        Ideal<C> ideal = this.zero.sum(genPolynomial);
        logger.info("added to ideal: " + genPolynomial);
        Condition<C> condition = new Condition<C>(ideal, this.nonZero);
        return condition.simplify();
    }

    public Condition<C> extendNonZero(GenPolynomial<C> genPolynomial) {
        GenPolynomial<C> genPolynomial2 = this.zero.normalform(genPolynomial).monic();
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return this;
        }
        MultiplicativeSet<C> multiplicativeSet = this.nonZero.add(genPolynomial2);
        logger.info("added to non zero: " + genPolynomial2);
        Condition<C> condition = new Condition<C>(this.zero, multiplicativeSet);
        return condition.simplify();
    }

    public Condition<C> simplify() {
        Condition<C> condition;
        List<GenPolynomial<C>> list;
        Ideal ideal = this.zero.squarefree();
        if (!ideal.getList().equals(this.zero.getList())) {
            logger.info("simplify squarefree: " + this.zero.getList() + " to " + ideal.getList());
        }
        List<GenPolynomial<C>> list2 = ideal.normalform(this.nonZero.mset);
        MultiplicativeSet<C> multiplicativeSet = this.nonZero;
        if (!list2.equals(this.nonZero.mset)) {
            if (list2.size() != this.nonZero.mset.size()) {
                logger.info("contradiction(==0):");
                logger.info("simplify normalform contradiction: " + this.nonZero.mset + " to " + list2);
                return null;
            }
            logger.info("simplify normalform: " + this.nonZero.mset + " to " + list2);
            multiplicativeSet = this.nonZero.replace(list2);
        }
        if (!(list = multiplicativeSet.removeFactors(ideal.getList())).equals(ideal.getList())) {
            if (list.size() != ideal.getList().size()) {
                logger.info("contradiction(!=0):");
                logger.info("simplify removeFactors contradiction: " + ideal.getList() + " to " + list);
                return null;
            }
            logger.info("simplify removeFactors: " + ideal.getList() + " to " + list);
            ideal = new Ideal<C>(this.zero.getRing(), list);
        }
        if ((condition = new Condition<C>(ideal, multiplicativeSet)).isContradictory()) {
            logger.info("simplify contradiction: " + condition);
            return null;
        }
        if (ideal.equals(this.zero) && multiplicativeSet.equals(this.nonZero)) {
            return this;
        }
        logger.info("condition simplified: " + this + " to " + condition);
        return condition.simplify();
    }

    public Color color(GenPolynomial<C> genPolynomial) {
        GenPolynomial<C> genPolynomial2 = this.zero.normalform(genPolynomial).monic();
        if (genPolynomial2.isZERO()) {
            return Color.GREEN;
        }
        if (genPolynomial2.isConstant()) {
            return Color.RED;
        }
        if (this.nonZero.contains(genPolynomial2) || this.nonZero.contains(genPolynomial)) {
            return Color.RED;
        }
        return Color.WHITE;
    }

    public ColorPolynomial<C> determine(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>> genPolynomial2;
        ColorPolynomial colorPolynomial = null;
        if (genPolynomial == null) {
            return colorPolynomial;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>> genPolynomial3 = genPolynomial2 = genPolynomial.ring.getZERO();
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>> genPolynomial4 = genPolynomial2;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>> genPolynomial5 = genPolynomial2;
        if (genPolynomial.isZERO()) {
            colorPolynomial = new ColorPolynomial(genPolynomial3, genPolynomial4, genPolynomial5);
            return colorPolynomial;
        }
        GenPolynomial<GenPolynomial<Object>> genPolynomial6 = genPolynomial;
        block4: while (!genPolynomial6.isZERO()) {
            Map.Entry<ExpVector, GenPolynomial<C>> entry = genPolynomial6.leadingMonomial();
            ExpVector expVector = entry.getKey();
            GenPolynomial<C> genPolynomial7 = entry.getValue();
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial8 = genPolynomial6.reductum();
            switch (this.color(genPolynomial7)) {
                case GREEN: {
                    genPolynomial3 = genPolynomial3.sum(genPolynomial7, expVector);
                    genPolynomial6 = genPolynomial8;
                    continue block4;
                }
                case RED: {
                    genPolynomial4 = genPolynomial4.sum(genPolynomial7, expVector);
                    genPolynomial5 = genPolynomial8;
                    return new ColorPolynomial<C>(genPolynomial3, genPolynomial4, genPolynomial5);
                }
            }
            logger.info("recheck undetermined coeff c = " + genPolynomial7 + ", cond = " + this);
            if (this.extendZero(genPolynomial7) == null) {
                logger.info("recheck assume red");
                genPolynomial4 = genPolynomial4.sum(genPolynomial7, expVector);
                genPolynomial5 = genPolynomial8;
                return new ColorPolynomial<C>(genPolynomial3, genPolynomial4, genPolynomial5);
            }
            if (this.extendNonZero(genPolynomial7) == null) {
                logger.info("recheck assume green");
                genPolynomial3 = genPolynomial3.sum(genPolynomial7, expVector);
                genPolynomial6 = genPolynomial8;
                continue;
            }
            System.out.println("undetermined cond       = " + this);
            System.out.println("undetermined poly     A = " + genPolynomial);
            System.out.println("undetermined poly green = " + genPolynomial3);
            System.out.println("undetermined poly   red = " + genPolynomial4);
            System.out.println("undetermined poly    Bp = " + genPolynomial8);
            System.out.println("undetermined coeff    c = " + genPolynomial7);
            throw new RuntimeException("undetermined, c is white = " + genPolynomial7);
        }
        colorPolynomial = new ColorPolynomial(genPolynomial3, genPolynomial4, genPolynomial5);
        return colorPolynomial;
    }

    public List<ColorPolynomial<C>> determine(List<GenPolynomial<GenPolynomial<C>>> list) {
        ArrayList<ColorPolynomial<C>> arrayList = null;
        if (list == null) {
            return arrayList;
        }
        arrayList = new ArrayList<ColorPolynomial<C>>(list.size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : list) {
            ColorPolynomial<C> colorPolynomial = this.determine(genPolynomial);
            if (colorPolynomial == null || colorPolynomial.isZERO()) continue;
            arrayList.add(colorPolynomial);
        }
        return arrayList;
    }

    public ColorPolynomial<C> reDetermine(ColorPolynomial<C> colorPolynomial) {
        ColorPolynomial<C> colorPolynomial2 = this.determine(colorPolynomial.getEssentialPolynomial());
        GenPolynomial genPolynomial = colorPolynomial.green.sum(colorPolynomial2.green);
        colorPolynomial2 = new ColorPolynomial(genPolynomial, colorPolynomial2.red, colorPolynomial2.white);
        return colorPolynomial2;
    }

    public List<ColorPolynomial<C>> reDetermine(List<ColorPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<ColorPolynomial<C>> arrayList = new ArrayList<ColorPolynomial<C>>();
        for (ColorPolynomial<C> colorPolynomial : list) {
            ColorPolynomial<C> colorPolynomial2 = this.reDetermine(colorPolynomial);
            arrayList.add(colorPolynomial2);
        }
        return arrayList;
    }

    public boolean isDetermined(ColorPolynomial<C> colorPolynomial) {
        ColorPolynomial<C> colorPolynomial2 = this.determine(colorPolynomial.getPolynomial());
        boolean bl = colorPolynomial2.equals(colorPolynomial);
        if (!bl) {
            System.out.println("not determined s    = " + colorPolynomial);
            System.out.println("not determined p    = " + colorPolynomial2);
            System.out.println("not determined cond = " + this);
        }
        return bl;
    }

    public boolean isDetermined(List<ColorPolynomial<C>> list) {
        if (list == null) {
            return true;
        }
        for (ColorPolynomial<C> colorPolynomial : list) {
            if (this.isDetermined(colorPolynomial)) continue;
            return false;
        }
        return true;
    }

    public static enum Color {
        GREEN,
        RED,
        WHITE;

    }
}

