/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ResidueSolvableWordPolynomialRing;
import edu.jas.application.WordResidue;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.RecSolvableWordPolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.GcdRingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResidueSolvableWordPolynomial<C extends GcdRingElem<C>>
extends GenSolvablePolynomial<WordResidue<C>> {
    public final ResidueSolvableWordPolynomialRing<C> ring;
    private static final Logger logger = LogManager.getLogger(ResidueSolvableWordPolynomial.class);
    private static final boolean debug = logger.isDebugEnabled();

    public ResidueSolvableWordPolynomial(ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing) {
        super(residueSolvableWordPolynomialRing);
        this.ring = residueSolvableWordPolynomialRing;
    }

    public ResidueSolvableWordPolynomial(ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing, ExpVector expVector) {
        this(residueSolvableWordPolynomialRing);
        this.val.put(expVector, (WordResidue)this.ring.getONECoefficient());
    }

    public ResidueSolvableWordPolynomial(ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing, WordResidue<C> wordResidue, ExpVector expVector) {
        this(residueSolvableWordPolynomialRing);
        if (wordResidue != null && !wordResidue.isZERO()) {
            this.val.put(expVector, wordResidue);
        }
    }

    public ResidueSolvableWordPolynomial(ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing, WordResidue<C> wordResidue) {
        this(residueSolvableWordPolynomialRing, wordResidue, residueSolvableWordPolynomialRing.evzero);
    }

    public ResidueSolvableWordPolynomial(ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing, GenSolvablePolynomial<WordResidue<C>> genSolvablePolynomial) {
        this(residueSolvableWordPolynomialRing, genSolvablePolynomial.getMap());
    }

    protected ResidueSolvableWordPolynomial(ResidueSolvableWordPolynomialRing<C> residueSolvableWordPolynomialRing, SortedMap<ExpVector, WordResidue<C>> sortedMap) {
        this(residueSolvableWordPolynomialRing);
        this.val.putAll(sortedMap);
    }

    @Override
    public ResidueSolvableWordPolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> copy() {
        return new ResidueSolvableWordPolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ResidueSolvableWordPolynomial)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial) {
        if (residueSolvableWordPolynomial == null || residueSolvableWordPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == residueSolvableWordPolynomial.ring.nvar);
        if (debug) {
            logger.debug("ring = " + this.ring);
        }
        ExpVector expVector = this.ring.evzero;
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
        GenSolvablePolynomial genSolvablePolynomial2 = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
        WordResidue wordResidue = (WordResidue)this.ring.getONECoefficient();
        SortedMap sortedMap = this.val;
        SortedMap sortedMap2 = residueSolvableWordPolynomial.val;
        Set set = sortedMap2.entrySet();
        for (Map.Entry entry : sortedMap.entrySet()) {
            WordResidue wordResidue2 = (WordResidue)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            if (debug) {
                logger.info("e = " + expVector2 + ", a = " + wordResidue2);
            }
            for (Map.Entry entry2 : set) {
                GenSolvablePolynomial genSolvablePolynomial3;
                GenSolvablePolynomial genSolvablePolynomial4;
                GenSolvablePolynomial genSolvablePolynomial5;
                WordResidue wordResidue3 = (WordResidue)entry2.getValue();
                ExpVector expVector3 = (ExpVector)entry2.getKey();
                if (debug) {
                    logger.info("f = " + expVector3 + ", b = " + wordResidue3);
                }
                int[] nArray = expVector3.dependencyOnVariables();
                int n = 0;
                if (nArray.length > 0) {
                    n = nArray[nArray.length - 1];
                }
                int n2 = this.ring.nvar + 1 - n;
                ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial2 = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
                if (this.ring.polCoeff.coeffTable.isEmpty() || wordResidue3.isConstant() || expVector2.isZERO()) {
                    residueSolvableWordPolynomial2 = new ResidueSolvableWordPolynomial<C>(this.ring, wordResidue3, expVector2);
                    if (debug) {
                        logger.info("symmetric coeff: b = " + wordResidue3 + ", e = " + expVector2);
                    }
                } else {
                    if (debug) {
                        logger.info("unsymmetric coeff: b = " + wordResidue3 + ", e = " + expVector2);
                    }
                    genSolvablePolynomial5 = new RecSolvableWordPolynomial(this.ring.polCoeff, expVector2);
                    genSolvablePolynomial4 = new RecSolvableWordPolynomial(this.ring.polCoeff, wordResidue3.val);
                    genSolvablePolynomial3 = ((RecSolvableWordPolynomial)genSolvablePolynomial5).multiply(genSolvablePolynomial4);
                    residueSolvableWordPolynomial2 = this.ring.fromPolyCoefficients(genSolvablePolynomial3);
                }
                if (debug) {
                    logger.info("coeff-poly: Cps = " + residueSolvableWordPolynomial2);
                }
                genSolvablePolynomial5 = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
                genSolvablePolynomial4 = null;
                if (this.ring.table.isEmpty() || residueSolvableWordPolynomial2.isConstant() || expVector3.isZERO()) {
                    if (debug) {
                        logger.info("symmetric poly: b = " + wordResidue3 + ", e = " + expVector2);
                    }
                    ExpVector expVector4 = expVector2.sum(expVector3);
                    genSolvablePolynomial4 = residueSolvableWordPolynomial2.isConstant() ? new ResidueSolvableWordPolynomial<C>(this.ring, (WordResidue)residueSolvableWordPolynomial2.leadingBaseCoefficient(), expVector4) : residueSolvableWordPolynomial2.shift(expVector3);
                } else {
                    if (debug) {
                        logger.info("unsymmetric poly: Cps = " + residueSolvableWordPolynomial2 + ", f = " + expVector3);
                    }
                    for (Map.Entry entry3 : residueSolvableWordPolynomial2.val.entrySet()) {
                        ExpVector expVector5;
                        int n3;
                        WordResidue wordResidue4 = (WordResidue)entry3.getValue();
                        ExpVector expVector6 = (ExpVector)entry3.getKey();
                        if (debug) {
                            logger.info("g = " + expVector6 + ", c = " + wordResidue4);
                        }
                        int[] nArray2 = expVector6.dependencyOnVariables();
                        int n4 = this.ring.nvar + 1;
                        if (nArray2.length > 0) {
                            n4 = nArray2[0];
                        }
                        if ((n3 = this.ring.nvar + 1 - n4) <= n2) {
                            expVector5 = expVector6.sum(expVector3);
                            if (debug) {
                                logger.info("disjoint poly: g = " + expVector6 + ", f = " + expVector3 + ", h = " + expVector5);
                            }
                            genSolvablePolynomial4 = (ResidueSolvableWordPolynomial)genSolvablePolynomial2.sum(wordResidue, expVector5);
                        } else {
                            ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial3;
                            expVector5 = expVector6.subst(n4, 0L);
                            ExpVector expVector7 = expVector.subst(n4, expVector6.getVal(n4));
                            ExpVector expVector8 = expVector3.subst(n, 0L);
                            ExpVector expVector9 = expVector.subst(n, expVector3.getVal(n));
                            if (debug) {
                                logger.info("poly, g1 = " + expVector5 + ", f1 = " + expVector8 + ", Dps = " + (ResidueSolvableWordPolynomial)genSolvablePolynomial5);
                            }
                            if (debug) {
                                logger.info("poly, g2 = " + expVector7 + ", f2 = " + expVector9);
                            }
                            TableRelation tableRelation = this.ring.table.lookup(expVector7, expVector9);
                            if (debug) {
                                logger.info("poly, g  = " + expVector6 + ", f  = " + expVector3 + ", rel = " + tableRelation);
                            }
                            genSolvablePolynomial4 = new ResidueSolvableWordPolynomial<C>(this.ring, tableRelation.p);
                            if (tableRelation.f != null) {
                                residueSolvableWordPolynomial3 = new ResidueSolvableWordPolynomial<C>(this.ring, wordResidue, tableRelation.f);
                                genSolvablePolynomial4 = ((ResidueSolvableWordPolynomial)genSolvablePolynomial4).multiply(residueSolvableWordPolynomial3);
                                ExpVector expVector10 = tableRelation.e == null ? expVector7 : expVector7.subtract(tableRelation.e);
                                this.ring.table.update(expVector10, expVector9, genSolvablePolynomial4);
                            }
                            if (tableRelation.e != null) {
                                genSolvablePolynomial3 = new ResidueSolvableWordPolynomial<C>(this.ring, wordResidue, tableRelation.e);
                                genSolvablePolynomial4 = ((ResidueSolvableWordPolynomial)genSolvablePolynomial3).multiply((ResidueSolvableWordPolynomial<C>)genSolvablePolynomial4);
                                this.ring.table.update(expVector7, expVector9, genSolvablePolynomial4);
                            }
                            if (!expVector8.isZERO()) {
                                residueSolvableWordPolynomial3 = new ResidueSolvableWordPolynomial<C>(this.ring, wordResidue, expVector8);
                                genSolvablePolynomial4 = ((ResidueSolvableWordPolynomial)genSolvablePolynomial4).multiply(residueSolvableWordPolynomial3);
                            }
                            if (!expVector5.isZERO()) {
                                genSolvablePolynomial3 = new ResidueSolvableWordPolynomial<C>(this.ring, wordResidue, expVector5);
                                genSolvablePolynomial4 = ((ResidueSolvableWordPolynomial)genSolvablePolynomial3).multiply((ResidueSolvableWordPolynomial<C>)genSolvablePolynomial4);
                            }
                        }
                        genSolvablePolynomial4 = ((ResidueSolvableWordPolynomial)genSolvablePolynomial4).multiplyLeft(wordResidue4);
                        genSolvablePolynomial5 = (ResidueSolvableWordPolynomial)genSolvablePolynomial5.sum(genSolvablePolynomial4);
                    }
                    genSolvablePolynomial4 = genSolvablePolynomial5;
                }
                genSolvablePolynomial4 = ((ResidueSolvableWordPolynomial)genSolvablePolynomial4).multiplyLeft(wordResidue2);
                if (debug) {
                    logger.debug("Ds = " + (ResidueSolvableWordPolynomial)genSolvablePolynomial4);
                }
                genSolvablePolynomial = (ResidueSolvableWordPolynomial)genSolvablePolynomial.sum(genSolvablePolynomial4);
            }
        }
        return genSolvablePolynomial;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial, ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial2) {
        if (residueSolvableWordPolynomial.isZERO() || residueSolvableWordPolynomial2.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (residueSolvableWordPolynomial.isONE()) {
            return this.multiply(residueSolvableWordPolynomial2);
        }
        if (residueSolvableWordPolynomial2.isONE()) {
            return residueSolvableWordPolynomial.multiply(this);
        }
        return residueSolvableWordPolynomial.multiply(this).multiply(residueSolvableWordPolynomial2);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(WordResidue<C> wordResidue) {
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (wordResidue == null || wordResidue.isZERO()) {
            return residueSolvableWordPolynomial;
        }
        residueSolvableWordPolynomial = this.ring.valueOf(wordResidue);
        return this.multiply(residueSolvableWordPolynomial);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(WordResidue<C> wordResidue, WordResidue<C> wordResidue2) {
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (wordResidue == null || wordResidue.isZERO()) {
            return genSolvablePolynomial;
        }
        if (wordResidue2 == null || wordResidue2.isZERO()) {
            return genSolvablePolynomial;
        }
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial = this.ring.valueOf(wordResidue);
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial2 = this.ring.valueOf(wordResidue2);
        return residueSolvableWordPolynomial.multiply(this).multiply(residueSolvableWordPolynomial2);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        WordResidue wordResidue = (WordResidue)this.ring.getONECoefficient();
        return this.multiply(wordResidue, expVector);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(ExpVector expVector, ExpVector expVector2) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (expVector2 == null || expVector2.isZERO()) {
            return this;
        }
        WordResidue wordResidue = (WordResidue)this.ring.getONECoefficient();
        return this.multiply(wordResidue, expVector, wordResidue, expVector2);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(WordResidue<C> wordResidue, ExpVector expVector) {
        if (wordResidue == null || wordResidue.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial = this.ring.valueOf(wordResidue, expVector);
        return this.multiply(residueSolvableWordPolynomial);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(WordResidue<C> wordResidue, ExpVector expVector, WordResidue<C> wordResidue2, ExpVector expVector2) {
        if (wordResidue == null || wordResidue.isZERO()) {
            return this.ring.getZERO();
        }
        if (wordResidue2 == null || wordResidue2.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial = this.ring.valueOf(wordResidue, expVector);
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial2 = this.ring.valueOf(wordResidue2, expVector2);
        return this.multiply(residueSolvableWordPolynomial, residueSolvableWordPolynomial2);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiplyLeft(WordResidue<C> wordResidue, ExpVector expVector) {
        if (wordResidue == null || wordResidue.isZERO()) {
            return this.ring.getZERO();
        }
        ResidueSolvableWordPolynomial<C> residueSolvableWordPolynomial = this.ring.valueOf(wordResidue, expVector);
        return residueSolvableWordPolynomial.multiply(this);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiplyLeft(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        GenSolvablePolynomial genSolvablePolynomial = this.ring.valueOf(expVector);
        return ((ResidueSolvableWordPolynomial)genSolvablePolynomial).multiply(this);
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiplyLeft(WordResidue<C> wordResidue) {
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (wordResidue == null || wordResidue.isZERO()) {
            return genSolvablePolynomial;
        }
        SortedMap sortedMap = ((ResidueSolvableWordPolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            WordResidue wordResidue2 = (WordResidue)entry.getValue();
            WordResidue<WordResidue> wordResidue3 = wordResidue.multiply(wordResidue2);
            if (wordResidue3.isZERO()) continue;
            sortedMap.put(expVector, wordResidue3);
        }
        return genSolvablePolynomial;
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiplyLeft(Map.Entry<ExpVector, WordResidue<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft(entry.getValue(), entry.getKey());
    }

    @Override
    public ResidueSolvableWordPolynomial<C> multiply(Map.Entry<ExpVector, WordResidue<C>> entry) {
        if (entry == null) {
            return this.ring.getZERO();
        }
        return this.multiply(entry.getValue(), entry.getKey());
    }

    protected ResidueSolvableWordPolynomial<C> shift(ExpVector expVector) {
        GenSolvablePolynomial genSolvablePolynomial = ((ResidueSolvableWordPolynomial)this.ring.getZERO()).copy();
        if (this.isZERO()) {
            return genSolvablePolynomial;
        }
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        SortedMap sortedMap = ((ResidueSolvableWordPolynomial)genSolvablePolynomial).val;
        SortedMap sortedMap2 = this.val;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector2 = (ExpVector)entry.getKey();
            WordResidue wordResidue = (WordResidue)entry.getValue();
            ExpVector expVector3 = expVector2.sum(expVector);
            if (wordResidue.isZERO()) continue;
            sortedMap.put(expVector3, wordResidue);
        }
        return genSolvablePolynomial;
    }
}

