/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Roots;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.StarRingElem;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BigDecimalComplex
implements StarRingElem<BigDecimalComplex>,
GcdRingElem<BigDecimalComplex>,
RingFactory<BigDecimalComplex> {
    public final BigDecimal re;
    public final BigDecimal im;
    private static final Random random = new Random();
    private static final Logger logger = LogManager.getLogger(BigDecimalComplex.class);
    public static final BigDecimalComplex ZERO = new BigDecimalComplex();
    public static final BigDecimalComplex ONE = new BigDecimalComplex(BigDecimal.ONE);
    public static final BigDecimalComplex I = new BigDecimalComplex(BigDecimal.ZERO, BigDecimal.ONE);

    public BigDecimalComplex(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this.re = bigDecimal;
        this.im = bigDecimal2;
    }

    public BigDecimalComplex(BigDecimal bigDecimal) {
        this(bigDecimal, BigDecimal.ZERO);
    }

    public BigDecimalComplex(long l) {
        this(new BigDecimal(l), BigDecimal.ZERO);
    }

    public BigDecimalComplex() {
        this(BigDecimal.ZERO);
    }

    public BigDecimalComplex(String string) throws NumberFormatException {
        if (string == null || string.length() == 0) {
            this.re = BigDecimal.ZERO;
            this.im = BigDecimal.ZERO;
            return;
        }
        int n = (string = string.trim()).indexOf("i");
        if (n < 0) {
            this.re = new BigDecimal(string);
            this.im = BigDecimal.ZERO;
            return;
        }
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        String string3 = "";
        if (n < string.length()) {
            string3 = string.substring(n + 1, string.length());
        }
        this.re = new BigDecimal(string2.trim());
        this.im = new BigDecimal(string3.trim());
    }

    public BigDecimalComplex(BigComplex bigComplex) {
        this(new BigDecimal(bigComplex.re), new BigDecimal(bigComplex.im));
    }

    public BigDecimalComplex factory() {
        return this;
    }

    @Override
    public List<BigDecimalComplex> generators() {
        ArrayList<BigDecimalComplex> arrayList = new ArrayList<BigDecimalComplex>(2);
        arrayList.add(this.getONE());
        arrayList.add(this.getIMAG());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigDecimalComplex copy() {
        return new BigDecimalComplex(this.re, this.im);
    }

    @Override
    public BigDecimalComplex copy(BigDecimalComplex bigDecimalComplex) {
        return new BigDecimalComplex(bigDecimalComplex.re, bigDecimalComplex.im);
    }

    @Override
    public BigDecimalComplex getZERO() {
        return ZERO;
    }

    @Override
    public BigDecimalComplex getONE() {
        return ONE;
    }

    public BigDecimalComplex getIMAG() {
        return I;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return BigInteger.ZERO;
    }

    @Override
    public BigDecimalComplex fromInteger(BigInteger bigInteger) {
        return new BigDecimalComplex(new BigDecimal(bigInteger));
    }

    @Override
    public BigDecimalComplex fromInteger(long l) {
        return new BigDecimalComplex(new BigDecimal(l));
    }

    public BigDecimal getRe() {
        return this.re;
    }

    public BigDecimal getIm() {
        return this.im;
    }

    public String toString() {
        Object object = this.re.toString();
        if (this.im.isZERO()) {
            return object;
        }
        object = (String)object + "i" + this.im;
        return object;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.im.isZERO();
        if (bl) {
            stringBuffer.append(this.re.toScript());
            return stringBuffer.toString();
        }
        boolean bl2 = this.re.isZERO();
        if (bl2) {
            if (!this.im.isONE()) {
                if (this.im.signum() > 0) {
                    stringBuffer.append(this.im.toScript() + "*");
                } else {
                    stringBuffer.append("-");
                    BigDecimal bigDecimal = this.im.negate();
                    if (!bigDecimal.isONE()) {
                        stringBuffer.append(bigDecimal.toScript() + "*");
                    }
                }
            }
        } else {
            stringBuffer.append(this.re.toScript());
            if (this.im.signum() > 0) {
                stringBuffer.append("+");
                if (!this.im.isONE()) {
                    stringBuffer.append(this.im.toScript() + "*");
                }
            } else {
                stringBuffer.append("-");
                BigDecimal bigDecimal = this.im.negate();
                if (!bigDecimal.isONE()) {
                    stringBuffer.append(bigDecimal.toScript() + "*");
                }
            }
        }
        stringBuffer.append("I");
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return "CD()";
    }

    public static boolean isCZERO(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null) {
            return false;
        }
        return bigDecimalComplex.isZERO();
    }

    @Override
    public boolean isZERO() {
        return this.re.isZERO() && this.im.isZERO();
    }

    public static boolean isCONE(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null) {
            return false;
        }
        return bigDecimalComplex.isONE();
    }

    @Override
    public boolean isONE() {
        return this.re.isONE() && this.im.isZERO();
    }

    public boolean isIMAG() {
        return this.re.isZERO() && this.im.isONE();
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigDecimalComplex)) {
            return false;
        }
        BigDecimalComplex bigDecimalComplex = (BigDecimalComplex)object;
        return this.re.compareTo(bigDecimalComplex.re) == 0 && this.im.compareTo(bigDecimalComplex.im) == 0;
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(BigDecimalComplex bigDecimalComplex) {
        int n = this.re.compareTo(bigDecimalComplex.re);
        if (n != 0) {
            return n;
        }
        n = this.im.compareTo(bigDecimalComplex.im);
        return n;
    }

    @Override
    public int signum() {
        int n = this.re.signum();
        if (n != 0) {
            return n;
        }
        return this.im.signum();
    }

    @Override
    public BigDecimalComplex sum(BigDecimalComplex bigDecimalComplex) {
        return new BigDecimalComplex(this.re.sum(bigDecimalComplex.re), this.im.sum(bigDecimalComplex.im));
    }

    public static BigDecimalComplex CSUM(BigDecimalComplex bigDecimalComplex, BigDecimalComplex bigDecimalComplex2) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.sum(bigDecimalComplex2);
    }

    public static BigDecimalComplex CDIF(BigDecimalComplex bigDecimalComplex, BigDecimalComplex bigDecimalComplex2) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.subtract(bigDecimalComplex2);
    }

    @Override
    public BigDecimalComplex subtract(BigDecimalComplex bigDecimalComplex) {
        return new BigDecimalComplex(this.re.subtract(bigDecimalComplex.re), this.im.subtract(bigDecimalComplex.im));
    }

    public static BigDecimalComplex CNEG(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.negate();
    }

    @Override
    public BigDecimalComplex negate() {
        return new BigDecimalComplex(this.re.negate(), this.im.negate());
    }

    public static BigDecimalComplex CCON(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.conjugate();
    }

    @Override
    public BigDecimalComplex conjugate() {
        return new BigDecimalComplex(this.re, this.im.negate());
    }

    @Override
    public BigDecimalComplex norm() {
        BigDecimal bigDecimal = this.re.multiply(this.re);
        if (!this.im.isZERO()) {
            bigDecimal = bigDecimal.sum(this.im.multiply(this.im));
        }
        return new BigDecimalComplex(bigDecimal);
    }

    @Override
    public BigDecimalComplex abs() {
        if (this.im.isZERO()) {
            return new BigDecimalComplex(this.re.abs());
        }
        BigDecimalComplex bigDecimalComplex = this.norm();
        BigDecimal bigDecimal = Roots.sqrt(bigDecimalComplex.re);
        if (logger.isDebugEnabled()) {
            logger.debug("sqrt(re) = " + bigDecimal);
        }
        return new BigDecimalComplex(bigDecimal);
    }

    public static BigDecimal CABS(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.abs().re;
    }

    public static BigDecimalComplex CPROD(BigDecimalComplex bigDecimalComplex, BigDecimalComplex bigDecimalComplex2) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.multiply(bigDecimalComplex2);
    }

    @Override
    public BigDecimalComplex multiply(BigDecimalComplex bigDecimalComplex) {
        return new BigDecimalComplex(this.re.multiply(bigDecimalComplex.re).subtract(this.im.multiply(bigDecimalComplex.im)), this.re.multiply(bigDecimalComplex.im).sum(this.im.multiply(bigDecimalComplex.re)));
    }

    public static BigDecimalComplex CINV(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.inverse();
    }

    @Override
    public BigDecimalComplex inverse() {
        BigDecimal bigDecimal = this.norm().re.inverse();
        return new BigDecimalComplex(this.re.multiply(bigDecimal), this.im.multiply(bigDecimal.negate()));
    }

    @Override
    public BigDecimalComplex remainder(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public static BigDecimalComplex CQ(BigDecimalComplex bigDecimalComplex, BigDecimalComplex bigDecimalComplex2) {
        if (bigDecimalComplex == null) {
            return null;
        }
        return bigDecimalComplex.divide(bigDecimalComplex2);
    }

    @Override
    public BigDecimalComplex divide(BigDecimalComplex bigDecimalComplex) {
        return this.multiply(bigDecimalComplex.inverse());
    }

    public BigDecimalComplex[] quotientRemainder(BigDecimalComplex bigDecimalComplex) {
        return new BigDecimalComplex[]{this.divide(bigDecimalComplex), ZERO};
    }

    @Override
    public BigDecimalComplex random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigDecimalComplex random(int n, Random random) {
        BigDecimal bigDecimal = BigDecimal.ONE.random(n, random);
        BigDecimal bigDecimal2 = BigDecimal.ONE.random(n, random);
        return new BigDecimalComplex(bigDecimal, bigDecimal2);
    }

    public static BigDecimalComplex CRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public BigDecimalComplex parse(String string) {
        return new BigDecimalComplex(string);
    }

    @Override
    public BigDecimalComplex parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public BigDecimalComplex gcd(BigDecimalComplex bigDecimalComplex) {
        if (bigDecimalComplex == null || bigDecimalComplex.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigDecimalComplex;
        }
        return ONE;
    }

    public BigDecimalComplex[] egcd(BigDecimalComplex bigDecimalComplex) {
        BigDecimalComplex[] bigDecimalComplexArray = new BigDecimalComplex[]{null, null, null};
        if (bigDecimalComplex == null || bigDecimalComplex.isZERO()) {
            bigDecimalComplexArray[0] = this;
            return bigDecimalComplexArray;
        }
        if (this.isZERO()) {
            bigDecimalComplexArray[0] = bigDecimalComplex;
            return bigDecimalComplexArray;
        }
        BigDecimalComplex bigDecimalComplex2 = this.fromInteger(2L).inverse();
        bigDecimalComplexArray[0] = ONE;
        bigDecimalComplexArray[1] = this.inverse().multiply(bigDecimalComplex2);
        bigDecimalComplexArray[2] = bigDecimalComplex.inverse().multiply(bigDecimalComplex2);
        return bigDecimalComplexArray;
    }

    public long bitLength() {
        return this.re.bitLength() + this.im.bitLength();
    }
}

