/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import java.math.MathContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigDecimalTest
extends TestCase {
    BigDecimal a;
    BigDecimal b;
    BigDecimal c;
    BigDecimal d;
    BigDecimal e;
    BigDecimal eps;
    BigDecimal fac;
    int precision = BigDecimal.DEFAULT_PRECISION;
    MathContext mc = BigDecimal.DEFAULT_CONTEXT;
    int kl = this.precision / 2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigDecimalTest.suite());
    }

    public BigDecimalTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigDecimalTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new BigDecimal(0L, this.mc);
        this.eps = new BigDecimal(new BigRational(1L, 10L));
        this.eps = (BigDecimal)this.eps.power(this.precision);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.eps = null;
    }

    public void testConstants() {
        this.a = BigDecimal.ZERO;
        this.b = BigDecimal.ONE;
        this.c = this.b.subtract(this.b);
        BigDecimalTest.assertTrue((String)"1-1 = 0", (this.c.compareTo(this.a) == 0 ? 1 : 0) != 0);
        BigDecimalTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigDecimalTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        this.a = BigDecimal.ZERO;
        this.b = BigDecimal.ONE;
        this.c = this.a.subtract(this.a);
        BigDecimalTest.assertTrue((String)"1-1 = 0", (this.c.compareTo(this.a) == 0 ? 1 : 0) != 0);
    }

    public void testBitLength() {
        this.a = BigDecimal.ZERO;
        this.b = BigDecimal.ONE;
        this.c = this.b.random(300, 100);
        BigDecimalTest.assertEquals((String)"len(0) = 1", (long)2L, (long)this.a.bitLength());
        BigDecimalTest.assertEquals((String)"len(1) = 3", (long)3L, (long)this.b.bitLength());
        BigDecimalTest.assertEquals((String)"len(-1) = 3", (long)3L, (long)this.b.negate().bitLength());
        BigDecimalTest.assertTrue((String)"len(random) >= 2", (2L <= this.c.bitLength() ? 1 : 0) != 0);
    }

    public void testConstructor() {
        this.a = new BigDecimal("6.8");
        this.b = new BigDecimal("3.4");
        this.b = this.b.sum(this.b);
        BigDecimalTest.assertEquals((String)"6.8 = 3.4", (int)0, (int)this.a.compareTo(this.b));
        String string = "6.1111111111111111111111111111111111111111111";
        this.a = new BigDecimal(string);
        String string2 = this.a.toString();
        BigDecimalTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        this.a = new BigDecimal(1L);
        this.b = new BigDecimal(-1L);
        this.c = this.b.sum(this.a);
        BigDecimalTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigDecimalTest.assertTrue((String)"1+(-1) = 0", (this.c.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
        BigDecimalTest.assertTrue((String)"1+(-1) = 0", (boolean)this.c.isZERO());
    }

    public void testRandom() {
        this.a = this.fac.random(5 * this.kl);
        this.b = new BigDecimal("" + this.a);
        this.c = this.a.subtract(this.a);
        BigDecimalTest.assertTrue((String)"a-b = 0", (boolean)this.c.isZERO());
        this.d = new BigDecimal("" + this.b);
        BigDecimalTest.assertTrue((String)"sign(a-a) = 0", (this.b.compareTo(this.d) == 0 ? 1 : 0) != 0);
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        BigDecimalTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = this.a.sum(BigDecimal.ZERO);
        BigDecimalTest.assertEquals((String)"a+0 = a", (int)0, (int)this.d.compareTo(this.a));
        this.d = this.a.subtract(BigDecimal.ZERO);
        BigDecimalTest.assertEquals((String)"a-0 = a", (int)0, (int)this.d.compareTo(this.a));
        this.d = this.a.subtract(this.a);
        BigDecimalTest.assertTrue((String)"a-a = 0", (this.d.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        BigDecimalTest.assertTrue((String)"a+b = b+a", (this.d.compareTo(this.c) == 0 ? 1 : 0) != 0);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.kl);
        this.b = this.a.multiply(this.a);
        this.c = this.b.divide(this.a);
        BigDecimalTest.assertTrue((String)"a*a/a = a", (this.c.compareTo(this.a) == 0 ? 1 : 0) != 0);
        this.d = this.a.multiply(BigDecimal.ONE);
        BigDecimalTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(BigDecimal.ONE);
        BigDecimalTest.assertEquals((String)"a/1 = a", (int)0, (int)this.d.compareTo(this.a));
        this.a = this.fac.random(this.kl);
        this.b = this.a.inverse();
        this.c = this.a.multiply(this.b);
        this.d = this.c.subtract(this.fac.getONE()).abs();
        BigDecimalTest.assertTrue((String)("a*1/a = 1: " + this.c), (this.d.compareTo(this.eps) <= 0 ? 1 : 0) != 0);
        this.b = this.fac.random(this.kl);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        BigDecimalTest.assertTrue((String)"ab = ba", (this.d.compareTo(this.c) == 0 ? 1 : 0) != 0);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        if (this.d.compareTo(this.e) == 0) {
            BigDecimalTest.assertTrue((String)"a(bc) = (ab)c", (this.d.compareTo(this.e) == 0 ? 1 : 0) != 0);
        }
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl);
        this.b = this.fac.random(this.kl);
        this.c = this.fac.random(this.kl);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        if (this.d.compareTo(this.e) == 0) {
            BigDecimalTest.assertTrue((String)"a(b+c) = ab+ac", (this.d.compareTo(this.e) == 0 ? 1 : 0) != 0);
        }
    }
}

