/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.MonoidElem;
import java.util.ArrayList;
import java.util.List;

public class Cyclic {
    final int N;
    final String var;
    final String order;
    public final GenPolynomialRing<BigInteger> ring;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("usage: Cyclic N <order> <var>");
            return;
        }
        int n = Integer.parseInt(stringArray[0]);
        Cyclic cyclic = null;
        if (stringArray.length == 1) {
            cyclic = new Cyclic(n);
        }
        if (stringArray.length == 2) {
            cyclic = new Cyclic("x", n, stringArray[1]);
        }
        if (stringArray.length == 3) {
            cyclic = new Cyclic(stringArray[2], n, stringArray[1]);
        }
        System.out.println("#Cyclic equations for N = " + n + ":");
        System.out.println("" + cyclic);
    }

    public Cyclic(int n) {
        this("x", n);
    }

    public Cyclic(String string, int n) {
        this(string, n, "G");
    }

    public Cyclic(String string, int n, String string2) {
        this.var = string;
        this.N = n;
        this.order = string2;
        BigInteger bigInteger = new BigInteger();
        this.ring = new GenPolynomialRing<BigInteger>(bigInteger, this.N);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ring.toString().replace("BigInteger", "Z"));
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append(this.cyclicPolys(this.ring).toString());
        return stringBuffer.toString();
    }

    public String polyList() {
        return this.cyclicPolys(this.ring).toString().replace("[", "(").replace("]", ")");
    }

    public List<GenPolynomial<BigInteger>> cyclicPolys() {
        return this.cyclicPolys(this.ring);
    }

    List<GenPolynomial<BigInteger>> cyclicPolys(GenPolynomialRing<BigInteger> genPolynomialRing) {
        int n = genPolynomialRing.nvar;
        ArrayList<GenPolynomial<BigInteger>> arrayList = new ArrayList<GenPolynomial<BigInteger>>(n);
        for (int i = 1; i <= n; ++i) {
            GenPolynomial<BigInteger> genPolynomial = this.cyclicPoly(genPolynomialRing, n, i);
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    GenPolynomial<BigInteger> cyclicPoly(GenPolynomialRing<BigInteger> genPolynomialRing, int n, int n2) {
        List<GenPolynomial<BigInteger>> list = genPolynomialRing.univariateList();
        GenPolynomial<MonoidElem> genPolynomial = genPolynomialRing.getZERO();
        for (int i = 1; i <= n; ++i) {
            GenPolynomial<GenPolynomial<BigInteger>> genPolynomial2 = genPolynomialRing.getONE();
            for (int j = i; j < i + n2; ++j) {
                genPolynomial2 = genPolynomial2.multiply(list.get(j % n));
            }
            genPolynomial = genPolynomial.sum(genPolynomial2);
            if (n2 != n) continue;
            genPolynomial = genPolynomial.subtract(genPolynomialRing.getONE());
            break;
        }
        return genPolynomial;
    }
}

