/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableReduction;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableGroebnerBaseSeq<C extends RingElem<C>>
extends SolvableGroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(SolvableGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();

    public SolvableGroebnerBaseSeq() {
    }

    public SolvableGroebnerBaseSeq(SolvableReduction<C> solvableReduction) {
        super(solvableReduction);
    }

    public SolvableGroebnerBaseSeq(PairList<C> pairList) {
        super(pairList);
    }

    public SolvableGroebnerBaseSeq(SolvableReduction<C> solvableReduction, PairList<C> pairList) {
        super(solvableReduction, pairList);
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monic(PolynomialList.castToList(list2)))).size() <= 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (!genSolvablePolynomialRing.coFac.isField() && genSolvablePolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficients not from a field: " + genSolvablePolynomialRing.coFac.toScript());
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        logger.info("start " + pairList);
        while (pairList.hasNext()) {
            GenPolynomial genPolynomial;
            GenSolvablePolynomial genSolvablePolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.info("pi    = " + genSolvablePolynomial2.leadingExpVector());
                logger.info("pj    = " + genSolvablePolynomial3.leadingExpVector());
            }
            if ((genSolvablePolynomial = this.sred.leftSPolynomial(genSolvablePolynomial2, genSolvablePolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(S) = " + genSolvablePolynomial.leadingExpVector());
            }
            if ((genPolynomial = this.sred.leftNormalform(list2, genSolvablePolynomial)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(H) = " + genPolynomial.leadingExpVector());
            }
            if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                list2.clear();
                list2.add((GenSolvablePolynomial<C>)genPolynomial);
                return list2;
            }
            if (debug) {
                logger.info("#monic(H) = " + genPolynomial.length());
            }
            if (genPolynomial.length() <= 0) continue;
            list2.add((GenSolvablePolynomial<C>)genPolynomial);
            pairList.put(genPolynomial);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("end " + pairList);
        return list2;
    }

    @Override
    public SolvableExtendedGB<C> extLeftGB(int n, List<GenSolvablePolynomial<C>> list) {
        GenPolynomial genPolynomial;
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("null or empty F not allowed");
        }
        List list2 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        List list3 = new ArrayList();
        PairList<C> pairList = null;
        boolean bl = false;
        int n2 = list.size();
        List<GenSolvablePolynomial<Object>> list4 = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        GenSolvablePolynomialRing genSolvablePolynomialRing = null;
        int n3 = 0;
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            if (genSolvablePolynomial.length() > 0) {
                ++n3;
            }
            if (genSolvablePolynomialRing != null) continue;
            genSolvablePolynomialRing = genSolvablePolynomial.ring;
        }
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.getONE();
        int n4 = 0;
        ListIterator<GenSolvablePolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenSolvablePolynomial<C> genSolvablePolynomial = listIterator.next();
            if (genSolvablePolynomial.length() > 0) {
                list4 = new ArrayList(n3);
                for (int i = 0; i < n3; ++i) {
                    list4.add(null);
                }
                list4.set(n4, (GenSolvablePolynomial<Object>)genPolynomial2);
                ++n4;
                if (genSolvablePolynomial.isUnit()) {
                    list2.clear();
                    list2.add(genSolvablePolynomial);
                    list3.clear();
                    list3.add(list4);
                    bl = true;
                    break;
                }
                list2.add(genSolvablePolynomial);
                list3.add(list4);
                if (pairList == null) {
                    pairList = this.strategy.create(n, genSolvablePolynomial.ring);
                }
                pairList.put(genSolvablePolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1 || bl) {
            for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
                list4 = new ArrayList(list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    list4.add(null);
                }
                GenSolvablePolynomial genSolvablePolynomial2 = this.sred.leftNormalform(list4, list2, genSolvablePolynomial);
                if (!genSolvablePolynomial2.isZERO()) {
                    logger.error("nonzero H = " + genSolvablePolynomial2);
                }
                arrayList.add(list4);
            }
            SolvableExtendedGB<C> solvableExtendedGB = new SolvableExtendedGB<C>(list, list2, arrayList, list3);
            return solvableExtendedGB;
        }
        logger.info("start " + pairList);
        while (pairList.hasNext() && !bl) {
            int n5;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            int n6 = pair.i;
            int n7 = pair.j;
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.info("i, pi    = " + n6 + ", " + genSolvablePolynomial);
                logger.info("j, pj    = " + n7 + ", " + genSolvablePolynomial3);
            }
            arrayList2 = new ArrayList(list2.size());
            for (n5 = 0; n5 < list2.size(); ++n5) {
                arrayList2.add(null);
            }
            GenSolvablePolynomial genSolvablePolynomial4 = this.sred.leftSPolynomial(arrayList2, n6, genSolvablePolynomial, n7, genSolvablePolynomial3);
            if (debug) {
                logger.debug("is reduction S = " + this.sred.isLeftReductionNF(arrayList2, list2, genSolvablePolynomialRing.getZERO(), genSolvablePolynomial4));
            }
            if (genSolvablePolynomial4.isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = " + genSolvablePolynomial4.leadingExpVector());
            }
            arrayList3 = new ArrayList(list2.size());
            for (n5 = 0; n5 < list2.size(); ++n5) {
                arrayList3.add(null);
            }
            genPolynomial = this.sred.leftNormalform(arrayList3, list2, genSolvablePolynomial4);
            if (debug) {
                logger.debug("is reduction H = " + this.sred.isLeftReductionNF(arrayList3, list2, genSolvablePolynomial4, genPolynomial));
            }
            if (genPolynomial.isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(H) = " + genPolynomial.leadingExpVector());
            }
            list4 = new ArrayList(list2.size() + 1);
            for (n5 = 0; n5 < list2.size(); ++n5) {
                GenSolvablePolynomial genSolvablePolynomial5;
                GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)arrayList2.get(n5);
                if (genSolvablePolynomial6 != null) {
                    genSolvablePolynomial6 = (GenSolvablePolynomial)genSolvablePolynomial6.negate();
                }
                if ((genSolvablePolynomial5 = (GenSolvablePolynomial)arrayList3.get(n5)) != null) {
                    genSolvablePolynomial5 = (GenSolvablePolynomial)genSolvablePolynomial5.negate();
                }
                genSolvablePolynomial6 = genSolvablePolynomial6 == null ? genSolvablePolynomial5 : (GenSolvablePolynomial)genSolvablePolynomial6.sum(genSolvablePolynomial5);
                list4.add(genSolvablePolynomial6);
            }
            if (debug) {
                logger.debug("is reduction 0+sum(row,G) == H : " + this.sred.isLeftReductionNF(list4, list2, genPolynomial, genSolvablePolynomialRing.getZERO()));
            }
            list4.add(null);
            Object object = genPolynomial.leadingBaseCoefficient();
            object = (RingElem)object.inverse();
            genPolynomial = ((GenSolvablePolynomial)genPolynomial).multiply((RingElem)object);
            list4 = PolynomialList.castToSolvableList(this.blas.scalarProduct(((GenSolvablePolynomial)genPolynomial2).multiply((RingElem)object), PolynomialList.castToList(list4)));
            list4.set(list2.size(), (GenSolvablePolynomial<Object>)genPolynomial2);
            if (genPolynomial.isONE()) {
                list2.add(genPolynomial);
                list3.add(list4);
                bl = true;
                break;
            }
            if (debug) {
                logger.debug("H = " + (GenSolvablePolynomial)genPolynomial);
            }
            list2.add(genPolynomial);
            pairList.put(genPolynomial);
            list3.add(list4);
        }
        if (debug) {
            SolvableExtendedGB<C> solvableExtendedGB = new SolvableExtendedGB<C>(list, list2, arrayList, list3);
            logger.info("exgb unnorm = " + solvableExtendedGB);
        }
        list3 = this.normalizeMatrix(list.size(), list3);
        if (debug) {
            SolvableExtendedGB<C> solvableExtendedGB = new SolvableExtendedGB<C>(list, list2, arrayList, list3);
            logger.info("exgb nonmin = " + solvableExtendedGB);
            boolean bl2 = this.isLeftReductionMatrix(solvableExtendedGB);
            logger.debug("exgb t2 = " + bl2);
        }
        SolvableExtendedGB solvableExtendedGB = this.minimalSolvableExtendedGB(list.size(), list2, list3);
        list2 = solvableExtendedGB.G;
        list3 = solvableExtendedGB.G2F;
        logger.debug("#sequential list = " + list2.size());
        logger.info("end " + pairList);
        for (GenSolvablePolynomial<C> genSolvablePolynomial : list) {
            list4 = new ArrayList(list2.size());
            for (int i = 0; i < list2.size(); ++i) {
                list4.add(null);
            }
            genPolynomial = this.sred.leftNormalform(list4, list2, genSolvablePolynomial);
            if (!genPolynomial.isZERO()) {
                logger.error("nonzero H = " + genPolynomial);
            }
            arrayList.add(list4);
        }
        logger.info("extGB end");
        return new SolvableExtendedGB<C>(list, list2, arrayList, list3);
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int n, List<GenSolvablePolynomial<C>> list) {
        GenPolynomial genPolynomial;
        GenPolynomial genPolynomial2;
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monic(PolynomialList.castToList(list2)))).size() < 1) {
            return list2;
        }
        if (list2.size() == 1 && list2.get(0).isONE()) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (!genSolvablePolynomialRing.coFac.isField() && genSolvablePolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        List list3 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = " + list3);
        List<GenSolvablePolynomial<C>> list4 = new ArrayList<GenSolvablePolynomial<C>>(list2.size() * (1 + list3.size()));
        list4.addAll(list2);
        logger.info("right multipy: G = " + list4);
        for (int i = 0; i < list4.size(); ++i) {
            genPolynomial2 = (GenSolvablePolynomial)list4.get(i);
            for (GenSolvablePolynomial genSolvablePolynomial2 : list3) {
                if (genSolvablePolynomial2.isONE()) continue;
                genPolynomial = ((GenSolvablePolynomial)genPolynomial2).multiply(genSolvablePolynomial2);
                logger.info("right multipy: p = " + (GenSolvablePolynomial)genPolynomial2 + ", x = " + genSolvablePolynomial2 + ", q = " + genPolynomial);
                genPolynomial = this.sred.leftNormalform(list4, genPolynomial);
                genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic();
                logger.info("right multipy: red(q) = " + genPolynomial);
                if (genPolynomial.isZERO()) continue;
                if (genPolynomial.isONE()) {
                    list4.clear();
                    list4.add((GenSolvablePolynomial<C>)genPolynomial);
                    return list4;
                }
                if (!list4.contains(genPolynomial)) {
                    list4.add((GenSolvablePolynomial<C>)genPolynomial);
                    continue;
                }
                logger.info("right multipy contained: q = " + (GenSolvablePolynomial)genPolynomial);
            }
        }
        if (list4.size() <= 1) {
            return list4;
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list4));
        logger.info("twosided start " + pairList);
        while (pairList.hasNext()) {
            GenPolynomial genPolynomial3;
            GenSolvablePolynomial genSolvablePolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.debug("pi    = " + genSolvablePolynomial2);
                logger.debug("pj    = " + genSolvablePolynomial3);
            }
            if ((genSolvablePolynomial = this.sred.leftSPolynomial(genSolvablePolynomial2, genSolvablePolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = " + genSolvablePolynomial.leadingExpVector());
            }
            if ((genPolynomial3 = this.sred.leftNormalform(list4, genSolvablePolynomial)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(H) = " + genPolynomial3.leadingExpVector());
            }
            if ((genPolynomial3 = ((GenSolvablePolynomial)genPolynomial3).monic()).isONE()) {
                list4.clear();
                list4.add((GenSolvablePolynomial<C>)genPolynomial3);
                return list4;
            }
            if (debug) {
                logger.debug("H = " + (GenSolvablePolynomial)genPolynomial3);
            }
            if (genPolynomial3.length() <= 0) continue;
            list4.add((GenSolvablePolynomial<C>)genPolynomial3);
            pairList.put(genPolynomial3);
            for (GenSolvablePolynomial genSolvablePolynomial4 : list3) {
                if (genSolvablePolynomial4.isONE() || (genPolynomial2 = this.sred.leftNormalform(list4, genPolynomial = ((GenSolvablePolynomial)genPolynomial3).multiply(genSolvablePolynomial4))).isZERO()) continue;
                if ((genPolynomial2 = ((GenSolvablePolynomial)genPolynomial2).monic()).isONE()) {
                    list4.clear();
                    list4.add((GenSolvablePolynomial<C>)genPolynomial2);
                    return list4;
                }
                list4.add((GenSolvablePolynomial<C>)genPolynomial2);
                pairList.put(genPolynomial2);
            }
        }
        logger.debug("#sequential list = " + list4.size());
        list4 = this.leftMinimalGB(list4);
        logger.info("twosided end " + pairList);
        return list4;
    }

    public List<List<GenSolvablePolynomial<C>>> normalizeMatrix(int n, List<List<GenSolvablePolynomial<C>>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() == 0) {
            return list;
        }
        ArrayList<List<GenSolvablePolynomial<Object>>> arrayList = new ArrayList<List<GenSolvablePolynomial<Object>>>();
        ArrayList<List<GenSolvablePolynomial<C>>> arrayList2 = new ArrayList<List<GenSolvablePolynomial<C>>>();
        int n2 = list.get(list.size() - 1).size();
        for (List<GenSolvablePolynomial<C>> list3 : list) {
            ArrayList<GenSolvablePolynomial<C>> list22 = new ArrayList<GenSolvablePolynomial<C>>(list3);
            for (int i = list3.size(); i < n2; ++i) {
                list22.add(null);
            }
            arrayList.add(list22);
        }
        int n3 = n;
        for (int i = 0; i < arrayList.size(); ++i) {
            List list2 = (List)arrayList.get(i);
            if (debug) {
                logger.info("row = " + list2);
            }
            arrayList2.add(list2);
            if (i < n) continue;
            for (int j = i + 1; j < arrayList.size(); ++j) {
                GenSolvablePolynomial genSolvablePolynomial;
                List list3 = (List)arrayList.get(j);
                if (n3 >= list3.size() || (genSolvablePolynomial = (GenSolvablePolynomial)list3.get(n3)) == null || genSolvablePolynomial.isZERO()) continue;
                List list4 = this.blas.scalarProduct(genSolvablePolynomial, PolynomialList.castToList(list2));
                list4 = this.blas.vectorAdd(list4, PolynomialList.castToList(list3));
                List list5 = PolynomialList.castToSolvableList(list4);
                arrayList.set(j, list5);
            }
            ++n3;
        }
        arrayList.clear();
        for (List list6 : arrayList2) {
            ArrayList<GenSolvablePolynomial> arrayList3 = new ArrayList<GenSolvablePolynomial>();
            for (int i = 0; i < n; ++i) {
                arrayList3.add((GenSolvablePolynomial)list6.get(i));
            }
            arrayList.add(arrayList3);
        }
        arrayList2 = arrayList;
        return arrayList2;
    }

    @Override
    public boolean isLeftReductionMatrix(SolvableExtendedGB<C> solvableExtendedGB) {
        if (solvableExtendedGB == null) {
            return true;
        }
        return this.isLeftReductionMatrix(solvableExtendedGB.F, solvableExtendedGB.G, solvableExtendedGB.F2G, solvableExtendedGB.G2F);
    }

    public SolvableExtendedGB<C> minimalSolvableExtendedGB(int n, List<GenSolvablePolynomial<C>> list, List<List<GenSolvablePolynomial<C>>> list2) {
        List<GenSolvablePolynomial<Object>> list3;
        if (list == null) {
            return null;
        }
        if (list.size() <= 1) {
            return new SolvableExtendedGB<C>(null, list, null, list2);
        }
        ArrayList<GenSolvablePolynomial<C>> arrayList = new ArrayList<GenSolvablePolynomial<C>>(list);
        ArrayList arrayList2 = new ArrayList(list.size());
        ArrayList<ArrayList<GenSolvablePolynomial<C>>> arrayList3 = new ArrayList<ArrayList<GenSolvablePolynomial<C>>>(list2.size());
        ArrayList arrayList4 = new ArrayList(list2.size());
        for (List<GenSolvablePolynomial<C>> object : list2) {
            list3 = new ArrayList<GenSolvablePolynomial<C>>(object);
            arrayList3.add((ArrayList<GenSolvablePolynomial<C>>)list3);
        }
        list3 = null;
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n2 = 0;
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenSolvablePolynomial genSolvablePolynomial;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.remove(0);
            ExpVector expVector2 = genSolvablePolynomial2.leadingExpVector();
            ListIterator listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial = (GenSolvablePolynomial)listIterator.next();
                expVector = genSolvablePolynomial.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genSolvablePolynomial = (GenSolvablePolynomial)listIterator.next();
                expVector = genSolvablePolynomial.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (!bl) {
                arrayList2.add(genSolvablePolynomial2);
                arrayList5.add(n2);
            } else {
                arrayList6.add(n2);
            }
            ++n2;
        }
        if (debug) {
            logger.debug("ix, #M, jx = " + arrayList5 + ", " + arrayList3.size() + ", " + arrayList6);
        }
        int n3 = -1;
        for (int i = 0; i < arrayList5.size(); ++i) {
            int n4 = (Integer)arrayList5.get(i);
            if (n4 >= n && n3 == -1) {
                n3 = arrayList4.size();
            }
            if (n4 < 0) continue;
            list3 = (List)arrayList3.get(n4);
            arrayList4.add(list3);
        }
        if (arrayList2.size() <= 1 || n3 == -1) {
            return new SolvableExtendedGB(null, arrayList2, null, arrayList4);
        }
        return new SolvableExtendedGB(null, arrayList2, null, arrayList4);
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(int n, List<GenSolvablePolynomial<C>> list) {
        List<GenSolvablePolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monic(PolynomialList.castToList(list2)))).size() <= 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (!genSolvablePolynomialRing.coFac.isField() && genSolvablePolynomialRing.coFac.isCommutative()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        logger.info("start " + pairList);
        while (pairList.hasNext()) {
            GenPolynomial genPolynomial;
            GenSolvablePolynomial genSolvablePolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.info("pi    = " + genSolvablePolynomial2);
                logger.info("pj    = " + genSolvablePolynomial3);
            }
            if ((genSolvablePolynomial = this.sred.rightSPolynomial(genSolvablePolynomial2, genSolvablePolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(S) = " + genSolvablePolynomial.leadingExpVector());
            }
            if ((genPolynomial = this.sred.rightNormalform(list2, genSolvablePolynomial)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(H) = " + genPolynomial.leadingExpVector());
            }
            if ((genPolynomial = ((GenSolvablePolynomial)genPolynomial).monic()).isONE()) {
                list2.clear();
                list2.add((GenSolvablePolynomial<C>)genPolynomial);
                return list2;
            }
            if (debug) {
                logger.info("H = " + (GenSolvablePolynomial)genPolynomial);
            }
            if (genPolynomial.length() <= 0) continue;
            list2.add((GenSolvablePolynomial<C>)genPolynomial);
            pairList.put(genPolynomial);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.rightMinimalGB(list2);
        logger.info("end " + pairList);
        return list2;
    }
}

