/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.gb.GroebnerBase;
import edu.jas.gbufd.RGroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RGroebnerBasePseudoSeqTest
extends TestCase {
    ProductRing<BigInteger> pfac;
    GenPolynomialRing<Product<BigInteger>> fac;
    List<GenPolynomial<Product<BigInteger>>> L;
    List<GenPolynomial<Product<BigInteger>>> G;
    PolynomialList<Product<BigInteger>> F;
    GroebnerBase<Product<BigInteger>> bb;
    GenPolynomial<Product<BigInteger>> a;
    GenPolynomial<Product<BigInteger>> b;
    GenPolynomial<Product<BigInteger>> c;
    GenPolynomial<Product<BigInteger>> d;
    GenPolynomial<Product<BigInteger>> e;
    int pl = 3;
    int rl = 3;
    int kl = 7;
    int ll = 7;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RGroebnerBasePseudoSeqTest.suite());
    }

    public RGroebnerBasePseudoSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RGroebnerBasePseudoSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        this.pfac = new ProductRing<BigInteger>(bigInteger, this.pl);
        this.fac = new GenPolynomialRing<BigInteger>(this.pfac, this.rl);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new RGroebnerBasePseudoSeq<BigInteger>(this.pfac);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenPolynomial<Product<BigInteger>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO()) {
            return;
        }
        RGroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        RGroebnerBasePseudoSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7() {
        String string = "Z(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( 10000 B**2 + 6600 B + 2673 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            RGroebnerBasePseudoSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            RGroebnerBasePseudoSeqTest.fail((String)("" + iOException));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new BigInteger());
        arrayList.add(new BigInteger());
        ProductRing productRing = new ProductRing(arrayList);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(productRing, polynomialList.ring);
        List list = null;
        list = PolyUtil.toProductGen(genPolynomialRing, polynomialList.list);
        ArrayList arrayList2 = new ArrayList();
        for (GenPolynomial iterable2 : list) {
            arrayList2.add(iterable2.multiply(productRing.getAtomic(0)));
            arrayList2.add(iterable2.multiply(productRing.getAtomic(1)));
        }
        RGroebnerBasePseudoSeq rGroebnerBasePseudoSeq = new RGroebnerBasePseudoSeq(productRing);
        list = arrayList2;
        List list2 = rGroebnerBasePseudoSeq.GB(list);
        PolynomialList polynomialList2 = new PolynomialList(genPolynomialRing, list2);
        RGroebnerBasePseudoSeqTest.assertFalse((String)"trinks != null", (polynomialList2 == null ? 1 : 0) != 0);
        RGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)rGroebnerBasePseudoSeq.isGB(list2));
    }
}

