/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Pair;
import edu.jas.gbufd.OrderedRPairlist;
import edu.jas.gbufd.RReduction;
import edu.jas.gbufd.RReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RegularRingElem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RGroebnerBaseSeq<C extends RegularRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(RGroebnerBaseSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected RReduction<C> rred;

    public RGroebnerBaseSeq() {
        this(new RReductionSeq());
    }

    public RGroebnerBaseSeq(RReduction<C> rReduction) {
        super(rReduction);
        this.rred = rReduction;
        assert (this.red == this.rred);
    }

    @Override
    public boolean isGB(int n, List<GenPolynomial<C>> list) {
        if (list == null) {
            return true;
        }
        if (!this.rred.isBooleanClosed(list)) {
            if (debug) {
                logger.debug("not boolean closed");
            }
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<C> genPolynomial2;
                GenPolynomial<C> genPolynomial3 = list.get(j);
                if (!this.red.moduleCriterion(n, genPolynomial, genPolynomial3) || (genPolynomial2 = this.red.SPolynomial(genPolynomial, genPolynomial3)).isZERO() || (genPolynomial2 = this.red.normalform(list, genPolynomial2)).isZERO()) continue;
                if (debug) {
                    logger.debug("p" + i + " = " + genPolynomial);
                    logger.debug("p" + j + " = " + genPolynomial3);
                    logger.debug("s-pol = " + this.red.SPolynomial(genPolynomial, genPolynomial3));
                    logger.debug("s-pol(" + i + "," + j + ") != 0: " + genPolynomial2);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.rred.reducedBooleanClosure(list);
        logger.info("#bcF-#F = " + (list2.size() - list.size()));
        list = list2;
        List<GenPolynomial<C>> list3 = new ArrayList<GenPolynomial<C>>();
        OrderedRPairlist<C> orderedRPairlist = null;
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            GenPolynomial<C> genPolynomial2 = genPolynomial.monic();
            if (genPolynomial2.isONE()) {
                list3.clear();
                list3.add(genPolynomial2);
                return list3;
            }
            list3.add(genPolynomial2);
            if (orderedRPairlist == null) {
                orderedRPairlist = new OrderedRPairlist<C>(n, genPolynomial2.ring);
            }
            orderedRPairlist.put(genPolynomial2);
        }
        if (list3.size() <= 1) {
            return list3;
        }
        while (orderedRPairlist.hasNext()) {
            GenPolynomial<C> genPolynomial;
            Pair pair = orderedRPairlist.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial3 = pair.pi;
            GenPolynomial genPolynomial4 = pair.pj;
            if (logger.isDebugEnabled()) {
                logger.debug("pi    = " + genPolynomial3);
                logger.debug("pj    = " + genPolynomial4);
            }
            if (!this.red.moduleCriterion(n, genPolynomial3, genPolynomial4)) continue;
            GenPolynomial genPolynomial5 = this.red.SPolynomial(genPolynomial3, genPolynomial4);
            if (genPolynomial5.isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(S) = " + genPolynomial5.leadingExpVector());
            }
            if ((genPolynomial = this.red.normalform(list3, genPolynomial5)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ht(H) = " + genPolynomial.leadingExpVector());
            }
            if (genPolynomial.isONE()) {
                list3.clear();
                list3.add(genPolynomial);
                return list3;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("H = " + genPolynomial);
            }
            if (genPolynomial.isZERO()) continue;
            logger.info("Sred = " + genPolynomial);
            List<GenPolynomial<C>> list4 = this.rred.reducedBooleanClosure(list3, genPolynomial);
            logger.info("#bcH = " + list4.size());
            for (GenPolynomial<C> genPolynomial6 : list4) {
                genPolynomial6 = genPolynomial6.monic();
                list3.add(genPolynomial6);
                orderedRPairlist.put(genPolynomial6);
            }
            if (!debug || pair.getUseCriterion3() && pair.getUseCriterion4()) continue;
            logger.info("H != 0 but: " + pair);
        }
        logger.debug("#sequential list = " + list3.size());
        list3 = this.minimalGB(list3);
        logger.info("" + orderedRPairlist);
        return list3;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        List<GenPolynomial<Object>> list2;
        AbelianGroupElem<GenPolynomial<GenPolynomial>> abelianGroupElem;
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList(list.size());
        for (GenPolynomial<C> genPolynomial2 : list) {
            if (genPolynomial2 == null || genPolynomial2.isZERO()) continue;
            arrayList.add(genPolynomial2);
        }
        ArrayList<GenPolynomial<Object>> arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            abelianGroupElem = (GenPolynomial)arrayList.remove(0);
            GenPolynomial genPolynomial = abelianGroupElem;
            if (this.red.isTopReducible(arrayList, abelianGroupElem) || this.red.isTopReducible(arrayList2, abelianGroupElem)) {
                if (!logger.isInfoEnabled()) continue;
                ArrayList arrayList3 = new ArrayList(arrayList);
                arrayList3.addAll(arrayList2);
                if (((GenPolynomial)(abelianGroupElem = this.red.normalform(arrayList3, abelianGroupElem))).isZERO()) continue;
                logger.info("minGB not zero " + abelianGroupElem);
                list2 = this.rred.reducedBooleanClosure(arrayList, abelianGroupElem);
                if (list2.size() > 1) {
                    System.out.println("minGB not bc: bcH size = " + list2.size());
                    arrayList2.add(genPolynomial);
                    continue;
                }
                arrayList2.addAll(list2);
                continue;
            }
            arrayList2.add((GenPolynomial<Object>)abelianGroupElem);
        }
        arrayList = arrayList2;
        Collections.reverse(arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            abelianGroupElem = (GenPolynomial)arrayList.remove(0);
            GenPolynomial genPolynomial = abelianGroupElem;
            list2 = this.rred.reducedBooleanClosure((List<GenPolynomial<C>>)arrayList, (GenPolynomial<C>)(abelianGroupElem = this.red.normalform(arrayList, abelianGroupElem)));
            if (list2.size() > 1) {
                System.out.println("minGB not bc: bcH size = " + list2.size());
                arrayList.add(genPolynomial);
                continue;
            }
            arrayList.addAll(list2);
        }
        arrayList2 = new ArrayList(arrayList.size());
        for (GenPolynomial genPolynomial : arrayList) {
            abelianGroupElem = genPolynomial.monic().abs();
            if (genPolynomial.length() != ((GenPolynomial)abelianGroupElem).length()) {
                System.out.println("minGB not bc: #p != #a: a = " + abelianGroupElem + ", p = " + genPolynomial);
                abelianGroupElem = genPolynomial;
            }
            arrayList2.add((GenPolynomial<Object>)abelianGroupElem);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            abelianGroupElem = (GenPolynomial)arrayList.get(i);
            if (abelianGroupElem == null || ((GenPolynomial)abelianGroupElem).isZERO()) continue;
            ExpVector expVector = ((GenPolynomial)abelianGroupElem).leadingExpVector();
            for (int j = i + 1; j < arrayList.size(); ++j) {
                ExpVector expVector2;
                GenPolynomial genPolynomial = (GenPolynomial)arrayList.get(j);
                if (genPolynomial == null || genPolynomial.isZERO() || !expVector.equals(expVector2 = genPolynomial.leadingExpVector())) continue;
                abelianGroupElem = ((GenPolynomial)abelianGroupElem).sum(genPolynomial);
                arrayList.set(j, null);
            }
            arrayList2.add((GenPolynomial<Object>)abelianGroupElem);
        }
        arrayList = arrayList2;
        return arrayList;
    }
}

