/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementaryIntegration<C extends GcdRingElem<C>> {
    private static final Logger logger = LogManager.getLogger(ElementaryIntegration.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final FactorAbstract<C> irr;
    public final SquarefreeAbstract<C> sqf;
    public final GreatestCommonDivisorAbstract<C> ufd;
    public boolean irredLogPart = true;

    public ElementaryIntegration(RingFactory<C> ringFactory) {
        this.ufd = GCDFactory.getProxy(ringFactory);
        this.sqf = SquarefreeFactory.getImplementation(ringFactory);
        this.irr = FactorFactory.getImplementation(ringFactory);
        this.irredLogPart = true;
    }

    public QuotIntegral<C> integrate(Quotient<C> quotient) {
        Integral integral = this.integrate(quotient.num, quotient.den);
        return new QuotIntegral(quotient.ring, integral);
    }

    public Integral<C> integrate(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("zero or null not allowed");
        }
        if (genPolynomial.isZERO()) {
            return new Integral<C>(genPolynomial, genPolynomial2, genPolynomial);
        }
        if (genPolynomial2.isONE()) {
            GenPolynomial<C> genPolynomial3 = PolyUtil.baseIntegral(genPolynomial);
            return new Integral<C>(genPolynomial, genPolynomial2, genPolynomial3);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + genPolynomialRing);
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + genPolynomialRing);
        }
        GenPolynomial<C>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(genPolynomial, genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomialArray[0];
        GenPolynomial<C> genPolynomial5 = genPolynomialArray[1];
        GenPolynomial<C> genPolynomial6 = this.ufd.gcd(genPolynomial5, genPolynomial2);
        if (!genPolynomial6.isONE()) {
            genPolynomial5 = PolyUtil.basePseudoQuotientRemainder(genPolynomial5, genPolynomial6)[0];
            genPolynomial2 = PolyUtil.basePseudoQuotientRemainder(genPolynomial2, genPolynomial6)[0];
        }
        List<GenPolynomial<C>>[] listArray = this.integrateHermite(genPolynomial5, genPolynomial2);
        List<GenPolynomial<C>> list = listArray[0];
        List<GenPolynomial<C>> list2 = listArray[1];
        GenPolynomial<C> genPolynomial7 = list2.remove(0);
        genPolynomial4 = genPolynomial4.sum(genPolynomial7);
        GenPolynomial<C> genPolynomial8 = PolyUtil.baseIntegral(genPolynomial4);
        if (debug) {
            logger.debug("pi  = " + genPolynomial8);
            logger.debug("rat = " + list);
            logger.debug("log = " + list2);
        }
        if (list2.size() == 0) {
            return new Integral<C>(genPolynomial, genPolynomial2, genPolynomial8, list);
        }
        ArrayList arrayList = new ArrayList(list2.size() / 2);
        for (int i = 0; i < list2.size(); ++i) {
            GenPolynomial<C> genPolynomial9 = list2.get(i++);
            GenPolynomial<C> genPolynomial10 = list2.get(i);
            LogIntegral<C> logIntegral = this.integrateLogPartPrepare(genPolynomial9, genPolynomial10);
            arrayList.add(logIntegral);
        }
        if (debug) {
            logger.debug("logi = " + arrayList);
        }
        return new Integral<C>(genPolynomial, genPolynomial2, genPolynomial8, list, arrayList);
    }

    public List<GenPolynomial<C>>[] integrateHermite(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("d == null or d == 0");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException("a == null or a == 0");
        }
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.sqf.squarefreeFactors(genPolynomial2);
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(sortedMap.keySet());
        ArrayList arrayList2 = new ArrayList();
        for (GenPolynomial iterable2 : arrayList) {
            long arrayList3 = (Long)sortedMap.get(iterable2);
            GenPolynomial n = (GenPolynomial)iterable2.power(arrayList3);
            arrayList2.add(n);
        }
        List<GenPolynomial<C>> list = this.ufd.basePartialFraction(genPolynomial, arrayList2);
        ArrayList<GenPolynomial> arrayList3 = new ArrayList<GenPolynomial>();
        ArrayList<GenPolynomial> arrayList4 = new ArrayList<GenPolynomial>();
        arrayList4.add((GenPolynomial)list.remove(0));
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        int n = 0;
        for (GenPolynomial genPolynomial3 : arrayList) {
            GenPolynomial<GenPolynomial<C>> genPolynomial4 = (GenPolynomial<GenPolynomial<C>>)list.get(n++);
            long l = (Long)sortedMap.get(genPolynomial3);
            for (long i = l - 1L; i >= 1L; --i) {
                GenPolynomial genPolynomial5 = PolyUtil.baseDeriviative(genPolynomial3);
                GenPolynomial genPolynomial6 = genPolynomial4.divide((GenPolynomial<GenPolynomial<C>>)genPolynomialRing.fromInteger(-i));
                GenPolynomial<C>[] genPolynomialArray = this.ufd.baseGcdDiophant(genPolynomial5, genPolynomial3, genPolynomial6);
                GenPolynomial<C> genPolynomial7 = genPolynomialArray[0];
                GenPolynomial<C> genPolynomial8 = genPolynomialArray[1];
                GenPolynomial genPolynomial9 = (GenPolynomial)genPolynomial3.power(i);
                arrayList3.add(genPolynomial7);
                arrayList3.add(genPolynomial9);
                genPolynomial4 = ((GenPolynomial)genPolynomialRing.fromInteger(-i)).multiply(genPolynomial8).subtract(PolyUtil.baseDeriviative(genPolynomial7));
            }
            if (genPolynomial4.isZERO()) continue;
            arrayList4.add(genPolynomial4);
            arrayList4.add(genPolynomial3);
        }
        List[] listArray = new List[]{arrayList3, arrayList4};
        return listArray;
    }

    public LogIntegral<C> integrateLogPartPrepare(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (!this.irredLogPart) {
            return this.integrateLogPart(genPolynomial, genPolynomial2);
        }
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException(" A == null or A == 0");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + genPolynomialRing);
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + genPolynomialRing);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add((GcdRingElem)genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        List<GenPolynomial<C>> list = this.irr.baseFactorsSquarefree(genPolynomial2);
        List<GenPolynomial<C>> list2 = this.ufd.basePartialFraction(genPolynomial, list);
        GenPolynomial<C> genPolynomial3 = list2.remove(0);
        if (!genPolynomial3.isZERO()) {
            throw new RuntimeException(" A0 != 0: deg(A)>= deg(P)");
        }
        int n = 0;
        for (GenPolynomial<C> genPolynomial4 : list) {
            GenPolynomial<C> genPolynomial5 = list2.get(n++);
            if (genPolynomial4.degree(0) <= 1L) {
                arrayList.add((GcdRingElem)genPolynomial5.leadingBaseCoefficient());
                arrayList2.add(genPolynomial4);
                continue;
            }
            LogIntegral<C> logIntegral = this.integrateLogPart(genPolynomial5, genPolynomial4);
            arrayList.addAll(logIntegral.cfactors);
            arrayList2.addAll(logIntegral.cdenom);
            arrayList3.addAll(logIntegral.afactors);
            arrayList4.addAll(logIntegral.adenom);
        }
        return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
    }

    public LogIntegral<C> integrateLogPart(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new IllegalArgumentException("P == null or P == 0");
        }
        GenPolynomialRing<C> genPolynomialRing = genPolynomial2.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + genPolynomialRing);
        }
        if (!genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + genPolynomialRing);
        }
        ArrayList<GcdRingElem> arrayList = new ArrayList<GcdRingElem>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        if (genPolynomial2.degree(0) <= 1L) {
            arrayList.add((GcdRingElem)genPolynomial.leadingBaseCoefficient());
            arrayList2.add(genPolynomial2);
            return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
        }
        GenPolynomial<C> genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
        String[] stringArray = new String[]{"t"};
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, 1, genPolynomialRing.tord, stringArray);
        GenPolynomial genPolynomial4 = genPolynomialRing2.univariate(0);
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing, genPolynomialRing2);
        GenPolynomial genPolynomial5 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial6 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial2);
        GenPolynomial genPolynomial7 = PolyUfdUtil.introduceLowerVariable(genPolynomialRing3, genPolynomial3);
        GenPolynomialRing genPolynomialRing4 = genPolynomial6.ring;
        GenPolynomial genPolynomial8 = ((GenPolynomial)genPolynomialRing4.getONE()).multiply(genPolynomial4);
        GenPolynomial genPolynomial9 = genPolynomial5.subtract(genPolynomial8.multiply(genPolynomial7));
        GreatestCommonDivisorSubres greatestCommonDivisorSubres = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract<GenPolynomial<AlgebraicNumber<C>>> greatestCommonDivisorAbstract = null;
        GenPolynomial genPolynomial10 = greatestCommonDivisorSubres.recursiveUnivariateResultant(genPolynomial6, genPolynomial9);
        GenPolynomial genPolynomial11 = genPolynomial10.leadingBaseCoefficient();
        SortedMap<GenPolynomial<C>, Long> sortedMap = this.irr.baseFactors(genPolynomial11);
        for (GenPolynomial<C> genPolynomial12 : sortedMap.keySet()) {
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> genPolynomial13;
            if (genPolynomial12.isConstant()) continue;
            stringArray = genPolynomialRing.newVars("z_");
            genPolynomialRing = genPolynomialRing.copy();
            String[] stringArray2 = genPolynomialRing.setVars(stringArray);
            genPolynomial12 = genPolynomialRing.copy(genPolynomial12);
            AlgebraicNumberRing<C> algebraicNumberRing = new AlgebraicNumberRing<C>(genPolynomial12, true);
            logger.debug("afac = " + algebraicNumberRing.toScript());
            AlgebraicNumber<C> algebraicNumber = algebraicNumberRing.getGenerator();
            GenPolynomialRing genPolynomialRing5 = new GenPolynomialRing(algebraicNumberRing, genPolynomial6.ring);
            GenPolynomial genPolynomial14 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing5, genPolynomial2);
            GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> genPolynomial15 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing5, genPolynomial3);
            GenPolynomial<AlgebraicNumber<GenPolynomial<AlgebraicNumber<C>>>> genPolynomial16 = PolyUtil.convertToAlgebraicCoefficients(genPolynomialRing5, genPolynomial);
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> genPolynomial17 = genPolynomial16.subtract((AlgebraicNumber<GenPolynomial<AlgebraicNumber<C>>>)((Object)genPolynomial15.multiply(algebraicNumber)));
            if (greatestCommonDivisorAbstract == null) {
                greatestCommonDivisorAbstract = GCDFactory.getImplementation(algebraicNumberRing);
            }
            if ((genPolynomial13 = greatestCommonDivisorAbstract.baseGcd(genPolynomial14, genPolynomial17)).isConstant() || algebraicNumber.isZERO()) continue;
            arrayList3.add(algebraicNumber);
            arrayList4.add(genPolynomial13);
        }
        return new LogIntegral<C>(genPolynomial, genPolynomial2, arrayList, arrayList2, arrayList3, arrayList4);
    }

    public Quotient<C> deriviative(Quotient<C> quotient) {
        GenPolynomial genPolynomial = quotient.num;
        GenPolynomial genPolynomial2 = quotient.den;
        GenPolynomial genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        if (genPolynomial2.isONE()) {
            return new Quotient(quotient.ring, genPolynomial3, genPolynomial2);
        }
        GenPolynomial genPolynomial4 = PolyUtil.baseDeriviative(genPolynomial2);
        GenPolynomial genPolynomial5 = genPolynomial2.multiply(genPolynomial3).subtract(genPolynomial.multiply(genPolynomial4));
        GenPolynomial genPolynomial6 = genPolynomial2.multiply(genPolynomial2);
        Quotient quotient2 = new Quotient(quotient.ring, genPolynomial5, genPolynomial6);
        return quotient2;
    }

    public boolean isIntegral(QuotIntegral<C> quotIntegral) {
        Quotient quotient = quotIntegral.quot;
        QuotientRing quotientRing = quotient.ring;
        Quotient quotient2 = quotient.ring.getZERO();
        for (Quotient object : quotIntegral.rational) {
            Quotient quotient3 = this.deriviative(object);
            quotient2 = quotient2.sum(quotient3);
        }
        if (quotIntegral.logarithm.size() == 0) {
            return quotient.equals(quotient2);
        }
        for (LogIntegral logIntegral : quotIntegral.logarithm) {
            Quotient quotient4 = new Quotient(quotientRing, logIntegral.num, logIntegral.den);
            quotient2 = quotient2.sum(quotient4);
        }
        boolean bl = quotient.equals(quotient2);
        if (!bl) {
            return false;
        }
        for (LogIntegral logIntegral : quotIntegral.logarithm) {
            bl = this.isIntegral(logIntegral);
            if (bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isIntegral(LogIntegral<C> logIntegral) {
        void var7_9;
        RingElem ringElem;
        GenPolynomial genPolynomial;
        QuotientRing quotientRing = new QuotientRing(logIntegral.den.ring);
        Quotient quotient = new Quotient(quotientRing, logIntegral.num, logIntegral.den);
        Quotient quotient2 = quotientRing.getZERO();
        int n = 0;
        for (GenPolynomial abelianGroupElem2 : logIntegral.cdenom) {
            genPolynomial = PolyUtil.baseDeriviative(abelianGroupElem2);
            genPolynomial = genPolynomial.multiply((GcdRingElem)logIntegral.cfactors.get(n++));
            ringElem = new Quotient(quotientRing, genPolynomial, abelianGroupElem2);
            quotient2 = quotient2.sum(ringElem);
        }
        if (logIntegral.afactors.size() == 0) {
            return quotient.equals(quotient2);
        }
        quotient = quotient.subtract(quotient2);
        QuotientRing quotientRing2 = new QuotientRing(logIntegral.adenom.get((int)0).ring);
        AbelianGroupElem abelianGroupElem = quotientRing2.getZERO();
        genPolynomial = PolyUtil.convertToAlgebraicCoefficients(quotientRing2.ring, quotient.num);
        ringElem = PolyUtil.convertToAlgebraicCoefficients(quotientRing2.ring, quotient.den);
        Quotient quotient3 = new Quotient(quotientRing2, genPolynomial, ringElem);
        n = 0;
        for (GenPolynomial genPolynomial2 : logIntegral.adenom) {
            GenPolynomial genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial2);
            genPolynomial3 = genPolynomial3.multiply(logIntegral.afactors.get(n++));
            Quotient quotient4 = new Quotient(quotientRing2, genPolynomial3, genPolynomial2);
            Quotient quotient5 = var7_9.sum(quotient4);
        }
        boolean bl = quotient3.equals(var7_9);
        if (bl) {
            return true;
        }
        logger.warn("log integral not verified");
        return true;
    }
}

