/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.poly.ComplexRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.StarRingElem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Complex<C extends RingElem<C>>
implements StarRingElem<Complex<C>>,
GcdRingElem<Complex<C>> {
    private static final Logger logger = LogManager.getLogger(Complex.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final ComplexRing<C> ring;
    protected final C re;
    protected final C im;

    public Complex(ComplexRing<C> complexRing, C c, C c2) {
        this.ring = complexRing;
        this.re = c;
        this.im = c2;
    }

    public Complex(ComplexRing<C> complexRing, C c) {
        this((ComplexRing<RingElem>)complexRing, (RingElem)c, (RingElem)complexRing.ring.getZERO());
    }

    public Complex(ComplexRing<C> complexRing, long l) {
        this(complexRing, (RingElem)complexRing.ring.fromInteger(l));
    }

    public Complex(ComplexRing<C> complexRing) {
        this(complexRing, (RingElem)complexRing.ring.getZERO());
    }

    public Complex(ComplexRing<C> complexRing, String string) throws NumberFormatException {
        this.ring = complexRing;
        if (string == null || string.length() == 0) {
            this.re = (RingElem)complexRing.ring.getZERO();
            this.im = (RingElem)complexRing.ring.getZERO();
            return;
        }
        int n = (string = string.trim()).indexOf("i");
        if (n < 0) {
            this.re = (RingElem)complexRing.ring.parse(string);
            this.im = (RingElem)complexRing.ring.getZERO();
            return;
        }
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        String string3 = "";
        if (n < string.length()) {
            string3 = string.substring(n + 1, string.length());
        }
        this.re = (RingElem)complexRing.ring.parse(string2.trim());
        this.im = (RingElem)complexRing.ring.parse(string3.trim());
    }

    @Override
    public ComplexRing<C> factory() {
        return this.ring;
    }

    public C getRe() {
        return this.re;
    }

    public C getIm() {
        return this.im;
    }

    @Override
    public Complex<C> copy() {
        return new Complex<C>(this.ring, this.re, this.im);
    }

    public String toString() {
        Object object = this.re.toString();
        if (this.im.isZERO()) {
            return object;
        }
        object = (String)object + "i" + this.im;
        return object;
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.im.isZERO()) {
            stringBuffer.append(this.re.toScript());
        } else {
            Object object = this.im;
            if (!this.re.isZERO()) {
                stringBuffer.append(this.re.toScript());
                if (object.signum() > 0) {
                    stringBuffer.append(" + ");
                } else {
                    stringBuffer.append(" - ");
                    object = (RingElem)object.negate();
                }
            }
            if (object.isONE()) {
                stringBuffer.append("I");
            } else {
                stringBuffer.append(object.toScript()).append(" * I");
            }
            stringBuffer.append("");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.ring.toScript();
    }

    @Override
    public boolean isZERO() {
        return this.re.isZERO() && this.im.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.re.isONE() && this.im.isZERO();
    }

    public boolean isIMAG() {
        return this.re.isZERO() && this.im.isONE();
    }

    @Override
    public boolean isUnit() {
        if (this.isZERO()) {
            return false;
        }
        if (this.ring.isField()) {
            return true;
        }
        return ((Complex)this.norm()).re.isUnit();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object;
        if (!this.ring.equals(complex.ring)) {
            return false;
        }
        return this.re.equals(complex.re) && this.im.equals(complex.im);
    }

    @Override
    public int hashCode() {
        return 37 * this.re.hashCode() + this.im.hashCode();
    }

    @Override
    public int compareTo(Complex<C> complex) {
        int n = this.re.compareTo(complex.re);
        if (n != 0) {
            return n;
        }
        return this.im.compareTo(complex.im);
    }

    @Override
    public int signum() {
        int n = this.re.signum();
        if (n != 0) {
            return n;
        }
        return this.im.signum();
    }

    @Override
    public Complex<C> sum(Complex<C> complex) {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.sum(complex.re), (RingElem)this.im.sum(complex.im));
    }

    @Override
    public Complex<C> subtract(Complex<C> complex) {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.subtract(complex.re), (RingElem)this.im.subtract(complex.im));
    }

    @Override
    public Complex<C> negate() {
        return new Complex<RingElem>(this.ring, (RingElem)this.re.negate(), (RingElem)this.im.negate());
    }

    @Override
    public Complex<C> conjugate() {
        return new Complex<RingElem>((ComplexRing<RingElem>)this.ring, (RingElem)this.re, (RingElem)this.im.negate());
    }

    @Override
    public Complex<C> norm() {
        RingElem ringElem = (RingElem)this.re.multiply(this.re);
        ringElem = ringElem.sum((RingElem)this.im.multiply(this.im));
        return new Complex<RingElem>(this.ring, ringElem);
    }

    @Override
    public Complex<C> abs() {
        StarRingElem starRingElem = this.norm();
        logger.error("abs() square root missing");
        return starRingElem;
    }

    @Override
    public Complex<C> multiply(Complex<C> complex) {
        return new Complex<RingElem>(this.ring, ((RingElem)this.re.multiply(complex.re)).subtract((RingElem)this.im.multiply(complex.im)), ((RingElem)this.re.multiply(complex.im)).sum((RingElem)this.im.multiply(complex.re)));
    }

    @Override
    public Complex<C> inverse() {
        RingElem ringElem = (RingElem)((Complex)this.norm()).re.inverse();
        return new Complex<RingElem>(this.ring, this.re.multiply((RingElem)ringElem), this.im.multiply((RingElem)((RingElem)ringElem.negate())));
    }

    @Override
    public Complex<C> remainder(Complex<C> complex) {
        if (this.ring.isField()) {
            return this.ring.getZERO();
        }
        return this.quotientRemainder(complex)[1];
    }

    @Override
    public Complex<C> divide(Complex<C> complex) {
        if (this.ring.isField()) {
            return this.multiply((Complex<C>)complex.inverse());
        }
        return this.quotientRemainder(complex)[0];
    }

    public Complex<C>[] quotientRemainder(Complex<C> complex) {
        Complex[] complexArray = new Complex[2];
        C c = ((Complex)complex.norm()).re;
        Complex<Object> complex2 = this.multiply((Complex<C>)complex.conjugate());
        RingElem ringElem = (RingElem)complex2.re.divide(c);
        RingElem ringElem2 = (RingElem)complex2.re.remainder(c);
        RingElem ringElem3 = (RingElem)complex2.im.divide(c);
        RingElem ringElem4 = (RingElem)complex2.im.remainder(c);
        RingElem ringElem5 = ringElem2;
        RingElem ringElem6 = ringElem4;
        if (ringElem2.signum() < 0) {
            ringElem2 = (RingElem)ringElem2.negate();
        }
        if (ringElem4.signum() < 0) {
            ringElem4 = (RingElem)ringElem4.negate();
        }
        RingElem ringElem7 = (RingElem)c.factory().fromInteger(1L);
        if (ringElem2.sum(ringElem2).compareTo(c) > 0) {
            ringElem = ringElem5.signum() < 0 ? ringElem.subtract(ringElem7) : ringElem.sum(ringElem7);
        }
        if (ringElem4.sum(ringElem4).compareTo(c) > 0) {
            ringElem3 = ringElem6.signum() < 0 ? ringElem3.subtract(ringElem7) : ringElem3.sum(ringElem7);
        }
        complex2 = new Complex<RingElem>(this.ring, ringElem, ringElem3);
        Complex<Object> complex3 = this.subtract(complex2.multiply(complex));
        if (debug && c.compareTo(((Complex)complex3.norm()).re) < 0) {
            System.out.println("n = " + c);
            System.out.println("qr   = " + ringElem);
            System.out.println("qi   = " + ringElem3);
            System.out.println("rr   = " + ringElem2);
            System.out.println("ri   = " + ringElem4);
            System.out.println("rr1  = " + ringElem5);
            System.out.println("ri1  = " + ringElem6);
            System.out.println("this = " + this);
            System.out.println("S    = " + complex);
            System.out.println("Sp   = " + complex2);
            BigInteger bigInteger = (BigInteger)this.re;
            BigInteger bigInteger2 = (BigInteger)this.im;
            BigInteger bigInteger3 = (BigInteger)complex.re;
            BigInteger bigInteger4 = (BigInteger)complex.im;
            BigComplex bigComplex = new BigComplex(new BigRational(bigInteger), new BigRational(bigInteger2));
            BigComplex bigComplex2 = new BigComplex(new BigRational(bigInteger3), new BigRational(bigInteger4));
            BigComplex bigComplex3 = bigComplex.divide(bigComplex2);
            System.out.println("qc   = " + bigComplex3);
            BigDecimal bigDecimal = new BigDecimal(bigComplex3.getRe());
            BigDecimal bigDecimal2 = new BigDecimal(bigComplex3.getIm());
            System.out.println("qrd  = " + bigDecimal);
            System.out.println("qid  = " + bigDecimal2);
            throw new ArithmeticException("QR norm not decreasing " + complex3 + ", " + (Complex)complex3.norm());
        }
        complexArray[0] = complex2;
        complexArray[1] = complex3;
        return complexArray;
    }

    @Override
    public Complex<C> gcd(Complex<C> complex) {
        if (complex == null || complex.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return complex;
        }
        if (this.ring.isField()) {
            return this.ring.getONE();
        }
        AbelianGroupElem<Complex<Complex<C>>> abelianGroupElem = this;
        AbelianGroupElem<Complex<C>> abelianGroupElem2 = complex;
        if (((Complex)abelianGroupElem).re.signum() < 0) {
            abelianGroupElem = ((Complex)abelianGroupElem).negate();
        }
        if (((Complex)abelianGroupElem2).re.signum() < 0) {
            abelianGroupElem2 = ((Complex)abelianGroupElem2).negate();
        }
        while (!((Complex)abelianGroupElem2).isZERO()) {
            Complex<Complex<C>>[] complexArray;
            if (debug) {
                logger.info("norm(b), a, b = " + (Complex)((Complex)abelianGroupElem2).norm() + ", " + abelianGroupElem + ", " + abelianGroupElem2);
            }
            if ((complexArray = ((Complex)abelianGroupElem).quotientRemainder((Complex<Complex<Complex<C>>>)abelianGroupElem2))[0].isZERO()) {
                System.out.println("a = " + abelianGroupElem);
            }
            abelianGroupElem = abelianGroupElem2;
            abelianGroupElem2 = complexArray[1];
        }
        if (((Complex)abelianGroupElem).re.signum() < 0) {
            abelianGroupElem = ((Complex)abelianGroupElem).negate();
        }
        return abelianGroupElem;
    }

    public Complex<C>[] egcd(Complex<C> complex) {
        Complex[] complexArray = new Complex[]{null, null, null};
        if (complex == null || complex.isZERO()) {
            complexArray[0] = this;
            return complexArray;
        }
        if (this.isZERO()) {
            complexArray[0] = complex;
            return complexArray;
        }
        if (this.ring.isField()) {
            Complex<RingElem> complex2 = new Complex<RingElem>(this.ring, ((RingElem)this.ring.ring.fromInteger(1L)).divide((RingElem)this.ring.ring.fromInteger(2L)));
            complexArray[0] = this.ring.getONE();
            complexArray[1] = ((Complex)this.inverse()).multiply(complex2);
            complexArray[2] = ((Complex)complex.inverse()).multiply(complex2);
            return complexArray;
        }
        Complex<C> complex3 = this;
        Complex<C> complex4 = complex;
        Element<C> element = this.ring.getONE();
        Complex<C> complex5 = this.ring.getZERO();
        AbelianGroupElem abelianGroupElem = this.ring.getZERO();
        Complex<C> complex6 = this.ring.getONE();
        while (!complex4.isZERO()) {
            if (debug) {
                logger.info("norm(r), q, r = " + (Complex)complex4.norm() + ", " + complex3 + ", " + complex4);
            }
            Complex<C>[] complexArray2 = complex3.quotientRemainder(complex4);
            complex3 = complexArray2[0];
            Complex<C> complex7 = ((Complex)element).subtract(complex3.multiply(complex5));
            Complex<C> complex8 = ((Complex)abelianGroupElem).subtract(complex3.multiply(complex6));
            element = complex5;
            abelianGroupElem = complex6;
            complex5 = complex7;
            complex6 = complex8;
            complex3 = complex4;
            complex4 = complexArray2[1];
        }
        if (complex3.re.signum() < 0) {
            complex3 = complex3.negate();
            element = ((Complex)element).negate();
            abelianGroupElem = ((Complex)abelianGroupElem).negate();
        }
        complexArray[0] = complex3;
        complexArray[1] = element;
        complexArray[2] = abelianGroupElem;
        return complexArray;
    }
}

