/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.TermOrder;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TermOrderByName {
    private static final Logger logger = LogManager.getLogger(TermOrderByName.class);
    public static final TermOrder LEX = new TermOrder(1);
    public static final TermOrder INVLEX = new TermOrder(2);
    public static final TermOrder GRLEX = new TermOrder(3);
    public static final TermOrder IGRLEX = new TermOrder(4);
    public static final TermOrder REVLEX = new TermOrder(5);
    public static final TermOrder REVILEX = new TermOrder(6);
    public static final TermOrder REVTDEG = new TermOrder(7);
    public static final TermOrder REVITDG = new TermOrder(8);
    public static final TermOrder ITDEGLEX = new TermOrder(9);
    public static final TermOrder REVITDEG = new TermOrder(10);
    public static final TermOrder DEFAULT = new TermOrder(4);
    public static final TermOrder Lexicographic = REVILEX;
    public static final TermOrder NegativeLexicographic = REVLEX;
    public static final TermOrder DegreeLexicographic = REVITDG;
    public static final TermOrder NegativeDegreeLexicographic = REVITDEG;
    public static final TermOrder ReverseLexicographic = INVLEX;
    public static final TermOrder DegreeReverseLexicographic = ITDEGLEX;
    public static final TermOrder NegativeReverseLexicographic = LEX;
    public static final TermOrder NegativeDegreeReverseLexicographic = GRLEX;
    public static final TermOrder lex = Lexicographic;
    public static final TermOrder degrevlex = DegreeReverseLexicographic;
    public static final TermOrder deglex = DegreeLexicographic;
    public static final TermOrder invlex = INVLEX;
    public static final TermOrder neglex = NegativeLexicographic;
    public static final TermOrder negdegrevlex = NegativeDegreeReverseLexicographic;
    public static final TermOrder negdeglex = NegativeDegreeLexicographic;
    public static final TermOrder negrevlex = NegativeReverseLexicographic;
    public static final TermOrder lp = lex;
    public static final TermOrder dp = degrevlex;
    public static final TermOrder Dp = deglex;
    public static final TermOrder rp = invlex;
    public static final TermOrder ls = neglex;
    public static final TermOrder ds = negdegrevlex;
    public static final TermOrder Ds = negdeglex;

    public static final TermOrder blockOrder(TermOrder termOrder, int n) {
        return termOrder.blockOrder(n);
    }

    public static final TermOrder blockOrder(TermOrder termOrder, ExpVector expVector, int n) {
        return termOrder.blockOrder(n, expVector.length());
    }

    public static final TermOrder blockOrder(TermOrder termOrder, TermOrder termOrder2, int n) {
        return new TermOrder(termOrder.getEvord(), termOrder2.getEvord(), Integer.MAX_VALUE, n);
    }

    public static final TermOrder blockOrder(TermOrder termOrder, TermOrder termOrder2, ExpVector expVector, int n) {
        return new TermOrder(termOrder.getEvord(), termOrder2.getEvord(), expVector.length(), n);
    }

    public static final TermOrder weightOrder(long[] lArray) {
        return TermOrder.reverseWeight(new long[][]{lArray});
    }

    public static final TermOrder weightOrder(long[][] lArray) {
        return TermOrder.reverseWeight(lArray);
    }

    public static final TermOrder weightOrder(List<List<Long>> list) {
        int n = list.size();
        long[][] lArrayArray = new long[n][];
        for (int i = 0; i < n; ++i) {
            List<Long> list2 = list.get(i);
            int n2 = list2.size();
            long[] lArray = new long[n2];
            for (int j = 0; j < n2; ++j) {
                lArray[j] = list2.get(j);
            }
            lArrayArray[i] = lArray;
        }
        return TermOrderByName.weightOrder(lArrayArray);
    }

    public static final long[][] weightForOrder(TermOrder termOrder, int n) {
        if (termOrder.isSplit()) {
            return TermOrderByName.weightForSplitOrder(termOrder.getEvord(), termOrder.getEvord2(), n, termOrder.getSplit());
        }
        return TermOrderByName.weightForOrder(termOrder.getEvord(), n);
    }

    static final long[][] weightForOrder(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 4: {
                n3 = n2 + 1;
                break;
            }
            case 2: 
            case 6: {
                n3 = n2;
                break;
            }
        }
        logger.info("to = " + n + ", k = " + n3);
        long[][] lArrayArray = new long[n3][];
        switch (n) {
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    lArrayArray[i] = new long[n2];
                    long[] lArray = lArrayArray[i];
                    for (int j = 0; j < n2; ++j) {
                        lArray[j] = i == j ? 1L : 0L;
                    }
                }
                break;
            }
            case 4: {
                int n4;
                lArrayArray[0] = new long[n2];
                long[] lArray = lArrayArray[0];
                for (n4 = 0; n4 < n2; ++n4) {
                    lArray[n4] = 1L;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    lArrayArray[n4 + 1] = new long[n2];
                    lArray = lArrayArray[n4 + 1];
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = n4 == i ? 1L : 0L;
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n2; ++i) {
                    lArrayArray[i] = new long[n2];
                    long[] lArray = lArrayArray[i];
                    for (int j = 0; j < n2; ++j) {
                        lArray[j] = n2 - 1 - i == j ? 1L : 0L;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("case " + n + " not implemented for weightForOrder");
            }
        }
        return lArrayArray;
    }

    static final long[][] weightForSplitOrder(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        long[] lArray;
        int n7 = 0;
        switch (n) {
            case 4: {
                ++n7;
                break;
            }
            case 2: {
                n7 += n4;
                break;
            }
        }
        switch (n2) {
            case 4: {
                ++n7;
                break;
            }
            case 2: {
                n7 += n3 - n4;
                break;
            }
        }
        logger.info("to = " + n + ", k = " + n7);
        long[][] lArrayArray = new long[n7 + n3][];
        boolean bl = true;
        switch (n) {
            case 4: {
                lArrayArray[0] = new long[n3];
                lArray = lArrayArray[0];
                for (n6 = 0; n6 < n4; ++n6) {
                    lArray[n6] = 1L;
                }
                while (n6 < n3) {
                    lArray[n6] = 0L;
                    ++n6;
                }
                break;
            }
            case 2: {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArrayArray[n5] = new long[n3];
                    lArray = lArrayArray[n5];
                    for (n6 = 0; n6 < n3; ++n6) {
                        lArray[n6] = n3 - 1 - n5 == n6 ? 1L : 0L;
                    }
                }
                break;
            }
            default: {
                bl = false;
            }
        }
        switch (n2) {
            case 4: {
                lArrayArray[n7 - 1] = new long[n3];
                lArray = lArrayArray[n7 - 1];
                for (n6 = 0; n6 < n4; ++n6) {
                    lArray[n6] = 0L;
                }
                while (n6 < n3) {
                    lArray[n6] = 1L;
                    ++n6;
                }
                break;
            }
            case 2: {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArrayArray[n4 + n5] = new long[n3];
                    lArray = lArrayArray[n4 + n5];
                    for (n6 = 0; n6 < n3; ++n6) {
                        lArray[n6] = n3 - 1 - n5 == n4 + n6 ? 1L : 0L;
                    }
                }
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            throw new UnsupportedOperationException("case " + n + "/" + n2 + " not implemented for weightForOrder");
        }
        for (int i = 0; i < n3; ++i) {
            lArrayArray[n7 + i] = new long[n3];
            long[] lArray2 = lArrayArray[n7 + i];
            for (n5 = 0; n5 < n3; ++n5) {
                lArray2[n5] = i == n5 ? 1L : 0L;
            }
        }
        return lArrayArray;
    }
}

