/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.ps.Coefficients;
import edu.jas.ps.TaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesMap;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.IntFunction;

public class UnivPowerSeriesRing<C extends RingElem<C>>
implements RingFactory<UnivPowerSeries<C>> {
    protected static final Random random = new Random();
    public static final int DEFAULT_TRUNCATE = 11;
    int truncate;
    public static final String DEFAULT_NAME = "x";
    String var;
    public final RingFactory<C> coFac;
    public final UnivPowerSeries<C> ONE;
    public final UnivPowerSeries<C> ZERO;

    private UnivPowerSeriesRing() {
        throw new IllegalArgumentException("do not use no-argument constructor");
    }

    public UnivPowerSeriesRing(RingFactory<C> ringFactory) {
        this(ringFactory, 11, DEFAULT_NAME);
    }

    public UnivPowerSeriesRing(RingFactory<C> ringFactory, int n) {
        this(ringFactory, n, DEFAULT_NAME);
    }

    public UnivPowerSeriesRing(RingFactory<C> ringFactory, String string) {
        this(ringFactory, 11, string);
    }

    public UnivPowerSeriesRing(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing.coFac, 11, genPolynomialRing.getVars()[0]);
    }

    public UnivPowerSeriesRing(RingFactory<C> ringFactory, int n, String string) {
        this.coFac = ringFactory;
        this.truncate = n;
        this.var = string;
        this.ONE = new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                if (n == 0) {
                    return (RingElem)UnivPowerSeriesRing.this.coFac.getONE();
                }
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
        this.ZERO = new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public UnivPowerSeries<C> fixPoint(UnivPowerSeriesMap<C> univPowerSeriesMap) {
        UnivPowerSeries univPowerSeries = new UnivPowerSeries(this);
        UnivPowerSeries<C> univPowerSeries2 = univPowerSeriesMap.map(univPowerSeries);
        univPowerSeries.lazyCoeffs = univPowerSeries2.lazyCoeffs;
        return univPowerSeries2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.coFac.getClass().getSimpleName();
        stringBuffer.append(string + "((" + this.var + "))");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("PS(");
        String string = null;
        try {
            string = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception exception) {
            string = this.coFac.toScript();
        }
        stringBuffer.append(string + ",\"" + this.var + "\"," + this.truncate + ")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        UnivPowerSeriesRing univPowerSeriesRing = null;
        try {
            univPowerSeriesRing = (UnivPowerSeriesRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (univPowerSeriesRing == null) {
            return false;
        }
        if (!this.coFac.equals(univPowerSeriesRing.coFac)) {
            return false;
        }
        return this.var.equals(univPowerSeriesRing.var);
    }

    public int hashCode() {
        int n = this.coFac.hashCode();
        n += this.var.hashCode() << 27;
        return n += this.truncate;
    }

    @Override
    public UnivPowerSeries<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public UnivPowerSeries<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<UnivPowerSeries<C>> generators() {
        List list = this.coFac.generators();
        ArrayList<UnivPowerSeries<C>> arrayList = new ArrayList<UnivPowerSeries<C>>(list.size());
        for (final RingElem ringElem : list) {
            UnivPowerSeries univPowerSeries = new UnivPowerSeries(this, new Coefficients<C>(){

                @Override
                public C generate(int n) {
                    if (n == 0) {
                        return ringElem;
                    }
                    return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
                }
            });
            arrayList.add(univPowerSeries);
        }
        arrayList.add(this.ONE.shift(1));
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    public UnivPowerSeries<C> getEXP() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> univPowerSeries) {
                return univPowerSeries.integrate((RingElem)UnivPowerSeriesRing.this.coFac.getONE());
            }
        });
    }

    public UnivPowerSeries<C> getSIN() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> univPowerSeries) {
                return ((UnivPowerSeries)univPowerSeries.negate()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getONE()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getZERO());
            }
        });
    }

    public UnivPowerSeries<C> getCOS() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> univPowerSeries) {
                return ((UnivPowerSeries)univPowerSeries.negate()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getZERO()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getONE());
            }
        });
    }

    public UnivPowerSeries<C> getTAN() {
        return this.fixPoint(new UnivPowerSeriesMap<C>(){

            @Override
            public UnivPowerSeries<C> map(UnivPowerSeries<C> univPowerSeries) {
                return univPowerSeries.multiply(univPowerSeries).sum((UnivPowerSeries)UnivPowerSeriesRing.this.getONE()).integrate((RingElem)UnivPowerSeriesRing.this.coFac.getZERO());
            }
        });
    }

    public UnivPowerSeries<C> solveODE(UnivPowerSeries<C> univPowerSeries, C c) {
        return univPowerSeries.integrate(c);
    }

    @Override
    public boolean isCommutative() {
        return this.coFac.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.coFac.isAssociative();
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    @Override
    public UnivPowerSeries<C> fromInteger(long l) {
        return this.ONE.multiply((RingElem)this.coFac.fromInteger(l));
    }

    @Override
    public UnivPowerSeries<C> fromInteger(BigInteger bigInteger) {
        return this.ONE.multiply((RingElem)this.coFac.fromInteger(bigInteger));
    }

    public GenPolynomialRing<C> polyRing() {
        return new GenPolynomialRing<C>(this.coFac, 1, new String[]{this.var});
    }

    public UnivPowerSeries<C> fromPolynomial(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ZERO;
        }
        if (genPolynomial.isONE()) {
            return this.ONE;
        }
        if (genPolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        HashMap<Integer, C> hashMap = new HashMap<Integer, C>(genPolynomial.length());
        for (Monomial<C> monomial : genPolynomial) {
            long l = monomial.exponent().getVal(0);
            hashMap.put((int)l, monomial.coefficient());
        }
        return new UnivPowerSeries(this, new Coefficients<C>(hashMap){

            @Override
            public C generate(int n) {
                return (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
            }
        });
    }

    public UnivPowerSeries<C> random() {
        return this.random(5, 0.7f, random);
    }

    @Override
    public UnivPowerSeries<C> random(int n) {
        return this.random(n, 0.7f, random);
    }

    @Override
    public UnivPowerSeries<C> random(int n, Random random) {
        return this.random(n, 0.7f, random);
    }

    public UnivPowerSeries<C> random(int n, float f) {
        return this.random(n, f, random);
    }

    public UnivPowerSeries<C> random(final int n, final float f, final Random random) {
        return new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int n2) {
                float f2 = random.nextFloat();
                RingElem ringElem = f2 < f ? (RingElem)UnivPowerSeriesRing.this.coFac.random(n, random) : (RingElem)UnivPowerSeriesRing.this.coFac.getZERO();
                return ringElem;
            }
        });
    }

    public UnivPowerSeries<C> generate(final IntFunction<C> intFunction) {
        return new UnivPowerSeries(this, new Coefficients<C>(){

            @Override
            public C generate(int n) {
                RingElem ringElem = (RingElem)intFunction.apply(n);
                return ringElem;
            }
        });
    }

    @Override
    public UnivPowerSeries<C> copy(UnivPowerSeries<C> univPowerSeries) {
        return new UnivPowerSeries(this, univPowerSeries.lazyCoeffs);
    }

    @Override
    public UnivPowerSeries<C> parse(String string) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    @Override
    public UnivPowerSeries<C> parse(Reader reader) {
        throw new UnsupportedOperationException("parse for power series not implemented");
    }

    public UnivPowerSeries<C> seriesOfTaylor(final TaylorFunction<C> taylorFunction, C c) {
        return new UnivPowerSeries(this, new Coefficients<C>((RingElem)c){
            TaylorFunction<C> der;
            long k;
            long n;
            final /* synthetic */ RingElem val$a;
            {
                this.val$a = ringElem;
                this.der = taylorFunction;
                this.k = 0L;
                this.n = 1L;
            }

            @Override
            public C generate(int n) {
                Object object;
                if (n == 0) {
                    RingElem ringElem = this.der.evaluate(this.val$a);
                    this.der = this.der.deriviative();
                    return ringElem;
                }
                if (n > 0) {
                    object = this.get(n - 1);
                }
                ++this.k;
                this.n *= this.k;
                object = this.der.evaluate(this.val$a);
                object = object.divide((RingElem)((RingElem)UnivPowerSeriesRing.this.coFac.fromInteger(this.n)));
                this.der = this.der.deriviative();
                return object;
            }
        });
    }
}

