/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.ps.PolynomialTaylorFunction;
import edu.jas.ps.TaylorFunction;
import edu.jas.ps.UnivPowerSeries;
import edu.jas.ps.UnivPowerSeriesRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.HenselUtil;
import edu.jas.ufd.NoLiftingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HenselMultUtil {
    private static final Logger logger = LogManager.getLogger(HenselMultUtil.class);
    private static final boolean debug = logger.isInfoEnabled();

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(GenPolynomial<MOD> genPolynomial, GenPolynomial<MOD> genPolynomial2, GenPolynomial<MOD> genPolynomial3, List<MOD> list, long l, long l2) throws NoLiftingException {
        GenPolynomial<RingElem<Object>> genPolynomial4;
        GenPolynomial<GcdRingElem> genPolynomial5;
        GenPolynomial<GcdRingElem> genPolynomial62;
        GenPolynomialRing genPolynomialRing = genPolynomial3.ring;
        if (genPolynomialRing.nvar == 1) {
            return HenselUtil.liftDiophant(genPolynomial, genPolynomial2, genPolynomial3, l2);
        }
        if (!genPolynomialRing.equals(genPolynomial.ring)) {
            throw new IllegalArgumentException("A.ring != pkfac: " + genPolynomial.ring + " != " + genPolynomialRing);
        }
        ArrayList<MOD> arrayList = new ArrayList<MOD>(list);
        GcdRingElem gcdRingElem = (GcdRingElem)arrayList.remove(arrayList.size() - 1);
        GenPolynomial genPolynomial7 = genPolynomialRing.getONE();
        GenPolynomial<Element> genPolynomial8 = genPolynomialRing.univariate(0, 1L);
        genPolynomial8 = genPolynomial8.subtract(genPolynomialRing.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal()));
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomialRing.coFac;
        GcdRingElem gcdRingElem2 = (GcdRingElem)modularRingFactory.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        GenPolynomial<GcdRingElem> genPolynomial9 = PolyUtil.evaluateMain(genPolynomialRing2, genPolynomial, gcdRingElem2);
        GenPolynomial<GcdRingElem> genPolynomial10 = PolyUtil.evaluateMain(genPolynomialRing2, genPolynomial2, gcdRingElem2);
        GenPolynomial<GcdRingElem> genPolynomial11 = PolyUtil.evaluateMain(genPolynomialRing2, genPolynomial3, gcdRingElem2);
        List<GenPolynomial<GcdRingElem>> list2 = HenselMultUtil.liftDiophant(genPolynomial9, genPolynomial10, genPolynomial11, arrayList, l, l2);
        if (genPolynomialRing.nvar == 2 && !HenselUtil.isDiophantLift(genPolynomial10, genPolynomial9, list2.get(0), list2.get(1), genPolynomial11)) {
            throw new NoLiftingException("isDiophantLift: false");
        }
        if (!genPolynomialRing2.equals(list2.get((int)0).ring)) {
            throw new IllegalArgumentException("qfac != ckfac: " + list2.get((int)0).ring + " != " + genPolynomialRing2);
        }
        GenPolynomialRing<BigInteger> genPolynomialRing3 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        String[] stringArray = new String[]{genPolynomialRing.getVars()[genPolynomialRing.nvar - 1]};
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing(genPolynomialRing2, 1, stringArray);
        ArrayList<GenPolynomial<MOD>> arrayList2 = new ArrayList<GenPolynomial<MOD>>(list2.size());
        ArrayList arrayList3 = new ArrayList(list2.size());
        for (GenPolynomial<GcdRingElem> genPolynomial62 : list2) {
            genPolynomial5 = genPolynomial62.extend(genPolynomialRing, 0, 0L);
            arrayList2.add(genPolynomial5);
            genPolynomial4 = PolyUtil.integerFromModularCoefficients(genPolynomialRing3, genPolynomial5);
            arrayList3.add(genPolynomial4);
        }
        GenPolynomial<BigInteger> genPolynomial12 = PolyUtil.integerFromModularCoefficients(genPolynomialRing3, genPolynomial);
        genPolynomial62 = PolyUtil.integerFromModularCoefficients(genPolynomialRing3, genPolynomial2);
        genPolynomial5 = PolyUtil.integerFromModularCoefficients(genPolynomialRing3, genPolynomial3);
        genPolynomial4 = genPolynomial5;
        genPolynomial4 = genPolynomial4.subtract((RingElem<Object>)genPolynomial62.multiply((GcdRingElem)((Object)((GenPolynomial)arrayList3.get(0)))));
        if ((genPolynomial4 = genPolynomial4.subtract((RingElem<Object>)genPolynomial12.multiply((BigInteger)((Object)((GenPolynomial)arrayList3.get(1)))))).isZERO()) {
            logger.info("liftDiophant leaving on zero E");
            return arrayList2;
        }
        GenPolynomial genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial4);
        logger.info("Ep(0," + genPolynomialRing.nvar + ") = " + genPolynomial13);
        if (genPolynomial13.isZERO()) {
            logger.info("liftDiophant leaving on zero Ep mod p^k");
            return arrayList2;
        }
        int n = 1;
        while ((long)n <= l) {
            GenPolynomial genPolynomial14 = PolyUtil.recursive(genPolynomialRing4, genPolynomial13);
            UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(genPolynomialRing4);
            PolynomialTaylorFunction polynomialTaylorFunction = new PolynomialTaylorFunction(genPolynomial14);
            Element element = genPolynomialRing2.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
            UnivPowerSeries<Element> univPowerSeries = univPowerSeriesRing.seriesOfTaylor(polynomialTaylorFunction, (GenPolynomial<Element>)element);
            GenPolynomial genPolynomial15 = (GenPolynomial)univPowerSeries.coefficient(n);
            List<GenPolynomial<GcdRingElem>> list3 = HenselMultUtil.liftDiophant(genPolynomial9, genPolynomial10, genPolynomial15, arrayList, l, l2);
            if (!genPolynomialRing2.coFac.equals(list3.get((int)0).ring.coFac)) {
                throw new IllegalArgumentException("ckfac != pkfac: " + genPolynomialRing2.coFac + " != " + list3.get((int)0).ring.coFac);
            }
            if (genPolynomialRing.nvar == 2 && !HenselUtil.isDiophantLift(genPolynomial9, genPolynomial10, list3.get(1), list3.get(0), genPolynomial15)) {
                throw new NoLiftingException("isDiophantLift: false");
            }
            genPolynomial7 = genPolynomial7.multiply(genPolynomial8);
            int n2 = 0;
            arrayList3 = new ArrayList(list2.size());
            for (GenPolynomial<GcdRingElem> genPolynomial16 : list3) {
                GenPolynomial<RingElem<Object>> genPolynomial17 = genPolynomial16.extend(genPolynomialRing, 0, 0L);
                GenPolynomial genPolynomial18 = genPolynomial17.multiply((GcdRingElem)((Object)genPolynomial7));
                genPolynomial17 = ((GenPolynomial)arrayList2.get(n2)).sum(genPolynomial18);
                arrayList2.set(n2++, genPolynomial17);
                GenPolynomial<BigInteger> genPolynomial19 = PolyUtil.integerFromModularCoefficients(genPolynomialRing3, genPolynomial18);
                arrayList3.add(genPolynomial19);
            }
            genPolynomial4 = genPolynomial4.subtract((RingElem<Object>)genPolynomial62.multiply((GcdRingElem)((Object)((GenPolynomial)arrayList3.get(0)))));
            if ((genPolynomial4 = genPolynomial4.subtract((RingElem<Object>)genPolynomial12.multiply((BigInteger)((Object)((GenPolynomial)arrayList3.get(1)))))).isZERO()) {
                logger.info("liftDiophant leaving on zero E");
                return arrayList2;
            }
            genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial4);
            logger.info("Ep(" + n + "," + genPolynomialRing.nvar + ") = " + genPolynomial13);
            if (genPolynomial13.isZERO()) {
                logger.info("liftDiophant leaving on zero Ep mod p^k");
                return arrayList2;
            }
            ++n;
        }
        return arrayList2;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftDiophant(List<GenPolynomial<MOD>> list, GenPolynomial<MOD> genPolynomial, List<MOD> list2, long l, long l2) throws NoLiftingException {
        GenPolynomial<BigInteger> genPolynomial2;
        GenPolynomial<RingElem<BigInteger>> genPolynomial3;
        Iterable iterable;
        MonoidElem<GenPolynomial<Object>> monoidElem;
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar == 1) {
            return HenselUtil.liftDiophant(list, genPolynomial, l2);
        }
        if (!genPolynomialRing.equals(list.get((int)0).ring)) {
            throw new IllegalArgumentException("A.ring != pkfac: " + list.get((int)0).ring + " != " + genPolynomialRing);
        }
        GenPolynomial<GenPolynomial<MOD>> genPolynomial5 = genPolynomialRing.getONE();
        for (GenPolynomial<MOD> arrayList2 : list) {
            genPolynomial5 = genPolynomial5.multiply(arrayList2);
        }
        ArrayList arrayList3 = new ArrayList(list.size());
        for (GenPolynomial<MOD> genPolynomial4 : list) {
            monoidElem = PolyUtil.basePseudoDivide(genPolynomial5, genPolynomial4);
            arrayList3.add(monoidElem);
        }
        ArrayList<MOD> arrayList = new ArrayList<MOD>(list2);
        GcdRingElem gcdRingElem = (GcdRingElem)arrayList.remove(arrayList.size() - 1);
        monoidElem = genPolynomialRing.getONE();
        GenPolynomial<Element> genPolynomial6 = genPolynomialRing.univariate(0, 1L);
        genPolynomial6 = genPolynomial6.subtract(genPolynomialRing.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal()));
        ModularRingFactory modularRingFactory = (ModularRingFactory)genPolynomialRing.coFac;
        GcdRingElem gcdRingElem2 = (GcdRingElem)modularRingFactory.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.contract(1);
        ArrayList<GenPolynomial<MOD>> arrayList2 = new ArrayList<GenPolynomial<MOD>>(list.size());
        for (GenPolynomial<MOD> genPolynomial7 : list) {
            iterable = PolyUtil.evaluateMain(genPolynomialRing2, genPolynomial7, gcdRingElem2);
            arrayList2.add((GenPolynomial<MOD>)iterable);
        }
        GenPolynomial<GcdRingElem> genPolynomial8 = PolyUtil.evaluateMain(genPolynomialRing2, genPolynomial, gcdRingElem2);
        List<GenPolynomial<MOD>> list3 = HenselMultUtil.liftDiophant(arrayList2, genPolynomial8, arrayList, l, l2);
        if (genPolynomialRing.nvar == 2 && !HenselUtil.isDiophantLift(arrayList2, list3, genPolynomial8)) {
            throw new NoLiftingException("isDiophantLift: false");
        }
        if (!genPolynomialRing2.equals(list3.get((int)0).ring)) {
            throw new IllegalArgumentException("qfac != ckfac: " + list3.get((int)0).ring + " != " + genPolynomialRing2);
        }
        iterable = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        String[] stringArray = new String[]{genPolynomialRing.getVars()[genPolynomialRing.nvar - 1]};
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2, 1, stringArray);
        ArrayList<GenPolynomial<MOD>> arrayList4 = new ArrayList<GenPolynomial<MOD>>(list3.size());
        ArrayList<GenPolynomial<BigInteger>> arrayList5 = new ArrayList<GenPolynomial<BigInteger>>(list3.size());
        for (GenPolynomial<MOD> genPolynomial9 : list3) {
            genPolynomial3 = genPolynomial9.extend(genPolynomialRing, 0, 0L);
            arrayList4.add(genPolynomial3);
            genPolynomial2 = PolyUtil.integerFromModularCoefficients(iterable, genPolynomial3);
            arrayList5.add(genPolynomial2);
        }
        ArrayList arrayList6 = new ArrayList(list.size());
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            genPolynomial3 = (GenPolynomial<BigInteger>)iterator.next();
            genPolynomial2 = PolyUtil.integerFromModularCoefficients(iterable, genPolynomial3);
            arrayList6.add(genPolynomial2);
        }
        GenPolynomial<BigInteger> genPolynomial10 = PolyUtil.integerFromModularCoefficients(iterable, genPolynomial);
        genPolynomial3 = genPolynomial10;
        int n = 0;
        GenPolynomial genPolynomial11 = arrayList6.iterator();
        while (genPolynomial11.hasNext()) {
            GenPolynomial genPolynomial12 = (GenPolynomial)genPolynomial11.next();
            genPolynomial3 = genPolynomial3.subtract((RingElem<BigInteger>)genPolynomial12.multiply((GenPolynomial)arrayList5.get(n++)));
        }
        if (genPolynomial3.isZERO()) {
            logger.info("liftDiophant leaving on zero E");
            return arrayList4;
        }
        genPolynomial11 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial3);
        logger.info("Ep(0," + genPolynomialRing.nvar + ") = " + genPolynomial11);
        if (genPolynomial11.isZERO()) {
            logger.info("liftDiophant leaving on zero Ep mod p^k");
            return arrayList4;
        }
        int n2 = 1;
        while ((long)n2 <= l) {
            Element element;
            UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(genPolynomialRing3);
            GenPolynomial genPolynomial13 = PolyUtil.recursive(genPolynomialRing3, genPolynomial11);
            PolynomialTaylorFunction polynomialTaylorFunction = new PolynomialTaylorFunction(genPolynomial13);
            UnivPowerSeries<Element> univPowerSeries = univPowerSeriesRing.seriesOfTaylor(polynomialTaylorFunction, (GenPolynomial<Element>)(element = genPolynomialRing2.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal())));
            GenPolynomial genPolynomial14 = (GenPolynomial)univPowerSeries.coefficient(n2);
            if (!genPolynomial14.isZERO()) {
                List<GenPolynomial<MOD>> list4 = HenselMultUtil.liftDiophant(arrayList2, genPolynomial14, arrayList, l, l2);
                if (!genPolynomialRing2.coFac.equals(list4.get((int)0).ring.coFac)) {
                    throw new IllegalArgumentException("ckfac != pkfac: " + genPolynomialRing2.coFac + " != " + list4.get((int)0).ring.coFac);
                }
                if (genPolynomialRing.nvar == 2 && !HenselUtil.isDiophantLift(arrayList2, list4, genPolynomial14)) {
                    throw new NoLiftingException("isDiophantLift: false");
                }
                monoidElem = ((GenPolynomial)monoidElem).multiply(genPolynomial6);
                n = 0;
                arrayList5 = new ArrayList(list3.size());
                for (GenPolynomial<MOD> genPolynomial15 : list4) {
                    GenPolynomial<Object> genPolynomial16 = genPolynomial15.extend(genPolynomialRing, 0, 0L);
                    GenPolynomial<MonoidElem<GenPolynomial<Object>>> genPolynomial17 = genPolynomial16.multiply((MOD)monoidElem);
                    genPolynomial16 = ((GenPolynomial)arrayList4.get(n)).sum(genPolynomial17);
                    arrayList4.set(n++, genPolynomial16);
                    GenPolynomial<BigInteger> genPolynomial18 = PolyUtil.integerFromModularCoefficients(iterable, genPolynomial17);
                    arrayList5.add(genPolynomial18);
                }
                n = 0;
                Iterator<GenPolynomial<Object>> iterator2 = arrayList6.iterator();
                while (iterator2.hasNext()) {
                    GenPolynomial<Object> genPolynomial19 = iterator2.next();
                    genPolynomial3 = genPolynomial3.subtract((RingElem<BigInteger>)genPolynomial19.multiply((Object)((GenPolynomial)arrayList5.get(n++))));
                }
                if (genPolynomial3.isZERO()) {
                    logger.info("liftDiophant leaving on zero E");
                    return arrayList4;
                }
                genPolynomial11 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial3);
                logger.info("Ep(" + n2 + "," + genPolynomialRing.nvar + ") = " + genPolynomial11);
                if (genPolynomial11.isZERO()) {
                    logger.info("liftDiophant leaving on zero Ep mod p^k");
                    return arrayList4;
                }
            }
            ++n2;
        }
        return arrayList4;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> boolean isHenselLift(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<MOD> genPolynomial2, List<GenPolynomial<MOD>> list, List<GenPolynomial<MOD>> list2) {
        GenPolynomial<Object> genPolynomial32;
        boolean bl = true;
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        GenPolynomial<GenPolynomial<MOD>> genPolynomial4 = genPolynomialRing.getONE();
        for (GenPolynomial<Object> genPolynomial32 : list2) {
            genPolynomial4 = genPolynomial4.multiply((GenPolynomial<MOD>)genPolynomial32);
        }
        bl = genPolynomial2.equals(genPolynomial4);
        if (!bl) {
            System.out.println("Cp     = " + genPolynomial2);
            System.out.println("q      = " + genPolynomial4);
            System.out.println("Cp != q: " + genPolynomial2.subtract((MOD)genPolynomial4));
            return bl;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomial.ring;
        genPolynomial32 = PolyUtil.integerFromModularCoefficients((GenPolynomialRing<BigInteger>)genPolynomialRing2, genPolynomial4);
        bl = genPolynomial.equals(genPolynomial32);
        if (!bl) {
            System.out.println("C      = " + genPolynomial);
            System.out.println("Ci     = " + genPolynomial32);
            System.out.println("C != Ci: " + genPolynomial.subtract((BigInteger)((Object)genPolynomial32)));
            return bl;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselMonic(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<MOD> genPolynomial2, List<GenPolynomial<MOD>> list, List<BigInteger> list2, long l) throws NoLiftingException {
        void var21_25;
        void var19_20;
        Iterable<Monomial<Object>> iterable;
        List<GenPolynomial<MOD>> list3;
        Serializable serializable;
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        long l2 = genPolynomial.degree();
        ArrayList<GenPolynomialRing> arrayList = new ArrayList<GenPolynomialRing>();
        ArrayList<GenPolynomial> arrayList2 = new ArrayList<GenPolynomial>();
        ArrayList<GcdRingElem> arrayList3 = new ArrayList<GcdRingElem>();
        GcdRingElem gcdRingElem = (GcdRingElem)genPolynomialRing.coFac.fromInteger(list2.get(0).getVal());
        arrayList.add(genPolynomialRing);
        arrayList2.add(genPolynomial2);
        arrayList3.add(gcdRingElem);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing;
        GenPolynomial genPolynomial3 = genPolynomial2;
        for (int i = genPolynomialRing.nvar; i > 2; --i) {
            genPolynomialRing2 = genPolynomialRing2.contract(1);
            arrayList.add(0, genPolynomialRing2);
            serializable = (GcdRingElem)genPolynomialRing.coFac.fromInteger(list2.get(i - 2).getVal());
            arrayList3.add(1, (GcdRingElem)serializable);
            genPolynomial3 = PolyUtil.evaluateMain(genPolynomialRing2, genPolynomial3, serializable);
            arrayList2.add(0, genPolynomial3);
        }
        if (debug) {
            logger.debug("Pfac   = " + arrayList);
        }
        GenPolynomialRing genPolynomialRing3 = list.get((int)0).ring;
        if (!genPolynomialRing.coFac.equals(genPolynomialRing3.coFac)) {
            throw new IllegalArgumentException("F.ring != pkfac: " + genPolynomialRing3 + " != " + genPolynomialRing);
        }
        genPolynomialRing = (GenPolynomialRing)arrayList.get(0);
        serializable = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing3);
        ArrayList<List<GenPolynomial<MOD>>> arrayList4 = new ArrayList<List<GenPolynomial<MOD>>>(list.size());
        for (GenPolynomial<MOD> iterable32 : list) {
            list3 = PolyUtil.integerFromModularCoefficients((GenPolynomialRing<BigInteger>)serializable, iterable32);
            arrayList4.add(list3);
        }
        ArrayList<Iterable<Monomial<Object>>> arrayList5 = new ArrayList<Iterable<Monomial<Object>>>(list.size());
        for (GenPolynomial genPolynomial4 : list) {
            iterable = genPolynomial4.extend(genPolynomialRing, 0, 0L);
            arrayList5.add(iterable);
        }
        list3 = list;
        AbelianGroupElem abelianGroupElem = genPolynomial.ring.getZERO();
        iterable = new ArrayList();
        while (arrayList.size() > 0) {
            Object object;
            void var30_42;
            void var21_27;
            genPolynomialRing = (GenPolynomialRing)arrayList.remove(0);
            genPolynomial2 = (GenPolynomial)arrayList2.remove(0);
            gcdRingElem = (GcdRingElem)arrayList3.remove(0);
            GenPolynomial genPolynomial5 = genPolynomialRing.getONE();
            GenPolynomial<Element> genPolynomial6 = genPolynomialRing.univariate(0, 1L);
            genPolynomial6 = genPolynomial6.subtract(genPolynomialRing.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal()));
            long l3 = genPolynomial2.degree(genPolynomialRing.nvar - 1);
            GenPolynomialRing<BigInteger> genPolynomialRing4 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
            ArrayList<GenPolynomial<BigInteger>> arrayList6 = new ArrayList<GenPolynomial<BigInteger>>(list.size());
            for (GenPolynomial genPolynomial7 : arrayList4) {
                GenPolynomial<BigInteger> genPolynomial8 = genPolynomial7.extend(genPolynomialRing4, 0, 0L);
                arrayList6.add(genPolynomial8);
            }
            arrayList4 = arrayList6;
            GenPolynomial<BigInteger> genPolynomial9 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, genPolynomial2);
            MonoidElem monoidElem = genPolynomialRing4.getONE();
            for (GenPolynomial genPolynomial10 : arrayList4) {
                GenPolynomial<GenPolynomial> genPolynomial11 = var21_27.multiply(genPolynomial10);
            }
            GenPolynomial<void> genPolynomial12 = genPolynomial9.subtract((BigInteger)var21_27);
            GenPolynomial genPolynomial13 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial12);
            logger.info("Ep(0," + l3 + "," + genPolynomialRing.nvar + ") = " + genPolynomial13);
            String[] stringArray = new String[]{genPolynomialRing.getVars()[genPolynomialRing.nvar - 1]};
            GenPolynomialRing genPolynomialRing5 = genPolynomialRing.contract(1);
            GenPolynomialRing genPolynomialRing6 = new GenPolynomialRing(genPolynomialRing5, 1, stringArray);
            int n = 1;
            while ((long)n <= l3 && !var30_42.isZERO()) {
                GenPolynomial genPolynomial14 = PolyUtil.recursive(genPolynomialRing6, var30_42);
                UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(genPolynomialRing6);
                object = new PolynomialTaylorFunction(genPolynomial14);
                Element element = genPolynomialRing5.fromInteger(((Modular)((Object)gcdRingElem)).getSymmetricInteger().getVal());
                UnivPowerSeries<Element> univPowerSeries = univPowerSeriesRing.seriesOfTaylor((TaylorFunction<GenPolynomial<Element>>)object, (GenPolynomial<Element>)element);
                logger.info("Epst(" + n + "," + l3 + ", " + genPolynomialRing.nvar + ") = " + univPowerSeries);
                GenPolynomial genPolynomial15 = (GenPolynomial)univPowerSeries.coefficient(n);
                if (!genPolynomial15.isZERO()) {
                    void var21_32;
                    List<GenPolynomial<Monomial<Object>>> list4 = HenselMultUtil.liftDiophant(list3, genPolynomial15, iterable, l2, l);
                    genPolynomial5 = genPolynomial5.multiply(genPolynomial6);
                    int n2 = 0;
                    ArrayList<GenPolynomial<BigInteger>> arrayList7 = new ArrayList<GenPolynomial<BigInteger>>(list4.size());
                    for (GenPolynomial<Monomial<Object>> genPolynomial16 : list4) {
                        GenPolynomial<Element<Monomial<Object>>> genPolynomial17 = genPolynomial16.extend(genPolynomialRing, 0, 0L);
                        GenPolynomial genPolynomial18 = genPolynomial17.multiply((Monomial<Object>)((Object)genPolynomial5));
                        genPolynomial17 = ((GenPolynomial)var19_20.get(n2)).sum(genPolynomial18);
                        var19_20.set(n2++, genPolynomial17);
                        GenPolynomial<BigInteger> genPolynomial19 = PolyUtil.integerFromModularCoefficients(genPolynomialRing4, genPolynomial17);
                        arrayList7.add(genPolynomial19);
                    }
                    MonoidElem monoidElem2 = genPolynomialRing4.getONE();
                    for (GenPolynomial<Monomial<Object>> genPolynomial20 : arrayList7) {
                        GenPolynomial<GenPolynomial<Monomial<Object>>> genPolynomial21 = var21_32.multiply(genPolynomial20);
                    }
                    GenPolynomial<void> genPolynomial22 = genPolynomial9.subtract((BigInteger)var21_32);
                    GenPolynomial genPolynomial23 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, genPolynomial22);
                    logger.info("Ep(" + n + "," + l3 + "," + genPolynomialRing.nvar + ") = " + genPolynomial23);
                }
                ++n;
            }
            iterable.add((GcdRingElem)gcdRingElem);
            list3 = var19_20;
            if (arrayList.size() <= 0) continue;
            ArrayList<Object> arrayList8 = new ArrayList<Object>(var19_20.size());
            genPolynomialRing = (GenPolynomialRing)arrayList.get(0);
            for (GenPolynomial genPolynomial24 : var19_20) {
                object = genPolynomial24.extend(genPolynomialRing, 0, 0L);
                arrayList8.add(object);
            }
            ArrayList<Object> arrayList9 = arrayList8;
        }
        if (var21_25.isZERO()) {
            logger.info("liftHensel leaving with zero E");
        }
        return var19_20;
    }

    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHensel(GenPolynomial<BigInteger> genPolynomial, GenPolynomial<MOD> genPolynomial2, List<GenPolynomial<MOD>> list, List<BigInteger> list2, long l, List<GenPolynomial<BigInteger>> list3) throws NoLiftingException {
        RingElem ringElem;
        Iterable<Monomial<Object>> iterable;
        Object object;
        Serializable serializable;
        ArrayList<GenPolynomial<MOD>> arrayList;
        Iterable<Monomial<Object>> iterable2;
        GenPolynomialRing genPolynomialRing = genPolynomial2.ring;
        long l2 = genPolynomial.degree();
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(genPolynomialRing.coFac, list3.get((int)0).ring);
        ArrayList arrayList2 = new ArrayList(list3.size());
        for (GenPolynomial<BigInteger> iterable32 : list3) {
            iterable2 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, iterable32);
            iterable2 = ((GenPolynomial)iterable2).extendLower(genPolynomialRing, 0, 0L);
            arrayList2.add(iterable2);
        }
        logger.info("G modulo p^k: " + arrayList2);
        ArrayList arrayList3 = new ArrayList();
        ArrayList<GenPolynomial> arrayList4 = new ArrayList<GenPolynomial>();
        iterable2 = new ArrayList();
        ArrayList<GcdRingElem> arrayList5 = new ArrayList<GcdRingElem>();
        arrayList3.add(genPolynomialRing);
        arrayList4.add(genPolynomial2);
        iterable2.add(arrayList2);
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing;
        GenPolynomial genPolynomial3 = genPolynomial2;
        Object object2 = arrayList2;
        for (int genPolynomialRing4 = genPolynomialRing.nvar; genPolynomialRing4 > 2; --genPolynomialRing4) {
            genPolynomialRing3 = genPolynomialRing3.contract(1);
            arrayList3.add(0, genPolynomialRing3);
            arrayList = (GcdRingElem)genPolynomialRing.coFac.fromInteger(list2.get(genPolynomialRing.nvar - genPolynomialRing4).getVal());
            arrayList5.add((GcdRingElem)((Object)arrayList));
            genPolynomial3 = PolyUtil.evaluateMain(genPolynomialRing3, genPolynomial3, arrayList);
            arrayList4.add(0, genPolynomial3);
            serializable = new ArrayList(object2.size());
            object = object2.iterator();
            while (object.hasNext()) {
                iterable = (GenPolynomial)object.next();
                ringElem = PolyUtil.evaluateMain(genPolynomialRing3, iterable, arrayList);
                serializable.add(ringElem);
            }
            object2 = serializable;
            iterable2.add(0, object2);
        }
        arrayList5.add((GcdRingElem)genPolynomialRing.coFac.fromInteger(list2.get(genPolynomialRing.nvar - 2).getVal()));
        if (debug) {
            logger.debug("Pfac   = " + (List)arrayList3);
        }
        GenPolynomialRing genPolynomialRing4 = list.get((int)0).ring;
        if (!genPolynomialRing.coFac.equals(genPolynomialRing4.coFac)) {
            throw new IllegalArgumentException("F.ring != pkfac: " + genPolynomialRing4 + " != " + genPolynomialRing);
        }
        arrayList = list;
        serializable = genPolynomial.ring.getZERO();
        object = new ArrayList();
        ringElem = null;
        while (arrayList3.size() > 0) {
            GenPolynomial<Object> genPolynomial4;
            GenPolynomial<RingElem<GenPolynomial<Serializable>>> genPolynomial5;
            Iterable<Monomial<Object>> iterable3;
            GenPolynomialRing genPolynomialRing5;
            genPolynomialRing = (GenPolynomialRing)arrayList3.remove(0);
            genPolynomial2 = (GenPolynomial)arrayList4.remove(0);
            object2 = (List)iterable2.remove(0);
            ringElem = (GcdRingElem)arrayList5.remove(arrayList5.size() - 1);
            logger.info("stack loop: pkfac = " + genPolynomialRing.toScript() + " v = " + ringElem);
            ArrayList<GenPolynomial<MOD>> arrayList6 = arrayList;
            logger.info("to lift U1 = " + arrayList6);
            arrayList = new ArrayList<GenPolynomial<MOD>>(arrayList6.size());
            int n = 0;
            for (GenPolynomial genPolynomial6 : arrayList6) {
                GenPolynomial<Object> genPolynomial7 = genPolynomial6.extend(genPolynomialRing, 0, 0L);
                GenPolynomial genPolynomial8 = (GenPolynomial)object2.get(n);
                if (!genPolynomial8.isONE()) {
                    genPolynomialRing5 = genPolynomialRing.recursive(genPolynomialRing.nvar - 1);
                    iterable3 = PolyUtil.recursive(genPolynomialRing5, genPolynomial7);
                    genPolynomial5 = PolyUtil.switchVariables(iterable3);
                    genPolynomial4 = PolyUtil.recursive(genPolynomialRing5, genPolynomial8);
                    GenPolynomial genPolynomial9 = PolyUtil.switchVariables(genPolynomial4);
                    if (!genPolynomial9.isConstant() && !genPolynomial9.isZERO()) {
                        throw new RuntimeException("ls not constant " + genPolynomial9 + ", li = " + genPolynomial8);
                    }
                    genPolynomial5.doPutToMap(genPolynomial5.leadingExpVector(), genPolynomial9.leadingBaseCoefficient());
                    iterable3 = PolyUtil.switchVariables(genPolynomial5);
                    genPolynomial7 = PolyUtil.distribute(genPolynomialRing, iterable3);
                }
                arrayList.add(genPolynomial7);
                ++n;
            }
            logger.info("U with leading coefficient replaced = " + arrayList);
            GenPolynomial<GenPolynomial<Element>> genPolynomial10 = genPolynomialRing.getONE();
            GenPolynomial<Element> genPolynomial12 = genPolynomialRing.univariate(0, 1L);
            genPolynomial12 = genPolynomial12.subtract(genPolynomialRing.fromInteger(((Modular)((Object)ringElem)).getSymmetricInteger().getVal()));
            long l3 = genPolynomial2.degree(genPolynomialRing.nvar - 1);
            genPolynomialRing5 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
            iterable3 = PolyUtil.integerFromModularCoefficients(genPolynomialRing5, arrayList);
            genPolynomial5 = PolyUtil.integerFromModularCoefficients(genPolynomialRing5, genPolynomial2);
            serializable = genPolynomialRing5.getONE();
            for (GenPolynomial genPolynomial13 : iterable3) {
                serializable = ((GenPolynomial)serializable).multiply(genPolynomial13);
            }
            serializable = genPolynomial5.subtract((RingElem<GenPolynomial<Serializable>>)serializable);
            genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, (GenPolynomial<BigInteger>)serializable);
            logger.info("Ep(0," + l3 + "," + genPolynomialRing.nvar + ") = " + genPolynomial4);
            GenPolynomialRing genPolynomialRing6 = genPolynomialRing.recursive(1);
            GenPolynomialRing genPolynomialRing7 = (GenPolynomialRing)genPolynomialRing6.coFac;
            int n2 = 1;
            while ((long)n2 <= l3 && !genPolynomial4.isZERO()) {
                logger.info("approximation loop: e = " + n2 + " of deg = " + l3);
                GenPolynomial genPolynomial14 = PolyUtil.recursive(genPolynomialRing6, genPolynomial4);
                UnivPowerSeriesRing<GenPolynomial<Element>> univPowerSeriesRing = new UnivPowerSeriesRing<GenPolynomial<Element>>(genPolynomialRing6);
                PolynomialTaylorFunction polynomialTaylorFunction = new PolynomialTaylorFunction(genPolynomial14);
                Element element = genPolynomialRing7.fromInteger(((Modular)((Object)ringElem)).getSymmetricInteger().getVal());
                UnivPowerSeries<Element> univPowerSeries = univPowerSeriesRing.seriesOfTaylor(polynomialTaylorFunction, (GenPolynomial<Element>)element);
                logger.info("Epst(" + n2 + "," + l3 + "," + genPolynomialRing.nvar + ") = " + univPowerSeries);
                GenPolynomial genPolynomial15 = (GenPolynomial)univPowerSeries.coefficient(n2);
                if (!genPolynomial15.isZERO()) {
                    List<GenPolynomial<MOD>> list4 = HenselMultUtil.liftDiophant(arrayList6, genPolynomial15, object, l2, l);
                    genPolynomial10 = genPolynomial10.multiply(genPolynomial12);
                    int n3 = 0;
                    iterable = new ArrayList(list4.size());
                    for (GenPolynomial<MOD> genPolynomial16 : list4) {
                        GenPolynomial<Object> genPolynomial17 = genPolynomial16.extend(genPolynomialRing, 0, 0L);
                        GenPolynomial<GenPolynomial<GenPolynomial<Element>>> genPolynomial18 = genPolynomial17.multiply((MOD)genPolynomial10);
                        genPolynomial17 = ((GenPolynomial)arrayList.get(n3)).sum(genPolynomial18);
                        arrayList.set(n3++, genPolynomial17);
                        GenPolynomial<BigInteger> genPolynomial19 = PolyUtil.integerFromModularCoefficients(genPolynomialRing5, genPolynomial17);
                        iterable.add(genPolynomial19);
                    }
                    serializable = genPolynomialRing5.getONE();
                    for (GenPolynomial<Object> genPolynomial20 : iterable) {
                        serializable = ((GenPolynomial)serializable).multiply(genPolynomial20);
                    }
                    serializable = genPolynomial5.subtract((RingElem<GenPolynomial<Serializable>>)serializable);
                    genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing, (GenPolynomial<BigInteger>)serializable);
                    logger.info("Ep(" + n2 + "," + l3 + "," + genPolynomialRing.nvar + ") = " + genPolynomial4);
                }
                ++n2;
            }
            object.add(ringElem);
            GenPolynomial<GenPolynomial> genPolynomial21 = ((GenPolynomial)arrayList.get((int)0)).ring.getONE();
            for (GenPolynomial genPolynomial22 : arrayList) {
                genPolynomial21 = genPolynomial21.multiply(genPolynomial22);
            }
        }
        if (((GenPolynomial)serializable).isZERO()) {
            logger.info("liftHensel leaving with zero E, Ep");
        }
        logger.info("multivariate lift: U = " + arrayList + ", of " + list);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static <MOD extends GcdRingElem<MOD> & Modular> List<GenPolynomial<MOD>> liftHenselFull(GenPolynomial<BigInteger> genPolynomial, List<GenPolynomial<MOD>> list, List<BigInteger> list2, long l, List<GenPolynomial<BigInteger>> list3) throws NoLiftingException {
        void var25_30;
        List list4;
        Iterable<GenPolynomial<Object>> iterable;
        Serializable serializable;
        GenPolynomial<Serializable> genPolynomial222;
        if (list == null || list.size() == 0) {
            return new ArrayList<GenPolynomial<MOD>>();
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        RingFactory ringFactory = genPolynomialRing.coFac;
        ModularRingFactory modularRingFactory = (ModularRingFactory)ringFactory;
        BigInteger bigInteger = modularRingFactory.getIntegerModul();
        BigInteger bigInteger2 = (BigInteger)bigInteger.power(l);
        Iterable<ModLong> iterable3 = ModLongRing.MAX_LONG.compareTo(bigInteger2.getVal()) > 0 ? new ModLongRing(bigInteger2.getVal()) : new ModIntegerRing(bigInteger2.getVal());
        GenPolynomialRing<ModLong> genPolynomialRing2 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable3), genPolynomial.ring);
        GenPolynomial<ModLong> genPolynomial3 = PolyUtil.fromIntegerCoefficients(genPolynomialRing2, genPolynomial);
        GenPolynomialRing<ModLong> genPolynomialRing3 = new GenPolynomialRing<ModLong>((RingFactory<ModLong>)((Object)iterable3), list3.get((int)0).ring);
        ArrayList<GenPolynomial<ModLong>> arrayList = new ArrayList<GenPolynomial<ModLong>>();
        boolean bl = true;
        for (GenPolynomial<Serializable> genPolynomial222 : list3) {
            if (!genPolynomial222.isONE()) {
                bl = false;
            }
            GenPolynomial<ModLong> genPolynomial4 = PolyUtil.fromIntegerCoefficients(genPolynomialRing3, genPolynomial222);
            arrayList.add(genPolynomial4);
        }
        GenPolynomialRing genPolynomialRing4 = genPolynomialRing2;
        genPolynomial222 = genPolynomial3;
        for (int i = genPolynomial.ring.nvar; i > 1; --i) {
            genPolynomialRing4 = genPolynomialRing4.contract(1);
            serializable = (GcdRingElem)iterable3.fromInteger(list2.get(genPolynomial.ring.nvar - i).getVal());
            genPolynomial222 = PolyUtil.evaluateMain(genPolynomialRing4, genPolynomial222, serializable);
        }
        GenPolynomial<GcdRingElem<BigInteger>> genPolynomial5 = genPolynomial222;
        if (genPolynomial5.isZERO()) {
            throw new NoLiftingException("C mod (I, p^k) == 0: " + genPolynomial);
        }
        serializable = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing4);
        AbelianGroupElem<GenPolynomial<BigInteger>> abelianGroupElem = PolyUtil.integerFromModularCoefficients(serializable, genPolynomial5);
        GreatestCommonDivisorAbstract<BigInteger> greatestCommonDivisorAbstract = GCDFactory.getImplementation(new BigInteger());
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs();
        BigInteger bigInteger3 = greatestCommonDivisorAbstract.baseContent((GenPolynomial<BigInteger>)abelianGroupElem);
        abelianGroupElem = ((GenPolynomial)abelianGroupElem).divide((GenPolynomial<BigInteger>)((Object)bigInteger3));
        for (GenPolynomial<GcdRingElem> iterable22 : arrayList) {
            iterable = genPolynomialRing3;
            GenPolynomial<GcdRingElem> genPolynomial2 = iterable22;
            for (int i = genPolynomialRing3.nvar; i > 1; --i) {
                iterable = ((GenPolynomialRing)iterable).contract(1);
                list4 = (GcdRingElem)iterable3.fromInteger(list2.get(genPolynomialRing3.nvar - i).getVal());
                genPolynomial2 = PolyUtil.evaluateMain(iterable, genPolynomial2, list4);
            }
        }
        BigInteger bigInteger4 = (BigInteger)((GenPolynomial)abelianGroupElem).leadingBaseCoefficient();
        Object var25_27 = null;
        if (bigInteger4.isONE()) {
            List<GenPolynomial<MOD>> list5 = HenselUtil.liftHenselMonic(abelianGroupElem, list, l);
        } else {
            List<GenPolynomial<MOD>> list6 = HenselUtil.liftHensel(abelianGroupElem, list, l, bigInteger4);
        }
        logger.info("univariate lift: Ci = " + abelianGroupElem + ", F = " + list + ", U1 = " + (List)var25_30);
        iterable = PolyUtil.integerFromModularCoefficients(((GenPolynomial)abelianGroupElem).ring, var25_30);
        boolean bl2 = HenselUtil.isHenselLift(abelianGroupElem, bigInteger2, bigInteger, iterable);
        if (!bl2) {
            throw new NoLiftingException("Ci = " + abelianGroupElem + ", U1i = " + iterable);
        }
        GcdRingElem gcdRingElem = (GcdRingElem)iterable3.fromInteger(bigInteger3.getVal());
        list4 = PolyUtil.fromIntegerCoefficients(list.get((int)0).ring, iterable);
        ArrayList<GenPolynomial<MOD>> arrayList2 = new ArrayList<GenPolynomial<MOD>>(var25_30.size());
        int n = 0;
        int n2 = 0;
        for (GenPolynomial genPolynomial4 : var25_30) {
            void var34_42;
            void var34_45;
            AbelianGroupElem abelianGroupElem2 = (GenPolynomial)list4.get(n);
            GenPolynomial<MOD> genPolynomial6 = list.get(n);
            GenPolynomial genPolynomial7 = (GenPolynomial)iterable.get(n);
            GenPolynomial<BigInteger> genPolynomial8 = list3.get(n);
            if (genPolynomial7.signum() != genPolynomial8.signum()) {
                AbelianGroupElem abelianGroupElem3 = genPolynomial4.negate();
                abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).negate();
                ++n2;
            }
            ++n;
            if (((GenPolynomial)abelianGroupElem2).isConstant()) {
                GenPolynomial<GcdRingElem> genPolynomial10 = var34_45.monic();
                genPolynomial10 = genPolynomial10.multiply(gcdRingElem);
                gcdRingElem = gcdRingElem.divide(gcdRingElem);
            } else {
                GcdRingElem gcdRingElem2 = ((GcdRingElem)genPolynomial6.leadingBaseCoefficient()).divide((GcdRingElem)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient());
                if (!gcdRingElem2.isONE()) {
                    GcdRingElem gcdRingElem3 = (GcdRingElem)iterable3.fromInteger(((Modular)((Object)gcdRingElem2)).getSymmetricInteger().getVal());
                    GenPolynomial<GcdRingElem> genPolynomial11 = var34_45.multiply(gcdRingElem3);
                    gcdRingElem = gcdRingElem.divide(gcdRingElem3);
                }
            }
            arrayList2.add((GenPolynomial<MOD>)var34_42);
        }
        if (!gcdRingElem.isONE()) {
            throw new NoLiftingException("s = " + n2 + ", Ci = " + abelianGroupElem + ", U1i = " + iterable + ", cC = " + gcdRingElem);
        }
        ArrayList<GenPolynomial<MOD>> arrayList3 = arrayList2;
        iterable = PolyUtil.integerFromModularCoefficients(((GenPolynomial)abelianGroupElem).ring, arrayList3);
        list4 = PolyUtil.fromIntegerCoefficients(list.get((int)0).ring, iterable);
        if (!list.equals(list4)) {
            System.out.println("F   = " + list);
            System.out.println("U1f = " + list4);
            throw new NoLiftingException("F = " + list + ", U1f = " + list4);
        }
        logger.info("multivariate lift: U1 = " + arrayList3);
        List<GenPolynomial<Object>> list7 = null;
        list7 = bl ? HenselMultUtil.liftHenselMonic(genPolynomial, genPolynomial3, arrayList3, list2, l) : HenselMultUtil.liftHensel(genPolynomial, genPolynomial3, arrayList3, list2, l, list3);
        logger.info("multivariate lift: C = " + genPolynomial + ", U1 = " + arrayList3 + ", U = " + list7);
        return list7;
    }
}

