/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartialFraction<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(PartialFraction.class);
    public final GenPolynomial<C> num;
    public final GenPolynomial<C> den;
    public final List<C> cfactors;
    public final List<GenPolynomial<C>> cdenom;
    public final List<AlgebraicNumber<C>> afactors;
    public final List<GenPolynomial<AlgebraicNumber<C>>> adenom;

    public PartialFraction(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, List<C> list, List<GenPolynomial<C>> list2, List<AlgebraicNumber<C>> list3, List<GenPolynomial<AlgebraicNumber<C>>> list4) {
        this.num = genPolynomial;
        this.den = genPolynomial2;
        this.cfactors = list;
        this.cdenom = list2;
        this.afactors = list3;
        this.adenom = list4;
        for (GenPolynomial<C> genPolynomial3 : this.cdenom) {
            if (genPolynomial3.degree(0) <= 1L) continue;
            throw new IllegalArgumentException("polynomial not linear, p = " + genPolynomial3);
        }
        for (GenPolynomial<Object> genPolynomial3 : this.adenom) {
            if (genPolynomial3.degree(0) <= 1L) continue;
            throw new IllegalArgumentException("polynomial not linear, a = " + genPolynomial3);
        }
    }

    public String toString() {
        Serializable serializable;
        AlgebraicNumber<C> algebraicNumber;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + this.num.toString() + ")");
        stringBuffer.append(" / ");
        stringBuffer.append("(" + this.den.toString() + ")");
        stringBuffer.append(" =\n");
        boolean bl = true;
        for (n = 0; n < this.cfactors.size(); ++n) {
            algebraicNumber = (AlgebraicNumber<C>)this.cfactors.get(n);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" + ");
            }
            stringBuffer.append("(" + ((Object)algebraicNumber).toString() + ")");
            serializable = this.cdenom.get(n);
            stringBuffer.append(" / (" + ((GenPolynomial)serializable).toString() + ")");
        }
        if (!bl && this.afactors.size() > 0) {
            stringBuffer.append(" + ");
        }
        bl = true;
        for (n = 0; n < this.afactors.size(); ++n) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" + ");
            }
            algebraicNumber = this.afactors.get(n);
            serializable = algebraicNumber.factory();
            GenPolynomial<AlgebraicNumber<C>> genPolynomial = this.adenom.get(n);
            if (genPolynomial.degree(0) < ((AlgebraicNumberRing)serializable).modul.degree(0) && ((AlgebraicNumberRing)serializable).modul.degree(0) > 2L) {
                stringBuffer.append("sum_(" + ((AlgebraicNumberRing)serializable).getGenerator() + " in ");
                stringBuffer.append("rootOf(" + ((AlgebraicNumberRing)serializable).modul + ") ) ");
            }
            stringBuffer.append("(" + algebraicNumber.toString() + ")");
            stringBuffer.append(" / (" + genPolynomial.toString() + ")");
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.num.toScript());
        stringBuffer.append(" / ");
        stringBuffer.append(this.den.toScript());
        stringBuffer.append(" = ");
        boolean bl = true;
        int n = 0;
        for (GcdRingElem gcdRingElem : this.cfactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" + ");
            }
            stringBuffer.append(gcdRingElem.toScript());
            serializable = this.cdenom.get(n);
            stringBuffer.append(" / " + ((GenPolynomial)serializable).toScript());
        }
        if (!bl) {
            stringBuffer.append(" + ");
        }
        bl = true;
        n = 0;
        for (AlgebraicNumber algebraicNumber : this.afactors) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" + ");
            }
            serializable = algebraicNumber.factory();
            GenPolynomial<AlgebraicNumber<C>> genPolynomial = this.adenom.get(n);
            if (genPolynomial.degree(0) < ((AlgebraicNumberRing)serializable).modul.degree(0) && ((AlgebraicNumberRing)serializable).modul.degree(0) > 2L) {
                stringBuffer.append("sum_(" + ((AlgebraicNumberRing)serializable).getGenerator().toScript() + " in ");
                stringBuffer.append("rootOf(" + ((AlgebraicNumberRing)serializable).modul.toScript() + ") ) ");
            }
            stringBuffer.append(algebraicNumber.toScript());
            stringBuffer.append(" / " + genPolynomial.toScript());
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.num.hashCode();
        n = n * 37 + this.den.hashCode();
        n = n * 37 + this.cfactors.hashCode();
        n = n * 37 + this.cdenom.hashCode();
        n = n * 37 + this.afactors.hashCode();
        n = n * 37 + this.adenom.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        if (!(object instanceof PartialFraction)) {
            return false;
        }
        PartialFraction partialFraction = (PartialFraction)object;
        boolean bl2 = bl = this.num.equals(partialFraction.num) && this.den.equals(partialFraction.den);
        if (!bl) {
            return bl;
        }
        bl = this.cfactors.equals(partialFraction.cfactors);
        if (!bl) {
            return bl;
        }
        bl = this.cdenom.equals(partialFraction.cdenom);
        if (!bl) {
            return bl;
        }
        bl = this.afactors.equals(partialFraction.afactors);
        if (!bl) {
            return bl;
        }
        bl = this.adenom.equals(partialFraction.adenom);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isPartialFraction() {
        boolean bl;
        boolean bl2;
        List list;
        AlgebraicNumberRing algebraicNumberRing;
        HashMap hashMap222;
        QuotientRing quotientRing = new QuotientRing(this.num.ring);
        Quotient<Object> quotient = new Quotient<Object>(quotientRing, this.num, this.den);
        Quotient<Object> quotient2 = quotientRing.getZERO();
        int n = 0;
        for (HashMap hashMap222 : this.cfactors) {
            GenPolynomial<C> hashMap3 = this.cdenom.get(n++);
            GenPolynomial<Object> genPolynomial = ((GenPolynomial)this.num.ring.getONE()).multiply(hashMap222);
            Quotient<Object> quotient3 = new Quotient<Object>(quotientRing, genPolynomial, hashMap3);
            quotient2 = quotient2.sum(quotient3);
        }
        if (this.afactors.isEmpty()) {
            return quotient.compareTo(quotient2) == 0;
        }
        HashSet hashSet = new HashSet();
        for (AlgebraicNumber algebraicNumber : this.afactors) {
            if (algebraicNumber.ring.depth() > 1) {
                logger.warn("extension field depth to high");
            }
            hashSet.add(algebraicNumber.ring);
        }
        hashMap222 = new HashMap();
        for (AlgebraicNumber<C> algebraicNumber : this.afactors) {
            void var9_22;
            List list2 = (List)hashMap222.get(algebraicNumber.ring);
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
            }
            var9_22.add(algebraicNumber);
            hashMap222.put(algebraicNumber.ring, var9_22);
        }
        HashMap<AlgebraicNumberRing, ArrayList<GenPolynomial<AlgebraicNumber<C>>>> hashMap = new HashMap<AlgebraicNumberRing, ArrayList<GenPolynomial<AlgebraicNumber<C>>>>();
        for (GenPolynomial<AlgebraicNumber<C>> genPolynomial : this.adenom) {
            algebraicNumberRing = (AlgebraicNumberRing)genPolynomial.ring.coFac;
            list = (ArrayList<GenPolynomial<AlgebraicNumber<C>>>)hashMap.get(algebraicNumberRing);
            if (list == null) {
                list = new ArrayList<GenPolynomial<AlgebraicNumber<C>>>();
            }
            list.add(genPolynomial);
            hashMap.put(algebraicNumberRing, (ArrayList<GenPolynomial<AlgebraicNumber<C>>>)list);
        }
        boolean bl3 = false;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Serializable serializable;
            GcdRingElem gcdRingElem;
            GenPolynomial genPolynomial;
            GenPolynomial<GenPolynomial<Object>> genPolynomial2;
            Serializable serializable22;
            algebraicNumberRing = (AlgebraicNumberRing)iterator.next();
            if (algebraicNumberRing.modul.degree(0) > 2L) {
                bl2 = true;
            }
            list = (List)hashMap222.get(algebraicNumberRing);
            List list3 = (List)hashMap.get(algebraicNumberRing);
            GenPolynomialRing genPolynomialRing = ((GenPolynomial)list3.get((int)0)).ring;
            QuotientRing quotientRing2 = new QuotientRing(genPolynomialRing);
            Quotient quotient4 = quotientRing2.getZERO();
            n = 0;
            for (Serializable serializable22 : list) {
                genPolynomial2 = (GenPolynomial)list3.get(n++);
                genPolynomial = ((GenPolynomial)genPolynomialRing.getONE()).multiply(serializable22);
                gcdRingElem = new Quotient(quotientRing2, genPolynomial, genPolynomial2);
                quotient4 = quotient4.sum(gcdRingElem);
            }
            GenPolynomialRing genPolynomialRing2 = algebraicNumberRing.ring;
            serializable22 = new GenPolynomialRing(genPolynomialRing2, genPolynomialRing);
            genPolynomial2 = PolyUtil.fromAlgebraicCoefficients(serializable22, quotient4.num);
            genPolynomial = PolyUtil.fromAlgebraicCoefficients(serializable22, quotient4.den);
            gcdRingElem = (GcdRingElem)genPolynomialRing2.coFac.getONE();
            GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2.coFac, (GenPolynomialRing)serializable22);
            GenPolynomial genPolynomial3 = PolyUtil.evaluateFirstRec(genPolynomialRing2, genPolynomialRing3, genPolynomial2, gcdRingElem);
            GenPolynomial genPolynomial4 = PolyUtil.evaluateFirstRec(genPolynomialRing2, genPolynomialRing3, genPolynomial, gcdRingElem);
            while (genPolynomialRing2.coFac instanceof AlgebraicNumberRing) {
                serializable = (AlgebraicNumberRing)genPolynomialRing2.coFac;
                genPolynomialRing2 = serializable.ring;
                serializable22 = new GenPolynomialRing(genPolynomialRing2, genPolynomialRing);
                GenPolynomial genPolynomial5 = genPolynomial3;
                GenPolynomial genPolynomial6 = genPolynomial4;
                genPolynomial2 = PolyUtil.fromAlgebraicCoefficients(serializable22, genPolynomial5);
                genPolynomial = PolyUtil.fromAlgebraicCoefficients(serializable22, genPolynomial6);
                gcdRingElem = (GcdRingElem)genPolynomialRing2.coFac.getONE();
                genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2.coFac, (GenPolynomialRing)serializable22);
                genPolynomial3 = PolyUtil.evaluateFirstRec(genPolynomialRing2, genPolynomialRing3, genPolynomial2, gcdRingElem);
                genPolynomial4 = PolyUtil.evaluateFirstRec(genPolynomialRing2, genPolynomialRing3, genPolynomial, gcdRingElem);
            }
            serializable = new Quotient(quotientRing, genPolynomial3, genPolynomial4);
            quotient2 = quotient2.sum((Quotient<Object>)serializable);
        }
        boolean bl4 = bl = quotient.compareTo(quotient2) == 0;
        if (!bl) {
            System.out.println("q != qs: " + quotient + " != " + quotient2);
        }
        return bl || bl2;
    }
}

