/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CReductionSeq<C extends GcdRingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(CReductionSeq.class);
    private final boolean info = logger.isInfoEnabled();
    protected final GreatestCommonDivisor<C> engine;
    protected final RingFactory<C> cofac;
    protected boolean top = true;

    public CReductionSeq(RingFactory<C> ringFactory) {
        this.cofac = ringFactory;
        this.engine = GCDFactory.getImplementation(this.cofac);
    }

    public ColorPolynomial<C> SPolynomial(ColorPolynomial<C> colorPolynomial, ColorPolynomial<C> colorPolynomial2) {
        GenPolynomial<C> genPolynomial;
        if (colorPolynomial2 == null || colorPolynomial2.isZERO()) {
            return colorPolynomial2;
        }
        if (colorPolynomial == null || colorPolynomial.isZERO()) {
            return colorPolynomial;
        }
        Map.Entry entry = colorPolynomial.red.leadingMonomial();
        Map.Entry entry2 = colorPolynomial2.red.leadingMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        GenPolynomial<C> genPolynomial2 = entry.getValue();
        GenPolynomial<C> genPolynomial3 = this.engine.gcd(genPolynomial2, genPolynomial = entry2.getValue());
        if (!genPolynomial3.isONE()) {
            genPolynomial2 = genPolynomial2.divide(genPolynomial3);
            genPolynomial = genPolynomial.divide(genPolynomial3);
        }
        ColorPolynomial<C> colorPolynomial3 = colorPolynomial.multiply(genPolynomial, expVector4);
        ColorPolynomial<C> colorPolynomial4 = colorPolynomial2.multiply(genPolynomial2, expVector5);
        ColorPolynomial<C> colorPolynomial5 = colorPolynomial3.subtract(colorPolynomial4);
        assert (!expVector3.equals(colorPolynomial5.getEssentialPolynomial().leadingExpVector())) : "g == lt(Cp)";
        return colorPolynomial5;
    }

    public boolean isTopReducible(List<ColorPolynomial<C>> list, ColorPolynomial<C> colorPolynomial) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (colorPolynomial == null || colorPolynomial.isZERO()) {
            return false;
        }
        boolean bl = false;
        ExpVector expVector = colorPolynomial.leadingExpVector();
        for (ColorPolynomial<C> colorPolynomial2 : list) {
            if (colorPolynomial2 == null) {
                return false;
            }
            ExpVector expVector2 = colorPolynomial2.leadingExpVector();
            if (expVector2 == null) {
                return false;
            }
            if (expVector == null) {
                return false;
            }
            bl = expVector.multipleOf(expVector2);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean isReducible(List<ColorPolynomial<C>> list, ColorPolynomial<C> colorPolynomial) {
        return !this.isNormalform(list, colorPolynomial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNormalform(List<ColorPolynomial<C>> expVectorArray, ColorPolynomial<C> colorPolynomial) {
        if (expVectorArray == null || expVectorArray.isEmpty()) {
            return true;
        }
        if (colorPolynomial == null || colorPolynomial.isZERO()) {
            return true;
        }
        ExpVector[] expVectorArray2 = expVectorArray;
        synchronized (expVectorArray) {
            int n;
            int n2 = expVectorArray.size();
            ColorPolynomial[] colorPolynomialArray = new ColorPolynomial[n2];
            for (int i = 0; i < expVectorArray.size(); ++i) {
                colorPolynomialArray[i] = expVectorArray.get(i);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            expVectorArray2 = new ExpVector[n2];
            ColorPolynomial[] colorPolynomialArray2 = new ColorPolynomial[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                colorPolynomialArray2[n] = colorPolynomialArray[n];
                Map.Entry entry = colorPolynomialArray2[n].red.leadingMonomial();
                if (entry == null) continue;
                colorPolynomialArray2[n3] = colorPolynomialArray2[n];
                expVectorArray2[n3] = entry.getKey();
                ++n3;
            }
            n2 = n3;
            boolean bl = false;
            for (ExpVector expVector : colorPolynomial.red.getMap().keySet()) {
                for (n = 0; n < n2; ++n) {
                    bl = expVector.multipleOf(expVectorArray2[n]);
                    if (!bl) continue;
                    System.out.println("not normalform " + colorPolynomial + ", P[i] = " + colorPolynomialArray[n]);
                    return false;
                }
                if (!this.top) continue;
                return true;
            }
            for (ExpVector expVector : colorPolynomial.white.getMap().keySet()) {
                for (n = 0; n < n2; ++n) {
                    bl = expVector.multipleOf(expVectorArray2[n]);
                    if (!bl) continue;
                    System.out.println("not normalform " + colorPolynomial + ", P[i] = " + colorPolynomialArray[n]);
                    return false;
                }
                if (!this.top) continue;
                return true;
            }
            return true;
        }
    }

    public boolean isNormalform(List<ColorPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        LinkedList<ColorPolynomial<C>> linkedList = new LinkedList<ColorPolynomial<C>>(list);
        int n = linkedList.size();
        for (int i = 0; i < n; ++i) {
            ColorPolynomial colorPolynomial = (ColorPolynomial)linkedList.remove(i);
            if (!this.isNormalform(linkedList, colorPolynomial)) {
                return false;
            }
            linkedList.add(colorPolynomial);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorPolynomial<C> normalform(Condition<C> condition, List<ColorPolynomial<C>> expVectorArray, ColorPolynomial<C> colorPolynomial) {
        if (expVectorArray == null || expVectorArray.isEmpty()) {
            return colorPolynomial;
        }
        if (colorPolynomial == null || colorPolynomial.isZERO()) {
            return colorPolynomial;
        }
        ExpVector[] expVectorArray2 = expVectorArray;
        synchronized (expVectorArray) {
            Map.Entry entry;
            int n;
            int n2 = expVectorArray.size();
            ColorPolynomial[] colorPolynomialArray = new ColorPolynomial[n2];
            for (int i = 0; i < expVectorArray.size(); ++i) {
                colorPolynomialArray[i] = expVectorArray.get(i);
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            expVectorArray2 = new ExpVector[n2];
            Object[] objectArray = new Object[n2];
            ColorPolynomial[] colorPolynomialArray2 = new ColorPolynomial[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                if (colorPolynomialArray[n] == null) continue;
                colorPolynomialArray2[n] = colorPolynomialArray[n];
                entry = colorPolynomialArray2[n].red.leadingMonomial();
                if (entry == null) continue;
                colorPolynomialArray2[n3] = colorPolynomialArray2[n];
                expVectorArray2[n3] = entry.getKey();
                objectArray[n3] = entry.getValue();
                ++n3;
            }
            n2 = n3;
            boolean bl = false;
            AbelianGroupElem abelianGroupElem = colorPolynomialArray2[0].red.ring.getZERO();
            ColorPolynomial colorPolynomial2 = new ColorPolynomial(abelianGroupElem, abelianGroupElem, abelianGroupElem);
            ColorPolynomial colorPolynomial3 = null;
            ColorPolynomial colorPolynomial4 = colorPolynomial;
            while (colorPolynomial4.length() > 0) {
                GenPolynomial genPolynomial;
                GenPolynomial genPolynomial2;
                entry = colorPolynomial4.leadingMonomial();
                ExpVector expVector = entry.getKey();
                GenPolynomial genPolynomial3 = entry.getValue();
                Condition.Color color = condition.color(genPolynomial3);
                if (color == Condition.Color.GREEN) {
                    genPolynomial2 = colorPolynomial4.green.sum(genPolynomial3, expVector);
                    genPolynomial = colorPolynomial4.red;
                    GenPolynomial genPolynomial4 = colorPolynomial4.white;
                    if (colorPolynomial4.red.isZERO()) {
                        genPolynomial4 = genPolynomial4.subtract(genPolynomial3, expVector);
                    } else {
                        logger.info("green_red = " + ((GenPolynomial)abelianGroupElem).sum(genPolynomial3, expVector));
                        genPolynomial = genPolynomial.subtract(genPolynomial3, expVector);
                    }
                    colorPolynomial4 = new ColorPolynomial(genPolynomial2, genPolynomial, genPolynomial4);
                    continue;
                }
                for (n = 0; n < n2 && !(bl = expVector.multipleOf(expVectorArray2[n])); ++n) {
                }
                if (!bl) {
                    if (this.top) {
                        return colorPolynomial4;
                    }
                    colorPolynomial2 = colorPolynomial2.sum(genPolynomial3, expVector);
                    colorPolynomial4 = colorPolynomial4.subtract(genPolynomial3, expVector);
                    continue;
                }
                ExpVector expVector2 = expVector;
                expVector = expVector.subtract(expVectorArray2[n]);
                genPolynomial2 = (GenPolynomial)objectArray[n];
                genPolynomial = this.engine.gcd(genPolynomial3, genPolynomial2);
                if (!genPolynomial.isONE()) {
                    genPolynomial3 = genPolynomial3.divide(genPolynomial);
                    genPolynomial2 = genPolynomial2.divide(genPolynomial);
                }
                colorPolynomial4 = colorPolynomial4.multiply(genPolynomial2);
                colorPolynomial2 = colorPolynomial2.multiply(genPolynomial2);
                colorPolynomial3 = colorPolynomialArray2[n].multiply(genPolynomial3, expVector);
                colorPolynomial4 = colorPolynomial4.subtract(colorPolynomial3);
                assert (!expVector2.equals(colorPolynomial4.getEssentialPolynomial().leadingExpVector())) : "f == lt(S)";
            }
            return colorPolynomial2;
        }
    }

    public List<Condition<C>> caseDistinction(List<GenPolynomial<GenPolynomial<C>>> list) {
        List<Condition<C>> list2 = new ArrayList<Condition<C>>();
        if (list == null || list.size() == 0) {
            return list2;
        }
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : list) {
            if (genPolynomial == null || genPolynomial.isZERO()) continue;
            list2 = this.caseDistinction(list2, genPolynomial);
        }
        return list2;
    }

    public List<Condition<C>> caseDistinction(List<Condition<C>> list, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        Serializable serializable;
        Iterable iterable;
        Serializable serializable2;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return list;
        }
        if (list == null) {
            list = new ArrayList<Condition<C>>();
        }
        if (list.size() == 0) {
            serializable2 = genPolynomial.ring.coFac;
            iterable = (GenPolynomialRing)serializable2;
            serializable = new Condition(iterable);
            list.add((Condition<C>)serializable);
        }
        serializable = new ArrayList<Condition<C>>();
        Iterator<Condition<C>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Condition<C> condition;
            Condition<C> condition2 = condition = iterator.next();
            serializable2 = genPolynomial;
            block5: while (!((GenPolynomial)serializable2).isZERO()) {
                Condition<C> condition3;
                GenPolynomial genPolynomial2 = (GenPolynomial)((GenPolynomial)serializable2).leadingBaseCoefficient();
                iterable = ((GenPolynomial)serializable2).reductum();
                switch (condition2.color(genPolynomial2)) {
                    case GREEN: {
                        serializable2 = iterable;
                        continue block5;
                    }
                    case RED: {
                        serializable.add(condition2);
                        serializable2 = genPolynomial.ring.getZERO();
                        continue block5;
                    }
                }
                Condition<C> condition4 = condition2.extendNonZero(genPolynomial2);
                if (condition4 != null) {
                    if (!condition2.equals(condition4)) {
                        serializable.add(condition4);
                    } else {
                        condition2 = null;
                        serializable2 = genPolynomial.ring.getZERO();
                        continue;
                    }
                }
                if ((condition3 = condition2.extendZero(genPolynomial2)) == null) {
                    condition2 = null;
                    serializable2 = genPolynomial.ring.getZERO();
                    continue;
                }
                condition2 = condition3;
                serializable2 = iterable;
            }
            if (condition2 == null || condition2.isContradictory() || serializable.contains(condition2)) continue;
            serializable.add(condition2);
        }
        return serializable;
    }

    public List<Condition<C>> caseDistinction(Condition<C> condition, GenPolynomial<GenPolynomial<C>> genPolynomial) {
        List<Condition<C>> list = new ArrayList<Condition<C>>();
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return list;
        }
        list.add(condition);
        list = this.caseDistinction(list, genPolynomial);
        if (this.info) {
            StringBuffer stringBuffer = new StringBuffer("extending condition: " + condition + "\n");
            stringBuffer.append("case distinctions: [ \n");
            for (Condition<C> condition2 : list) {
                stringBuffer.append(condition2.toString() + "\n");
            }
            stringBuffer.append("]");
            logger.info(stringBuffer.toString());
        }
        return list;
    }

    public List<ColoredSystem<C>> determine(List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.size() == 0) {
            ArrayList<ColoredSystem<C>> arrayList = new ArrayList<ColoredSystem<C>>();
            return arrayList;
        }
        Collections.reverse(list);
        List<Condition<C>> list2 = this.caseDistinction(list);
        return this.determine(list2, list);
    }

    public List<ColoredSystem<C>> determine(List<Condition<C>> list, List<GenPolynomial<GenPolynomial<C>>> list2) {
        ArrayList<ColoredSystem<C>> arrayList = new ArrayList<ColoredSystem<C>>();
        if (list2 == null || list2.size() == 0) {
            return arrayList;
        }
        for (Condition<C> condition : list) {
            logger.info("determine wrt cond = " + condition);
            if (condition.zero.isONE()) {
                System.out.println("ideal is one = " + condition.zero);
            }
            List<ColorPolynomial<C>> list3 = condition.determine(list2);
            ColoredSystem<C> coloredSystem = new ColoredSystem<C>(condition, list3);
            arrayList.add(coloredSystem);
        }
        return arrayList;
    }
}

