/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.FactorAlgebraicPrim;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.FactorAlgebraic;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorAlgebraicPrimTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorAlgebraicPrimTest.suite());
    }

    public FactorAlgebraicPrimTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorAlgebraicPrimTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testAlgebraicFactorization() {
        TermOrder termOrder = new TermOrder(2);
        BigRational bigRational = new BigRational(1L);
        String[] stringArray = new String[]{"alpha"};
        String[] stringArray2 = new String[]{"z"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, 1, termOrder, stringArray);
        GenPolynomial<BigRational> genPolynomial = genPolynomialRing.univariate(0, 2L);
        genPolynomial = genPolynomial.sum((BigRational)genPolynomialRing.getONE());
        AlgebraicNumberRing<BigRational> algebraicNumberRing = new AlgebraicNumberRing<BigRational>(genPolynomial, true);
        GenPolynomialRing<BigRational> genPolynomialRing2 = new GenPolynomialRing<BigRational>(algebraicNumberRing, 1, termOrder, stringArray2);
        FactorAlgebraicPrim<BigRational> factorAlgebraicPrim = new FactorAlgebraicPrim<BigRational>(algebraicNumberRing);
        for (int i = 1; i < 7; ++i) {
            int n = 0;
            GenPolynomial<BigRational> genPolynomial2 = genPolynomialRing2.random(2, this.ll + i, this.el + i, this.q);
            GenPolynomial<RingElem<BigRational>> genPolynomial3 = genPolynomialRing2.random(2, this.ll + i, this.el + i, this.q);
            if (genPolynomial3.degree() == 0L) {
                genPolynomial3 = genPolynomial3.multiply((RingElem<BigRational>)genPolynomialRing2.univariate(0));
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            GenPolynomial<GenPolynomial<RingElem<BigRational>>> genPolynomial4 = genPolynomial2.multiply((BigRational)((Object)genPolynomial3));
            long l = System.currentTimeMillis();
            SortedMap sortedMap = factorAlgebraicPrim.baseFactors(genPolynomial4);
            l = System.currentTimeMillis() - l;
            if (sortedMap.size() >= n) {
                FactorAlgebraicPrimTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                System.out.println("smi.size() < facs = " + n);
            }
            boolean bl = factorAlgebraicPrim.isFactorization(genPolynomial4, sortedMap);
            FactorAlgebraicPrimTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            long l2 = System.currentTimeMillis();
            SortedMap sortedMap2 = new FactorAlgebraic<BigRational>(algebraicNumberRing).baseFactors(genPolynomial4);
            l2 = System.currentTimeMillis() - l2;
            if (sortedMap2.size() >= n) {
                FactorAlgebraicPrimTest.assertTrue((String)("#facs < " + n), (sortedMap2.size() >= n ? 1 : 0) != 0);
            } else {
                System.out.println("smr.size() < facs = " + n);
            }
            bl = factorAlgebraicPrim.isFactorization(genPolynomial4, sortedMap2);
            FactorAlgebraicPrimTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
            FactorAlgebraicPrimTest.assertTrue((String)"positive times", (l2 >= 0L && l >= 0L ? 1 : 0) != 0);
            FactorAlgebraicPrimTest.assertEquals((String)"smi == smr: ", sortedMap, sortedMap2);
        }
    }
}

