/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.ArithUtil;
import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigDecimalComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigOctonion;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.Combinatoric;
import edu.jas.arith.Roots;
import edu.jas.structure.Power;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArithTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)ArithTest.suite());
    }

    public ArithTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ArithTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testIntegerConstants() {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger2);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)bigInteger.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)bigInteger2.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)bigInteger3, (Object)bigInteger);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)bigInteger3.isZERO());
        BigInteger bigInteger4 = bigInteger2.multiply(bigInteger2);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)bigInteger4.isONE());
        bigInteger4 = bigInteger2.multiply(bigInteger);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)bigInteger4.isZERO());
    }

    public void testIntegerConstructor() {
        BigInteger bigInteger = new BigInteger(1L);
        BigInteger bigInteger2 = new BigInteger(-1L);
        BigInteger bigInteger3 = new BigInteger(0L);
        BigInteger bigInteger4 = bigInteger.sum(bigInteger2);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)bigInteger.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)bigInteger4.isZERO());
        bigInteger4 = bigInteger.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)bigInteger4, (Object)bigInteger2);
        bigInteger4 = bigInteger.multiply(bigInteger3);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)bigInteger4.isZERO());
        bigInteger4 = bigInteger2.multiply(bigInteger2);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)bigInteger4.isONE());
        bigInteger = new BigInteger(3L);
        bigInteger2 = new BigInteger("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)bigInteger, (Object)bigInteger2);
        bigInteger = new BigInteger(-5L);
        bigInteger2 = new BigInteger("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)bigInteger, (Object)bigInteger2);
        String string = "1111111111111111111111111111111111111111111111";
        bigInteger = new BigInteger(string);
        String string2 = bigInteger.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
    }

    public void testIntegerRandom() {
        BigInteger bigInteger = BigInteger.ZERO.random(500);
        BigInteger bigInteger2 = new BigInteger("" + bigInteger);
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)bigInteger3.isZERO());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)bigInteger2.compareTo(bigInteger));
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)bigInteger3.signum());
    }

    public void testIntegerAddition() {
        BigInteger bigInteger = BigInteger.ZERO.random(500);
        BigInteger bigInteger2 = bigInteger.sum(BigInteger.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)bigInteger2, (Object)bigInteger);
        bigInteger2 = bigInteger.subtract(BigInteger.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)bigInteger2, (Object)bigInteger);
        BigInteger bigInteger3 = bigInteger.sum(bigInteger);
        BigInteger bigInteger4 = bigInteger3.subtract(bigInteger);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)bigInteger4, (Object)bigInteger);
        bigInteger3 = bigInteger.subtract(bigInteger);
        bigInteger4 = bigInteger3.sum(bigInteger);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)bigInteger4, (Object)bigInteger);
        bigInteger3 = BigInteger.ZERO.random(500);
        bigInteger4 = bigInteger.sum(bigInteger3);
        bigInteger2 = bigInteger3.sum(bigInteger);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)bigInteger4, (Object)bigInteger2);
        bigInteger4 = bigInteger.subtract(bigInteger3);
        bigInteger2 = bigInteger.sum(bigInteger3.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)bigInteger4, (Object)bigInteger2);
        bigInteger4 = BigInteger.ZERO.random(500);
        bigInteger2 = bigInteger.sum(bigInteger3.sum(bigInteger4));
        BigInteger bigInteger5 = bigInteger.sum(bigInteger3).sum(bigInteger4);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)bigInteger2, (Object)bigInteger5);
    }

    public void testIntegerMultiplication() {
        BigInteger bigInteger = BigInteger.ZERO.random(500);
        BigInteger bigInteger2 = bigInteger.multiply(BigInteger.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)bigInteger2, (Object)bigInteger);
        bigInteger2 = bigInteger.divide(BigInteger.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)bigInteger2, (Object)bigInteger);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger);
        BigInteger bigInteger4 = bigInteger3.divide(bigInteger);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)bigInteger4, (Object)bigInteger);
        bigInteger3 = bigInteger.divide(bigInteger);
        bigInteger4 = bigInteger3.multiply(bigInteger);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)bigInteger4, (Object)bigInteger);
        bigInteger3 = BigInteger.ZERO.random(500);
        bigInteger4 = bigInteger.multiply(bigInteger3);
        bigInteger2 = bigInteger3.multiply(bigInteger);
        ArithTest.assertEquals((String)"a*b = b*a", (Object)bigInteger4, (Object)bigInteger2);
        bigInteger2 = bigInteger4.divide(bigInteger3);
        BigInteger bigInteger5 = bigInteger;
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)bigInteger2, (Object)bigInteger5);
        bigInteger4 = BigInteger.ZERO.random(500);
        bigInteger2 = bigInteger.multiply(bigInteger3.multiply(bigInteger4));
        bigInteger5 = bigInteger.multiply(bigInteger3).multiply(bigInteger4);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)bigInteger2, (Object)bigInteger5);
    }

    public void testRationalConstants() {
        BigRational bigRational = BigRational.ZERO;
        BigRational bigRational2 = BigRational.ONE;
        BigRational bigRational3 = bigRational2.subtract(bigRational2);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)bigRational.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)bigRational2.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)bigRational3, (Object)bigRational);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)bigRational3.isZERO());
        BigRational bigRational4 = bigRational2.multiply(bigRational2);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)bigRational4.isONE());
        bigRational4 = bigRational2.multiply(bigRational);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)bigRational4.isZERO());
    }

    public void testComplexConstants() {
        BigComplex bigComplex = BigComplex.ZERO;
        BigComplex bigComplex2 = BigComplex.ONE;
        BigComplex bigComplex3 = bigComplex2.subtract(bigComplex2);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)bigComplex.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)bigComplex2.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)bigComplex3, (Object)bigComplex);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)bigComplex3.isZERO());
        BigComplex bigComplex4 = bigComplex2.multiply(bigComplex2);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)bigComplex4.isONE());
        bigComplex4 = bigComplex2.multiply(bigComplex);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)bigComplex4.isZERO());
    }

    public void testQuaternionConstants() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigQuaternion bigQuaternion = bigQuaternionRing.ZERO;
        BigQuaternion bigQuaternion2 = bigQuaternionRing.ONE;
        BigQuaternion bigQuaternion3 = bigQuaternion2.subtract(bigQuaternion2);
        ArithTest.assertTrue((String)"0.isZERO()", (boolean)bigQuaternion.isZERO());
        ArithTest.assertTrue((String)"1.isONE", (boolean)bigQuaternion2.isONE());
        ArithTest.assertEquals((String)"1-1 = 0", (Object)bigQuaternion3, (Object)bigQuaternion);
        ArithTest.assertTrue((String)"(1-1).isZERO()", (boolean)bigQuaternion3.isZERO());
        BigQuaternion bigQuaternion4 = bigQuaternion2.multiply(bigQuaternion2);
        ArithTest.assertTrue((String)"1*1 = 1", (boolean)bigQuaternion4.isONE());
        bigQuaternion4 = bigQuaternion2.multiply(bigQuaternion);
        ArithTest.assertTrue((String)"1*0 = 0", (boolean)bigQuaternion4.isZERO());
    }

    public void testRationalConstructor() {
        BigRational bigRational = new BigRational(1L);
        BigRational bigRational2 = new BigRational(-1L);
        BigRational bigRational3 = new BigRational(0L);
        BigRational bigRational4 = bigRational.sum(bigRational2);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)bigRational.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)bigRational4.isZERO());
        bigRational4 = bigRational.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)bigRational4, (Object)bigRational2);
        bigRational4 = bigRational.multiply(bigRational3);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)bigRational4.isZERO());
        bigRational4 = bigRational2.multiply(bigRational2);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)bigRational4.isONE());
        bigRational = new BigRational(3L);
        bigRational2 = new BigRational("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)bigRational, (Object)bigRational2);
        bigRational = new BigRational(-5L);
        bigRational2 = new BigRational("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)bigRational, (Object)bigRational2);
        String string = "1111111111111111111111111111111111111111111111";
        bigRational = new BigRational(string);
        String string2 = bigRational.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        string = "2/4";
        bigRational = new BigRational(string);
        string2 = bigRational.toString(5);
        String string3 = "0.5";
        ArithTest.assertEquals((String)"stringConstr = toString", (String)string3, (String)string2);
    }

    public void testComplexConstructor() {
        BigComplex bigComplex = new BigComplex(1L);
        BigComplex bigComplex2 = new BigComplex(-1L);
        BigComplex bigComplex3 = new BigComplex(0L);
        BigComplex bigComplex4 = bigComplex.sum(bigComplex2);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)bigComplex.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)bigComplex4.isZERO());
        bigComplex4 = bigComplex.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)bigComplex4, (Object)bigComplex2);
        bigComplex4 = bigComplex.multiply(bigComplex3);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)bigComplex4.isZERO());
        bigComplex4 = bigComplex2.multiply(bigComplex2);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)bigComplex4.isONE());
        bigComplex = new BigComplex(3L);
        bigComplex2 = new BigComplex("3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)bigComplex, (Object)bigComplex2);
        bigComplex = new BigComplex(-5L);
        bigComplex2 = new BigComplex("-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)bigComplex, (Object)bigComplex2);
        String string = "1111111111111111111111111111111111111111111111";
        bigComplex = new BigComplex(string);
        String string2 = bigComplex.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
    }

    public void testQuaternionConstructor() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigQuaternion bigQuaternion = new BigQuaternion(bigQuaternionRing, 1L);
        BigQuaternion bigQuaternion2 = new BigQuaternion(bigQuaternionRing, -1L);
        BigQuaternion bigQuaternion3 = new BigQuaternion(bigQuaternionRing, 0L);
        BigQuaternion bigQuaternion4 = bigQuaternion.sum(bigQuaternion2);
        ArithTest.assertTrue((String)"'1'.isONE()", (boolean)bigQuaternion.isONE());
        ArithTest.assertTrue((String)"1+(-1) = 0", (boolean)bigQuaternion4.isZERO());
        bigQuaternion4 = bigQuaternion.negate();
        ArithTest.assertEquals((String)"-1 = -(1)", (Object)bigQuaternion4, (Object)bigQuaternion2);
        bigQuaternion4 = bigQuaternion.multiply(bigQuaternion3);
        ArithTest.assertTrue((String)"'0'.isZERO()", (boolean)bigQuaternion4.isZERO());
        bigQuaternion4 = bigQuaternion2.multiply(bigQuaternion2);
        ArithTest.assertTrue((String)"(-1)*(-1) = 1", (boolean)bigQuaternion4.isONE());
        bigQuaternion = new BigQuaternion(bigQuaternionRing, 3L);
        bigQuaternion2 = new BigQuaternion(bigQuaternionRing, "3");
        ArithTest.assertEquals((String)"3 = '3'", (Object)bigQuaternion, (Object)bigQuaternion2);
        bigQuaternion = new BigQuaternion(bigQuaternionRing, -5L);
        bigQuaternion2 = new BigQuaternion(bigQuaternionRing, "-5");
        ArithTest.assertEquals((String)"-5 = '-5'", (Object)bigQuaternion, (Object)bigQuaternion2);
        String string = "1111111111111111111111111111111111111111111111";
        bigQuaternion = new BigQuaternion(bigQuaternionRing, string);
        String string2 = bigQuaternion.toString();
        ArithTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
    }

    public void testRationalRandom() {
        BigRational bigRational = BigRational.ZERO.random(500);
        BigRational bigRational2 = new BigRational("" + bigRational);
        BigRational bigRational3 = bigRational2.subtract(bigRational);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)bigRational3.isZERO());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)bigRational2.compareTo(bigRational));
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)bigRational3.signum());
    }

    public void testComplexRandom() {
        BigComplex bigComplex = BigComplex.ZERO.random(500);
        BigComplex bigComplex2 = new BigComplex("" + bigComplex);
        BigComplex bigComplex3 = bigComplex2.subtract(bigComplex);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)bigComplex3.isZERO());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)bigComplex2.compareTo(bigComplex));
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)bigComplex3.signum());
    }

    public void testQuaternionRandom() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigQuaternion bigQuaternion = bigQuaternionRing.random(500);
        BigQuaternion bigQuaternion2 = new BigQuaternion(bigQuaternionRing, bigQuaternion.toString());
        BigQuaternion bigQuaternion3 = bigQuaternion2.subtract(bigQuaternion);
        ArithTest.assertTrue((String)"a-'a' = 0", (boolean)bigQuaternion3.isZERO());
        ArithTest.assertEquals((String)"signum('a'-a) = 0", (int)0, (int)bigQuaternion3.signum());
        ArithTest.assertEquals((String)"compareTo('a',a) = 0", (int)0, (int)bigQuaternion2.compareTo(bigQuaternion));
    }

    public void testRationalAddition() {
        BigRational bigRational = BigRational.ZERO.random(500);
        BigRational bigRational2 = bigRational.sum(BigRational.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)bigRational2, (Object)bigRational);
        bigRational2 = bigRational.subtract(BigRational.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)bigRational2, (Object)bigRational);
        BigRational bigRational3 = bigRational.sum(bigRational);
        BigRational bigRational4 = bigRational3.subtract(bigRational);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)bigRational4, (Object)bigRational);
        bigRational3 = bigRational.subtract(bigRational);
        bigRational4 = bigRational3.sum(bigRational);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)bigRational4, (Object)bigRational);
        bigRational3 = BigRational.ZERO.random(500);
        bigRational4 = bigRational.sum(bigRational3);
        bigRational2 = bigRational3.sum(bigRational);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)bigRational4, (Object)bigRational2);
        bigRational4 = bigRational.subtract(bigRational3);
        bigRational2 = bigRational.sum(bigRational3.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)bigRational4, (Object)bigRational2);
        bigRational4 = BigRational.ZERO.random(500);
        bigRational2 = bigRational.sum(bigRational3.sum(bigRational4));
        BigRational bigRational5 = bigRational.sum(bigRational3).sum(bigRational4);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)bigRational2, (Object)bigRational5);
    }

    public void testComplexAddition() {
        BigComplex bigComplex = BigComplex.ZERO.random(500);
        BigComplex bigComplex2 = bigComplex.sum(BigComplex.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)bigComplex2, (Object)bigComplex);
        bigComplex2 = bigComplex.subtract(BigComplex.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)bigComplex2, (Object)bigComplex);
        BigComplex bigComplex3 = bigComplex.sum(bigComplex);
        BigComplex bigComplex4 = bigComplex3.subtract(bigComplex);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)bigComplex4, (Object)bigComplex);
        bigComplex3 = bigComplex.subtract(bigComplex);
        bigComplex4 = bigComplex3.sum(bigComplex);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)bigComplex4, (Object)bigComplex);
        bigComplex3 = BigComplex.ZERO.random(500);
        bigComplex4 = bigComplex.sum(bigComplex3);
        bigComplex2 = bigComplex3.sum(bigComplex);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)bigComplex4, (Object)bigComplex2);
        bigComplex4 = bigComplex.subtract(bigComplex3);
        bigComplex2 = bigComplex.sum(bigComplex3.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)bigComplex4, (Object)bigComplex2);
        bigComplex4 = BigComplex.ZERO.random(500);
        bigComplex2 = bigComplex.sum(bigComplex3.sum(bigComplex4));
        BigComplex bigComplex5 = bigComplex.sum(bigComplex3).sum(bigComplex4);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)bigComplex2, (Object)bigComplex5);
    }

    public void testQuaternionAddition() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigQuaternion bigQuaternion = bigQuaternionRing.random(500);
        BigQuaternion bigQuaternion2 = bigQuaternion.sum(bigQuaternionRing.ZERO);
        ArithTest.assertEquals((String)"a+0 = a", (Object)bigQuaternion2, (Object)bigQuaternion);
        bigQuaternion2 = bigQuaternion.subtract(bigQuaternionRing.ZERO);
        ArithTest.assertEquals((String)"a-0 = a", (Object)bigQuaternion2, (Object)bigQuaternion);
        BigQuaternion bigQuaternion3 = bigQuaternion.sum(bigQuaternion);
        BigQuaternion bigQuaternion4 = bigQuaternion3.subtract(bigQuaternion);
        ArithTest.assertEquals((String)"(a+a)-a = a", (Object)bigQuaternion4, (Object)bigQuaternion);
        bigQuaternion3 = bigQuaternion.subtract(bigQuaternion);
        bigQuaternion4 = bigQuaternion3.sum(bigQuaternion);
        ArithTest.assertEquals((String)"(a-a)+a = a", (Object)bigQuaternion4, (Object)bigQuaternion);
        bigQuaternion3 = bigQuaternionRing.random(500);
        bigQuaternion4 = bigQuaternion.sum(bigQuaternion3);
        bigQuaternion2 = bigQuaternion3.sum(bigQuaternion);
        ArithTest.assertEquals((String)"a+b = b+a", (Object)bigQuaternion4, (Object)bigQuaternion2);
        bigQuaternion4 = bigQuaternion.subtract(bigQuaternion3);
        bigQuaternion2 = bigQuaternion.sum(bigQuaternion3.negate());
        ArithTest.assertEquals((String)"a-b = a+(-b)", (Object)bigQuaternion4, (Object)bigQuaternion2);
        bigQuaternion4 = bigQuaternionRing.random(500);
        bigQuaternion2 = bigQuaternion.sum(bigQuaternion3.sum(bigQuaternion4));
        BigQuaternion bigQuaternion5 = bigQuaternion.sum(bigQuaternion3).sum(bigQuaternion4);
        ArithTest.assertEquals((String)"a+(b+c) = (a+b)+c", (Object)bigQuaternion2, (Object)bigQuaternion5);
    }

    public void testRationalMultiplication() {
        BigRational bigRational = BigRational.ZERO.random(500);
        BigRational bigRational2 = bigRational.multiply(BigRational.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)bigRational2, (Object)bigRational);
        bigRational2 = bigRational.divide(BigRational.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)bigRational2, (Object)bigRational);
        BigRational bigRational3 = bigRational.multiply(bigRational);
        BigRational bigRational4 = bigRational3.divide(bigRational);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)bigRational4, (Object)bigRational);
        bigRational3 = bigRational.divide(bigRational);
        bigRational4 = bigRational3.multiply(bigRational);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)bigRational4, (Object)bigRational);
        bigRational3 = BigRational.ZERO.random(500);
        bigRational4 = bigRational.multiply(bigRational3);
        bigRational2 = bigRational3.multiply(bigRational);
        ArithTest.assertEquals((String)"a*b = b*a", (Object)bigRational4, (Object)bigRational2);
        bigRational2 = bigRational4.divide(bigRational3);
        BigRational bigRational5 = bigRational4.multiply(bigRational3.inverse());
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)bigRational2, (Object)bigRational5);
        bigRational4 = BigRational.ZERO.random(500);
        bigRational2 = bigRational.multiply(bigRational3.multiply(bigRational4));
        bigRational5 = bigRational.multiply(bigRational3).multiply(bigRational4);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)bigRational2, (Object)bigRational5);
    }

    public void testComplexMultiplication() {
        BigComplex bigComplex = BigComplex.ZERO.random(500);
        BigComplex bigComplex2 = bigComplex.multiply(BigComplex.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)bigComplex2, (Object)bigComplex);
        bigComplex2 = bigComplex.divide(BigComplex.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)bigComplex2, (Object)bigComplex);
        BigComplex bigComplex3 = bigComplex.multiply(bigComplex);
        BigComplex bigComplex4 = bigComplex3.divide(bigComplex);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)bigComplex4, (Object)bigComplex);
        bigComplex3 = bigComplex.divide(bigComplex);
        bigComplex4 = bigComplex3.multiply(bigComplex);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)bigComplex4, (Object)bigComplex);
        bigComplex3 = BigComplex.ZERO.random(500);
        bigComplex4 = bigComplex.multiply(bigComplex3);
        bigComplex2 = bigComplex3.multiply(bigComplex);
        ArithTest.assertEquals((String)"a*b = b*a", (Object)bigComplex4, (Object)bigComplex2);
        bigComplex2 = bigComplex4.divide(bigComplex3);
        BigComplex bigComplex5 = bigComplex4.multiply(bigComplex3.inverse());
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)bigComplex2, (Object)bigComplex5);
        bigComplex4 = BigComplex.ZERO.random(500);
        bigComplex2 = bigComplex.multiply(bigComplex3.multiply(bigComplex4));
        bigComplex5 = bigComplex.multiply(bigComplex3).multiply(bigComplex4);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)bigComplex2, (Object)bigComplex5);
    }

    public void testQuaternionMultiplication() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigQuaternion bigQuaternion = bigQuaternionRing.random(500);
        BigQuaternion bigQuaternion2 = bigQuaternion.multiply(bigQuaternionRing.ONE);
        ArithTest.assertEquals((String)"a*1 = a", (Object)bigQuaternion2, (Object)bigQuaternion);
        bigQuaternion2 = bigQuaternion.divide(bigQuaternionRing.ONE);
        ArithTest.assertEquals((String)"a/1 = a", (Object)bigQuaternion2, (Object)bigQuaternion);
        BigQuaternion bigQuaternion3 = bigQuaternion.multiply(bigQuaternion);
        BigQuaternion bigQuaternion4 = bigQuaternion3.divide(bigQuaternion);
        ArithTest.assertEquals((String)"(a*a)/a = a", (Object)bigQuaternion4, (Object)bigQuaternion);
        bigQuaternion3 = bigQuaternion.divide(bigQuaternion);
        bigQuaternion4 = bigQuaternion3.multiply(bigQuaternion);
        ArithTest.assertEquals((String)"(a/a)*a = a", (Object)bigQuaternion4, (Object)bigQuaternion);
        bigQuaternion3 = bigQuaternionRing.random(500);
        bigQuaternion4 = bigQuaternion3.multiply(bigQuaternion);
        bigQuaternion2 = bigQuaternion4.divide(bigQuaternion3);
        BigQuaternion bigQuaternion5 = bigQuaternion4.multiply(bigQuaternion3.inverse());
        ArithTest.assertEquals((String)"a/b = a*(1/b)", (Object)bigQuaternion2, (Object)bigQuaternion5);
        bigQuaternion4 = bigQuaternionRing.random(500);
        bigQuaternion2 = bigQuaternion.multiply(bigQuaternion3.multiply(bigQuaternion4));
        bigQuaternion5 = bigQuaternion.multiply(bigQuaternion3).multiply(bigQuaternion4);
        ArithTest.assertEquals((String)"a*(b*c) = (a*b)*c", (Object)bigQuaternion2, (Object)bigQuaternion5);
        bigQuaternion = bigQuaternionRing.I;
        bigQuaternion3 = bigQuaternionRing.J;
        bigQuaternion4 = bigQuaternion.multiply(bigQuaternion3);
        bigQuaternion2 = bigQuaternion3.multiply(bigQuaternion);
        ArithTest.assertEquals((String)"I*J = -J*I", (Object)bigQuaternion4, (Object)bigQuaternion2.negate());
        bigQuaternion = bigQuaternionRing.I;
        bigQuaternion3 = bigQuaternionRing.K;
        bigQuaternion4 = bigQuaternion.multiply(bigQuaternion3);
        bigQuaternion2 = bigQuaternion3.multiply(bigQuaternion);
        ArithTest.assertEquals((String)"I*K = -K*I", (Object)bigQuaternion4, (Object)bigQuaternion2.negate());
        bigQuaternion = bigQuaternionRing.J;
        bigQuaternion3 = bigQuaternionRing.K;
        bigQuaternion4 = bigQuaternion.multiply(bigQuaternion3);
        bigQuaternion2 = bigQuaternion3.multiply(bigQuaternion);
        ArithTest.assertEquals((String)"J*K = -K*J", (Object)bigQuaternion4, (Object)bigQuaternion2.negate());
    }

    public void testRationalPower() {
        BigRational bigRational = BigRational.ZERO.random(100);
        BigRational bigRational2 = Power.positivePower(bigRational, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)bigRational2, (Object)bigRational);
        Power<BigRational> power = new Power<BigRational>(BigRational.ONE);
        bigRational2 = power.power(bigRational, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)bigRational2, (Object)bigRational);
        bigRational2 = power.power(bigRational, 2L);
        BigRational bigRational3 = bigRational.multiply(bigRational);
        ArithTest.assertEquals((String)"a^2 = a*a", (Object)bigRational2, (Object)bigRational3);
        BigRational bigRational4 = power.power(bigRational, -2L);
        bigRational3 = bigRational2.multiply(bigRational4);
        ArithTest.assertTrue((String)"a^2 * a^-2 = 1", (boolean)bigRational3.isONE());
        bigRational2 = power.power(bigRational, 3L);
        bigRational3 = bigRational.multiply(bigRational).multiply(bigRational);
        ArithTest.assertEquals((String)"a^3 = a*a*a", (Object)bigRational2, (Object)bigRational3);
        bigRational4 = power.power(bigRational, -3L);
        bigRational3 = bigRational2.multiply(bigRational4);
        ArithTest.assertTrue((String)"a^3 * a^-3 = 1", (boolean)bigRational3.isONE());
        bigRational4 = (BigRational)bigRational.power(-3L);
        bigRational3 = bigRational2.multiply(bigRational4);
        ArithTest.assertTrue((String)"a^3 * a^-3 = 1", (boolean)bigRational3.isONE());
    }

    public void testIntegerPower() {
        BigInteger bigInteger = BigInteger.ZERO.random(500);
        BigInteger bigInteger2 = Power.positivePower(bigInteger, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        Power<BigInteger> power = new Power<BigInteger>(BigInteger.ONE);
        bigInteger2 = power.power(bigInteger, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        bigInteger2 = power.power(bigInteger, 2L);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger);
        ArithTest.assertEquals((String)"a^2 = a*a", (Object)bigInteger2, (Object)bigInteger3);
        bigInteger2 = power.power(bigInteger, 3L);
        bigInteger3 = bigInteger.multiply(bigInteger).multiply(bigInteger);
        ArithTest.assertEquals((String)"a^3 = a*a*a", (Object)bigInteger2, (Object)bigInteger3);
        bigInteger = new BigInteger(3L);
        bigInteger2 = Power.positivePower(bigInteger, 1L);
        ArithTest.assertEquals((String)"a^1 = a", (Object)bigInteger2, (Object)bigInteger);
        bigInteger = new BigInteger(11L);
        BigInteger bigInteger4 = new BigInteger(2L);
        bigInteger3 = Power.modPositivePower(bigInteger, 10L, bigInteger4);
        ArithTest.assertTrue((String)"3^n mod 2 = 1", (boolean)bigInteger3.isONE());
        bigInteger = BigInteger.ZERO.random(500);
        bigInteger2 = new BigInteger(11L);
        bigInteger3 = Power.modPositivePower(bigInteger, 11L, bigInteger2);
        BigInteger bigInteger5 = bigInteger.remainder(bigInteger2);
        ArithTest.assertEquals((String)"a^p = a mod p", (Object)bigInteger3, (Object)bigInteger5);
        bigInteger3 = power.modPower(bigInteger, 11L, bigInteger2);
        ArithTest.assertEquals((String)"a^p = a mod p", (Object)bigInteger3, (Object)bigInteger5);
        bigInteger = BigInteger.ZERO.random(100);
        bigInteger5 = (BigInteger)bigInteger.power(1L);
        bigInteger3 = bigInteger;
        ArithTest.assertEquals((String)"a^1 == a", (Object)bigInteger3, (Object)bigInteger5);
        bigInteger5 = (BigInteger)bigInteger.power(0L);
        bigInteger3 = BigInteger.ONE;
        ArithTest.assertEquals((String)"a^0 == 1", (Object)bigInteger3, (Object)bigInteger5);
        bigInteger5 = (BigInteger)bigInteger.power(3L);
        bigInteger3 = bigInteger.multiply(bigInteger).multiply(bigInteger);
        ArithTest.assertEquals((String)"a^3 == a*a*a", (Object)bigInteger3, (Object)bigInteger5);
    }

    public void testCombinatoric() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = Combinatoric.binCoeff(5, 0);
        ArithTest.assertTrue((String)"(5 0) == 1 ", (boolean)bigInteger2.isONE());
        bigInteger2 = Combinatoric.binCoeff(5, 7);
        ArithTest.assertTrue((String)"(5 7) == 1 ", (boolean)bigInteger2.isONE());
        int n = 7;
        for (int i = 0; i <= n; ++i) {
            bigInteger2 = Combinatoric.binCoeff(n, i);
            bigInteger = Combinatoric.binCoeff(n, n - i);
            ArithTest.assertEquals((String)"(5 k) == (5 5-k) ", (Object)bigInteger, (Object)bigInteger2);
        }
        ArithTest.assertTrue((String)"(5 5) == 1 ", (boolean)bigInteger2.isONE());
        bigInteger = Combinatoric.binCoeffSum(n, n);
        BigInteger bigInteger3 = Power.positivePower(new BigInteger(2L), n);
        ArithTest.assertEquals((String)"sum(5 5) == 1 ", (Object)bigInteger, (Object)bigInteger3);
        bigInteger = Combinatoric.factorial(3L);
        ArithTest.assertEquals((String)"3! == 6 ", (Object)bigInteger, (Object)new BigInteger(6L));
        bigInteger = Combinatoric.factorial(0L);
        ArithTest.assertEquals((String)"0! == 1 ", (Object)bigInteger, (Object)new BigInteger(1L));
    }

    public void testSquareRoot() {
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = bigInteger.random(47).abs();
        BigInteger bigInteger3 = Roots.sqrtInt(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.multiply(bigInteger3);
        ArithTest.assertTrue((String)"root^2 <= a ", (bigInteger4.compareTo(bigInteger2) <= 0 ? 1 : 0) != 0);
        bigInteger3 = bigInteger3.sum(BigInteger.ONE);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger3);
        ArithTest.assertTrue((String)"(root+1)^2 >= a ", (bigInteger5.compareTo(bigInteger2) >= 0 ? 1 : 0) != 0);
        BigInteger bigInteger6 = Roots.sqrt(bigInteger2);
        bigInteger4 = bigInteger6.multiply(bigInteger6);
        ArithTest.assertTrue((String)"root^2 <= a ", (bigInteger4.compareTo(bigInteger2) <= 0 ? 1 : 0) != 0);
        bigInteger6 = bigInteger6.sum(BigInteger.ONE);
        bigInteger5 = bigInteger6.multiply(bigInteger6);
        ArithTest.assertTrue((String)"(root+1)^2 >= a ", (bigInteger5.compareTo(bigInteger2) >= 0 ? 1 : 0) != 0);
    }

    public void testRoot() {
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = bigInteger.random(47).abs();
        for (int i = 2; i < 8; ++i) {
            BigInteger bigInteger3 = Roots.root(bigInteger2, i);
            BigInteger bigInteger4 = Power.positivePower(bigInteger3, i);
            ArithTest.assertTrue((String)("root^" + i + " <= a " + bigInteger2.subtract(bigInteger4)), (bigInteger4.compareTo(bigInteger2) <= 0 ? 1 : 0) != 0);
            bigInteger3 = bigInteger3.sum(BigInteger.ONE);
            BigInteger bigInteger5 = Power.positivePower(bigInteger3, i);
            ArithTest.assertTrue((String)("(root+1)^" + i + " >= a "), (bigInteger5.compareTo(bigInteger2) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testRootDecimal() {
        BigDecimal bigDecimal = BigDecimal.ONE;
        BigRational bigRational = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 2);
        BigDecimal bigDecimal2 = new BigDecimal(bigRational);
        BigDecimal bigDecimal3 = bigDecimal.random(17).abs();
        for (int i = 1; i < 8; ++i) {
            BigDecimal bigDecimal4 = Roots.root(bigDecimal3, i);
            BigDecimal bigDecimal5 = Power.positivePower(bigDecimal4, i);
            if (bigDecimal3.compareTo(bigDecimal5) == 0) {
                ArithTest.assertTrue((String)("root^" + i + " == b: " + bigDecimal5), (bigDecimal3.compareTo(bigDecimal5) == 0 ? 1 : 0) != 0);
                continue;
            }
            BigDecimal bigDecimal6 = bigDecimal3.subtract(bigDecimal5).abs().divide(bigDecimal3.abs().sum(bigDecimal5.abs()));
            ArithTest.assertTrue((String)("root(a,n)**n == a: " + bigDecimal6), (bigDecimal6.compareTo(bigDecimal2) <= 0 ? 1 : 0) != 0);
        }
    }

    public void test2RootDecimal() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = Roots.sqrt(bigDecimal);
        ArithTest.assertTrue((String)("sqrt(0) == 0: " + bigDecimal2), (boolean)bigDecimal2.isZERO());
        bigDecimal = BigDecimal.ONE;
        bigDecimal2 = Roots.sqrt(bigDecimal);
        ArithTest.assertTrue((String)("sqrt(1) == 1: " + bigDecimal2), (boolean)bigDecimal2.isONE());
        bigDecimal = new BigDecimal("4");
        bigDecimal2 = Roots.sqrt(bigDecimal);
        BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal2);
        ArithTest.assertTrue((String)("sqrt(4)*sqrt(4) == 4: " + bigDecimal.subtract(bigDecimal3)), (bigDecimal.compareTo(bigDecimal3) == 0 ? 1 : 0) != 0);
        bigDecimal = new BigDecimal("0.5");
        bigDecimal2 = Roots.sqrt(bigDecimal);
        bigDecimal3 = bigDecimal2.multiply(bigDecimal2);
        ArithTest.assertTrue((String)("sqrt(0.5)*sqrt(0.5) == 0.5: " + bigDecimal.subtract(bigDecimal3)), (bigDecimal.compareTo(bigDecimal3) == 0 ? 1 : 0) != 0);
        ArithTest.assertTrue((String)("sqrt(0.5)*sqrt(0.5) == 0.5: " + bigDecimal2), (bigDecimal.compareTo(bigDecimal3) == 0 ? 1 : 0) != 0);
        bigDecimal = bigDecimal.random(5).abs();
        bigDecimal2 = Roots.sqrt(bigDecimal);
        bigDecimal3 = bigDecimal2.multiply(bigDecimal2);
        BigDecimal bigDecimal4 = (BigDecimal)new BigDecimal("0.1").power(BigDecimal.DEFAULT_PRECISION - 2);
        BigDecimal bigDecimal5 = bigDecimal.subtract(bigDecimal3).abs().divide(bigDecimal.abs().sum(BigDecimal.ONE));
        ArithTest.assertTrue((String)("sqrt(a)*sqrt(a) == a: " + bigDecimal5), (bigDecimal5.compareTo(bigDecimal4) <= 0 ? 1 : 0) != 0);
    }

    public void testRootDecimalComplex() {
        BigDecimalComplex bigDecimalComplex = BigDecimalComplex.ZERO;
        BigDecimalComplex bigDecimalComplex2 = Roots.sqrt(bigDecimalComplex);
        ArithTest.assertTrue((String)("sqrt(0) == 0: " + bigDecimalComplex2), (boolean)bigDecimalComplex2.isZERO());
        bigDecimalComplex = BigDecimalComplex.ONE;
        bigDecimalComplex2 = Roots.sqrt(bigDecimalComplex);
        ArithTest.assertTrue((String)("sqrt(1) == 1: " + bigDecimalComplex2), (boolean)bigDecimalComplex2.isONE());
        bigDecimalComplex = BigDecimalComplex.ONE.negate();
        bigDecimalComplex2 = Roots.sqrt(bigDecimalComplex);
        BigDecimalComplex bigDecimalComplex3 = bigDecimalComplex2.multiply(bigDecimalComplex2);
        ArithTest.assertTrue((String)("sqrt(-1) == I: " + bigDecimalComplex2), (boolean)bigDecimalComplex2.isIMAG());
        ArithTest.assertTrue((String)("sqrt(-1)*sqrt(-1) == -1: " + bigDecimalComplex + ", b = " + bigDecimalComplex2), (bigDecimalComplex.compareTo(bigDecimalComplex3) == 0 ? 1 : 0) != 0);
        bigDecimalComplex2 = BigDecimalComplex.I;
        BigDecimalComplex bigDecimalComplex4 = Roots.sqrt(bigDecimalComplex2);
        bigDecimalComplex3 = bigDecimalComplex4.multiply(bigDecimalComplex4);
        ArithTest.assertTrue((String)("sqrt(b)*sqrt(b) == b: " + bigDecimalComplex4 + ", b = " + bigDecimalComplex2), (bigDecimalComplex2.compareTo(bigDecimalComplex3) == 0 ? 1 : 0) != 0);
        bigDecimalComplex2 = bigDecimalComplex.fromInteger(4L);
        bigDecimalComplex4 = Roots.sqrt(bigDecimalComplex2);
        bigDecimalComplex3 = BigDecimalComplex.ONE.sum(BigDecimalComplex.ONE);
        ArithTest.assertTrue((String)("sqrt(4) == 2: " + bigDecimalComplex4), (bigDecimalComplex4.compareTo(bigDecimalComplex3) == 0 ? 1 : 0) != 0);
        bigDecimalComplex2 = bigDecimalComplex2.multiply(BigDecimalComplex.I);
        bigDecimalComplex4 = Roots.sqrt(bigDecimalComplex2);
        bigDecimalComplex3 = bigDecimalComplex4.multiply(bigDecimalComplex4);
        ArithTest.assertTrue((String)("sqrt(b)*sqrt(b) == b: " + bigDecimalComplex4 + ", b = " + bigDecimalComplex2), (bigDecimalComplex2.compareTo(bigDecimalComplex3) == 0 ? 1 : 0) != 0);
        bigDecimalComplex2 = bigDecimalComplex.random(5);
        bigDecimalComplex4 = bigDecimalComplex2.norm();
        bigDecimalComplex3 = bigDecimalComplex2.multiply(bigDecimalComplex2.conjugate());
        ArithTest.assertTrue((String)("norm(b) == b*b^: b-d = " + bigDecimalComplex4.subtract(bigDecimalComplex3)), (bigDecimalComplex4.compareTo(bigDecimalComplex3) == 0 ? 1 : 0) != 0);
        BigRational bigRational = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        BigDecimal bigDecimal = new BigDecimal(bigRational);
        bigDecimalComplex3 = bigDecimalComplex2.abs();
        BigDecimalComplex bigDecimalComplex5 = bigDecimalComplex3.multiply(bigDecimalComplex3);
        BigDecimal bigDecimal2 = bigDecimalComplex5.re.subtract(bigDecimalComplex4.re).abs().divide(bigDecimalComplex5.re.abs().sum(bigDecimalComplex4.re.abs()));
        ArithTest.assertTrue((String)("abs()*abs() == norm(): " + bigDecimal2), (bigDecimal2.compareTo(bigDecimal) <= 0 ? 1 : 0) != 0);
    }

    public void test2RootRational() {
        BigRational bigRational = BigRational.ZERO;
        BigRational bigRational2 = Roots.sqrt(bigRational);
        ArithTest.assertTrue((String)("sqrt(0) == 0: " + bigRational2), (boolean)bigRational2.isZERO());
        bigRational = BigRational.ONE;
        bigRational2 = Roots.sqrt(bigRational);
        ArithTest.assertTrue((String)("sqrt(1) == 1: " + bigRational2), (boolean)bigRational2.isONE());
        bigRational = BigRational.ONE.negate();
        try {
            bigRational2 = Roots.sqrt(bigRational);
            ArithTest.fail((String)("sqrt(-1) illegal: " + bigRational2));
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        bigRational = new BigRational("4");
        bigRational2 = Roots.sqrt(bigRational);
        BigRational bigRational3 = bigRational2.multiply(bigRational2);
        ArithTest.assertTrue((String)("sqrt(4)*sqrt(4) == 4: " + bigRational.subtract(bigRational3)), (bigRational.compareTo(bigRational3) == 0 ? 1 : 0) != 0);
        BigRational bigRational4 = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        bigRational = new BigRational("0.5");
        bigRational2 = Roots.sqrt(bigRational);
        bigRational3 = bigRational2.multiply(bigRational2);
        BigRational bigRational5 = bigRational.subtract(bigRational3).abs().divide(bigRational.abs().sum(bigRational3.abs()));
        ArithTest.assertTrue((String)("sqrt(0.5)*sqrt(0.5) == 0.5: " + bigRational3), (bigRational5.compareTo(bigRational4) <= 0 ? 1 : 0) != 0);
        bigRational = bigRational.random(5).abs();
        bigRational2 = Roots.sqrt(bigRational);
        bigRational3 = bigRational2.multiply(bigRational2);
        bigRational5 = bigRational.subtract(bigRational3).abs().divide(bigRational.abs().sum(bigRational3.abs()));
        ArithTest.assertTrue((String)("sqrt(0.5)*sqrt(0.5) == 0.5: " + bigRational3), (bigRational5.compareTo(bigRational4) <= 0 ? 1 : 0) != 0);
    }

    public void test2NormComplex() {
        BigComplex bigComplex = BigComplex.ZERO;
        BigComplex bigComplex2 = bigComplex.abs();
        ArithTest.assertTrue((String)("abs(0) == 0: " + bigComplex2), (boolean)bigComplex2.isZERO());
        bigComplex = BigComplex.ONE;
        bigComplex2 = bigComplex.abs();
        ArithTest.assertTrue((String)("abs(1) == 1: " + bigComplex2), (boolean)bigComplex2.isONE());
        bigComplex = BigComplex.ONE.negate();
        bigComplex2 = bigComplex.abs();
        ArithTest.assertTrue((String)("abs(-1): " + bigComplex2), (boolean)bigComplex2.isONE());
        BigRational bigRational = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        bigComplex = bigComplex.random(5);
        bigComplex2 = bigComplex.abs();
        BigRational bigRational2 = bigComplex2.multiply((BigComplex)bigComplex2).re;
        BigRational bigRational3 = bigComplex.multiply((BigComplex)bigComplex.conjugate()).re;
        BigRational bigRational4 = bigRational2.subtract(bigRational3).abs().divide(bigRational2.abs().sum(bigRational3.abs()));
        ArithTest.assertTrue((String)("abs()*abs() == norm(): " + bigComplex2), (bigRational4.compareTo(bigRational) <= 0 ? 1 : 0) != 0);
    }

    public void test2NormQuaternion() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigQuaternion bigQuaternion = bigQuaternionRing.ZERO;
        BigQuaternion bigQuaternion2 = bigQuaternion.abs();
        ArithTest.assertTrue((String)("abs(0) == 0: " + bigQuaternion2), (boolean)bigQuaternion2.isZERO());
        bigQuaternion = bigQuaternionRing.ONE;
        bigQuaternion2 = bigQuaternion.abs();
        ArithTest.assertTrue((String)("abs(1) == 1: " + bigQuaternion2), (boolean)bigQuaternion2.isONE());
        bigQuaternion = bigQuaternionRing.ONE.negate();
        bigQuaternion2 = bigQuaternion.abs();
        ArithTest.assertTrue((String)("abs(-1): " + bigQuaternion2), (boolean)bigQuaternion2.isONE());
        BigRational bigRational = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        bigQuaternion = bigQuaternionRing.random(5);
        bigQuaternion2 = bigQuaternion.abs();
        BigRational bigRational2 = bigQuaternion2.multiply((BigQuaternion)bigQuaternion2).re;
        BigRational bigRational3 = bigQuaternion.multiply((BigQuaternion)bigQuaternion.conjugate()).re;
        BigRational bigRational4 = bigRational2.subtract(bigRational3).abs().divide(bigRational2.abs().sum(bigRational3.abs()));
        ArithTest.assertTrue((String)("sqrt(x)*sqrt(x): " + bigQuaternion2), (bigRational4.compareTo(bigRational) <= 0 ? 1 : 0) != 0);
    }

    public void test2NormOctonion() {
        BigQuaternionRing bigQuaternionRing = new BigQuaternionRing();
        BigOctonion bigOctonion = new BigOctonion(bigQuaternionRing);
        BigOctonion bigOctonion2 = bigOctonion.getZERO();
        BigOctonion bigOctonion3 = bigOctonion2.abs();
        ArithTest.assertTrue((String)("abs(0) == 0: " + bigOctonion3), (boolean)bigOctonion3.isZERO());
        bigOctonion2 = bigOctonion.getONE();
        bigOctonion3 = bigOctonion2.abs();
        ArithTest.assertTrue((String)("abs(1) == 1: " + bigOctonion3), (boolean)bigOctonion3.isONE());
        bigOctonion2 = bigOctonion.getONE().negate();
        bigOctonion3 = bigOctonion2.abs();
        ArithTest.assertTrue((String)("abs(-1): " + bigOctonion3), (boolean)bigOctonion3.isONE());
        BigRational bigRational = (BigRational)new BigRational(1L, 10L).power(BigDecimal.DEFAULT_PRECISION - 1);
        bigOctonion2 = bigOctonion.random(5);
        bigOctonion3 = bigOctonion2.abs();
        BigRational bigRational2 = bigOctonion3.multiply((BigOctonion)bigOctonion3).or.re;
        BigRational bigRational3 = bigOctonion2.multiply((BigOctonion)bigOctonion2.conjugate()).or.re;
        BigRational bigRational4 = bigRational2.subtract(bigRational3).abs().divide(bigRational2.abs().sum(bigRational3.abs()));
        ArithTest.assertTrue((String)("sqrt(x)*sqrt(x): " + bigOctonion3), (bigRational4.compareTo(bigRational) <= 0 ? 1 : 0) != 0);
    }

    public void testContinuedFraction() {
        BigRational bigRational = BigRational.ONE;
        BigRational bigRational2 = bigRational.random(35);
        List<BigInteger> list = ArithUtil.continuedFraction(bigRational2);
        BigRational bigRational3 = ArithUtil.continuedFractionApprox(list);
        ArithTest.assertEquals((String)"a = approx(cf(a)): ", (Object)bigRational2, (Object)bigRational3);
    }
}

