/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import edu.jas.arith.PrimeInteger;
import edu.jas.arith.PrimeList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PrimeTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)PrimeTest.suite());
    }

    public PrimeTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(PrimeTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testPrime() {
        PrimeList primeList = new PrimeList();
        int n = 0;
        for (java.math.BigInteger bigInteger : primeList) {
            PrimeTest.assertFalse((String)"p != null", (bigInteger == null ? 1 : 0) != 0);
            if (n++ <= 50) continue;
            break;
        }
        PrimeTest.assertTrue((String)"all primes ", (boolean)primeList.checkPrimes());
    }

    public void testSmallPrime() {
        Object object;
        List<Long> list = PrimeInteger.SMPRM;
        for (Long l : list) {
            object = new java.math.BigInteger(l.toString());
            PrimeTest.assertTrue((String)("isPrime: " + l), (boolean)((java.math.BigInteger)object).isProbablePrime(16));
        }
        PrimeList primeList = new PrimeList(PrimeList.Range.small);
        int n = primeList.size() - 1;
        object = primeList.iterator();
        while (object.hasNext()) {
            java.math.BigInteger bigInteger = (java.math.BigInteger)object.next();
            PrimeTest.assertTrue((String)"p.isPrime: ", (boolean)PrimeInteger.isPrime(bigInteger.longValue()));
            if (n-- > 0) continue;
            break;
        }
    }

    public void testLowPrime() {
        PrimeList primeList = new PrimeList(PrimeList.Range.low);
        int n = primeList.size() - 1;
        for (java.math.BigInteger bigInteger : primeList) {
            PrimeTest.assertTrue((String)"p.isPrime: ", (boolean)PrimeInteger.isPrime(bigInteger.longValue()));
            if (n-- > 0) continue;
            break;
        }
    }

    public void testMediumPrime() {
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        int n = primeList.size() - 1;
        for (java.math.BigInteger bigInteger : primeList) {
            PrimeTest.assertTrue((String)"p.isPrime: ", (boolean)PrimeInteger.isPrime(bigInteger.longValue()));
            if (n-- > 0) continue;
            break;
        }
    }

    public void testLargePrime() {
        java.math.BigInteger bigInteger;
        long l;
        PrimeList primeList = new PrimeList(PrimeList.Range.large);
        int n = primeList.size() - 1;
        Iterator<java.math.BigInteger> iterator = primeList.iterator();
        while (iterator.hasNext() && (l = (bigInteger = iterator.next()).longValue()) < PrimeInteger.BETA) {
            PrimeTest.assertTrue((String)"p.isPrime: ", (boolean)PrimeInteger.isPrime(l));
            if (n-- > 0) continue;
            break;
        }
    }

    public void testMersennePrime() {
        java.math.BigInteger bigInteger;
        long l;
        PrimeList primeList = new PrimeList(PrimeList.Range.mersenne);
        int n = primeList.size() - 1;
        Iterator<java.math.BigInteger> iterator = primeList.iterator();
        while (iterator.hasNext() && (l = (bigInteger = iterator.next()).longValue()) < PrimeInteger.BETA) {
            PrimeTest.assertTrue((String)"p.isPrime: ", (boolean)PrimeInteger.isPrime(l));
            if (n-- > 0) continue;
            break;
        }
        PrimeTest.assertTrue((String)"all primes ", (boolean)primeList.checkPrimes(5));
    }

    public void testFactorInteger() {
        java.math.BigInteger bigInteger;
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(582460200L);
        PrimeTest.assertEquals((String)"factors: ", (int)sortedMap.size(), (int)6);
        for (Long l : sortedMap.keySet()) {
            bigInteger = java.math.BigInteger.valueOf(l);
            PrimeTest.assertTrue((String)("isPrime: " + l), (boolean)bigInteger.isProbablePrime(16));
        }
        sortedMap = PrimeInteger.factors(801289898L);
        PrimeTest.assertEquals((String)"factors: ", (int)sortedMap.size(), (int)3);
        for (Long l : sortedMap.keySet()) {
            bigInteger = java.math.BigInteger.valueOf(l);
            PrimeTest.assertTrue((String)("isPrime: " + l), (boolean)bigInteger.isProbablePrime(16));
        }
        sortedMap = PrimeInteger.factors(PrimeList.getLongPrime(15, 135).longValue());
        PrimeTest.assertEquals((String)"factors: ", (int)sortedMap.size(), (int)1);
        for (Long l : sortedMap.keySet()) {
            bigInteger = java.math.BigInteger.valueOf(l);
            PrimeTest.assertTrue((String)("isPrime: " + l), (boolean)bigInteger.isProbablePrime(16));
        }
        sortedMap = PrimeInteger.factors(PrimeList.getLongPrime(59, 0).longValue());
        PrimeTest.assertEquals((String)"factors: ", (int)sortedMap.size(), (int)1);
        for (Long l : sortedMap.keySet()) {
            bigInteger = java.math.BigInteger.valueOf(l);
            PrimeTest.assertTrue((String)("isPrime: " + l), (boolean)bigInteger.isProbablePrime(32));
        }
    }

    public void testFactorLargeInteger() {
        long l = 582460200L;
        java.math.BigInteger bigInteger = java.math.BigInteger.valueOf(l);
        SortedMap<java.math.BigInteger, Integer> sortedMap = PrimeInteger.factors(bigInteger);
        PrimeTest.assertEquals((String)"factors: ", (int)sortedMap.size(), (int)6);
        for (java.math.BigInteger bigInteger2 : sortedMap.keySet()) {
            PrimeTest.assertTrue((String)("isPrime: " + bigInteger2), (boolean)bigInteger2.isProbablePrime(16));
        }
        bigInteger = bigInteger.multiply(PrimeList.getLongPrime(59, 19));
        bigInteger = bigInteger.multiply(PrimeList.getLongPrime(61, 1));
        sortedMap = PrimeInteger.factors(bigInteger);
        for (java.math.BigInteger bigInteger2 : sortedMap.keySet()) {
            PrimeTest.assertTrue((String)("isPrime: " + bigInteger2), (boolean)bigInteger2.isProbablePrime(32));
        }
    }

    public void testRandom() {
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = 0; i < 5; ++i) {
            BigInteger bigInteger2 = bigInteger.random(60).abs();
            long l = Math.abs(bigInteger2.getVal().longValue());
            if (l >= PrimeInteger.BETA) continue;
            SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
            PrimeTest.assertTrue((String)("isFactorization: " + l + ", ff = " + sortedMap), (boolean)PrimeInteger.isPrimeFactorization(l, sortedMap));
        }
    }

    public void testRandom3() {
        BigInteger bigInteger = BigInteger.ONE;
        for (int i = 0; i < 5; ++i) {
            BigInteger bigInteger2 = bigInteger.random(20).abs();
            long l = Math.abs((bigInteger2 = (BigInteger)bigInteger2.power(3L)).getVal().longValue());
            if (l >= PrimeInteger.BETA) continue;
            SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
            PrimeTest.assertTrue((String)("isFactorization: " + l + ", ff = " + sortedMap), (boolean)PrimeInteger.isPrimeFactorization(l, sortedMap));
            for (Integer n : sortedMap.values()) {
                PrimeTest.assertTrue((String)("e >= 3: " + n + ", ff = " + sortedMap), (n >= 3 ? 1 : 0) != 0);
            }
        }
    }

    public void ytestRandomCompare() {
        SortedMap<Long, Integer> sortedMap;
        long l;
        SortedMap<Long, Integer> sortedMap2;
        long l2;
        long l3;
        BigInteger bigInteger;
        int n;
        BigInteger bigInteger2 = BigInteger.ONE;
        for (n = 0; n < 5; ++n) {
            bigInteger = bigInteger2.random(60).abs();
            l3 = Math.abs(bigInteger.getVal().longValue());
            if (l3 >= PrimeInteger.BETA) continue;
            l2 = System.currentTimeMillis();
            sortedMap2 = PrimeInteger.factors(l3);
            l2 = System.currentTimeMillis() - l2;
            System.out.println("ff = " + sortedMap2);
            PrimeTest.assertTrue((String)("isFactorization: " + l3 + ", ff = " + sortedMap2), (boolean)PrimeInteger.isFactorization(l3, sortedMap2));
            l = System.currentTimeMillis();
            sortedMap = PrimeInteger.factorsPollard(l3);
            l = System.currentTimeMillis() - l;
            System.out.println("time: t = " + l2 + ", s = " + l);
            PrimeTest.assertEquals((String)("isFactorization: " + l3), sortedMap2, sortedMap);
        }
        for (n = 0; n < 5; ++n) {
            bigInteger = bigInteger2.random(20).abs();
            l3 = Math.abs((bigInteger = (BigInteger)bigInteger.power(3L)).getVal().longValue());
            if (l3 >= PrimeInteger.BETA) continue;
            l2 = System.currentTimeMillis();
            sortedMap2 = PrimeInteger.factors(l3);
            l2 = System.currentTimeMillis() - l2;
            System.out.println("ff = " + sortedMap2);
            PrimeTest.assertTrue((String)("isFactorization: " + l3 + ", ff = " + sortedMap2), (boolean)PrimeInteger.isFactorization(l3, sortedMap2));
            l = System.currentTimeMillis();
            sortedMap = PrimeInteger.factorsPollard(l3);
            l = System.currentTimeMillis() - l;
            System.out.println("time: t = " + l2 + ", s = " + l);
            PrimeTest.assertEquals((String)("isFactorization: " + l3), sortedMap2, sortedMap);
        }
    }
}

