/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.WordPair;
import edu.jas.gb.WordPairList;
import edu.jas.gb.WordReduction;
import edu.jas.gb.WordReductionSeq;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.Word;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderedWordPairlist<C extends RingElem<C>>
implements WordPairList<C> {
    protected final List<GenWordPolynomial<C>> P;
    protected final SortedMap<Word, LinkedList<WordPair<C>>> pairlist;
    protected final List<BitSet> red;
    protected final GenWordPolynomialRing<C> ring;
    protected final WordReduction<C> reduction;
    protected boolean oneInGB = false;
    protected int putCount;
    protected int remCount;
    private static final Logger logger = LogManager.getLogger(OrderedWordPairlist.class);

    public OrderedWordPairlist() {
        this.ring = null;
        this.P = null;
        this.pairlist = null;
        this.red = null;
        this.reduction = null;
        this.putCount = 0;
        this.remCount = 0;
    }

    public OrderedWordPairlist(GenWordPolynomialRing<C> genWordPolynomialRing) {
        this.ring = genWordPolynomialRing;
        this.P = new ArrayList<GenWordPolynomial<C>>();
        this.pairlist = new TreeMap<Word, LinkedList<WordPair<C>>>(this.ring.alphabet.getAscendComparator());
        this.red = new ArrayList<BitSet>();
        this.putCount = 0;
        this.remCount = 0;
        this.reduction = new WordReductionSeq();
    }

    @Override
    public WordPairList<C> create(GenWordPolynomialRing<C> genWordPolynomialRing) {
        return new OrderedWordPairlist<C>(genWordPolynomialRing);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName() + "(");
        stringBuffer.append("#put=" + this.putCount);
        stringBuffer.append(", #rem=" + this.remCount);
        if (this.pairlist != null && this.pairlist.size() != 0) {
            stringBuffer.append(", size=" + this.pairlist.size());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public synchronized int put(GenWordPolynomial<C> genWordPolynomial) {
        ++this.putCount;
        if (this.oneInGB) {
            return this.P.size() - 1;
        }
        if (genWordPolynomial.isONE()) {
            return this.putOne();
        }
        Word word = genWordPolynomial.leadingWord();
        int n = this.P.size();
        BitSet bitSet = new BitSet();
        for (int i = 0; i < n; ++i) {
            LinkedList<WordPair<C>> linkedList;
            WordPair<C> wordPair;
            GenWordPolynomial<C> genWordPolynomial2 = this.P.get(i);
            Word word2 = genWordPolynomial2.leadingWord();
            Word word3 = word2.lcm(word);
            if (word3 != null) {
                wordPair = new WordPair<C>(genWordPolynomial2, genWordPolynomial, i, n);
                linkedList = (LinkedList<WordPair<C>>)this.pairlist.get(word3);
                if (linkedList == null) {
                    linkedList = new LinkedList<WordPair<C>>();
                }
                linkedList.addFirst(wordPair);
                this.pairlist.put(word3, linkedList);
                bitSet.set(i);
            }
            if ((word3 = word.lcm(word2)) == null) continue;
            wordPair = new WordPair<C>(genWordPolynomial, genWordPolynomial2, n, i);
            linkedList = (LinkedList<WordPair<C>>)this.pairlist.get(word3);
            if (linkedList == null) {
                linkedList = new LinkedList<WordPair<C>>();
            }
            linkedList.addFirst(wordPair);
            this.pairlist.put(word3, linkedList);
            this.red.get(i).set(n);
        }
        this.red.add(bitSet);
        this.P.add(genWordPolynomial);
        return n;
    }

    @Override
    public int put(List<GenWordPolynomial<C>> list) {
        int n = 0;
        for (GenWordPolynomial<C> genWordPolynomial : list) {
            n = this.put(genWordPolynomial);
        }
        return n;
    }

    @Override
    public synchronized WordPair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator<Map.Entry<Word, LinkedList<WordPair<C>>>> iterator = this.pairlist.entrySet().iterator();
        WordPair<C> wordPair = null;
        if (iterator.hasNext()) {
            Map.Entry<Word, LinkedList<WordPair<C>>> entry = iterator.next();
            Word word = entry.getKey();
            LinkedList<WordPair<C>> linkedList = entry.getValue();
            if (logger.isInfoEnabled()) {
                logger.info("g  = " + word);
            }
            wordPair = null;
            if (linkedList.size() > 0) {
                wordPair = linkedList.removeFirst();
                int n = wordPair.i;
                int n2 = wordPair.j;
                this.red.get(n2).clear(n);
            }
            if (linkedList.size() == 0) {
                iterator.remove();
            }
        }
        ++this.remCount;
        return wordPair;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.pairlist.size() > 0;
    }

    @Override
    public List<GenWordPolynomial<C>> getList() {
        return this.P;
    }

    @Override
    public synchronized int putCount() {
        return this.putCount;
    }

    @Override
    public synchronized int remCount() {
        return this.remCount;
    }

    public synchronized int putOne(GenWordPolynomial<C> genWordPolynomial) {
        if (genWordPolynomial == null) {
            return this.P.size() - 1;
        }
        if (!genWordPolynomial.isONE()) {
            return this.P.size() - 1;
        }
        return this.putOne();
    }

    @Override
    public synchronized int putOne() {
        ++this.putCount;
        this.oneInGB = true;
        this.pairlist.clear();
        this.P.clear();
        this.P.add((GenWordPolynomial<C>)this.ring.getONE());
        this.red.clear();
        return this.P.size() - 1;
    }

    public boolean criterion3(int n, int n2, Word word) {
        boolean bl = this.red.get(n2).get(n);
        for (int i = 0; i < this.P.size(); ++i) {
            GenWordPolynomial<C> genWordPolynomial;
            Word word2;
            boolean bl2;
            if (n == i || n2 == i || !(bl2 = word.multipleOf(word2 = (genWordPolynomial = this.P.get(i)).leadingWord()))) continue;
            if (n < n2) {
                if (i < n) {
                    bl = this.red.get(n).get(i) || this.red.get(n2).get(i);
                } else if (n < i && i < n2) {
                    bl = this.red.get(i).get(n) || this.red.get(n2).get(i);
                } else if (n2 < i) {
                    bl = this.red.get(i).get(n) || this.red.get(i).get(n2);
                }
            } else if (i < n2) {
                bl = this.red.get(i).get(n2) || this.red.get(i).get(n);
            } else if (n2 < i && i < n) {
                bl = this.red.get(n2).get(i) || this.red.get(i).get(n);
            } else if (n < i) {
                boolean bl3 = bl = this.red.get(n2).get(i) || this.red.get(n).get(i);
            }
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

