/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBasePseudoSeq<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBasePseudoSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> red;
    protected final RingFactory<C> cofac;

    public GroebnerBasePseudoSeq(RingFactory<C> ringFactory) {
        this(new PseudoReductionSeq(), ringFactory, new OrderedPairlist());
    }

    public GroebnerBasePseudoSeq(RingFactory<C> ringFactory, PairList<C> pairList) {
        this(new PseudoReductionSeq(), ringFactory, pairList);
    }

    public GroebnerBasePseudoSeq(PseudoReduction<C> pseudoReduction, RingFactory<C> ringFactory, PairList<C> pairList) {
        super(pseudoReduction, pairList);
        this.red = pseudoReduction;
        this.cofac = ringFactory;
        this.engine = GCDFactory.getImplementation(ringFactory);
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = this.engine.basePrimitivePart(list2)).size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList<C> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        while (pairList.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
            GenPolynomial genPolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial2 = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            if (debug) {
                logger.debug("pi    = " + genPolynomial2);
                logger.debug("pj    = " + genPolynomial3);
            }
            if ((genPolynomial = this.red.SPolynomial(genPolynomial2, genPolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(S) = " + genPolynomial.leadingExpVector());
            }
            if (((GenPolynomial)(abelianGroupElem = this.red.normalform(list2, genPolynomial))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.debug("ht(H) = " + ((GenPolynomial)abelianGroupElem).leadingExpVector());
            }
            abelianGroupElem = this.engine.basePrimitivePart((GenPolynomial<C>)abelianGroupElem);
            if (((GenPolynomial)(abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs())).isConstant()) {
                list2.clear();
                list2.add((GenPolynomial<C>)abelianGroupElem);
                return list2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("H = " + abelianGroupElem);
            }
            if (((GenPolynomial)abelianGroupElem).length() <= 0) continue;
            list2.add((GenPolynomial<C>)abelianGroupElem);
            pairList.put((GenPolynomial<C>)abelianGroupElem);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.minimalGB(list2);
        logger.info("" + pairList);
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
        List<GenPolynomial<C>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list2.size());
        while (list2.size() > 0) {
            abelianGroupElem = list2.remove(0);
            if (this.red.isTopReducible(list2, (GenPolynomial<C>)abelianGroupElem) || this.red.isTopReducible((List<GenPolynomial<C>>)arrayList, (GenPolynomial<C>)abelianGroupElem)) {
                if (!debug) continue;
                System.out.println("dropped " + abelianGroupElem);
                ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list2);
                arrayList2.addAll(arrayList);
                if ((abelianGroupElem = this.red.normalform((List<GenPolynomial<C>>)arrayList2, (GenPolynomial<C>)abelianGroupElem)).isZERO()) continue;
                System.out.println("error, nf(a) " + abelianGroupElem);
                continue;
            }
            arrayList.add((GenPolynomial<C>)abelianGroupElem);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            abelianGroupElem = list2.remove(0);
            abelianGroupElem = this.red.normalform(list2, (GenPolynomial<C>)abelianGroupElem);
            abelianGroupElem = this.engine.basePrimitivePart((GenPolynomial<C>)abelianGroupElem);
            abelianGroupElem = abelianGroupElem.abs();
            list2.add((GenPolynomial<C>)abelianGroupElem);
        }
        Collections.reverse(list2);
        return list2;
    }
}

