/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.RecSolvableWordPolynomial;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecSolvableWordPolynomialRing<C extends RingElem<C>>
extends GenSolvablePolynomialRing<GenWordPolynomial<C>> {
    public final RelationTable<GenWordPolynomial<C>> coeffTable = new RelationTable(this, true);
    public final RecSolvableWordPolynomial<C> ZERO = new RecSolvableWordPolynomial(this);
    public final RecSolvableWordPolynomial<C> ONE;
    private static final Logger logger = LogManager.getLogger(RecSolvableWordPolynomialRing.class);
    private static final boolean debug = logger.isDebugEnabled();

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), (String[])null, (RelationTable<GenWordPolynomial<C>>)null);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, int n, RelationTable<GenWordPolynomial<C>> relationTable) {
        this(ringFactory, n, new TermOrder(), (String[])null, relationTable);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, (String[])null, (RelationTable<GenWordPolynomial<C>>)null);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, int n, TermOrder termOrder, RelationTable<GenWordPolynomial<C>> relationTable) {
        this(ringFactory, n, termOrder, (String[])null, relationTable);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, (RelationTable<GenWordPolynomial<C>>)null);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, (RelationTable<GenWordPolynomial<C>>)null);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, (RelationTable<GenWordPolynomial<C>>)null);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<GenWordPolynomial<C>> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        GenWordPolynomial genWordPolynomial = (GenWordPolynomial)this.coFac.getONE();
        this.ONE = new RecSolvableWordPolynomial(this, genWordPolynomial, this.evzero);
    }

    public RecSolvableWordPolynomialRing(RingFactory<GenWordPolynomial<C>> ringFactory, RecSolvableWordPolynomialRing recSolvableWordPolynomialRing) {
        this(ringFactory, recSolvableWordPolynomialRing.nvar, recSolvableWordPolynomialRing.tord, recSolvableWordPolynomialRing.getVars(), (RelationTable<GenWordPolynomial<C>>)null);
    }

    @Override
    public String toString() {
        Object object = super.toString();
        object = PrettyPrint.isTrue() ? (String)object + "\n" + this.coeffTable.toString(this.vars) : (String)object + ", #rel = " + this.table.size() + " + " + this.coeffTable.size();
        return object;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toScript();
        stringBuffer.append(string2);
        if (this.table.size() > 0) {
            string = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string);
        }
        if (this.coeffTable.size() > 0) {
            string = this.coeffTable.toScript();
            stringBuffer.append(",coeffrel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RecSolvableWordPolynomialRing)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RecSolvableWordPolynomialRing recSolvableWordPolynomialRing = (RecSolvableWordPolynomialRing)object;
        return this.coeffTable.equals(recSolvableWordPolynomialRing.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.coeffTable.hashCode();
        return n;
    }

    @Override
    public RecSolvableWordPolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public RecSolvableWordPolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.coeffTable.isEmpty()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            RecSolvableWordPolynomial recSolvableWordPolynomial = (RecSolvableWordPolynomial)list.get(i);
            if (recSolvableWordPolynomial.isONE()) continue;
            for (int j = i + 1; j < n; ++j) {
                RecSolvableWordPolynomial recSolvableWordPolynomial2 = (RecSolvableWordPolynomial)list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    RecSolvableWordPolynomial recSolvableWordPolynomial3 = (RecSolvableWordPolynomial)list.get(k);
                    try {
                        RecSolvableWordPolynomial recSolvableWordPolynomial4 = recSolvableWordPolynomial3.multiply(recSolvableWordPolynomial2).multiply(recSolvableWordPolynomial);
                        RecSolvableWordPolynomial recSolvableWordPolynomial5 = recSolvableWordPolynomial3.multiply(recSolvableWordPolynomial2.multiply(recSolvableWordPolynomial));
                        if (recSolvableWordPolynomial4.equals(recSolvableWordPolynomial5)) continue;
                        if (logger.isInfoEnabled()) {
                            logger.info("Xk = " + recSolvableWordPolynomial3 + ", Xj = " + recSolvableWordPolynomial2 + ", Xi = " + recSolvableWordPolynomial);
                            logger.info("p = ( Xk * Xj ) * Xi = " + recSolvableWordPolynomial4);
                            logger.info("q = Xk * ( Xj * Xi ) = " + recSolvableWordPolynomial5);
                        }
                        return false;
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        System.out.println("Xk = " + recSolvableWordPolynomial3 + ", Xj = " + recSolvableWordPolynomial2 + ", Xi = " + recSolvableWordPolynomial);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public RecSolvableWordPolynomial<C> valueOf(GenWordPolynomial<C> genWordPolynomial) {
        return new RecSolvableWordPolynomial<C>(this, genWordPolynomial);
    }

    @Override
    public RecSolvableWordPolynomial<C> valueOf(ExpVector expVector) {
        return this.valueOf((GenWordPolynomial)this.coFac.getONE(), expVector);
    }

    @Override
    public RecSolvableWordPolynomial<C> valueOf(GenWordPolynomial<C> genWordPolynomial, ExpVector expVector) {
        return new RecSolvableWordPolynomial<C>(this, genWordPolynomial, expVector);
    }

    @Override
    public RecSolvableWordPolynomial<C> fromInteger(long l) {
        return new RecSolvableWordPolynomial(this, (GenWordPolynomial)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public RecSolvableWordPolynomial<C> fromInteger(BigInteger bigInteger) {
        return new RecSolvableWordPolynomial(this, (GenWordPolynomial)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public RecSolvableWordPolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public RecSolvableWordPolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public RecSolvableWordPolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public RecSolvableWordPolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            GenWordPolynomial genWordPolynomial = (GenWordPolynomial)this.coFac.random(n, random);
            genSolvablePolynomial = (RecSolvableWordPolynomial)genSolvablePolynomial.sum(genWordPolynomial, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public RecSolvableWordPolynomial<C> copy(RecSolvableWordPolynomial<C> recSolvableWordPolynomial) {
        return new RecSolvableWordPolynomial(this, recSolvableWordPolynomial.val);
    }

    @Override
    public RecSolvableWordPolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public RecSolvableWordPolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        RecSolvableWordPolynomial recSolvableWordPolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            recSolvableWordPolynomial = new RecSolvableWordPolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error(iOException.toString() + " parse " + this);
            recSolvableWordPolynomial = this.ZERO;
        }
        return recSolvableWordPolynomial;
    }

    @Override
    public RecSolvableWordPolynomial<C> univariate(int n) {
        return (RecSolvableWordPolynomial)super.univariate(n);
    }

    @Override
    public RecSolvableWordPolynomial<C> univariate(int n, long l) {
        return (RecSolvableWordPolynomial)super.univariate(n, l);
    }

    @Override
    public RecSolvableWordPolynomial<C> univariate(int n, int n2, long l) {
        return (RecSolvableWordPolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<RecSolvableWordPolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<RecSolvableWordPolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<RecSolvableWordPolynomial<C>> univariateList(int n, long l) {
        ArrayList<RecSolvableWordPolynomial<C>> arrayList = new ArrayList<RecSolvableWordPolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((RecSolvableWordPolynomial<C>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public RecSolvableWordPolynomialRing<C> extend(int n) {
        GenPolynomialRing genPolynomialRing = super.extend(n);
        RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing = new RecSolvableWordPolynomialRing<C>(((GenSolvablePolynomialRing)genPolynomialRing).coFac, ((GenSolvablePolynomialRing)genPolynomialRing).nvar, ((GenSolvablePolynomialRing)genPolynomialRing).tord, ((GenSolvablePolynomialRing)genPolynomialRing).vars, ((GenSolvablePolynomialRing)genPolynomialRing).table);
        recSolvableWordPolynomialRing.coeffTable.extend(this.coeffTable);
        return recSolvableWordPolynomialRing;
    }

    @Override
    public RecSolvableWordPolynomialRing<C> extend(String[] stringArray) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray);
        RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing = new RecSolvableWordPolynomialRing<C>(((GenSolvablePolynomialRing)genPolynomialRing).coFac, ((GenSolvablePolynomialRing)genPolynomialRing).nvar, ((GenSolvablePolynomialRing)genPolynomialRing).tord, ((GenSolvablePolynomialRing)genPolynomialRing).vars, ((GenSolvablePolynomialRing)genPolynomialRing).table);
        recSolvableWordPolynomialRing.coeffTable.extend(this.coeffTable);
        return recSolvableWordPolynomialRing;
    }

    @Override
    public RecSolvableWordPolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing = new RecSolvableWordPolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        recSolvableWordPolynomialRing.table.contract(this.table);
        recSolvableWordPolynomialRing.coeffTable.contract(this.coeffTable);
        return recSolvableWordPolynomialRing;
    }

    @Override
    public RecSolvableWordPolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public RecSolvableWordPolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        RecSolvableWordPolynomialRing<C> recSolvableWordPolynomialRing = new RecSolvableWordPolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        recSolvableWordPolynomialRing.partial = bl;
        recSolvableWordPolynomialRing.table.reverse(this.table);
        recSolvableWordPolynomialRing.coeffTable.reverse(this.coeffTable);
        return recSolvableWordPolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<GenWordPolynomial<C>> permutation(List<Integer> list) {
        if (!this.coeffTable.isEmpty()) {
            throw new UnsupportedOperationException("permutation with coeff relations: " + this);
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)super.permutation(list);
        return genSolvablePolynomialRing;
    }
}

