/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.structure;

import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AbelianGroupFactory;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.MonoidFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.math.BigInteger;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Power<C extends RingElem<C>> {
    private static final Logger logger = LogManager.getLogger(Power.class);
    private static final boolean debug = logger.isDebugEnabled();
    private final RingFactory<C> fac;

    public Power() {
        this(null);
    }

    public Power(RingFactory<C> ringFactory) {
        this.fac = ringFactory;
    }

    public static <C extends RingElem<C>> C positivePower(C c, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("only positive n allowed");
        }
        if (c.isZERO() || c.isONE()) {
            return c;
        }
        C c2 = c;
        long l2 = l - 1L;
        C c3 = c2;
        do {
            if (l2 % 2L == 1L) {
                c3 = c3.multiply(c2);
            }
            if ((l2 /= 2L) <= 0L) continue;
            c2 = c2.multiply(c2);
        } while (l2 > 0L);
        return c3;
    }

    public static <C extends RingElem<C>> C positivePower(C c, BigInteger bigInteger) {
        if (bigInteger.signum() <= 0) {
            throw new IllegalArgumentException("only positive n allowed");
        }
        if (c.isZERO() || c.isONE()) {
            return c;
        }
        C c2 = c;
        if (bigInteger.compareTo(BigInteger.ONE) == 0) {
            return c2;
        }
        if (bigInteger.bitLength() <= 63) {
            long l = bigInteger.longValue();
            return Power.positivePower(c, l);
        }
        C c3 = c;
        BigInteger bigInteger2 = bigInteger.subtract(BigInteger.ONE);
        do {
            if (bigInteger2.testBit(0)) {
                c3 = c3.multiply(c2);
            }
            if ((bigInteger2 = bigInteger2.shiftRight(1)).signum() <= 0) continue;
            c2 = c2.multiply(c2);
        } while (bigInteger2.signum() > 0);
        return c3;
    }

    public static <C extends RingElem<C>> C modPositivePower(C c, long l, C c2) {
        if (l <= 0L) {
            throw new IllegalArgumentException("only positive n allowed");
        }
        if (c.isZERO() || c.isONE()) {
            return c;
        }
        C c3 = c.remainder(c2);
        long l2 = l - 1L;
        C c4 = c3;
        do {
            if (l2 % 2L == 1L) {
                c4 = c4.multiply(c3).remainder(c2);
            }
            if ((l2 /= 2L) <= 0L) continue;
            c3 = c3.multiply(c3).remainder(c2);
        } while (l2 > 0L);
        return c4;
    }

    public static <C extends RingElem<C>> C power(RingFactory<C> ringFactory, C c, long l) {
        if (c == null || c.isZERO()) {
            return c;
        }
        return (C)((RingElem)Power.power(ringFactory, c, l));
    }

    public static <C extends MonoidElem<C>> C power(MonoidFactory<C> monoidFactory, C c, long l) {
        if (l == 0L) {
            if (monoidFactory == null) {
                throw new IllegalArgumentException("fac may not be null for a^0");
            }
            return monoidFactory.getONE();
        }
        if (c.isONE()) {
            return c;
        }
        C c2 = c;
        if (l < 0L) {
            c2 = c.inverse();
            l = -l;
        }
        if (l == 1L) {
            return c2;
        }
        if (monoidFactory == null) {
            throw new IllegalArgumentException("fac may not be null for n > 1");
        }
        C c3 = monoidFactory.getONE();
        long l2 = l;
        do {
            if (l2 % 2L == 1L) {
                c3 = c3.multiply(c2);
            }
            if ((l2 /= 2L) <= 0L) continue;
            c2 = c2.multiply(c2);
        } while (l2 > 0L);
        if (l > 11L && debug) {
            logger.info("n  = " + l + ", p  = " + c3);
        }
        return c3;
    }

    public static <C extends MonoidElem<C>> C modPower(MonoidFactory<C> monoidFactory, C c, long l, C c2) {
        if (l == 0L) {
            if (monoidFactory == null) {
                throw new IllegalArgumentException("fac may not be null for a^0");
            }
            return monoidFactory.getONE();
        }
        if (c.isONE()) {
            return c;
        }
        C c3 = c.remainder(c2);
        if (l < 0L) {
            c3 = c.inverse().remainder(c2);
            l = -l;
        }
        if (l == 1L) {
            return c3;
        }
        if (monoidFactory == null) {
            throw new IllegalArgumentException("fac may not be null for n > 1");
        }
        C c4 = monoidFactory.getONE();
        long l2 = l;
        do {
            if (l2 % 2L == 1L) {
                c4 = c4.multiply(c3).remainder(c2);
            }
            if ((l2 /= 2L) <= 0L) continue;
            c3 = c3.multiply(c3).remainder(c2);
        } while (l2 > 0L);
        if (l > 11L && debug) {
            logger.info("n  = " + l + ", p  = " + c4);
        }
        return c4;
    }

    public static <C extends MonoidElem<C>> C modPower(MonoidFactory<C> monoidFactory, C c, BigInteger bigInteger, C c2) {
        if (bigInteger.signum() == 0) {
            if (monoidFactory == null) {
                throw new IllegalArgumentException("fac may not be null for a^0");
            }
            return monoidFactory.getONE();
        }
        if (c.isONE()) {
            return c;
        }
        C c3 = c.remainder(c2);
        if (bigInteger.signum() < 0) {
            c3 = c.inverse().remainder(c2);
            bigInteger = bigInteger.negate();
        }
        if (bigInteger.compareTo(BigInteger.ONE) == 0) {
            return c3;
        }
        if (bigInteger.bitLength() <= 63) {
            long l = bigInteger.longValue();
            return Power.modPower(monoidFactory, c, l, c2);
        }
        if (monoidFactory == null) {
            throw new IllegalArgumentException("fac may not be null for n > 1");
        }
        C c4 = monoidFactory.getONE();
        BigInteger bigInteger2 = bigInteger;
        do {
            if (bigInteger2.testBit(0)) {
                c4 = c4.multiply(c3).remainder(c2);
            }
            if ((bigInteger2 = bigInteger2.shiftRight(1)).signum() <= 0) continue;
            c3 = c3.multiply(c3).remainder(c2);
        } while (bigInteger2.signum() > 0);
        if (debug) {
            logger.info("n  = " + bigInteger + ", p  = " + c4);
        }
        return c4;
    }

    public C power(C c, long l) {
        return Power.power(this.fac, c, l);
    }

    public static long power(long l, long l2) {
        if (l2 == 0L) {
            return 1L;
        }
        if (l == 1L) {
            return l;
        }
        long l3 = l;
        if (l2 == 1L) {
            return l3;
        }
        long l4 = 1L;
        long l5 = l2;
        do {
            if (l5 % 2L == 1L) {
                l4 *= l3;
            }
            if ((l5 /= 2L) <= 0L) continue;
            l3 *= l3;
        } while (l5 > 0L);
        if (l2 > 11L && debug) {
            logger.info("n  = " + l2 + ", p  = " + l4);
        }
        return l4;
    }

    public C modPower(C c, long l, C c2) {
        return (C)((RingElem)Power.modPower(this.fac, c, l, c2));
    }

    public C modPower(C c, BigInteger bigInteger, C c2) {
        return (C)((RingElem)Power.modPower(this.fac, c, bigInteger, c2));
    }

    public static <C extends RingElem<C>> long logarithm(C c, C c2) {
        long l = 1L;
        C c3 = c;
        while (c3.compareTo(c2) < 0) {
            c3 = c3.multiply(c);
            ++l;
        }
        return l;
    }

    public static <C extends RingElem<C>> C multiply(RingFactory<C> ringFactory, List<C> list) {
        return (C)((RingElem)Power.multiply(ringFactory, list));
    }

    public static <C extends MonoidElem<C>> C multiply(MonoidFactory<C> monoidFactory, List<C> list) {
        if (monoidFactory == null) {
            throw new IllegalArgumentException("fac may not be null for empty list");
        }
        MonoidElem monoidElem = monoidFactory.getONE();
        if (list == null || list.isEmpty()) {
            return (C)monoidElem;
        }
        for (MonoidElem monoidElem2 : list) {
            monoidElem = monoidElem.multiply((MonoidElem)monoidElem2);
        }
        return (C)monoidElem;
    }

    public static <C extends RingElem<C>> C sum(RingFactory<C> ringFactory, List<C> list) {
        return (C)((RingElem)Power.sum(ringFactory, list));
    }

    public static <C extends AbelianGroupElem<C>> C sum(AbelianGroupFactory<C> abelianGroupFactory, List<C> list) {
        if (abelianGroupFactory == null) {
            throw new IllegalArgumentException("fac may not be null for empty list");
        }
        AbelianGroupElem abelianGroupElem = abelianGroupFactory.getZERO();
        if (list == null || list.isEmpty()) {
            return (C)abelianGroupElem;
        }
        for (AbelianGroupElem abelianGroupElem2 : list) {
            abelianGroupElem = abelianGroupElem.sum((AbelianGroupElem)abelianGroupElem2);
        }
        return (C)abelianGroupElem;
    }
}

