/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.RemoteExecutable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Executor
extends Thread {
    private static final Logger logger = LogManager.getLogger(Executor.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final SocketChannel channel;

    Executor(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RemoteExecutable remoteExecutable = null;
        boolean bl = true;
        logger.debug("executor started " + this);
        while (bl) {
            try {
                Object object = this.channel.receive();
                logger.info("receive: " + object + " from " + this.channel);
                if (this.isInterrupted()) {
                    bl = false;
                    continue;
                }
                if (debug) {
                    logger.debug("receive: " + object + " from " + this.channel);
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if ("Stop".equals(string)) {
                        bl = false;
                        this.channel.send("Done");
                    } else {
                        logger.warn("invalid/unknown String: " + string + " from " + this.channel);
                        bl = false;
                        this.channel.send("Done");
                    }
                }
                if (!(object instanceof RemoteExecutable)) continue;
                remoteExecutable = (RemoteExecutable)object;
                if (debug) {
                    logger.info("running " + remoteExecutable);
                }
                try {
                    remoteExecutable.run();
                }
                catch (Exception exception) {
                    logger.info("Exception on re.run()" + exception);
                    if (logger.isInfoEnabled()) {
                        exception.printStackTrace();
                    }
                }
                finally {
                    logger.info("finally re.run() " + remoteExecutable);
                }
                if (debug) {
                    logger.info("finished " + remoteExecutable);
                }
                if (this.isInterrupted()) {
                    bl = false;
                    continue;
                }
                this.channel.send("Done");
                logger.info("finished send Done");
            }
            catch (IOException iOException) {
                bl = false;
                logger.info("IOException " + iOException);
                if (!debug) continue;
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
                logger.info("ClassNotFoundException " + classNotFoundException);
                classNotFoundException.printStackTrace();
            }
            finally {
                logger.info("finally " + this);
            }
        }
        this.channel.close();
        logger.info("terminated " + this);
    }
}

