/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.ResidueRing;
import edu.jas.arith.PrimeInteger;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.Rectangle;
import edu.jas.root.RootUtil;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.QuotientRing;
import edu.jas.vector.GenMatrixRing;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.List;

public class ExtensionFieldBuilder
implements Serializable {
    public final RingFactory factory;

    protected ExtensionFieldBuilder() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public ExtensionFieldBuilder(RingFactory ringFactory) {
        this.factory = ringFactory;
    }

    public RingFactory build() {
        return this.factory;
    }

    public static ExtensionFieldBuilder baseField(RingFactory ringFactory) {
        return new ExtensionFieldBuilder(ringFactory);
    }

    public ExtensionFieldBuilder transcendentExtension(String string) {
        QuotientRing quotientRing;
        String[] stringArray = GenPolynomialTokenizer.variableList(string);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(this.factory, stringArray);
        QuotientRing quotientRing2 = quotientRing = new QuotientRing(genPolynomialRing);
        return new ExtensionFieldBuilder(quotientRing2);
    }

    public ExtensionFieldBuilder polynomialExtension(String string) {
        GenPolynomialRing genPolynomialRing;
        String[] stringArray = GenPolynomialTokenizer.variableList(string);
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing = new GenPolynomialRing(this.factory, stringArray);
        return new ExtensionFieldBuilder(genPolynomialRing2);
    }

    public ExtensionFieldBuilder matrixExtension(int n) {
        GenMatrixRing genMatrixRing;
        GenMatrixRing genMatrixRing2 = genMatrixRing = new GenMatrixRing(this.factory, n, n);
        return new ExtensionFieldBuilder(genMatrixRing2);
    }

    public ExtensionFieldBuilder finiteFieldExtension(int n) {
        BigInteger bigInteger = this.factory.characteristic();
        if (bigInteger.signum() != 1) {
            throw new IllegalArgumentException("characteristic not finite");
        }
        if (!PrimeInteger.isPrime(bigInteger)) {
            throw new IllegalArgumentException("characteristic not prime");
        }
        AlgebraicNumberRing algebraicNumberRing = PolyUfdUtil.algebraicNumberField(this.factory, n);
        return new ExtensionFieldBuilder(algebraicNumberRing);
    }

    public ExtensionFieldBuilder algebraicExtension(String string, String string2) {
        ResidueRing residueRing;
        String[] stringArray = GenPolynomialTokenizer.variableList(string);
        if (stringArray.length < 1 && (stringArray = GenPolynomialTokenizer.expressionVariables(string2)).length < 1) {
            throw new IllegalArgumentException("no variables in '" + string + "' and '" + string2 + "'");
        }
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(this.factory, stringArray);
        if (stringArray.length == 1) {
            AlgebraicNumberRing algebraicNumberRing;
            Element element = genPolynomialRing.parse(string2);
            AlgebraicNumberRing algebraicNumberRing2 = algebraicNumberRing = new AlgebraicNumberRing(element);
            return new ExtensionFieldBuilder(algebraicNumberRing2);
        }
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(genPolynomialRing, new StringReader(string2));
        List list = null;
        try {
            list = genPolynomialTokenizer.nextPolynomialList();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        Ideal ideal = new Ideal(genPolynomialRing, list);
        if (ideal.isONE()) {
            throw new IllegalArgumentException("ideal is 1: " + string2);
        }
        if (ideal.isZERO()) {
            QuotientRing quotientRing;
            QuotientRing quotientRing2 = quotientRing = new QuotientRing(genPolynomialRing);
            return new ExtensionFieldBuilder(quotientRing2);
        }
        ResidueRing residueRing2 = residueRing = new ResidueRing(ideal);
        return new ExtensionFieldBuilder(residueRing2);
    }

    public ExtensionFieldBuilder realAlgebraicExtension(String string, String string2, String string3) {
        RealAlgebraicRing realAlgebraicRing;
        String[] stringArray = new String[]{string};
        RingElem ringElem = (RingElem)this.factory.getONE();
        if (!(ringElem instanceof Rational)) {
            throw new IllegalArgumentException("base field not instance of Rational");
        }
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(this.factory, termOrder, stringArray);
        Element element = genPolynomialRing.parse(string2);
        RingFactory ringFactory = genPolynomialRing.coFac;
        Interval interval = RootUtil.parseInterval(ringFactory, string3);
        RealAlgebraicRing realAlgebraicRing2 = realAlgebraicRing = new RealAlgebraicRing(element, interval);
        return new ExtensionFieldBuilder(realAlgebraicRing2);
    }

    public ExtensionFieldBuilder complexAlgebraicExtension(String string, String string2, String string3) {
        ComplexAlgebraicRing complexAlgebraicRing;
        String[] stringArray = new String[]{string};
        RingElem ringElem = (RingElem)this.factory.getONE();
        if (!(ringElem instanceof Complex)) {
            throw new IllegalArgumentException("base field not instance of Complex");
        }
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(this.factory, stringArray);
        Element element = genPolynomialRing.parse(string2);
        RingFactory ringFactory = genPolynomialRing.coFac;
        Rectangle rectangle = RootUtil.parseRectangle(ringFactory, string3);
        ComplexAlgebraicRing complexAlgebraicRing2 = complexAlgebraicRing = new ComplexAlgebraicRing(element, rectangle);
        return new ExtensionFieldBuilder(complexAlgebraicRing2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        stringBuffer.append(this.factory.toString());
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer(" ");
        stringBuffer.append(this.factory.toScript());
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }
}

