/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.WordGroebnerBaseAbstract;
import edu.jas.gb.WordGroebnerBaseSeq;
import edu.jas.gbufd.WordGroebnerBasePseudoRecSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.QuotientRing;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class WordGroebnerBasePseudoRecSeqTest
extends TestCase {
    GenWordPolynomialRing<GenPolynomial<BigInteger>> fac;
    List<GenWordPolynomial<GenPolynomial<BigInteger>>> L;
    List<GenWordPolynomial<GenPolynomial<BigInteger>>> G;
    WordGroebnerBaseAbstract<GenPolynomial<BigInteger>> bb;
    WordGroebnerBaseAbstract<GenPolynomial<BigRational>> bbr;
    GenWordPolynomial<GenPolynomial<BigInteger>> a;
    GenWordPolynomial<GenPolynomial<BigInteger>> b;
    GenWordPolynomial<GenPolynomial<BigInteger>> c;
    GenWordPolynomial<GenPolynomial<BigInteger>> d;
    GenWordPolynomial<GenPolynomial<BigInteger>> e;
    int rl = 2;
    int kl = 2;
    int ll = 3;
    int el = 2;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WordGroebnerBasePseudoRecSeqTest.suite());
        ComputerThreads.terminate();
    }

    public WordGroebnerBasePseudoRecSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordGroebnerBasePseudoRecSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(9L);
        String[] stringArray = new String[]{"x", "y"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, stringArray);
        String string = "a b";
        this.fac = new GenWordPolynomialRing<BigInteger>(genPolynomialRing, string);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new WordGroebnerBasePseudoRecSeq<BigInteger>(genPolynomialRing);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testRecSequentialGBase() {
        this.L = new ArrayList<GenWordPolynomial<GenPolynomial<BigInteger>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.fac.getZERO();
        this.e = this.c;
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        if (this.bb.commonZeroTest(this.L) < 0) {
            this.L.clear();
        }
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.d);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
    }

    public void testHawes2GBase() {
        String string = "IntFunc(a, c, b) (y2, y1, z1, z2, x) G(( x + 2 y1 z1 + { 3 a } y1^2 + 5 y1^4 + { 2 c } y1 ),( x + 2 y2 z2 + { 3 a } y2^2 + 5 y2^4 + { 2 c } y2 ),( 2 z2 + { 6 a } y2 + 20 y2^3 + { 2 c } ),( 3 z1^2 + y1^2 + { b } ),( 3 z2^2 + y2^2 + { b } ))";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        PolynomialList polynomialList = null;
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            WordGroebnerBasePseudoRecSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            WordGroebnerBasePseudoRecSeqTest.fail((String)("" + iOException));
        }
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)polynomialList.ring.coFac;
        GenPolynomialRing<BigInteger> genPolynomialRing2 = new GenPolynomialRing<BigInteger>(new BigInteger(), genPolynomialRing);
        GenPolynomialRing<BigInteger> genPolynomialRing3 = new GenPolynomialRing<BigInteger>(genPolynomialRing2, polynomialList.ring);
        List list = PolyUfdUtil.integerFromRationalCoefficients(genPolynomialRing3, polynomialList.list);
        this.fac = new GenWordPolynomialRing<BigInteger>(genPolynomialRing3);
        this.L = this.fac.valueOf(list);
        this.L.addAll(this.fac.commute());
        long l = System.currentTimeMillis();
        this.G = this.bb.GB(this.L);
        l = System.currentTimeMillis() - l;
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( G )", (boolean)this.bb.isGB(this.G));
        QuotientRing<BigInteger> quotientRing = new QuotientRing<BigInteger>(genPolynomialRing2);
        GenPolynomialRing<BigInteger> genPolynomialRing4 = new GenPolynomialRing<BigInteger>(quotientRing, genPolynomialRing3);
        List list2 = PolyUfdUtil.quotientFromIntegralCoefficients(genPolynomialRing4, list);
        list2 = PolyUtil.monic(list2);
        WordGroebnerBaseSeq wordGroebnerBaseSeq = new WordGroebnerBaseSeq();
        GenWordPolynomialRing<BigInteger> genWordPolynomialRing = new GenWordPolynomialRing<BigInteger>(genPolynomialRing4);
        List list3 = genWordPolynomialRing.valueOf(list2);
        list3.addAll(genWordPolynomialRing.commute());
        long l2 = System.currentTimeMillis();
        List list4 = ((WordGroebnerBaseAbstract)wordGroebnerBaseSeq).GB(list3);
        l2 = System.currentTimeMillis() - l2;
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"isGB( Gq )", (boolean)wordGroebnerBaseSeq.isGB(list4));
        WordGroebnerBasePseudoRecSeqTest.assertTrue((String)"nonsense", (l2 >= l ? 1 : 0) != 0);
    }
}

