/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.arith.BigRational;
import edu.jas.integrate.ElementaryIntegration;
import edu.jas.integrate.ElementaryIntegrationBernoulli;
import edu.jas.integrate.ElementaryIntegrationCzichowski;
import edu.jas.integrate.ElementaryIntegrationLazard;
import edu.jas.integrate.QuotIntegral;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;

public class ExamplesMore {
    public static void main(String[] stringArray) {
        ExamplesMore.exampleRothstein();
        ExamplesMore.exampleLazard();
        ExamplesMore.exampleCzichwoski();
        ExamplesMore.exampleBernoulli();
        ComputerThreads.terminate();
    }

    public static void exampleRothstein() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        ElementaryIntegration<BigRational> elementaryIntegration = new ElementaryIntegration<BigRational>(bigRational);
        Element element = genPolynomialRing.parse("x^4 - 3 x^2 + 6");
        Element element2 = genPolynomialRing.parse("x^6 - 5 x^4 + 5 x^2 + 4");
        Quotient<BigRational> quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        elementaryIntegration.irredLogPart = true;
        double d = System.currentTimeMillis();
        QuotIntegral<BigRational> quotIntegral = elementaryIntegration.integrate(quotient);
        double d2 = System.currentTimeMillis();
        System.out.println("Rothstein took " + (d2 - d) / 1000.0 + " seconds");
        System.out.println("Result: " + quotIntegral);
        boolean bl = elementaryIntegration.isIntegral(quotIntegral);
        System.out.println(bl);
    }

    public static void exampleLazard() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        ElementaryIntegrationLazard<BigRational> elementaryIntegrationLazard = new ElementaryIntegrationLazard<BigRational>(bigRational);
        Element element = genPolynomialRing.parse("x^4 - 3 x^2 + 6");
        Element element2 = genPolynomialRing.parse("x^6 - 5 x^4 + 5 x^2 + 4");
        Quotient<BigRational> quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        elementaryIntegrationLazard.irredLogPart = true;
        double d = System.currentTimeMillis();
        QuotIntegral<BigRational> quotIntegral = elementaryIntegrationLazard.integrate(quotient);
        double d2 = System.currentTimeMillis();
        System.out.println("Lazard took " + (d2 - d) / 1000.0 + " seconds");
        System.out.println("Result: " + quotIntegral);
        boolean bl = elementaryIntegrationLazard.isIntegral(quotIntegral);
        System.out.println(bl);
    }

    public static void exampleCzichwoski() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        ElementaryIntegrationCzichowski<BigRational> elementaryIntegrationCzichowski = new ElementaryIntegrationCzichowski<BigRational>(bigRational);
        Element element = genPolynomialRing.parse("x^5 - x^4 + 4 x^3 + x^2 - x + 5");
        Element element2 = genPolynomialRing.parse("x^4 - 2 x^3 + 5 x^2 - 4 x + 4");
        Quotient<BigRational> quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        elementaryIntegrationCzichowski.irredLogPart = true;
        double d = System.currentTimeMillis();
        QuotIntegral<BigRational> quotIntegral = elementaryIntegrationCzichowski.integrate(quotient);
        double d2 = System.currentTimeMillis();
        System.out.println("Czichowski took " + (d2 - d) / 1000.0 + " seconds");
        System.out.println("Result: " + quotIntegral);
        boolean bl = elementaryIntegrationCzichowski.isIntegral(quotIntegral);
        System.out.println(bl);
    }

    public static void exampleBernoulli() {
        BigRational bigRational = new BigRational(0L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, stringArray.length, new TermOrder(2), stringArray);
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        ElementaryIntegrationBernoulli<BigRational> elementaryIntegrationBernoulli = new ElementaryIntegrationBernoulli<BigRational>(bigRational);
        Element element = genPolynomialRing.parse("x^4 - 3 x^2 + 6");
        Element element2 = genPolynomialRing.parse("x^6 - 5 x^4 + 5 x^2 + 4");
        Quotient<BigRational> quotient = new Quotient<BigRational>(quotientRing, (GenPolynomial<BigRational>)element, (GenPolynomial<BigRational>)element2);
        double d = System.currentTimeMillis();
        QuotIntegral<BigRational> quotIntegral = elementaryIntegrationBernoulli.integrate(quotient);
        double d2 = System.currentTimeMillis();
        System.out.println("Bernoulli took " + (d2 - d) / 1000.0 + " seconds");
        System.out.println("Result: " + quotIntegral);
    }
}

