/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigOctonion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.InvalidExpressionException;
import edu.jas.poly.ModuleList;
import edu.jas.poly.OrderedModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.Word;
import edu.jas.poly.WordFactory;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenPolynomialTokenizer {
    private static final Logger logger = LogManager.getLogger(GenPolynomialTokenizer.class);
    private static final boolean debug = logger.isDebugEnabled();
    private String[] vars = null;
    private int nvars = 1;
    private TermOrder tord;
    private RelationTable table;
    private final StreamTokenizer tok;
    private final Reader reader;
    private RingFactory fac;
    private coeffType parsedCoeff = coeffType.BigRat;
    private GenPolynomialRing pfac;
    private polyType parsedPoly = polyType.PolBigRat;
    private GenSolvablePolynomialRing spfac;

    public GenPolynomialTokenizer() {
        this(new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF8"))));
    }

    public GenPolynomialTokenizer(GenPolynomialRing genPolynomialRing, Reader reader) {
        this(reader);
        if (genPolynomialRing == null) {
            return;
        }
        if (genPolynomialRing instanceof GenSolvablePolynomialRing) {
            this.pfac = genPolynomialRing;
            this.spfac = (GenSolvablePolynomialRing)genPolynomialRing;
        } else {
            this.pfac = genPolynomialRing;
            this.spfac = null;
        }
        this.fac = genPolynomialRing.coFac;
        this.vars = genPolynomialRing.vars;
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = genPolynomialRing.tord;
        this.table = this.spfac != null ? this.spfac.table : null;
    }

    public GenPolynomialTokenizer(Reader reader) {
        this.tord = new TermOrder();
        this.fac = new BigRational(1L);
        this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.reader = reader;
        this.tok = new StreamTokenizer(this.reader);
        this.tok.resetSyntax();
        this.tok.eolIsSignificant(false);
        this.tok.wordChars(48, 57);
        this.tok.wordChars(97, 122);
        this.tok.wordChars(65, 90);
        this.tok.wordChars(95, 95);
        this.tok.wordChars(47, 47);
        this.tok.wordChars(46, 46);
        this.tok.wordChars(126, 126);
        this.tok.wordChars(160, 255);
        this.tok.whitespaceChars(0, 32);
        this.tok.commentChar(35);
        this.tok.quoteChar(34);
        this.tok.quoteChar(39);
    }

    public void initFactory(RingFactory ringFactory, coeffType coeffType2) {
        this.fac = ringFactory;
        this.parsedCoeff = coeffType2;
        switch (coeffType2) {
            case BigRat: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigO: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigO;
                break;
            }
            case BigD: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case IntFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public void initSolvableFactory(RingFactory ringFactory, coeffType coeffType2) {
        this.fac = ringFactory;
        this.parsedCoeff = coeffType2;
        switch (coeffType2) {
            case BigRat: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigO: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigO;
                break;
            }
            case BigD: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case IntFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public GenPolynomial nextPolynomial() throws IOException {
        if (debug) {
            logger.debug("torder = " + this.tord);
        }
        GenPolynomial<MonoidElem> genPolynomial = this.pfac.getZERO();
        MonoidElem monoidElem = this.pfac.getONE();
        ExpVector expVector = this.pfac.evzero;
        if (debug) {
            logger.debug("a = " + genPolynomial);
            logger.debug("a1 = " + (GenPolynomial)monoidElem);
        }
        Element<RingElem> element = monoidElem;
        block22: while (true) {
            int n = this.tok.nextToken();
            logger.debug("while tt = " + this.tok);
            if (n == -1) break;
            switch (n) {
                case 41: 
                case 44: {
                    return genPolynomial;
                }
                case 45: {
                    element = ((GenPolynomial)element).negate();
                }
                case 42: 
                case 43: {
                    n = this.tok.nextToken();
                    break;
                }
            }
            if (n == -1) break;
            switch (n) {
                case 125: {
                    throw new InvalidExpressionException("mismatch of braces after " + genPolynomial + ", error at " + (GenPolynomial)element);
                }
                case 123: {
                    RingElem ringElem;
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    do {
                        if ((n = this.tok.nextToken()) == -1) {
                            throw new InvalidExpressionException("mismatch of braces after " + genPolynomial + ", error at " + (GenPolynomial)element);
                        }
                        if (n == 123) {
                            ++n2;
                        }
                        if (n == 125 && --n2 < 0) continue;
                        if (this.tok.sval != null) {
                            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '.') {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append(this.tok.sval);
                            continue;
                        }
                        stringBuffer.append((char)n);
                    } while (n2 >= 0);
                    try {
                        ringElem = (RingElem)this.fac.parse(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidExpressionException("not a number " + stringBuffer, numberFormatException);
                    }
                    if (debug) {
                        logger.debug("coeff " + ringElem);
                    }
                    long l = this.nextExponent();
                    if (debug) {
                        logger.debug("ie " + l);
                    }
                    ringElem = (RingElem)ringElem.power(l);
                    if (debug) {
                        logger.debug("coeff^ie " + ringElem);
                    }
                    element = ((GenPolynomial)element).multiply(ringElem, expVector);
                    n = this.tok.nextToken();
                    if (!debug) break;
                    logger.debug("tt,digit = " + this.tok);
                    break;
                }
                case -3: {
                    long l;
                    RingElem ringElem;
                    if (this.tok.sval == null || this.tok.sval.length() == 0) break;
                    char c = this.tok.sval.charAt(0);
                    if (GenPolynomialTokenizer.digit(c) || c == '/' || c == '.' || c == '~') {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.tok.sval);
                        if (this.tok.sval.length() > 1 && GenPolynomialTokenizer.digit(this.tok.sval.charAt(1))) {
                            if (c == '/') {
                                stringBuffer.insert(0, "1");
                            }
                            if (c == '.') {
                                stringBuffer.insert(0, "0");
                            }
                        }
                        if (this.tok.sval.charAt(this.tok.sval.length() - 1) == 'i') {
                            n = this.tok.nextToken();
                            if (debug) {
                                logger.debug("tt,im = " + this.tok);
                            }
                            if (this.tok.sval != null || n == 45) {
                                if (this.tok.sval != null) {
                                    stringBuffer.append(this.tok.sval);
                                } else {
                                    stringBuffer.append("-");
                                }
                                if (n == 45) {
                                    n = this.tok.nextToken();
                                    if (this.tok.sval != null && GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                                        stringBuffer.append(this.tok.sval);
                                    } else {
                                        this.tok.pushBack();
                                    }
                                }
                            } else {
                                this.tok.pushBack();
                            }
                        }
                        if ((n = this.tok.nextToken()) == 46) {
                            n = this.tok.nextToken();
                            if (debug) {
                                logger.debug("tt,dot = " + this.tok);
                            }
                            if (this.tok.sval != null) {
                                stringBuffer.append(".");
                                stringBuffer.append(this.tok.sval);
                            } else {
                                this.tok.pushBack();
                                this.tok.pushBack();
                            }
                        } else {
                            this.tok.pushBack();
                        }
                        try {
                            ringElem = (RingElem)this.fac.parse(stringBuffer.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidExpressionException("not a number " + stringBuffer, numberFormatException);
                        }
                        if (debug) {
                            logger.debug("coeff " + ringElem);
                        }
                        l = this.nextExponent();
                        if (debug) {
                            logger.debug("ie " + l);
                        }
                        ringElem = (RingElem)ringElem.power(l);
                        if (debug) {
                            logger.debug("coeff^ie " + ringElem);
                        }
                        element = ((GenPolynomial)element).multiply(ringElem, expVector);
                        n = this.tok.nextToken();
                        if (debug) {
                            logger.debug("tt,digit = " + this.tok);
                        }
                    }
                    if (n == -1 || this.tok.sval == null || !GenPolynomialTokenizer.letter(c = this.tok.sval.charAt(0))) break;
                    int n3 = expVector.indexVar(this.tok.sval, this.vars);
                    if (n3 < 0) {
                        try {
                            ringElem = (RingElem)this.fac.parse(this.tok.sval);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidExpressionException("recursively unknown variable " + this.tok.sval);
                        }
                        if (debug) {
                            logger.info("coeff " + ringElem);
                        }
                        l = this.nextExponent();
                        ringElem = (RingElem)ringElem.power(l);
                        element = ((GenPolynomial)element).multiply(ringElem);
                    } else {
                        l = this.nextExponent();
                        ExpVector expVector2 = ExpVector.create(this.vars.length, n3, l);
                        element = ((GenPolynomial)element).multiply(expVector2);
                    }
                    n = this.tok.nextToken();
                    if (!debug) break;
                    logger.debug("tt,letter = " + this.tok);
                    break;
                }
                case 40: {
                    GenPolynomial genPolynomial2 = this.nextPolynomial();
                    if (debug) {
                        logger.debug("factor " + genPolynomial2);
                    }
                    long l = this.nextExponent();
                    if (debug) {
                        logger.debug("ie " + l);
                    }
                    genPolynomial2 = (GenPolynomial)genPolynomial2.power(l);
                    if (debug) {
                        logger.debug("factor^ie " + genPolynomial2);
                    }
                    element = ((GenPolynomial)element).multiply(genPolynomial2);
                    n = this.tok.nextToken();
                    if (!debug) break;
                    logger.debug("tt,digit = " + this.tok);
                    break;
                }
            }
            if (n == -1) break;
            this.tok.pushBack();
            switch (n) {
                case 41: 
                case 43: 
                case 44: 
                case 45: {
                    logger.debug("b, = " + (GenPolynomial)element);
                    genPolynomial = genPolynomial.sum((MonoidElem)element);
                    element = monoidElem;
                    continue block22;
                }
                case 42: {
                    logger.debug("b, = " + (GenPolynomial)element);
                    continue block22;
                }
                case 10: {
                    n = this.tok.nextToken();
                    if (!debug) continue block22;
                    logger.debug("tt,nl = " + n);
                    continue block22;
                }
            }
            if (!debug) continue;
            logger.debug("default: " + this.tok);
        }
        if (debug) {
            logger.debug("b = " + (GenPolynomial)element);
        }
        genPolynomial = genPolynomial.sum((MonoidElem)element);
        if (debug) {
            logger.debug("a = " + genPolynomial);
        }
        return genPolynomial;
    }

    public long nextExponent() throws IOException {
        char c;
        long l = 1L;
        int n = this.tok.nextToken();
        if (n == 94) {
            if (debug) {
                logger.debug("exponent ^");
            }
            n = this.tok.nextToken();
            if (this.tok.sval != null && GenPolynomialTokenizer.digit(c = this.tok.sval.charAt(0))) {
                l = Long.parseLong(this.tok.sval);
                return l;
            }
        }
        if (n == 42) {
            n = this.tok.nextToken();
            if (n == 42) {
                if (debug) {
                    logger.debug("exponent **");
                }
                n = this.tok.nextToken();
                if (this.tok.sval != null && GenPolynomialTokenizer.digit(c = this.tok.sval.charAt(0))) {
                    l = Long.parseLong(this.tok.sval);
                    return l;
                }
            }
            this.tok.pushBack();
        }
        this.tok.pushBack();
        return l;
    }

    public String nextComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (debug) {
            logger.debug("comment: " + this.tok);
        }
        int n = this.tok.nextToken();
        if (debug) {
            logger.debug("comment: " + this.tok);
        }
        if (n == 40) {
            n = this.tok.nextToken();
            if (debug) {
                logger.debug("comment: " + this.tok);
            }
            if (n == 42) {
                if (debug) {
                    logger.debug("comment: ");
                }
                while (true) {
                    if ((n = this.tok.nextToken()) == 42) {
                        n = this.tok.nextToken();
                        if (n == 41) {
                            return stringBuffer.toString();
                        }
                        this.tok.pushBack();
                    }
                    stringBuffer.append(this.tok.sval);
                }
            }
            this.tok.pushBack();
            if (debug) {
                logger.debug("comment: " + this.tok);
            }
        }
        this.tok.pushBack();
        if (debug) {
            logger.debug("comment: " + this.tok);
        }
        return stringBuffer.toString();
    }

    public String[] nextVariableList() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.tok.nextToken();
        if (n == 40 || n == 123) {
            logger.debug("variable list");
            n = this.tok.nextToken();
            while (n != -1 && n != 41 && n != 125) {
                if (n == -3) {
                    arrayList.add(this.tok.sval);
                }
                n = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] objectArray = arrayList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public RingFactory nextCoefficientRing() throws IOException {
        RingFactory<BigRational> ringFactory = null;
        coeffType coeffType2 = null;
        int n = this.tok.nextToken();
        if (this.tok.sval != null) {
            if (this.tok.sval.equalsIgnoreCase("Q")) {
                ringFactory = new BigRational(0L);
                coeffType2 = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("Rat")) {
                ringFactory = new BigRational(0L);
                coeffType2 = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("D")) {
                ringFactory = new BigDecimal(0L);
                coeffType2 = coeffType.BigD;
            } else if (this.tok.sval.equalsIgnoreCase("Z")) {
                ringFactory = new BigInteger(0L);
                coeffType2 = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("Int")) {
                ringFactory = new BigInteger(0L);
                coeffType2 = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("C")) {
                ringFactory = new BigComplex(0L);
                coeffType2 = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Complex")) {
                ringFactory = new BigComplex(0L);
                coeffType2 = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Quat")) {
                logger.warn("parse of quaternion coefficients may fail for negative components (use ~ for -)");
                ringFactory = new BigQuaternionRing();
                coeffType2 = coeffType.BigQ;
            } else if (this.tok.sval.equalsIgnoreCase("Oct")) {
                logger.warn("parse of octonion coefficients may fail for negative components (use ~ for -)");
                ringFactory = new BigOctonion(new BigQuaternionRing());
                coeffType2 = coeffType.BigO;
            } else if (this.tok.sval.equalsIgnoreCase("Mod")) {
                n = this.tok.nextToken();
                boolean bl = false;
                if (n == 91) {
                    bl = true;
                    n = this.tok.nextToken();
                }
                if (this.tok.sval != null && this.tok.sval.length() > 0) {
                    if (GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                        BigInteger bigInteger = new BigInteger(this.tok.sval);
                        BigInteger bigInteger2 = new BigInteger(ModLongRing.MAX_LONG);
                        ringFactory = bigInteger.compareTo(bigInteger2) < 0 ? (bigInteger.compareTo(new BigInteger(ModIntRing.MAX_INT)) < 0 ? new ModIntRing(bigInteger.getVal()) : new ModLongRing(bigInteger.getVal())) : new ModIntegerRing(bigInteger.getVal());
                        coeffType2 = coeffType.ModInt;
                    } else {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
                if (n == 93 && bl) {
                    n = this.tok.nextToken();
                }
            } else {
                if (this.tok.sval.equalsIgnoreCase("RatFunc") || this.tok.sval.equalsIgnoreCase("ModFunc")) {
                    throw new InvalidExpressionException("RatFunc and ModFunc can no more be read, see edu.jas.application.RingFactoryTokenizer.");
                }
                if (this.tok.sval.equalsIgnoreCase("IntFunc")) {
                    String[] stringArray = this.nextVariableList();
                    int n2 = stringArray.length;
                    BigRational bigRational = new BigRational();
                    TermOrder termOrder = new TermOrder(2);
                    GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, n2, termOrder, stringArray);
                    ringFactory = genPolynomialRing;
                    coeffType2 = coeffType.IntFunc;
                } else if (this.tok.sval.equalsIgnoreCase("AN")) {
                    n = this.tok.nextToken();
                    if (n == 91) {
                        GenPolynomial genPolynomial;
                        n = this.tok.nextToken();
                        Iterable<ModInteger> iterable = new ModIntegerRing("19");
                        if (this.tok.sval != null && this.tok.sval.length() > 0) {
                            if (GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                                iterable = new ModIntegerRing(this.tok.sval);
                            } else {
                                iterable = new BigRational();
                                this.tok.pushBack();
                            }
                        } else {
                            iterable = new BigRational();
                            this.tok.pushBack();
                        }
                        Object[] objectArray = this.nextVariableList();
                        int n3 = objectArray.length;
                        if (n3 != 1) {
                            throw new InvalidExpressionException("AlgebraicNumber only for univariate polynomials " + Arrays.toString(objectArray));
                        }
                        String[] stringArray = this.vars;
                        this.vars = objectArray;
                        GenPolynomialRing genPolynomialRing = this.pfac;
                        RingFactory ringFactory2 = this.fac;
                        this.fac = iterable;
                        this.pfac = iterable instanceof ModIntegerRing ? new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)iterable), n3, new TermOrder(), (String[])objectArray) : new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)iterable), n3, new TermOrder(), (String[])objectArray);
                        if (debug) {
                            logger.debug("pfac = " + this.pfac);
                        }
                        if ((n = this.tok.nextToken()) == 40) {
                            genPolynomial = this.nextPolynomial();
                            n = this.tok.nextToken();
                            if (this.tok.ttype != 41) {
                                this.tok.pushBack();
                            }
                        } else {
                            this.tok.pushBack();
                            genPolynomial = this.nextPolynomial();
                        }
                        if (debug) {
                            logger.debug("mod = " + genPolynomial);
                        }
                        this.pfac = genPolynomialRing;
                        this.fac = ringFactory2;
                        this.vars = stringArray;
                        if (iterable instanceof ModIntegerRing) {
                            GenPolynomial genPolynomial2 = genPolynomial;
                            ringFactory = new AlgebraicNumberRing(genPolynomial2);
                            coeffType2 = coeffType.ANmod;
                        } else {
                            GenPolynomial genPolynomial3 = genPolynomial;
                            ringFactory = new AlgebraicNumberRing(genPolynomial3);
                            coeffType2 = coeffType.ANrat;
                        }
                        if (debug) {
                            logger.debug("coeff = " + ringFactory);
                        }
                        if ((n = this.tok.nextToken()) != 93) {
                            this.tok.pushBack();
                        }
                    } else {
                        this.tok.pushBack();
                    }
                }
            }
        }
        if (ringFactory == null) {
            this.tok.pushBack();
            ringFactory = new BigRational();
            coeffType2 = coeffType.BigRat;
        }
        this.parsedCoeff = coeffType2;
        return ringFactory;
    }

    public long[] nextWeightList() throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = this.tok.nextToken();
        if (n == 40) {
            logger.debug("weight list");
            n = this.tok.nextToken();
            while (n != -1 && n != 41) {
                char c;
                if (this.tok.sval != null && GenPolynomialTokenizer.digit(c = this.tok.sval.charAt(0))) {
                    long l = Long.parseLong(this.tok.sval);
                    arrayList.add(l);
                }
                n = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Long[] longArray = new Long[1];
        longArray = arrayList.toArray(longArray);
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = longArray[longArray.length - i - 1];
        }
        return lArray;
    }

    public long[][] nextWeightArray() throws IOException {
        ArrayList<long[]> arrayList = new ArrayList<long[]>();
        int n = this.tok.nextToken();
        if (n == 40) {
            logger.debug("weight array");
            n = this.tok.nextToken();
            while (n != -1 && n != 41) {
                char c;
                long[] lArray;
                if (n == 40) {
                    this.tok.pushBack();
                    lArray = this.nextWeightList();
                    arrayList.add(lArray);
                } else if (this.tok.sval != null && GenPolynomialTokenizer.digit(c = this.tok.sval.charAt(0))) {
                    this.tok.pushBack();
                    this.tok.pushBack();
                    lArray = this.nextWeightList();
                    arrayList.add(lArray);
                    break;
                }
                n = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] objectArray = arrayList.toArray();
        long[][] lArrayArray = new long[objectArray.length][];
        for (int i = 0; i < lArrayArray.length; ++i) {
            lArrayArray[i] = (long[])objectArray[i];
        }
        return lArrayArray;
    }

    public int nextSplitIndex() throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = this.tok.nextToken();
        if (n3 == 124) {
            if (debug) {
                logger.debug("split index");
            }
            if ((n3 = this.tok.nextToken()) == -1) {
                return n;
            }
            if (this.tok.sval != null) {
                char c = this.tok.sval.charAt(0);
                if (GenPolynomialTokenizer.digit(c)) {
                    n = Integer.parseInt(this.tok.sval);
                }
                if ((n3 = this.tok.nextToken()) != 124) {
                    this.tok.pushBack();
                }
            }
        } else if (n3 == 91) {
            if (debug) {
                logger.debug("split index");
            }
            if ((n3 = this.tok.nextToken()) == -1) {
                return n;
            }
            if (this.tok.sval != null) {
                char c = this.tok.sval.charAt(0);
                if (GenPolynomialTokenizer.digit(c)) {
                    n2 = Integer.parseInt(this.tok.sval);
                }
                if ((n3 = this.tok.nextToken()) == 44) {
                    n3 = this.tok.nextToken();
                    if (n3 == -1) {
                        return n2;
                    }
                    if (this.tok.sval != null && GenPolynomialTokenizer.digit(c = this.tok.sval.charAt(0))) {
                        n = Integer.parseInt(this.tok.sval);
                    }
                    if (n3 != 93) {
                        this.tok.pushBack();
                    }
                }
            }
        } else {
            this.tok.pushBack();
        }
        return n;
    }

    public TermOrder nextTermOrder() throws IOException {
        int n;
        int n2 = 4;
        int n3 = this.tok.nextToken();
        if (n3 != -1) {
            if (n3 == -3) {
                if (this.tok.sval != null) {
                    if (this.tok.sval.equalsIgnoreCase("L")) {
                        n2 = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("IL")) {
                        n2 = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("INVLEX")) {
                        n2 = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("LEX")) {
                        n2 = 1;
                    } else if (this.tok.sval.equalsIgnoreCase("G")) {
                        n2 = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IG")) {
                        n2 = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IGRLEX")) {
                        n2 = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("GRLEX")) {
                        n2 = 3;
                    } else if (this.tok.sval.equalsIgnoreCase("REVITDG")) {
                        n2 = 8;
                    } else if (this.tok.sval.equalsIgnoreCase("REVILEX")) {
                        n2 = 6;
                    } else if (this.tok.sval.equalsIgnoreCase("W")) {
                        long[][] lArray = this.nextWeightArray();
                        return new TermOrder(lArray);
                    }
                }
            } else {
                this.tok.pushBack();
            }
        }
        if ((n = this.nextSplitIndex()) <= 0) {
            return new TermOrder(n2);
        }
        return new TermOrder(n2, n2, this.nvars, n);
    }

    public List<GenPolynomial> nextPolynomialList() throws IOException {
        ArrayList<GenPolynomial> arrayList = new ArrayList<GenPolynomial>();
        int n = this.tok.nextToken();
        if (n == -1) {
            return arrayList;
        }
        if (n != 40) {
            return arrayList;
        }
        logger.debug("polynomial list");
        while (true) {
            GenPolynomial genPolynomial;
            n = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (n == 40) {
                genPolynomial = this.nextPolynomial();
                n = this.tok.nextToken();
                if (this.tok.ttype != 41) {
                    this.tok.pushBack();
                }
            } else {
                this.tok.pushBack();
                genPolynomial = this.nextPolynomial();
            }
            logger.info("next pol = " + genPolynomial);
            arrayList.add(genPolynomial);
            if (this.tok.ttype == -1 || this.tok.ttype == 41) break;
        }
        return arrayList;
    }

    public List<List<GenPolynomial>> nextSubModuleList() throws IOException {
        ArrayList<List<GenPolynomial>> arrayList = new ArrayList<List<GenPolynomial>>();
        int n = this.tok.nextToken();
        if (n == -1) {
            return arrayList;
        }
        if (n != 40) {
            return arrayList;
        }
        logger.debug("module list");
        List<GenPolynomial> list = null;
        while (true) {
            n = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (this.tok.ttype == 41 || this.tok.ttype == -1) break;
            if (n != 40) continue;
            this.tok.pushBack();
            list = this.nextPolynomialList();
            logger.info("next vect = " + list);
            arrayList.add(list);
        }
        return arrayList;
    }

    public void nextRelationTable() throws IOException {
        if (this.spfac == null) {
            return;
        }
        RelationTable relationTable = this.spfac.table;
        List<GenPolynomial> list = null;
        int n = this.tok.nextToken();
        if (debug) {
            logger.debug("start relation table: " + n);
        }
        if (this.tok.sval != null && this.tok.sval.equalsIgnoreCase("RelationTable")) {
            list = this.nextPolynomialList();
        }
        if (list == null) {
            this.tok.pushBack();
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GenPolynomial genPolynomial = (GenPolynomial)iterator.next();
            ExpVector expVector = genPolynomial.leadingExpVector();
            if (!iterator.hasNext()) continue;
            genPolynomial = (GenPolynomial)iterator.next();
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            if (!iterator.hasNext()) continue;
            genPolynomial = (GenPolynomial)iterator.next();
            GenSolvablePolynomial genSolvablePolynomial = new GenSolvablePolynomial(this.spfac, genPolynomial.val);
            relationTable.update(expVector, expVector2, genSolvablePolynomial);
        }
        if (debug) {
            logger.info("table = " + relationTable);
        }
    }

    public PolynomialList nextPolynomialSet() throws IOException {
        RingFactory ringFactory = this.nextCoefficientRing();
        logger.info("coeff = " + ringFactory.getClass().getSimpleName());
        this.vars = this.nextVariableList();
        logger.info("vars = " + Arrays.toString(this.vars));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info("tord = " + this.tord);
        this.initFactory(ringFactory, this.parsedCoeff);
        List list = null;
        list = this.nextPolynomialList();
        logger.info("s = " + list);
        return new PolynomialList(this.pfac, list);
    }

    public ModuleList nextSubModuleSet() throws IOException {
        RingFactory ringFactory = this.nextCoefficientRing();
        logger.info("coeff = " + ringFactory.getClass().getSimpleName());
        this.vars = this.nextVariableList();
        logger.info("vars = " + Arrays.toString(this.vars));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info("tord = " + this.tord);
        this.initFactory(ringFactory, this.parsedCoeff);
        List list = null;
        list = this.nextSubModuleList();
        logger.info("m = " + list);
        return new ModuleList(this.pfac, list);
    }

    public List<GenSolvablePolynomial> nextSolvablePolynomialList() throws IOException {
        List<GenPolynomial> list = this.nextPolynomialList();
        logger.info("s = " + list);
        ArrayList<GenSolvablePolynomial> arrayList = new ArrayList<GenSolvablePolynomial>(list.size());
        for (GenPolynomial genPolynomial : list) {
            GenSolvablePolynomial genSolvablePolynomial = new GenSolvablePolynomial(this.spfac, genPolynomial.val);
            arrayList.add(genSolvablePolynomial);
        }
        return arrayList;
    }

    public GenSolvablePolynomial nextSolvablePolynomial() throws IOException {
        GenPolynomial genPolynomial = this.nextPolynomial();
        logger.info("nextSolvablePolynomial = " + genPolynomial);
        GenSolvablePolynomial genSolvablePolynomial = new GenSolvablePolynomial(this.spfac, genPolynomial.val);
        return genSolvablePolynomial;
    }

    public PolynomialList nextSolvablePolynomialSet() throws IOException {
        RingFactory ringFactory = this.nextCoefficientRing();
        logger.info("coeff = " + ringFactory.getClass().getSimpleName());
        this.vars = this.nextVariableList();
        logger.info("vars = " + Arrays.toString(this.vars));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info("tord = " + this.tord);
        this.initFactory(ringFactory, this.parsedCoeff);
        this.initSolvableFactory(ringFactory, this.parsedCoeff);
        this.nextRelationTable();
        if (logger.isInfoEnabled()) {
            logger.info("table = " + this.table);
        }
        List list = null;
        list = this.nextSolvablePolynomialList();
        logger.info("s = " + list);
        return new PolynomialList(this.spfac, list);
    }

    public List<List<GenSolvablePolynomial>> nextSolvableSubModuleList() throws IOException {
        ArrayList<List<GenSolvablePolynomial>> arrayList = new ArrayList<List<GenSolvablePolynomial>>();
        int n = this.tok.nextToken();
        if (n == -1) {
            return arrayList;
        }
        if (n != 40) {
            return arrayList;
        }
        logger.debug("module list");
        List<GenSolvablePolynomial> list = null;
        while (true) {
            n = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (this.tok.ttype == 41 || this.tok.ttype == -1) break;
            if (n != 40) continue;
            this.tok.pushBack();
            list = this.nextSolvablePolynomialList();
            logger.info("next vect = " + list);
            arrayList.add(list);
        }
        return arrayList;
    }

    public ModuleList nextSolvableSubModuleSet() throws IOException {
        RingFactory ringFactory = this.nextCoefficientRing();
        logger.info("coeff = " + ringFactory.getClass().getSimpleName());
        this.vars = this.nextVariableList();
        logger.info("vars = " + Arrays.toString(this.vars));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info("tord = " + this.tord);
        this.initFactory(ringFactory, this.parsedCoeff);
        this.initSolvableFactory(ringFactory, this.parsedCoeff);
        this.nextRelationTable();
        if (logger.isInfoEnabled()) {
            logger.info("table = " + this.table);
        }
        List list = null;
        list = this.nextSolvableSubModuleList();
        logger.info("s = " + list);
        return new OrderedModuleList(this.spfac, list);
    }

    public GenWordPolynomial nextWordPolynomial() throws IOException {
        GenWordPolynomialRing genWordPolynomialRing = new GenWordPolynomialRing(this.pfac);
        return this.nextWordPolynomial(genWordPolynomialRing);
    }

    public GenWordPolynomial nextWordPolynomial(GenWordPolynomialRing genWordPolynomialRing) throws IOException {
        WordFactory wordFactory = genWordPolynomialRing.alphabet;
        GenWordPolynomial<MonoidElem> genWordPolynomial = genWordPolynomialRing.getZERO();
        MonoidElem monoidElem = genWordPolynomialRing.getONE();
        Word word = genWordPolynomialRing.wone;
        RingFactory ringFactory = genWordPolynomialRing.coFac;
        if (debug) {
            logger.debug("a = " + genWordPolynomial);
            logger.debug("a1 = " + (GenWordPolynomial)monoidElem);
        }
        Element<RingElem> element = monoidElem;
        block24: while (true) {
            int n = this.tok.nextToken();
            logger.debug("while tt = " + this.tok);
            if (n == -1) break;
            switch (n) {
                case 41: 
                case 44: {
                    if (logger.isInfoEnabled()) {
                        logger.info("nextWordPolynomial = " + genWordPolynomial);
                    }
                    return genWordPolynomial;
                }
                case 45: {
                    element = ((GenWordPolynomial)element).negate();
                }
                case 42: 
                case 43: {
                    n = this.tok.nextToken();
                    break;
                }
            }
            if (n == -1) break;
            switch (n) {
                case 125: {
                    throw new InvalidExpressionException("mismatch of braces after " + genWordPolynomial + ", error at " + (GenWordPolynomial)element);
                }
                case 123: {
                    RingElem ringElem;
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 0;
                    do {
                        if ((n = this.tok.nextToken()) == -1) {
                            throw new InvalidExpressionException("mismatch of braces after " + genWordPolynomial + ", error at " + (GenWordPolynomial)element);
                        }
                        if (n == 123) {
                            ++n2;
                        }
                        if (n == 125 && --n2 < 0) continue;
                        if (this.tok.sval != null) {
                            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '.') {
                                stringBuffer.append(" ");
                            }
                            stringBuffer.append(this.tok.sval);
                            continue;
                        }
                        stringBuffer.append((char)n);
                    } while (n2 >= 0);
                    try {
                        ringElem = (RingElem)ringFactory.parse(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidExpressionException("not a number " + stringBuffer, numberFormatException);
                    }
                    if (debug) {
                        logger.debug("coeff " + ringElem);
                    }
                    long l = this.nextExponent();
                    if (debug) {
                        logger.debug("ie " + l);
                    }
                    ringElem = (RingElem)ringElem.power(l);
                    if (debug) {
                        logger.debug("coeff^ie " + ringElem);
                    }
                    element = ((GenWordPolynomial)element).multiply(ringElem, word);
                    n = this.tok.nextToken();
                    if (!debug) break;
                    logger.debug("tt,digit = " + this.tok);
                    break;
                }
                case -3: {
                    Word word2;
                    long l;
                    RingElem ringElem;
                    if (this.tok.sval == null || this.tok.sval.length() == 0) break;
                    char c = this.tok.sval.charAt(0);
                    if (GenPolynomialTokenizer.digit(c) || c == '/' || c == '.' || c == '~') {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.tok.sval);
                        if (this.tok.sval.length() > 1 && GenPolynomialTokenizer.digit(this.tok.sval.charAt(1))) {
                            if (c == '/') {
                                stringBuffer.insert(0, "1");
                            }
                            if (c == '.') {
                                stringBuffer.insert(0, "0");
                            }
                        }
                        if (this.tok.sval.charAt(this.tok.sval.length() - 1) == 'i') {
                            n = this.tok.nextToken();
                            if (debug) {
                                logger.debug("tt,im = " + this.tok);
                            }
                            if (this.tok.sval != null || n == 45) {
                                if (this.tok.sval != null) {
                                    stringBuffer.append(this.tok.sval);
                                } else {
                                    stringBuffer.append("-");
                                }
                                if (n == 45) {
                                    n = this.tok.nextToken();
                                    if (this.tok.sval != null && GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                                        stringBuffer.append(this.tok.sval);
                                    } else {
                                        this.tok.pushBack();
                                    }
                                }
                            } else {
                                this.tok.pushBack();
                            }
                        }
                        if ((n = this.tok.nextToken()) == 46) {
                            n = this.tok.nextToken();
                            if (debug) {
                                logger.debug("tt,dot = " + this.tok);
                            }
                            if (this.tok.sval != null) {
                                stringBuffer.append(".");
                                stringBuffer.append(this.tok.sval);
                            } else {
                                this.tok.pushBack();
                                this.tok.pushBack();
                            }
                        } else {
                            this.tok.pushBack();
                        }
                        try {
                            ringElem = (RingElem)ringFactory.parse(stringBuffer.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidExpressionException("not a number " + stringBuffer, numberFormatException);
                        }
                        if (debug) {
                            logger.debug("coeff " + ringElem);
                        }
                        l = this.nextExponent();
                        if (debug) {
                            logger.debug("ie " + l);
                        }
                        ringElem = (RingElem)ringElem.power(l);
                        if (debug) {
                            logger.debug("coeff^ie " + ringElem);
                        }
                        element = ((GenWordPolynomial)element).multiply(ringElem, word);
                        n = this.tok.nextToken();
                        if (debug) {
                            logger.debug("tt,digit = " + this.tok);
                        }
                    }
                    if (n == -1 || this.tok.sval == null || !GenPolynomialTokenizer.letter(c = this.tok.sval.charAt(0))) break;
                    try {
                        word2 = wordFactory.parse(this.tok.sval);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        word2 = null;
                    }
                    if (debug) {
                        logger.info("monom " + word2);
                    }
                    if (word2 == null) {
                        try {
                            ringElem = (RingElem)ringFactory.parse(this.tok.sval);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidExpressionException("recursively unknown variable " + this.tok.sval);
                        }
                        l = this.nextExponent();
                        ringElem = (RingElem)ringElem.power(l);
                        element = ((GenWordPolynomial)element).multiply(ringElem, word);
                    } else {
                        l = this.nextExponent();
                        word2 = (Word)word2.power(l);
                        element = ((GenWordPolynomial)element).multiply(word2);
                    }
                    n = this.tok.nextToken();
                    if (!debug) break;
                    logger.debug("tt,letter = " + this.tok);
                    break;
                }
                case 40: {
                    GenWordPolynomial genWordPolynomial2 = this.nextWordPolynomial(genWordPolynomialRing);
                    if (debug) {
                        logger.debug("factor " + genWordPolynomial2);
                    }
                    long l = this.nextExponent();
                    if (debug) {
                        logger.debug("ie " + l);
                    }
                    genWordPolynomial2 = (GenWordPolynomial)genWordPolynomial2.power(l);
                    if (debug) {
                        logger.debug("factor^ie " + genWordPolynomial2);
                    }
                    element = ((GenWordPolynomial)element).multiply(genWordPolynomial2);
                    n = this.tok.nextToken();
                    if (!debug) break;
                    logger.debug("tt,digit = " + this.tok);
                    break;
                }
            }
            if (n == -1) break;
            this.tok.pushBack();
            switch (n) {
                case 41: 
                case 43: 
                case 44: 
                case 45: {
                    logger.debug("b, = " + (GenWordPolynomial)element);
                    genWordPolynomial = genWordPolynomial.sum((MonoidElem)element);
                    element = monoidElem;
                    continue block24;
                }
                case 42: {
                    logger.debug("b, = " + (GenWordPolynomial)element);
                    continue block24;
                }
                case 10: {
                    n = this.tok.nextToken();
                    if (!debug) continue block24;
                    logger.debug("tt,nl = " + n);
                    continue block24;
                }
            }
            if (!debug) continue;
            logger.debug("default: " + this.tok);
        }
        if (debug) {
            logger.debug("b = " + (GenWordPolynomial)element);
        }
        genWordPolynomial = genWordPolynomial.sum((MonoidElem)element);
        if (logger.isInfoEnabled()) {
            logger.info("nextWordPolynomial = " + genWordPolynomial);
        }
        return genWordPolynomial;
    }

    public List<GenWordPolynomial> nextWordPolynomialList() throws IOException {
        GenWordPolynomialRing genWordPolynomialRing = new GenWordPolynomialRing(this.pfac);
        return this.nextWordPolynomialList(genWordPolynomialRing);
    }

    public List<GenWordPolynomial> nextWordPolynomialList(GenWordPolynomialRing genWordPolynomialRing) throws IOException {
        ArrayList<GenWordPolynomial> arrayList = new ArrayList<GenWordPolynomial>();
        int n = this.tok.nextToken();
        if (n == -1) {
            return arrayList;
        }
        if (n != 40) {
            return arrayList;
        }
        logger.debug("word polynomial list");
        while (true) {
            GenWordPolynomial genWordPolynomial;
            n = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (n == 40) {
                genWordPolynomial = this.nextWordPolynomial(genWordPolynomialRing);
                n = this.tok.nextToken();
                if (this.tok.ttype != 41) {
                    this.tok.pushBack();
                }
            } else {
                this.tok.pushBack();
                genWordPolynomial = this.nextWordPolynomial(genWordPolynomialRing);
            }
            logger.info("next pol = " + genWordPolynomial);
            arrayList.add(genWordPolynomial);
            if (this.tok.ttype == -1 || this.tok.ttype == 41) break;
        }
        return arrayList;
    }

    static boolean digit(char c) {
        return '0' <= c && c <= '9';
    }

    static boolean letter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    public void nextComma() throws IOException {
        if (this.tok.ttype == 44) {
            int n = this.tok.nextToken();
            if (debug) {
                logger.debug("after comma: " + n);
            }
        }
    }

    public static String[] variableList(String string) {
        String[] stringArray = null;
        if (string == null) {
            return stringArray;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return new String[0];
        }
        if (string2.charAt(0) == '(') {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == ')') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        string2 = string2.replaceAll(",", " ");
        ArrayList<String> arrayList = new ArrayList<String>();
        Scanner scanner = new Scanner(string2);
        while (scanner.hasNext()) {
            String string3 = scanner.next();
            arrayList.add(string3);
        }
        scanner.close();
        stringArray = new String[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string4;
            stringArray[n] = string4 = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public static String[] expressionVariables(String string) {
        String[] stringArray = null;
        if (string == null) {
            return stringArray;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return new String[0];
        }
        string2 = string2.replaceAll(",", " ");
        string2 = string2.replaceAll("\\+", " ");
        string2 = string2.replaceAll("-", " ");
        string2 = string2.replaceAll("\\*", " ");
        string2 = string2.replaceAll("/", " ");
        string2 = string2.replaceAll("\\(", " ");
        string2 = string2.replaceAll("\\)", " ");
        string2 = string2.replaceAll("\\{", " ");
        string2 = string2.replaceAll("\\}", " ");
        string2 = string2.replaceAll("\\[", " ");
        string2 = string2.replaceAll("\\]", " ");
        string2 = string2.replaceAll("\\^", " ");
        TreeSet<String> treeSet = new TreeSet<String>();
        Scanner scanner = new Scanner(string2);
        while (scanner.hasNext()) {
            int n;
            String string3 = scanner.next();
            if (string3 == null || string3.length() == 0) continue;
            for (n = 0; GenPolynomialTokenizer.digit(string3.charAt(n)) && n < string3.length() - 1; ++n) {
            }
            if (n > 0) {
                string3 = string3.substring(n, string3.length());
            }
            if (string3.length() == 0 || !GenPolynomialTokenizer.letter(string3.charAt(0))) continue;
            treeSet.add(string3);
        }
        scanner.close();
        stringArray = new String[treeSet.size()];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string4;
            stringArray[n] = string4 = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    private static enum polyType {
        PolBigRat,
        PolBigInt,
        PolModInt,
        PolBigC,
        PolBigD,
        PolBigQ,
        PolBigO,
        PolANrat,
        PolANmod,
        PolIntFunc;

    }

    private static enum coeffType {
        BigRat,
        BigInt,
        ModInt,
        BigC,
        BigQ,
        BigO,
        BigD,
        ANrat,
        ANmod,
        IntFunc;

    }
}

