/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.structure.GcdRingElem;
import java.math.BigInteger;

public class RealAlgebraicNumber<C extends GcdRingElem<C> & Rational>
implements GcdRingElem<RealAlgebraicNumber<C>>,
Rational {
    public final AlgebraicNumber<C> number;
    public final RealAlgebraicRing<C> ring;

    public RealAlgebraicNumber(RealAlgebraicRing<C> realAlgebraicRing, GenPolynomial<C> genPolynomial) {
        this.number = new AlgebraicNumber(realAlgebraicRing.algebraic, genPolynomial);
        this.ring = realAlgebraicRing;
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> realAlgebraicRing, AlgebraicNumber<C> algebraicNumber) {
        this.number = algebraicNumber;
        this.ring = realAlgebraicRing;
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> realAlgebraicRing) {
        this(realAlgebraicRing, (AlgebraicNumber<C>)realAlgebraicRing.algebraic.getZERO());
    }

    @Override
    public RealAlgebraicRing<C> factory() {
        return this.ring;
    }

    @Override
    public RealAlgebraicNumber<C> copy() {
        return new RealAlgebraicNumber<C>(this.ring, this.number);
    }

    @Override
    public BigRational getRational() {
        return this.magnitude();
    }

    @Override
    public boolean isZERO() {
        return this.number.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.number.isONE();
    }

    @Override
    public boolean isUnit() {
        return this.number.isUnit();
    }

    public boolean isRootOfUnity() {
        return this.number.isRootOfUnity();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return "{ " + this.number.toString() + " }";
        }
        return "Real" + this.number.toString();
    }

    @Override
    public String toScript() {
        return this.number.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((RealAlgebraicRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(RealAlgebraicNumber<C> realAlgebraicNumber) {
        int n = 0;
        if (this.number.ring != realAlgebraicNumber.number.ring) {
            n = this.number.ring.modul.compareTo(realAlgebraicNumber.number.ring.modul);
            System.out.println("s_mod = " + n);
        }
        if (n != 0) {
            return n;
        }
        n = this.subtract(realAlgebraicNumber).signum();
        return n;
    }

    @Override
    public int compareTo(AlgebraicNumber<C> algebraicNumber) {
        int n = this.number.compareTo(algebraicNumber);
        System.out.println("s_algeb = " + n);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RealAlgebraicNumber)) {
            return false;
        }
        RealAlgebraicNumber realAlgebraicNumber = (RealAlgebraicNumber)object;
        if (!this.ring.equals(realAlgebraicNumber.ring)) {
            return false;
        }
        return this.number.equals(realAlgebraicNumber.number);
    }

    @Override
    public int hashCode() {
        return 37 * this.number.val.hashCode() + this.ring.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> abs() {
        if (this.signum() < 0) {
            return new RealAlgebraicNumber<C>(this.ring, this.number.negate());
        }
        return this;
    }

    @Override
    public RealAlgebraicNumber<C> sum(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber<AlgebraicNumber<C>>(this.ring, this.number.sum(realAlgebraicNumber.number));
    }

    @Override
    public RealAlgebraicNumber<C> sum(GenPolynomial<C> genPolynomial) {
        return new RealAlgebraicNumber<GenPolynomial<C>>(this.ring, this.number.sum(genPolynomial));
    }

    @Override
    public RealAlgebraicNumber<C> sum(C c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.sum(c));
    }

    @Override
    public RealAlgebraicNumber<C> negate() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.negate());
    }

    @Override
    public int signum() {
        Interval interval = this.ring.engine.invariantSignInterval(this.ring.root, this.ring.algebraic.modul, this.number.val);
        this.ring.setRoot(interval);
        return this.ring.engine.realIntervalSign(interval, this.ring.algebraic.modul, this.number.val);
    }

    public void halfInterval() {
        Interval interval = this.ring.engine.halfInterval(this.ring.root, this.ring.algebraic.modul);
        this.ring.setRoot(interval);
    }

    public BigInteger floor() {
        BigRational bigRational = this.magnitude();
        BigInteger bigInteger = bigRational.floor();
        return bigInteger;
    }

    public BigRational magnitude() {
        Interval interval = this.ring.engine.invariantMagnitudeInterval(this.ring.root, this.ring.algebraic.modul, this.number.val, this.ring.getEps());
        this.ring.setRoot(interval);
        GcdRingElem gcdRingElem = (GcdRingElem)this.ring.engine.realIntervalMagnitude(interval, this.ring.algebraic.modul, this.number.val);
        BigRational bigRational = ((Rational)((Object)gcdRingElem)).getRational();
        return bigRational;
    }

    public BigDecimal decimalMagnitude() {
        return new BigDecimal(this.magnitude());
    }

    @Override
    public RealAlgebraicNumber<C> subtract(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.subtract(realAlgebraicNumber.number));
    }

    @Override
    public RealAlgebraicNumber<C> divide(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return this.multiply((C)realAlgebraicNumber.inverse());
    }

    @Override
    public RealAlgebraicNumber<C> inverse() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.inverse());
    }

    @Override
    public RealAlgebraicNumber<C> remainder(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.remainder(realAlgebraicNumber.number));
    }

    public RealAlgebraicNumber<C>[] quotientRemainder(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber[]{this.divide(realAlgebraicNumber), this.remainder(realAlgebraicNumber)};
    }

    @Override
    public RealAlgebraicNumber<C> multiply(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber<AlgebraicNumber<C>>(this.ring, this.number.multiply(realAlgebraicNumber.number));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(C c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.multiply(c));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(GenPolynomial<C> genPolynomial) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.multiply(genPolynomial));
    }

    public RealAlgebraicNumber<C> monic() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.monic());
    }

    @Override
    public RealAlgebraicNumber<C> gcd(RealAlgebraicNumber<C> realAlgebraicNumber) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.gcd(realAlgebraicNumber.number));
    }

    public RealAlgebraicNumber<C>[] egcd(RealAlgebraicNumber<C> realAlgebraicNumber) {
        AlgebraicNumber<C>[] algebraicNumberArray = this.number.egcd(realAlgebraicNumber.number);
        RealAlgebraicNumber[] realAlgebraicNumberArray = new RealAlgebraicNumber[]{new RealAlgebraicNumber<C>(this.ring, algebraicNumberArray[0]), new RealAlgebraicNumber<C>(this.ring, algebraicNumberArray[1]), new RealAlgebraicNumber<C>(this.ring, algebraicNumberArray[2])};
        return realAlgebraicNumberArray;
    }
}

