/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.BasicLinAlg;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import edu.jas.vector.LinAlg;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenMatrixTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;
    int rows = 23;
    int cols = 23;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenMatrixTest.suite());
    }

    public GenMatrixTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(GenMatrixTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstruction() {
        BigRational bigRational = new BigRational(1L);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, this.rows, this.cols);
        GenMatrixTest.assertTrue((String)("#rows = " + this.rows), (genMatrixRing.rows == this.rows ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)("#columns = " + this.cols), (genMatrixRing.cols == this.cols ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)"cfac == coFac ", (bigRational == genMatrixRing.coFac ? 1 : 0) != 0);
        Element element = genMatrixRing.getZERO();
        GenMatrixTest.assertTrue((String)"isZERO( a )", (boolean)((GenMatrix)element).isZERO());
        AlgebraElem algebraElem = new GenMatrix<BigRational>(genMatrixRing);
        GenMatrixTest.assertTrue((String)"isZERO( b )", (boolean)algebraElem.isZERO());
        GenMatrixTest.assertTrue((String)"a == b ", (boolean)((GenMatrix)element).equals(algebraElem));
        Element element2 = algebraElem.copy();
        GenMatrixTest.assertTrue((String)"isZERO( c )", (boolean)((GenMatrix)element2).isZERO());
        GenMatrixTest.assertTrue((String)"a == c ", (boolean)((GenMatrix)element).equals(element2));
        GenMatrix<BigRational> genMatrix = genMatrixRing.copy((GenMatrix<BigRational>)algebraElem);
        GenMatrixTest.assertTrue((String)"isZERO( d )", (boolean)genMatrix.isZERO());
        GenMatrixTest.assertTrue((String)"a == d ", (boolean)((GenMatrix)element).equals(genMatrix));
        element = genMatrixRing.getONE();
        GenMatrixTest.assertTrue((String)"isONE( a )", (boolean)((GenMatrix)element).isONE());
        ArrayList arrayList = ((GenMatrix)element).matrix;
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>(arrayList.size());
        for (ArrayList arrayList3 : arrayList) {
            arrayList2.add(arrayList3);
        }
        algebraElem = genMatrixRing.fromList(arrayList2);
        GenMatrixTest.assertEquals((String)"a == fromList(a.matrix)", element, algebraElem);
        GenMatrix<BigRational> genMatrix2 = genMatrixRing.generate((n, n2) -> bigRational.getZERO());
        GenMatrixTest.assertTrue((String)"e == 0: ", (boolean)genMatrix2.isZERO());
        genMatrix2 = genMatrixRing.generate((n, n2) -> n == n2 ? bigRational.getONE() : bigRational.getZERO());
        GenMatrixTest.assertTrue((String)"e == 1: ", (boolean)genMatrix2.isONE());
        genMatrix2 = genMatrixRing.generate((n, n2) -> n == n2 + 1 ? bigRational.getONE() : bigRational.getZERO());
        GenMatrixTest.assertTrue((String)("e**" + genMatrixRing.cols + " == 0: "), (boolean)((GenMatrix)genMatrix2.power(genMatrixRing.cols)).isZERO());
    }

    public void testRandom() {
        BigRational bigRational = new BigRational(1L);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, this.rows, this.cols);
        GenMatrixRing<BigRational> genMatrixRing2 = genMatrixRing.transpose();
        if (this.rows == this.cols) {
            GenMatrixTest.assertTrue((String)" mfac = tfac ", (boolean)genMatrixRing.equals(genMatrixRing2));
        }
        for (int i = 0; i < 5; ++i) {
            AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
            if (((GenMatrix)algebraElem).isZERO()) continue;
            GenMatrixTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
            GenMatrix<BigRational> genMatrix = ((GenMatrix)algebraElem).transpose(genMatrixRing2);
            GenMatrixTest.assertTrue((String)(" not isZERO( b" + i + " )"), (!genMatrix.isZERO() ? 1 : 0) != 0);
            GenMatrix<BigRational> genMatrix2 = genMatrix.transpose(genMatrixRing);
            GenMatrixTest.assertEquals((String)" a^r^r == a ", (Object)algebraElem, genMatrix2);
        }
    }

    public void testAddition() {
        BigRational bigRational = new BigRational(1L);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, this.rows, this.cols);
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
        AlgebraElem algebraElem2 = genMatrixRing.random(this.kl, this.q);
        AlgebraElem algebraElem3 = ((GenMatrix)algebraElem).sum(algebraElem2);
        GenMatrix genMatrix = algebraElem3.subtract(algebraElem2);
        GenMatrixTest.assertEquals((String)"a+b-b = a", (Object)algebraElem, genMatrix);
        algebraElem3 = ((GenMatrix)algebraElem).sum(algebraElem2);
        genMatrix = algebraElem3.sum(((GenMatrix)algebraElem2).negate());
        GenMatrixTest.assertEquals((String)"a+b+(-b) = a", (Object)algebraElem, genMatrix);
        algebraElem3 = ((GenMatrix)algebraElem).sum(algebraElem2);
        genMatrix = ((GenMatrix)algebraElem2).sum(algebraElem);
        GenMatrixTest.assertEquals((String)"a+b = b+a", algebraElem3, genMatrix);
        algebraElem3 = genMatrixRing.random(this.kl, this.q);
        genMatrix = ((GenMatrix)algebraElem).sum(algebraElem2).sum(algebraElem3);
        GenMatrix genMatrix2 = ((GenMatrix)algebraElem).sum(((GenMatrix)algebraElem2).sum(algebraElem3));
        GenMatrixTest.assertEquals((String)"a+(b+c) = (a+b)+c", genMatrix, genMatrix2);
    }

    public void testScalarMultiplication() {
        BigRational bigRational = new BigRational(1L);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, this.rows, this.cols);
        BigRational bigRational2 = bigRational.random(this.kl);
        BigRational bigRational3 = bigRational2.inverse();
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
        GenMatrix<BigRational> genMatrix = ((GenMatrix)algebraElem).scalarMultiply(bigRational2);
        GenMatrix<BigRational> genMatrix2 = genMatrix.scalarMultiply((RingElem)bigRational3);
        GenMatrixTest.assertEquals((String)"a*b*(1/b) = a", (Object)algebraElem, (Object)genMatrix2);
        AlgebraElem algebraElem2 = genMatrixRing.random(this.kl, this.q);
        BigRational bigRational4 = bigRational.getONE();
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, bigRational4);
        genMatrix2 = ((GenMatrix)algebraElem2).linearCombination(algebraElem, bigRational4);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", genMatrix, genMatrix2);
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, bigRational4);
        genMatrix2 = ((GenMatrix)algebraElem).sum(algebraElem2);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", genMatrix, genMatrix2);
        bigRational3 = bigRational4.negate();
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, bigRational4);
        genMatrix2 = genMatrix.linearCombination((GenMatrix<BigRational>)algebraElem2, bigRational3);
        GenMatrixTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)algebraElem, genMatrix2);
        genMatrix = ((GenMatrix)algebraElem).linearCombination(bigRational4, algebraElem2, bigRational4);
        genMatrix2 = genMatrix.linearCombination(bigRational4, (GenMatrix<BigRational>)algebraElem2, bigRational3);
        GenMatrixTest.assertEquals((String)"a*1+b*1+b*(-1) = a", (Object)algebraElem, genMatrix2);
        bigRational4 = bigRational.getZERO();
        genMatrix = ((GenMatrix)algebraElem).linearCombination(algebraElem2, bigRational4);
        GenMatrixTest.assertEquals((String)"a+0*b = a", (Object)algebraElem, genMatrix);
        genMatrix2 = ((GenMatrix)algebraElem).linearCombination(bigRational4, algebraElem2, bigRational4);
        GenMatrixTest.assertEquals((String)"0*a+0*b = 0", (Object)genMatrixRing.getZERO(), genMatrix2);
    }

    public void testSimpleMultiplication() {
        BigRational bigRational = new BigRational(1L);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, this.rows, this.cols);
        Element element = genMatrixRing.getZERO();
        Element element2 = genMatrixRing.getZERO();
        AlgebraElem algebraElem = ((GenMatrix)element).multiplySimple(element2);
        GenMatrixTest.assertTrue((String)"0*0 = 0 ", (boolean)algebraElem.isZERO());
        element = genMatrixRing.getONE();
        element2 = genMatrixRing.getONE();
        algebraElem = ((GenMatrix)element).multiplySimple(element2);
        GenMatrixTest.assertTrue((String)"1*1 = 1 ", (boolean)algebraElem.isONE());
        element = genMatrixRing.random(this.kl, this.q);
        element2 = genMatrixRing.getONE();
        algebraElem = ((GenMatrix)element).multiplySimple(element2);
        GenMatrix genMatrix = ((GenMatrix)element).multiply(element2);
        GenMatrixTest.assertEquals((String)"a*1 = a ", element, algebraElem);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", algebraElem, genMatrix);
        algebraElem = ((GenMatrix)element2).multiplySimple(element);
        genMatrix = ((GenMatrix)element).multiply(element2);
        GenMatrixTest.assertEquals((String)"1*a = a ", element, algebraElem);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", algebraElem, genMatrix);
        element2 = genMatrixRing.random(this.kl, this.q);
        long l = System.currentTimeMillis();
        algebraElem = ((GenMatrix)element).multiplySimple(element2);
        l = System.currentTimeMillis() - l;
        GenMatrixTest.assertTrue((String)("nonsense " + l), (l >= 0L ? 1 : 0) != 0);
        genMatrix = ((GenMatrix)element2).multiplySimple(element);
        long l2 = System.currentTimeMillis();
        GenMatrix genMatrix2 = ((GenMatrix)element).multiply(element2);
        l2 = System.currentTimeMillis() - l2;
        GenMatrixTest.assertTrue((String)("nonsense " + l2), (l2 >= 0L ? 1 : 0) != 0);
        GenMatrix genMatrix3 = ((GenMatrix)element2).multiply(element);
        GenMatrixTest.assertTrue((String)"a*b != b*a ", (!algebraElem.equals(genMatrix) ? 1 : 0) != 0);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", algebraElem, genMatrix2);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", genMatrix, genMatrix3);
        if (!genMatrixRing.isAssociative()) {
            return;
        }
        algebraElem = genMatrixRing.random(this.kl, this.q);
        genMatrix = ((GenMatrix)element).multiply(((GenMatrix)element2).sum(algebraElem));
        genMatrix2 = ((GenMatrix)element).multiply(element2).sum(((GenMatrix)element).multiply(algebraElem));
        GenMatrixTest.assertEquals((String)"a*(b+c) = a*b+a*c", genMatrix, genMatrix2);
        genMatrix = ((GenMatrix)element).multiply(((GenMatrix)element2).multiply(algebraElem));
        genMatrix2 = ((GenMatrix)element).multiply(element2).multiply(algebraElem);
        GenMatrixTest.assertEquals((String)"a*(b*c) = (a*b)*c", genMatrix, genMatrix2);
    }

    public void testParse() {
        BigRational bigRational = new BigRational(1L);
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, this.rows, this.cols);
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, this.q);
        if (!((GenMatrix)algebraElem).isZERO()) {
            GenMatrixTest.assertTrue((String)" not isZERO( a )", (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        }
        String string = ((GenMatrix)algebraElem).toString();
        Element element = genMatrixRing.parse(string);
        GenMatrixTest.assertEquals((String)"parse(toStirng(a) == a ", (Object)algebraElem, (Object)element);
    }

    public void testLUdecomp() {
        BigRational bigRational = new BigRational(1L);
        int n = 10;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, n, n);
        GenVectorModul<BigRational> genVectorModul = new GenVectorModul<BigRational>(bigRational, n);
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, 0.7f);
        if (((GenMatrix)algebraElem).isZERO()) {
            return;
        }
        GenMatrixTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        Element element = ((GenMatrix)algebraElem).copy();
        LinAlg linAlg = new LinAlg();
        BasicLinAlg basicLinAlg = new BasicLinAlg();
        List<Integer> list = linAlg.decompositionLU(algebraElem);
        if (list.size() == 0) {
            System.out.println("undecomposable");
            return;
        }
        Element element2 = genVectorModul.random(this.kl);
        GenVector genVector = basicLinAlg.rightProduct(element2, element);
        GenVector genVector2 = linAlg.solveLU(algebraElem, list, genVector);
        GenMatrixTest.assertEquals((String)"s == x: ", (Object)element2, genVector2);
        GenVector genVector3 = basicLinAlg.rightProduct(genVector2, element);
        GenMatrixTest.assertEquals((String)"b == r: ", genVector, genVector3);
        BigRational bigRational2 = (BigRational)linAlg.determinantLU(algebraElem, list);
        GenMatrixTest.assertFalse((String)"det(A) != 0: ", (boolean)bigRational2.isZERO());
        GenMatrix genMatrix = linAlg.inverseLU(algebraElem, list);
        GenMatrix genMatrix2 = ((GenMatrix)element).multiply(genMatrix);
        GenMatrixTest.assertTrue((String)"A*iA == 1: ", (boolean)genMatrix2.isONE());
        MonoidElem monoidElem = ((GenMatrix)element).inverse();
        GenMatrix genMatrix3 = ((GenMatrix)element).multiply(monoidElem);
        GenMatrixTest.assertTrue((String)"Ap*I == 1: ", (boolean)genMatrix3.isONE());
        AlgebraElem algebraElem2 = genMatrixRing.random(3, 0.5f);
        GenMatrix genMatrix4 = ((GenMatrix)algebraElem2).divide(element);
        GenMatrix genMatrix5 = ((GenMatrix)algebraElem2).divideLeft(element);
        GenMatrixTest.assertFalse((String)"C/A != A\\C: ", (boolean)genMatrix4.equals(genMatrix5));
        GenMatrix genMatrix6 = genMatrix4.multiply(element);
        GenMatrixTest.assertEquals((String)"C == C/A*A: ", genMatrix6, (Object)algebraElem2);
        genMatrix6 = ((GenMatrix)element).multiply(genMatrix5);
        GenMatrixTest.assertEquals((String)"C == A*A\\C: ", genMatrix6, (Object)algebraElem2);
    }

    public void testNullSpaceMod() {
        GenMatrix genMatrix;
        ModLongRing modLongRing = new ModLongRing(11L);
        int n = 100;
        GenMatrixRing<ModLong> genMatrixRing = new GenMatrixRing<ModLong>(modLongRing, n, n);
        GenMatrixRing<ModLong> genMatrixRing2 = genMatrixRing.transpose();
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, 0.5f / (float)n);
        if (n < 50) {
            System.out.println("A = " + (GenMatrix)algebraElem);
        }
        if (((GenMatrix)algebraElem).isZERO()) {
            return;
        }
        GenMatrixTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        GenMatrix genMatrix2 = ((GenMatrix)algebraElem).copy();
        GenMatrix<ModLong> genMatrix3 = ((GenMatrix)algebraElem).transpose(genMatrixRing2);
        if (n < 10) {
            System.out.println("At = " + genMatrix3);
        }
        LinAlg linAlg = new LinAlg();
        BasicLinAlg<ModLong> basicLinAlg = new BasicLinAlg<ModLong>();
        List list = linAlg.nullSpaceBasis(algebraElem);
        if (list.size() == 0) {
            System.out.println("no null space basis");
            return;
        }
        if (n < 10) {
            System.out.println("mod A-I = " + (GenMatrix)algebraElem);
        }
        for (GenVector genVector : list) {
            GenVector<ModLong> genVector2 = basicLinAlg.leftProduct(genVector, genMatrix3);
            GenMatrixTest.assertTrue((String)("z == 0: " + genVector2), (boolean)genVector2.isZERO());
        }
        genMatrix2 = ((GenMatrix)algebraElem).sum(genMatrixRing.getONE());
        if (!genMatrix2.equals(genMatrix = genMatrix2.multiply(genMatrix2))) {
            System.out.println("Ap = " + genMatrix2);
            System.out.println("B = " + genMatrix);
        }
        GenMatrixTest.assertEquals((String)"A*A == B: ", genMatrix2, genMatrix);
    }

    public void testNullSpace() {
        GenMatrix genMatrix;
        BigRational bigRational = new BigRational(11L);
        int n = 100;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, n, n);
        GenMatrixRing<BigRational> genMatrixRing2 = genMatrixRing.transpose();
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, 0.5f / (float)n);
        if (n < 10) {
            System.out.println("A = " + (GenMatrix)algebraElem);
        }
        if (((GenMatrix)algebraElem).isZERO()) {
            return;
        }
        GenMatrixTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        GenMatrix genMatrix2 = ((GenMatrix)algebraElem).copy();
        GenMatrix<BigRational> genMatrix3 = ((GenMatrix)algebraElem).transpose(genMatrixRing2);
        LinAlg linAlg = new LinAlg();
        BasicLinAlg<BigRational> basicLinAlg = new BasicLinAlg<BigRational>();
        List list = linAlg.nullSpaceBasis(algebraElem);
        if (list.size() == 0) {
            System.out.println("no null space basis");
            return;
        }
        if (n < 10) {
            System.out.println("mod A-I = " + (GenMatrix)algebraElem);
        }
        if (n < 10) {
            System.out.println("T = " + genMatrix3);
        }
        for (GenVector genVector : list) {
            GenVector<BigRational> genVector2 = basicLinAlg.leftProduct(genVector, genMatrix3);
            GenMatrixTest.assertTrue((String)("z == 0: " + genVector2), (boolean)genVector2.isZERO());
        }
        genMatrix2 = ((GenMatrix)algebraElem).sum(genMatrixRing.getONE());
        if (!genMatrix2.equals(genMatrix = genMatrix2.multiply(genMatrix2))) {
            System.out.println("Ap = " + genMatrix2);
            System.out.println("B = " + genMatrix);
        }
        GenMatrixTest.assertEquals((String)"A*A == B: ", genMatrix2, genMatrix);
    }

    public void testNullSpaceKernels() {
        BigRational bigRational = new BigRational(11L);
        int n = 10;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, n, n);
        GenMatrixRing<BigRational> genMatrixRing2 = genMatrixRing.transpose();
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, 0.7f / (float)n);
        if (n < 10) {
            System.out.println("A = " + (GenMatrix)algebraElem);
        }
        if (((GenMatrix)algebraElem).isZERO()) {
            return;
        }
        GenMatrixTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        Element element = ((GenMatrix)algebraElem).copy();
        GenMatrix<BigRational> genMatrix = ((GenMatrix)element).transpose(genMatrixRing2);
        Element element2 = genMatrix.copy();
        if (n < 10) {
            System.out.println("T = " + genMatrix);
        }
        LinAlg<BigRational> linAlg = new LinAlg<BigRational>();
        BasicLinAlg basicLinAlg = new BasicLinAlg();
        List list = linAlg.nullSpaceBasis((GenMatrix<BigRational>)algebraElem);
        if (list.size() == 0) {
            System.out.println("no cokern null space basis");
        }
        for (GenVector object : list) {
            GenVector genVector = basicLinAlg.leftProduct(object, element2);
            GenMatrixTest.assertTrue((String)("z == 0: " + genVector), (boolean)genVector.isZERO());
        }
        List<GenVector<BigRational>> list2 = linAlg.nullSpaceBasis(genMatrix);
        if (list2.size() == 0) {
            System.out.println("no kern null space basis");
        }
        for (GenVector genVector : list2) {
            GenVector genVector2 = basicLinAlg.rightProduct(genVector, element);
            GenMatrixTest.assertTrue((String)("z == 0: " + genVector2), (boolean)genVector2.isZERO());
        }
        long l = linAlg.rankNS((GenMatrix<BigRational>)element);
        long l2 = list.size();
        GenMatrixTest.assertTrue((String)"0 <= rank < n: ", (0L <= l && l <= (long)n ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)"rank + dim coker == n ", (l + l2 == (long)n ? 1 : 0) != 0);
        long l3 = linAlg.rankNS((GenMatrix<BigRational>)element2);
        long l4 = list2.size();
        GenMatrixTest.assertTrue((String)"0 <= rank < n: ", (0L <= l3 && l3 <= (long)n ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)"rank + dim ker == n ", (l3 + l4 == (long)n ? 1 : 0) != 0);
    }

    public void testRowEchelonForm() {
        BigRational bigRational = new BigRational(11L);
        int n = 50;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(bigRational, n, n);
        GenMatrixRing<BigRational> genMatrixRing2 = genMatrixRing.transpose();
        AlgebraElem algebraElem = genMatrixRing.random(this.kl, 2.0f / (float)n);
        if (n < 10) {
            System.out.println("A = " + (GenMatrix)algebraElem);
        }
        if (((GenMatrix)algebraElem).isZERO()) {
            return;
        }
        GenMatrixTest.assertTrue((String)" not isZERO( A )", (!((GenMatrix)algebraElem).isZERO() ? 1 : 0) != 0);
        Element element = ((GenMatrix)algebraElem).copy();
        GenMatrix<BigRational> genMatrix = ((GenMatrix)element).transpose(genMatrixRing2);
        if (n < 10) {
            System.out.println("T = " + genMatrix.ring.rows);
        }
        LinAlg linAlg = new LinAlg();
        long l = 0L;
        long l2 = 0L;
        GenMatrix genMatrix2 = linAlg.rowEchelonForm(algebraElem);
        l = linAlg.rankRE(genMatrix2);
        GenMatrixTest.assertTrue((String)"0 <= rank < n: ", (0L <= l && l <= (long)n ? 1 : 0) != 0);
        GenMatrix<BigRational> genMatrix3 = linAlg.rowEchelonForm(genMatrix);
        l2 = linAlg.rankRE(genMatrix3);
        GenMatrixTest.assertTrue((String)"0 <= rank < n: ", (0L <= l2 && l2 <= (long)n ? 1 : 0) != 0);
        GenMatrix genMatrix4 = linAlg.rowEchelonFormSparse(genMatrix2);
        l2 = linAlg.rankRE(genMatrix4);
        GenMatrixTest.assertTrue((String)"rank1 == rank2: ", (l == l2 ? 1 : 0) != 0);
    }
}

