/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.annotations;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.vocabulary.RDF;
import de.unibonn.iai.eis.luzzu.datatypes.ProblemList;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.QPRO;
import java.util.List;

public class QualityReport {
    public Model createQualityProblem(Resource metricURI, ProblemList<?> problemList) {
        Model m = ModelFactory.createDefaultModel();
        if (problemList.getProblemList().get(0) instanceof Quad) {
            for (Object obj : problemList.getProblemList()) {
                Resource problemURI = Commons.generateURI();
                m.add((Statement)new StatementImpl(problemURI, RDF.type, (RDFNode)QPRO.QualityProblem));
                m.add((Statement)new StatementImpl(problemURI, QPRO.isDescribedBy, (RDFNode)metricURI));
                Resource bNode = Commons.generateRDFBlankNode().asResource();
                m.add((Statement)new StatementImpl(problemURI, QPRO.problematicThing, (RDFNode)bNode));
                Quad q = (Quad)obj;
                m.add((Statement)new StatementImpl(bNode, RDF.type, (RDFNode)RDF.Statement));
                m.add((Statement)new StatementImpl(bNode, RDF.subject, Commons.asRDFNode((Node)q.getSubject())));
                m.add((Statement)new StatementImpl(bNode, RDF.predicate, Commons.asRDFNode((Node)q.getPredicate())));
                m.add((Statement)new StatementImpl(bNode, RDF.object, Commons.asRDFNode((Node)q.getObject())));
                if (q.getGraph() == null) continue;
                m.add((Statement)new StatementImpl(bNode, QPRO.inGraph, Commons.asRDFNode((Node)q.getGraph())));
            }
        } else if (problemList.getProblemList().get(0) instanceof Model) {
            for (Object obj : problemList.getProblemList()) {
                Resource problemURI = Commons.generateURI();
                m.add((Statement)new StatementImpl(problemURI, RDF.type, (RDFNode)QPRO.QualityProblem));
                m.add((Statement)new StatementImpl(problemURI, QPRO.isDescribedBy, (RDFNode)metricURI));
                Model qpModel = (Model)obj;
                Resource sNode = (Resource)qpModel.listSubjects().next();
                m.add((Statement)new StatementImpl(problemURI, QPRO.problematicThing, (RDFNode)sNode));
                m.add(qpModel);
            }
        } else {
            Seq problemSeq = m.createSeq();
            int i = 1;
            for (Object obj : problemList.getProblemList()) {
                Resource r = (Resource)obj;
                problemSeq.add(i, (RDFNode)r);
                ++i;
            }
            Resource problemURI = Commons.generateURI();
            m.add((Statement)new StatementImpl(problemURI, RDF.type, (RDFNode)QPRO.QualityProblem));
            m.add((Statement)new StatementImpl(problemURI, QPRO.isDescribedBy, (RDFNode)metricURI));
            m.add((Statement)new StatementImpl(problemURI, QPRO.problematicThing, (RDFNode)problemSeq));
        }
        return m;
    }

    public Model createQualityReport(Resource computedOn, List<Model> problemReportModels) {
        Model m = ModelFactory.createDefaultModel();
        Resource reportURI = Commons.generateURI();
        m.add((Statement)new StatementImpl(reportURI, RDF.type, (RDFNode)QPRO.QualityReport));
        m.add((Statement)new StatementImpl(reportURI, QPRO.computedOn, (RDFNode)computedOn));
        for (Model prModel : problemReportModels) {
            for (Resource r : this.getProblemURI(prModel)) {
                m.add((Statement)new StatementImpl(reportURI, QPRO.hasProblem, (RDFNode)r));
                m.add(prModel);
            }
        }
        return m;
    }

    public List<Resource> getProblemURI(Model problemReport) {
        return problemReport.listSubjectsWithProperty(RDF.type, (RDFNode)QPRO.QualityProblem).toList();
    }
}

