/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.communications;

import de.unibonn.iai.eis.luzzu.properties.PropertyManager;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class Main {
    private static final Properties PROP = PropertyManager.getInstance().getProperties("webservice.properties");
    private static final String SCHEME = PROP.getProperty("SCHEME");
    private static final String DOMAIN = PROP.getProperty("DOMAIN");
    private static final String PORT_NUMBER = PROP.getProperty("PORT");
    private static final String APPLICATION = PROP.getProperty("APPLICATION");
    public static final String BASE_URI = SCHEME + "://" + DOMAIN + ":" + PORT_NUMBER + "/" + APPLICATION + "/";

    public static HttpServer startServer() {
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"de.unibonn.iai.eis.luzzu"}).property("javax.json.stream.JsonGenerator.prettyPrinting", (Object)true);
        return GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(BASE_URI), (ResourceConfig)rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        HttpServer server = Main.startServer();
        try {
            server.start();
            System.out.println(String.format("Jersey app started with WADL available at %sapplication.wadl\n", BASE_URI));
            Thread.currentThread().join();
        }
        catch (Exception ioe) {
            System.out.println("Error running Luzzu Communications service: " + ioe.toString());
        }
        finally {
            if (server != null && server.isStarted()) {
                server.shutdownNow();
            }
        }
    }
}

