/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.communications.resources;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import de.unibonn.iai.eis.luzzu.communications.ExtendedCallable;
import de.unibonn.iai.eis.luzzu.communications.Main;
import de.unibonn.iai.eis.luzzu.io.ProcessorController;
import de.unibonn.iai.eis.luzzu.io.impl.SPARQLEndPointProcessor;
import de.unibonn.iai.eis.luzzu.io.impl.StreamProcessor;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class QualityResource {
    static final Logger logger = LoggerFactory.getLogger(QualityResource.class);

    @POST
    @Path(value="getStatisticsForRequest")
    @Produces(value={"application/json"})
    public Response getStatisticsForRequest(MultivaluedMap<String, String> formParams) {
        String jsonResponse = "";
        String reqID = "";
        try {
            List lstRequestID = (List)formParams.get((Object)"RequestID");
            if (lstRequestID == null || lstRequestID.size() <= 0) {
                throw new IllegalArgumentException("Request ID was not provided");
            }
            reqID = (String)lstRequestID.get(0);
            jsonResponse = Main.getRequestStats(reqID);
        }
        catch (Exception e) {
            String errorTimeStamp = Long.toString(new Date().getTime());
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"Agent\": \"" + Main.BASE_URI + "\", ");
            sb.append("\"RequestID\": \"" + reqID + "\", ");
            sb.append("\"TimeStamp\": \"" + errorTimeStamp + "\", ");
            sb.append("\"ErrorMessage\": \"" + e.getMessage() + "\"");
            sb.append("}");
            jsonResponse = sb.toString();
            e.printStackTrace();
        }
        return Response.ok((Object)jsonResponse.toString(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @POST
    @Path(value="cancelRequest")
    @Produces(value={"application/json"})
    public Response cancelRequest(MultivaluedMap<String, String> formParams) {
        String jsonResponse = "";
        String reqID = "";
        try {
            List lstRequestID = (List)formParams.get((Object)"RequestID");
            if (lstRequestID == null || lstRequestID.size() <= 0) {
                throw new IllegalArgumentException("Request ID was not provided");
            }
            reqID = (String)lstRequestID.get(0);
            boolean success = Main.cancelRequest(reqID);
            String timeStamp = Long.toString(new Date().getTime());
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"Agent\": \"" + Main.BASE_URI + "\", ");
            sb.append("\"RequestID\": \"" + reqID + "\", ");
            sb.append("\"CancellationRequestSuccess\": \"" + success + "\", ");
            sb.append("\"Time\": \"" + timeStamp + "\"");
            sb.append("}");
            jsonResponse = sb.toString();
        }
        catch (Exception e) {
            String errorTimeStamp = Long.toString(new Date().getTime());
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"Agent\": \"" + Main.BASE_URI + "\", ");
            sb.append("\"RequestID\": \"" + reqID + "\", ");
            sb.append("\"TimeStamp\": \"" + errorTimeStamp + "\", ");
            sb.append("\"ErrorMessage\": \"" + e.getMessage() + "\"");
            sb.append("}");
            jsonResponse = sb.toString();
            e.printStackTrace();
        }
        return Response.ok((Object)jsonResponse.toString(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @GET
    @Path(value="getPendingRequests")
    @Produces(value={"application/json"})
    public Response getPendingRequests() {
        return Response.ok((Object)Main.getAllPendingRequests(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @GET
    @Path(value="getSuccessfulRequests")
    @Produces(value={"application/json"})
    public Response getSuccessfulRequests() {
        return Response.ok((Object)Main.getAllSuccessfulRequests(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @GET
    @Path(value="getFailedRequests")
    @Produces(value={"application/json"})
    public Response getFailedRequests() {
        return Response.ok((Object)Main.getAllFailedRequests(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @POST
    @Path(value="status")
    @Produces(value={"application/json"})
    public Response status(MultivaluedMap<String, String> formParams) {
        String jsonResponse = "";
        String reqID = "";
        try {
            List lstRequestID = (List)formParams.get((Object)"RequestID");
            if (lstRequestID == null || lstRequestID.size() <= 0) {
                throw new IllegalArgumentException("Request ID was not provided");
            }
            reqID = (String)lstRequestID.get(0);
            jsonResponse = Main.getRequestStatus(reqID);
        }
        catch (Exception e) {
            String errorTimeStamp = Long.toString(new Date().getTime());
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"Agent\": \"" + Main.BASE_URI + "\", ");
            sb.append("\"RequestID\": \"" + reqID + "\", ");
            sb.append("\"TimeStamp\": \"" + errorTimeStamp + "\", ");
            sb.append("\"ErrorMessage\": \"" + e.getMessage() + "\"");
            sb.append("}");
            jsonResponse = sb.toString();
            e.printStackTrace();
        }
        return Response.ok((Object)jsonResponse.toString(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @POST
    @Path(value="compute_quality")
    @Produces(value={"application/json"})
    public Response computeQuality(MultivaluedMap<String, String> formParams) {
        String jsonResponse = "";
        String _datasetURI = "";
        try {
            logger.info("Quality computation request received for dataset: {}", formParams.get((Object)"Dataset"));
            List lstDatasetURI = (List)formParams.get((Object)"Dataset");
            List lstQualityReportReq = (List)formParams.get((Object)"QualityReportRequired");
            List lstMetricsConfig = (List)formParams.get((Object)"MetricsConfiguration");
            List lstBaseUri = (List)formParams.get((Object)"BaseUri");
            List lstIsSparql = (List)formParams.get((Object)"IsSparql");
            logger.debug("Processing request parameters. DatasetURI: {}; QualityReportRequired: {}; MetricsConfiguration: {}; BaseUri: {}; IsSPARQLEndPoint: {}", new Object[]{lstDatasetURI, lstQualityReportReq, lstMetricsConfig, lstBaseUri});
            System.out.printf("Processing request parameters. DatasetURI: %s; QualityReportRequired: %s; MetricsConfiguration: %s; BaseUri: %s; IsSPARQLEndPoint: %s", lstDatasetURI, lstQualityReportReq.get(0), lstMetricsConfig.get(0), lstBaseUri.get(0), lstIsSparql.get(0));
            if (lstDatasetURI == null || lstDatasetURI.size() <= 0) {
                throw new IllegalArgumentException("Dataset URI parameter was not provided");
            }
            if (lstQualityReportReq == null || lstQualityReportReq.size() <= 0) {
                throw new IllegalArgumentException("Generate Quality Report parameter was not provided");
            }
            if (lstMetricsConfig == null || lstMetricsConfig.size() <= 0) {
                throw new IllegalArgumentException("Metrics configuration parameter was not provided");
            }
            if (lstBaseUri == null || lstBaseUri.size() <= 0) {
                throw new IllegalArgumentException("Base URI parameter was not provided");
            }
            if (lstIsSparql == null || lstIsSparql.size() <= 0) {
                throw new IllegalArgumentException("IsSparql parameter was not provided");
            }
            String jsonStrMetricsConfig = (String)lstMetricsConfig.get(0);
            final boolean genQualityReport = Boolean.parseBoolean((String)lstQualityReportReq.get(0));
            Model _modelConfig = ModelFactory.createDefaultModel();
            RDFDataMgr.read((Model)_modelConfig, (StringReader)new StringReader(jsonStrMetricsConfig), null, (Lang)Lang.JSONLD);
            final Model modelConfig = _modelConfig;
            final String baseURI = (String)lstBaseUri.get(0);
            final boolean isSPARQLEndpoint = Boolean.parseBoolean((String)lstIsSparql.get(0));
            final String datasetURI = (String)lstDatasetURI.get(0);
            _datasetURI = (String)lstDatasetURI.get(0);
            ExtendedCallable<String> newRequest = new ExtendedCallable<String>(){

                @Override
                public String call() throws Exception {
                    String jsonResponse;
                    try {
                        if (isSPARQLEndpoint) {
                            this.strmProc = new SPARQLEndPointProcessor(baseURI, datasetURI, genQualityReport, modelConfig);
                        } else if (datasetURI.startsWith("http://") || datasetURI.startsWith("ftp://")) {
                            this.strmProc = new StreamProcessor(baseURI, datasetURI, genQualityReport, modelConfig);
                        } else {
                            this.strmProc = ProcessorController.getInstance().decide(baseURI, datasetURI, genQualityReport, modelConfig);
                            logger.debug("Chosen Processor: {}", (Object)this.strmProc.getClass().toString());
                            System.out.println("Chosen Processor: " + this.strmProc.getClass().toString());
                        }
                        this.strmProc.processorWorkFlow();
                        this.strmProc.cleanUp();
                        Model modelQualityRep = null;
                        if (genQualityReport) {
                            modelQualityRep = this.strmProc.retreiveQualityReport();
                        }
                        jsonResponse = QualityResource.this.buildJsonResponse(datasetURI == null ? baseURI : datasetURI, modelQualityRep);
                        logger.debug("Quality computation request completed. DatasetURI: {}", (Object)datasetURI);
                    }
                    catch (Exception ex) {
                        String errorTimeStamp = Long.toString(new Date().getTime());
                        logger.error("Error processing quality computation request [" + errorTimeStamp + "]", (Throwable)ex);
                        jsonResponse = QualityResource.this.buildJsonErrorResponse(datasetURI, errorTimeStamp, ex.getMessage());
                        ex.printStackTrace();
                    }
                    return jsonResponse.toString();
                }
            };
            String requestID = Main.addRequest((Callable<String>)newRequest, _datasetURI);
            System.out.println("Added request: " + requestID);
            jsonResponse = Main.getRequestStatus(requestID);
        }
        catch (Exception e) {
            String errorTimeStamp = Long.toString(new Date().getTime());
            jsonResponse = this.buildJsonErrorResponse(_datasetURI, errorTimeStamp, e.getMessage());
        }
        return Response.ok((Object)jsonResponse, (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    private String buildJsonResponse(String datasetURI, Model qualityReport) {
        StringBuilder sbJsonResponse = new StringBuilder();
        sbJsonResponse.append("{ \"Dataset\": \"" + datasetURI + "\", ");
        sbJsonResponse.append("\"Agent\": \"" + Main.BASE_URI + "\", ");
        sbJsonResponse.append("\"Outcome\": \"SUCCESS\"");
        sbJsonResponse.append(" }");
        return sbJsonResponse.toString();
    }

    private String buildJsonErrorResponse(String datasetURI, String errorCode, String errorMessage) {
        StringBuilder sbJsonResponse = new StringBuilder();
        sbJsonResponse.append("{ \"Dataset\": \"" + datasetURI + "\", ");
        sbJsonResponse.append("\"Agent\": \"" + Main.BASE_URI + "\", ");
        sbJsonResponse.append("\"Outcome\": \"ERROR\", ");
        sbJsonResponse.append("\"ErrorMessage\": \"" + errorMessage + "\", ");
        sbJsonResponse.append("\"ErrorCode\": \"" + errorCode + "\" }");
        return sbJsonResponse.toString();
    }
}

