/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.communications.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankBy;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankedObject;
import de.unibonn.iai.eis.luzzu.operations.ranking.Ranking;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankingConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class RankResource {
    static final Logger logger = LoggerFactory.getLogger(RankResource.class);

    @POST
    @Path(value="rank")
    @Produces(value={"application/json"})
    public Response rank(String message) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<RankingConfiguration> conf = new ArrayList<RankingConfiguration>();
        try {
            JsonNode rootNode = mapper.readTree(message);
            Iterator iter = rootNode.elements();
            while (iter.hasNext()) {
                JsonNode n = (JsonNode)iter.next();
                Resource res = ModelFactory.createDefaultModel().createResource(n.get("uri").asText());
                RankBy type = n.get("type").asText().equals("category") ? RankBy.CATEGORY : (n.get("type").asText().equals("dimension") ? RankBy.DIMENSION : RankBy.METRIC);
                RankingConfiguration rc = new RankingConfiguration(res, type, n.get("weight").asDouble());
                conf.add(rc);
            }
            Ranking ranking = new Ranking();
            List rank = ranking.rank(conf, true);
            String json = "{ \"ranking\" : [";
            for (RankedObject ro : rank) {
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                try {
                    json = json + ow.writeValueAsString((Object)ro) + ",";
                }
                catch (JsonProcessingException e) {
                    logger.error("Error transforming to json : {}", (Object)e.getMessage());
                }
            }
            json = json.substring(0, json.length() - 1);
            json = json + "]}";
            return Response.ok((Object)json, (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
        }
        catch (IOException e) {
            return Response.ok((Object)this.buildJsonErrorResponse(e.getLocalizedMessage(), e.getMessage()), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
        }
    }

    private String buildJsonErrorResponse(String errorCode, String errorMessage) {
        StringBuilder sbJsonResponse = new StringBuilder();
        sbJsonResponse.append("{ ");
        sbJsonResponse.append("\"Outcome\": ERROR, ");
        sbJsonResponse.append("\"ErrorMessage\": \"" + errorMessage + "\", ");
        sbJsonResponse.append("\"ErrorCode\": \"" + errorCode + "\" }");
        return sbJsonResponse.toString();
    }
}

