/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.communications.resources;

import com.hp.hpl.jena.rdf.model.Model;
import de.unibonn.iai.eis.luzzu.web.assessment.MetricConfiguration;
import de.unibonn.iai.eis.luzzu.web.export.CSVExporter;
import de.unibonn.iai.eis.luzzu.web.ranking.Facets;
import de.unibonn.iai.eis.luzzu.web.visualise.Data;
import de.unibonn.iai.eis.luzzu.web.visualise.Wizard;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/framework/web/")
public class WebResource {
    static final Logger logger = LoggerFactory.getLogger(WebResource.class);

    @GET
    @Path(value="get/configured/metrics")
    @Produces(value={"application/json"})
    public Response getLoadedMetrics() {
        Model m = MetricConfiguration.getAllMetrics();
        StringWriter strWriter = new StringWriter();
        RDFDataMgr.write((StringWriter)strWriter, (Model)m, (RDFFormat)RDFFormat.JSONLD);
        return Response.ok((Object)strWriter.toString(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @GET
    @Path(value="get/facet/options")
    @Produces(value={"application/json"})
    public Response getFacetOptions() {
        return Response.ok((Object)Facets.getFacetOptions(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @POST
    @Path(value="post/wizard/option")
    @Produces(value={"application/json"})
    public Response getWizardOptions(MultivaluedMap<String, String> formParams) {
        String type = (String)((List)formParams.get((Object)"type")).get(0);
        logger.info("Requesting a wizard view for type : {}", (Object)type);
        if (type.equals("one")) {
            return Response.ok((Object)Wizard.getAllCommonDatasetsMetrics(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
        }
        if (type.equals("two")) {
            return Response.ok((Object)Wizard.getAllDatasetsWithMultipleObservations(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
        }
        if (type.equals("three")) {
            return Response.ok((Object)Wizard.getAllDatasets(), (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
        }
        return null;
    }

    @POST
    @Path(value="post/visualisation/dsvsm")
    @Produces(value={"application/json"})
    public Response getDatasetVSMetricVisualisation(MultivaluedMap<String, String> formParams) {
        String metric = (String)((List)formParams.get((Object)"metric")).get(0);
        String datasetsArrayString = (String)((List)formParams.get((Object)"datasets")).get(0);
        datasetsArrayString = datasetsArrayString.replace("[", "").replace("]", "");
        List<String> datasets = Arrays.asList(datasetsArrayString.split(","));
        logger.info("Requesting a Dataset vs Metric view for {} on {}", (Object)metric, (Object)StringUtils.join((Object[])datasets.toArray()));
        String json = Data.getLatestValueForMetrics((String)metric, datasets);
        return Response.ok((Object)json, (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @POST
    @Path(value="post/visualisation/dsqualityvis")
    @Produces(value={"application/json"})
    public Response getDatasetQualityValuesForVisualisation(MultivaluedMap<String, String> formParams) {
        String dataset = (String)((List)formParams.get((Object)"dataset")).get(0);
        logger.info("Requesting a Dataset Quality View for {}", (Object)dataset);
        String json = Data.getLatestObservationForDataset((String)dataset);
        return Response.ok((Object)json, (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @POST
    @Path(value="post/visualisation/dstime")
    @Produces(value={"application/json"})
    public Response getDatasetOverTimeVisualisation(MultivaluedMap<String, String> formParams) {
        String dataset = (String)((List)formParams.get((Object)"dataset")).get(0);
        String metricsArrayString = (String)((List)formParams.get((Object)"metrics")).get(0);
        metricsArrayString = metricsArrayString.replace("[", "").replace("]", "");
        List<String> metrics = Arrays.asList(metricsArrayString.split(","));
        logger.info("Requesting a Dataset Over Time view for {} on {}", (Object)dataset, (Object)StringUtils.join((Object[])metrics.toArray()));
        String json = Data.getObservationsForDataset((String)dataset, metrics);
        System.out.println(json);
        return Response.ok((Object)json, (String)"application/json").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }

    @GET
    @Path(value="get/export/csv")
    @Produces(value={"text/plain"})
    public Response exportAllToCSV() {
        return Response.ok((Object)CSVExporter.exportAllDatasets().toString(), (String)"text/plain").header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"POST, GET, PUT, UPDATE, OPTIONS").header("Access-Control-Allow-Headers", (Object)"x-requested-with, x-requested-by").build();
    }
}

