/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.io.configuration;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import de.unibonn.iai.eis.luzzu.assessment.QualityMetric;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.LMI;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalMetricLoader {
    static final Logger logger = LoggerFactory.getLogger(ExternalMetricLoader.class);
    private static ExternalMetricLoader instance = null;
    private static ConcurrentMap<File, List<String>> metricsInFile = new ConcurrentHashMap<File, List<String>>();
    private static FileFilter jarFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    };

    protected ExternalMetricLoader() {
    }

    public static ExternalMetricLoader getInstance() {
        if (instance == null) {
            logger.info("Initialising and verifying external metrics.");
            instance = new ExternalMetricLoader();
            ExternalMetricLoader.loadMetrics();
        }
        return instance;
    }

    private static void loadMetrics() {
        File[] listOfFiles;
        File externalsFolder = new File("externals/metrics/");
        for (File metrics : listOfFiles = externalsFolder.listFiles()) {
            if (metrics.isHidden() || !metrics.isDirectory()) continue;
            File jarFile = metrics.listFiles(jarFilter)[0];
            metricsInFile.putIfAbsent(jarFile, new ArrayList());
            logger.info("Loading metrics from : {} ", (Object)jarFile.toPath());
            Model m = ModelFactory.createDefaultModel();
            m.read(metrics + "/metrics.trig");
            NodeIterator res = m.listObjectsOfProperty(LMI.javaPackageName);
            while (res.hasNext()) {
                String javaMetric = res.next().toString();
                ((List)metricsInFile.get(jarFile)).add(javaMetric);
                logger.info("Metric : {} ", (Object)javaMetric);
            }
        }
    }

    public Map<String, Class<? extends QualityMetric>> getQualityMetricClasses() {
        if (instance == null) {
            ExternalMetricLoader.getInstance();
        }
        HashMap<String, Class<? extends QualityMetric>> clazzes = new HashMap<String, Class<? extends QualityMetric>>();
        for (File jar : metricsInFile.keySet()) {
            List metrics = (List)metricsInFile.get(jar);
            URL jarUrl = null;
            try {
                jarUrl = new URL("file:" + jar.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                logger.error("Jar URL is malformed : {}. Skipped loading the file.\nFull Exception Trace: {}", jarUrl, (Object)e.getMessage());
                continue;
            }
            URLClassLoader cl = new URLClassLoader(new URL[]{jarUrl}, ExternalMetricLoader.class.getClassLoader());
            for (String m : metrics) {
                Class<?> clazz;
                logger.info("Creating class for metric : {} ", (Object)m);
                try {
                    clazz = cl.loadClass(m);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Class {} is not found for External JAR package {}. Skipped loading the class.", (Object)m, (Object)jar.getName());
                    continue;
                }
                clazzes.put(m, clazz);
            }
        }
        return clazzes;
    }
}

