/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.io.configuration;

import de.unibonn.iai.eis.luzzu.assessment.QualityMetric;
import de.unibonn.iai.eis.luzzu.qml.parser.LQMLParser;
import de.unibonn.iai.eis.luzzu.qml.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclerativeMetricCompiler {
    static final Logger logger = LoggerFactory.getLogger(DeclerativeMetricCompiler.class);
    private static DeclerativeMetricCompiler instance = null;
    private final StringBuilder javaClass = new StringBuilder();
    private static FileFilter lqmFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".lqm");
        }
    };

    public DeclerativeMetricCompiler() throws URISyntaxException, IOException {
        this.loadDeclerativePattern();
    }

    public static DeclerativeMetricCompiler getInstance() {
        if (instance == null) {
            logger.info("Initialising and verifying external metrics.");
            try {
                instance = new DeclerativeMetricCompiler();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public Map<String, Class<? extends QualityMetric>> compile() throws IOException, ParseException {
        HashMap<String, Class<? extends QualityMetric>> clazzes = new HashMap<String, Class<? extends QualityMetric>>();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        MyDiagnosticListener c = new MyDiagnosticListener();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(c, Locale.ENGLISH, null);
        File f = new File("classes/");
        if (!f.exists()) {
            f.mkdir();
        }
        List<String> options = Arrays.asList("-d", "classes/");
        Set<URI> lqiSet = this.loadMetrics();
        if (lqiSet.size() > 0) {
            try {
                this.loadDeclerativePattern();
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
        for (URI lqiMetric : lqiSet) {
            Tuple parsed = this.parse(lqiMetric);
            InMemoryJavaFileObject so = null;
            try {
                so = new InMemoryJavaFileObject(parsed.className, parsed.javaClass);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            List<JavaFileObject> files = Arrays.asList(so);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, c, options, null, files);
            task.call();
            File file = new File("classes/");
            URL uri = file.toURI().toURL();
            URL[] urls = new URL[]{uri};
            URLClassLoader loader = new URLClassLoader(urls);
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(parsed.className);
            }
            catch (ClassNotFoundException e) {
                logger.error("Class {} is not found. Skipped loading the class.", (Object)parsed.className);
                continue;
            }
            clazzes.put(parsed.className, clazz);
        }
        fileManager.close();
        return clazzes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclerativePattern() throws URISyntaxException, IOException {
        String nextLine = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("declerative_pattern.txt"), Charset.defaultCharset()));
            while ((nextLine = reader.readLine()) != null) {
                this.javaClass.append(nextLine);
            }
        }
    }

    private Tuple parse(URI lqmFile) throws IOException, ParseException {
        List<String> lines = Files.readAllLines(Paths.get(lqmFile), Charset.defaultCharset());
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            sb.append(s);
        }
        StringReader reader = new StringReader(sb.toString());
        LQMLParser parser = new LQMLParser((Reader)reader);
        Map parse = parser.parse();
        String _jClass = this.javaClass.toString();
        _jClass = _jClass.replace("[%%packagename%%]", (CharSequence)parse.get("[%%packagename%%]"));
        _jClass = _jClass.replace("[%%metricuri%%]", (CharSequence)parse.get("[%%metricuri%%]"));
        _jClass = _jClass.replace("[%%imports%%]", (CharSequence)parse.get("[%%imports%%]"));
        _jClass = _jClass.replace("[%%author%%]", (CharSequence)parse.get("[%%author%%]"));
        _jClass = _jClass.replace("[%%label%%]", (CharSequence)parse.get("[%%label%%]"));
        _jClass = _jClass.replace("[%%description%%]", (CharSequence)parse.get("[%%description%%]"));
        _jClass = _jClass.replace("[%%classname%%]", (CharSequence)parse.get("[%%classname%%]"));
        _jClass = _jClass.replace("[%%variables%%]", (CharSequence)parse.get("[%%variables%%]"));
        _jClass = _jClass.replace("[%%computefunction%%]", (CharSequence)parse.get("[%%computefunction%%]"));
        _jClass = _jClass.replace("[%%metricvaluefuntion%%]", (CharSequence)parse.get("[%%metricvaluefuntion%%]"));
        Tuple t = new Tuple();
        t.className = (String)parse.get("[%%packagename%%]") + "." + (String)parse.get("[%%classname%%]");
        t.javaClass = _jClass;
        return t;
    }

    private Set<URI> loadMetrics() throws IOException, ParseException {
        File[] listOfFiles;
        HashSet<URI> files = new HashSet<URI>();
        File externalsFolder = new File("externals/");
        for (File metrics : listOfFiles = externalsFolder.listFiles()) {
            for (File declFile : metrics.listFiles(lqmFilter)) {
                files.add(declFile.toURI());
            }
        }
        return files;
    }

    private static class InMemoryJavaFileObject
    extends SimpleJavaFileObject {
        private String contents = null;

        public InMemoryJavaFileObject(String className, String contents) throws Exception {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.contents = contents;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.contents;
        }
    }

    private static class MyDiagnosticListener
    implements DiagnosticListener<JavaFileObject> {
        private MyDiagnosticListener() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            System.out.println("Line Number->" + diagnostic.getLineNumber());
            System.out.println("code->" + diagnostic.getCode());
            System.out.println("Message->" + diagnostic.getMessage(Locale.ENGLISH));
            System.out.println("Source->" + diagnostic.getSource());
            System.out.println(" ");
        }
    }

    private class Tuple {
        protected String className;
        protected String javaClass;

        private Tuple() {
        }
    }
}

