/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.io.helper;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import de.unibonn.iai.eis.luzzu.cache.impl.TemporaryGraphMetadataCacheObject;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StreamMetadataSniffer {
    private TemporaryGraphMetadataCacheObject _temp = null;
    private ConcurrentMap<String, Model> temporaryResources = new ConcurrentHashMap<String, Model>();
    public int counter = 0;

    public void sniff(Quad quad) {
        ++this.counter;
        if (quad.getGraph() != null) {
            if (this._temp != null && this._temp.getGraphURI() != null) {
                if (quad.getGraph().getURI().equals(this._temp.getGraphURI().getURI())) {
                    this._temp.addTriplesToMetadata(quad);
                }
            } else if (this.temporaryResources.containsKey(quad.getGraph())) {
                Model m = (Model)this.temporaryResources.get(quad.getGraph());
                m.add(Commons.asRDFNode((Node)quad.getSubject()).asResource(), m.createProperty(quad.getPredicate().getURI()), Commons.asRDFNode((Node)quad.getObject()));
                this.temporaryResources.put(quad.getGraph().toString(), m);
            } else {
                Model m = ModelFactory.createDefaultModel();
                m.add(Commons.asRDFNode((Node)quad.getSubject()).asResource(), m.createProperty(quad.getPredicate().getURI()), Commons.asRDFNode((Node)quad.getObject()));
                this.temporaryResources.put(quad.getGraph().toString(), m);
            }
        }
        if (quad.getObject().isURI() && quad.getObject().getURI().equals(DAQ.QualityGraph.getURI())) {
            this._temp = new TemporaryGraphMetadataCacheObject(Commons.asRDFNode((Node)quad.getObject()).asResource());
        }
    }

    public TemporaryGraphMetadataCacheObject getCachingObject() {
        if (this._temp == null) {
            return null;
        }
        if (this.temporaryResources.containsKey(this._temp.getGraphURI().toString())) {
            this._temp.addModelToMetadata((Model)this.temporaryResources.get(this._temp.getGraphURI()));
        }
        return this._temp;
    }
}

