package de.unibonn.iai.eis.luzzu.io.impl;

import java.io.IOException;
import java.util.Iterator;

import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdtjena.HDTGraph;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;

public class HDTTest {

	public static void main (String [] args) throws IOException{
		// Load HDT file using the hdt-java library
		HDT hdt = HDTManager.mapIndexedHDT("/Users/jeremy/Downloads/swdf-2012-11-28.hdt", null);

		// Create Jena Model on top of HDT.
		HDTGraph graph = new HDTGraph(hdt, true);
		Model model = ModelFactory.createModelForGraph(graph);
		
		
		
		Iterator<Statement> stmt = model.listStatements();
		while(stmt.hasNext()){
			System.out.println(stmt.next().toString());
		}
		

		model.close(); // Close when it's no longer needed.
	}
}
