/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.io;

import com.hp.hpl.jena.rdf.model.Model;
import de.unibonn.iai.eis.luzzu.io.IOProcessor;
import de.unibonn.iai.eis.luzzu.io.impl.LargeStreamProcessor;
import de.unibonn.iai.eis.luzzu.io.impl.MemoryProcessor;
import de.unibonn.iai.eis.luzzu.io.impl.StreamProcessor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ProcessorController {
    private static ProcessorController instance = null;

    private ProcessorController() {
    }

    public static ProcessorController getInstance() {
        if (instance == null) {
            instance = new ProcessorController();
        }
        return instance;
    }

    public IOProcessor decide(String baseURI, String datasetURI, boolean genQualityReport, Model modelConfig) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        System.out.println();
        System.out.println("free memory: " + (double)freeMemory / 1048576.0 + " MB");
        File file = new File(datasetURI);
        long length = file.length();
        if (datasetURI.endsWith("gz")) {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                raf.seek(raf.length() - 4L);
                int b4 = raf.read();
                int b3 = raf.read();
                int b2 = raf.read();
                int b1 = raf.read();
                length = Math.abs(b1 << 24 | (b2 << 16) + (b3 << 8) + b4);
                raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("file size: " + (double)length / 1048576.0 + " MB");
        if ((double)length <= (double)freeMemory * 0.1) {
            return new MemoryProcessor(baseURI, datasetURI, genQualityReport, modelConfig);
        }
        if ((double)length <= (double)freeMemory * 0.5) {
            return new StreamProcessor(baseURI, datasetURI, genQualityReport, modelConfig);
        }
        return new LargeStreamProcessor(baseURI, datasetURI, genQualityReport, modelConfig);
    }
}

