/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.io.impl;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import de.unibonn.iai.eis.luzzu.annotations.QualityMetadata;
import de.unibonn.iai.eis.luzzu.annotations.QualityReport;
import de.unibonn.iai.eis.luzzu.assessment.ComplexQualityMetric;
import de.unibonn.iai.eis.luzzu.assessment.QualityMetric;
import de.unibonn.iai.eis.luzzu.cache.CacheManager;
import de.unibonn.iai.eis.luzzu.cache.CacheObject;
import de.unibonn.iai.eis.luzzu.datatypes.Args;
import de.unibonn.iai.eis.luzzu.datatypes.Object2Quad;
import de.unibonn.iai.eis.luzzu.exceptions.AfterException;
import de.unibonn.iai.eis.luzzu.exceptions.BeforeException;
import de.unibonn.iai.eis.luzzu.exceptions.ExternalMetricLoaderException;
import de.unibonn.iai.eis.luzzu.exceptions.MetadataException;
import de.unibonn.iai.eis.luzzu.exceptions.ProcessorNotInitialised;
import de.unibonn.iai.eis.luzzu.io.IOProcessor;
import de.unibonn.iai.eis.luzzu.io.configuration.DeclerativeMetricCompiler;
import de.unibonn.iai.eis.luzzu.io.configuration.ExternalMetricLoader;
import de.unibonn.iai.eis.luzzu.io.helper.IOStats;
import de.unibonn.iai.eis.luzzu.io.helper.StreamMetadataSniffer;
import de.unibonn.iai.eis.luzzu.properties.EnvironmentProperties;
import de.unibonn.iai.eis.luzzu.properties.PropertyManager;
import de.unibonn.iai.eis.luzzu.qml.parser.ParseException;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.LMI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.lang.PipedQuadsStream;
import org.apache.jena.riot.lang.PipedRDFIterator;
import org.apache.jena.riot.lang.PipedRDFStream;
import org.apache.jena.riot.lang.PipedTriplesStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZNTMemoryProcessor
implements IOProcessor {
    private final CacheManager cacheMgr = CacheManager.getInstance();
    private final String graphCacheName = PropertyManager.getInstance().getProperties("cache.properties").getProperty("GRAPH_METADATA_CACHE");
    private final String metadataBaseDir;
    private ConcurrentMap<String, QualityMetric> metricInstances = new ConcurrentHashMap<String, QualityMetric>();
    private ExternalMetricLoader loader = ExternalMetricLoader.getInstance();
    private DeclerativeMetricCompiler dmc = DeclerativeMetricCompiler.getInstance();
    static final Logger logger = LoggerFactory.getLogger(GZNTMemoryProcessor.class);
    private List<String> datasetList;
    private String baseURI;
    private String datasetURI;
    private boolean genQualityReport;
    private Model metricConfiguration;
    private Model qualityReport;
    private List<MetricProcess> lstMetricConsumers = new ArrayList<MetricProcess>();
    private boolean isInitalised = false;
    protected RandomAccessFile raf;
    protected PipedRDFIterator<?> iterator;
    protected PipedRDFStream<?> rdfStream;
    private final int rdfIterBufferSize = 20000;
    private final int rdfIterPollTimeout = 10000;
    private final int rdfIterMaxPolls = 50;
    private final boolean rdfIterFairBufferLock = true;
    private ExecutorService executor;
    private String tempFileID;

    public GZNTMemoryProcessor(String baseURI, String datasetURI, boolean genQualityReport, Model configuration) {
        this.cacheMgr.createNewCache(this.graphCacheName, 50);
        PropertyManager props = PropertyManager.getInstance();
        this.metadataBaseDir = props.getProperties("directories.properties") == null || props.getProperties("directories.properties").getProperty("QUALITY_METADATA_BASE_DIR") == null ? System.getProperty("user.dir") + "/qualityMetadata" : props.getProperties("directories.properties").getProperty("QUALITY_METADATA_BASE_DIR");
        this.tempFileID = "";
        this.datasetList = new ArrayList<String>();
        this.datasetList.add(datasetURI);
        this.genQualityReport = genQualityReport;
        this.metricConfiguration = configuration;
        this.baseURI = baseURI;
        PropertyManager.getInstance().addToEnvironmentVars("baseURI", baseURI);
    }

    public GZNTMemoryProcessor(String baseURI, List<String> datasetList, boolean genQualityReport, Model configuration) {
        this.cacheMgr.createNewCache(this.graphCacheName, 50);
        PropertyManager props = PropertyManager.getInstance();
        this.metadataBaseDir = props.getProperties("directories.properties") == null || props.getProperties("directories.properties").getProperty("QUALITY_METADATA_BASE_DIR") == null ? System.getProperty("user.dir") + "/qualityMetadata" : props.getProperties("directories.properties").getProperty("QUALITY_METADATA_BASE_DIR");
        this.tempFileID = "";
        this.datasetList = datasetList;
        this.genQualityReport = genQualityReport;
        this.metricConfiguration = configuration;
        this.baseURI = baseURI;
        PropertyManager.getInstance().addToEnvironmentVars("baseURI", baseURI);
    }

    @Override
    public void setUpProcess() {
        Lang lang = RDFLanguages.filenameToLang((String)this.datasetURI);
        if (lang == Lang.NQ || lang == Lang.NQUADS) {
            this.iterator = new PipedRDFIterator(20000, true, 10000, 50);
            this.rdfStream = new PipedQuadsStream(this.iterator);
        } else {
            this.iterator = new PipedRDFIterator(20000, true, 10000, 50);
            this.rdfStream = new PipedTriplesStream(this.iterator);
        }
        this.isInitalised = true;
        try {
            this.loadMetrics();
        }
        catch (ExternalMetricLoaderException e) {
            logger.error(e.getLocalizedMessage());
        }
        this.executor = Executors.newSingleThreadExecutor();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startProcessing() throws ProcessorNotInitialised {
        StreamMetadataSniffer sniffer;
        block19: {
            Object in;
            if (!this.isInitalised) {
                throw new ProcessorNotInitialised("Streaming will not start as processor has not been initalised");
            }
            sniffer = new StreamMetadataSniffer();
            long totalQuadsProcessed = 0L;
            try {
                in = Channels.newInputStream(this.raf.getChannel());
                Runnable parser = new Runnable((InputStream)in){
                    final /* synthetic */ InputStream val$in;
                    {
                        this.val$in = inputStream;
                    }

                    @Override
                    public void run() {
                        try {
                            RDFDataMgr.parse(GZNTMemoryProcessor.this.rdfStream, (InputStream)this.val$in, (Lang)Lang.NTRIPLES);
                        }
                        catch (Exception e) {
                            logger.error("Error parsing dataset {}. Error message {}", (Object)GZNTMemoryProcessor.this.datasetURI, (Object)e.getMessage());
                        }
                    }
                };
                this.executor.submit(parser);
                while (this.iterator.hasNext()) {
                    ++totalQuadsProcessed;
                    Object2Quad stmt = new Object2Quad(this.iterator.next());
                    sniffer.sniff(stmt.getStatement());
                    if (this.lstMetricConsumers == null) continue;
                    for (MetricProcess mConsumer : this.lstMetricConsumers) {
                        try {
                            mConsumer.notifyNewQuad(stmt);
                        }
                        catch (InterruptedException iex) {
                            logger.warn("/!\\ Quad lost for {}!!!. Interrumpted thread while notifying quad #: {} to metric: {}. Error: {}", new Object[]{this.datasetURI, totalQuadsProcessed, mConsumer.metricName, iex.getMessage()});
                        }
                    }
                }
                if (this.lstMetricConsumers == null) break block19;
                in = this.lstMetricConsumers.iterator();
            }
            catch (RiotException rex) {
                try {
                    logger.warn("Failed to process dataset: {}. RIOT Exception while attempting to process quad # : {}. Error details: {}", new Object[]{this.datasetURI, totalQuadsProcessed, rex.getMessage()});
                    throw new RuntimeException(rex);
                    catch (Exception ex) {
                        logger.error("Failed to process dataset: {}. Exception while attempting to process quad # : {}. Error details: {}", new Object[]{this.datasetURI, totalQuadsProcessed, ex});
                        throw new RuntimeException(ex);
                    }
                }
                catch (Throwable throwable) {
                    if (this.lstMetricConsumers != null) {
                        for (MetricProcess mConsumer : this.lstMetricConsumers) {
                            mConsumer.stop();
                        }
                    }
                    throw throwable;
                }
            }
            while (in.hasNext()) {
                MetricProcess mConsumer = (MetricProcess)in.next();
                mConsumer.stop();
            }
        }
        if (sniffer.getCachingObject() != null) {
            this.cacheMgr.addToCache(this.graphCacheName, (Object)this.datasetURI, (CacheObject)sniffer.getCachingObject());
        }
        Iterator iterator = this.metricInstances.keySet().iterator();
        while (iterator.hasNext()) {
            String clazz = (String)iterator.next();
            if (!(this.metricInstances.get(clazz) instanceof ComplexQualityMetric)) continue;
            try {
                List<Args> args = this.loader.getBeforeArgs(clazz);
                ArrayList<Object> pass = new ArrayList<Object>();
                for (Args arg : args) {
                    pass.add(this.transformJavaArgs(Class.forName(arg.getType()), arg.getParameter()));
                }
                ((ComplexQualityMetric)this.metricInstances.get(clazz)).after(pass.toArray());
            }
            catch (AfterException | ClassNotFoundException e) {
                logger.error(e.getMessage());
                continue;
            }
            break;
        }
        return;
    }

    @Override
    public void cleanUp() throws ProcessorNotInitialised {
        this.isInitalised = false;
        this.lstMetricConsumers.clear();
        this.metricInstances.clear();
        File f = new File("/tmp/" + this.tempFileID);
        f.delete();
    }

    @Override
    public Model retreiveQualityReport() {
        return this.qualityReport;
    }

    @Override
    public void processorWorkFlow() {
        this.setUpProcess();
        int datasetListCounter = 0;
        Iterator<String> iterator = this.datasetList.iterator();
        while (iterator.hasNext()) {
            String dataset;
            this.datasetURI = dataset = iterator.next();
            try {
                this.loadGZNTfileInRAM();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            PropertyManager.getInstance().addToEnvironmentVars("datasetURI", this.datasetURI);
            try {
                this.startProcessing();
            }
            catch (ProcessorNotInitialised e) {
                logger.warn("Processor not initialized while trying to start dataset processing. Dataset: {}", (Object)this.datasetURI);
                this.processorWorkFlow();
            }
            if (++datasetListCounter >= this.datasetList.size()) continue;
            this.setUpProcess();
        }
        this.writeQualityMetadataFile();
        if (this.genQualityReport) {
            this.generateQualityReport();
            this.writeReportMetadataFile();
        }
    }

    private void loadMetrics() throws ExternalMetricLoaderException {
        NodeIterator iter = this.metricConfiguration.listObjectsOfProperty(LMI.metric);
        Map<String, Class<? extends QualityMetric>> map = this.loader.getQualityMetricClasses();
        try {
            map.putAll(this.dmc.compile());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        while (iter.hasNext()) {
            String className = iter.next().toString();
            Class<? extends QualityMetric> clazz = map.get(className);
            QualityMetric metric = null;
            try {
                metric = clazz.newInstance();
            }
            catch (InstantiationException e) {
                logger.error("Cannot load metric for {}", (Object)className);
                throw new ExternalMetricLoaderException("Cannot create class instance for " + className + ". Exception caused by an Instantiation Exception : " + e.getLocalizedMessage());
            }
            catch (IllegalAccessException e) {
                logger.error("Cannot load metric for {}", (Object)className);
                throw new ExternalMetricLoaderException("Cannot create class instance " + className + ". Exception caused by an Illegal Access Exception : " + e.getLocalizedMessage());
            }
            catch (NullPointerException e) {
                logger.error("Cannot load metric for {}", (Object)className);
                throw new ExternalMetricLoaderException("Cannot create class instance " + className + ". Exception caused by an Illegal Access Exception : " + e.getLocalizedMessage());
            }
            this.metricInstances.put(className, metric);
        }
        for (String className : this.metricInstances.keySet()) {
            if (this.metricInstances.get(className) instanceof ComplexQualityMetric) {
                try {
                    List<Args> args = this.loader.getBeforeArgs(className);
                    ArrayList<Object> pass = new ArrayList<Object>();
                    for (Args arg : args) {
                        pass.add(this.transformJavaArgs(Class.forName(arg.getType()), arg.getParameter()));
                    }
                    ((ComplexQualityMetric)this.metricInstances.get(className)).before(pass.toArray());
                }
                catch (BeforeException | ClassNotFoundException e) {
                    logger.error(e.getMessage());
                }
            }
            this.lstMetricConsumers.add(new MetricProcess((QualityMetric)this.metricInstances.get(className)));
        }
    }

    private Object transformJavaArgs(Class<?> target, String s) {
        if (target == Object.class || target == String.class || s == null) {
            return s;
        }
        if (target == Character.class || target == Character.TYPE) {
            return Character.valueOf(s.charAt(0));
        }
        if (target == Byte.class || target == Byte.TYPE) {
            return Byte.parseByte(s);
        }
        if (target == Short.class || target == Short.TYPE) {
            return Short.parseShort(s);
        }
        if (target == Integer.class || target == Integer.TYPE) {
            return Integer.parseInt(s);
        }
        if (target == Long.class || target == Long.TYPE) {
            return Long.parseLong(s);
        }
        if (target == Float.class || target == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (target == Double.class || target == Double.TYPE) {
            return Double.parseDouble(s);
        }
        if (target == Boolean.class || target == Boolean.TYPE) {
            return Boolean.parseBoolean(s);
        }
        throw new IllegalArgumentException("Don't know how to convert to " + target);
    }

    private void generateQualityReport() {
        QualityReport r = new QualityReport();
        ArrayList<String> qualityProblems = new ArrayList<String>();
        for (String className : this.metricInstances.keySet()) {
            QualityMetric m = (QualityMetric)this.metricInstances.get(className);
            qualityProblems.add(r.createQualityProblem(m.getMetricURI(), m.getQualityProblems()));
        }
        Resource res = ModelFactory.createDefaultModel().createResource(EnvironmentProperties.getInstance().getBaseURI());
        this.qualityReport = r.createQualityReport(res, qualityProblems);
        r.flush();
    }

    private void generateQualityMetadata() {
        Resource res = ModelFactory.createDefaultModel().createResource(EnvironmentProperties.getInstance().getBaseURI());
        QualityMetadata md = new QualityMetadata(res, false);
        for (String className : this.metricInstances.keySet()) {
            QualityMetric m = (QualityMetric)this.metricInstances.get(className);
            md.addMetricData(m);
        }
        try {
            RDFDataMgr.write((OutputStream)System.out, (Dataset)md.createQualityMetadata(), (Lang)Lang.TRIG);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage());
        }
    }

    private synchronized void writeQualityMetadataFile() {
        String fld = this.metadataBaseDir + "/" + this.baseURI.replace("http://", "");
        fld = fld.replaceFirst("^~", System.getProperty("user.home"));
        File folder = new File(fld);
        folder.mkdirs();
        String metadataFilePath = fld + "/quality-meta-data.trig";
        metadataFilePath = metadataFilePath.replace("//", "/");
        logger.debug("Writing quality meta-data to file: metadataFilePath...");
        File fileMetadata = new File(metadataFilePath);
        Dataset model = DatasetFactory.createMem();
        if (fileMetadata.exists()) {
            RDFDataMgr.read((Dataset)model, (String)metadataFilePath, (String)this.baseURI, (Lang)Lang.TRIG);
        }
        Resource res = ModelFactory.createDefaultModel().createResource(this.baseURI);
        QualityMetadata md = new QualityMetadata(model, res);
        for (String className : this.metricInstances.keySet()) {
            QualityMetric m = (QualityMetric)this.metricInstances.get(className);
            md.addMetricData(m);
        }
        try {
            fileMetadata.createNewFile();
            FileOutputStream out = new FileOutputStream(fileMetadata, false);
            RDFDataMgr.write((OutputStream)out, (Dataset)md.createQualityMetadata(), (RDFFormat)RDFFormat.TRIG);
            logger.debug("Quality meta-data successfully written.");
        }
        catch (MetadataException | IOException ex) {
            logger.error("Quality meta-data could not be written to file: " + metadataFilePath, ex);
        }
    }

    private synchronized void writeReportMetadataFile() {
        String fld = this.metadataBaseDir + "/" + this.baseURI.replace("http://", "");
        File folder = new File(fld = fld.replaceFirst("^~", System.getProperty("user.home")));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        long timestamp = new Date().getTime();
        String metadataFilePath = String.format("%s/%s/problem-report-%d.trig", this.metadataBaseDir, this.baseURI.replace("http://", ""), timestamp);
        metadataFilePath = metadataFilePath.replace("//", "/");
        metadataFilePath = metadataFilePath.replaceFirst("^~", System.getProperty("user.home"));
        logger.debug("Writing quality report to file: metadataFilePath...");
        if (this.retreiveQualityReport() != null) {
            File fileMetadata = new File(metadataFilePath);
            Dataset model = DatasetFactory.create((Model)this.retreiveQualityReport());
            try {
                fileMetadata.createNewFile();
                FileOutputStream out = new FileOutputStream(fileMetadata, false);
                RDFDataMgr.write((OutputStream)out, (Dataset)model, (RDFFormat)RDFFormat.TRIG);
                logger.debug("Quality report successfully written.");
            }
            catch (IOException ex) {
                logger.error("Quality meta-data could not be written to file: " + metadataFilePath, (Throwable)ex);
            }
        } else {
            logger.warn("Attempted to write quality report, but no report model has been generated");
        }
    }

    @Override
    public synchronized List<IOStats> getIOStats() throws ProcessorNotInitialised {
        ArrayList<IOStats> lst = new ArrayList<IOStats>();
        if (!this.isInitalised) {
            throw new ProcessorNotInitialised("Streaming will not start as processor has not been initalised");
        }
        for (MetricProcess mp : this.lstMetricConsumers) {
            Long stmtProcessed = mp.getStatementProcessed();
            String metricName = mp.getMetricName();
            lst.add(new IOStats(metricName, stmtProcessed));
        }
        return lst;
    }

    private void loadGZNTfileInRAM() throws IOException {
        int bytes_read;
        FileInputStream fileIn = new FileInputStream(this.datasetURI);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileIn);
        this.tempFileID = UUID.randomUUID().toString();
        FileOutputStream fileOutputStream = new FileOutputStream("/tmp/" + this.tempFileID);
        byte[] buffer = new byte[1024];
        while ((bytes_read = gZIPInputStream.read(buffer)) > 0) {
            fileOutputStream.write(buffer, 0, bytes_read);
        }
        gZIPInputStream.close();
        fileOutputStream.close();
        this.raf = new RandomAccessFile("/tmp/" + this.tempFileID, "r");
    }

    @Override
    public void cancelMetricAssessment() throws ProcessorNotInitialised {
        if (!this.isInitalised) {
            throw new ProcessorNotInitialised("Streaming will not start as processor has not been initalised");
        }
        for (MetricProcess mp : this.lstMetricConsumers) {
            logger.info("Closing and clearing quads queue for {}", (Object)mp.metricName);
            mp.closeAssessment();
        }
        logger.info("Closing Iterators");
        this.iterator.close();
        this.rdfStream.finish();
        this.executor.shutdownNow();
    }

    private final class MetricProcess {
        volatile BlockingQueue<Object2Quad> quadsToProcess = new ArrayBlockingQueue<Object2Quad>(500000);
        Thread metricThread = null;
        String metricName = null;
        Long stmtsProcessed = 0L;
        boolean stopSignal = false;

        MetricProcess(final QualityMetric m) {
            this.metricName = m.getClass().getSimpleName();
            this.metricThread = new Thread(){

                @Override
                public void run() {
                    logger.debug("Starting thread for metric {}", (Object)m.getClass().getName());
                    Object2Quad curQuad = null;
                    while (!MetricProcess.this.stopSignal || !MetricProcess.this.quadsToProcess.isEmpty()) {
                        curQuad = (Object2Quad)MetricProcess.this.quadsToProcess.poll();
                        if (curQuad == null) continue;
                        logger.trace("Metric {}, new quad (processed: {}, to-process: {})", new Object[]{m.getClass().getName(), MetricProcess.this.stmtsProcessed, MetricProcess.this.quadsToProcess.size()});
                        m.compute(curQuad.getStatement());
                        curQuad = null;
                        Long l = MetricProcess.this.stmtsProcessed;
                        Long l2 = MetricProcess.this.stmtsProcessed = Long.valueOf(MetricProcess.this.stmtsProcessed + 1L);
                    }
                    logger.debug("Thread for metric {} completed, total statements processed {}", (Object)m.getClass().getName(), (Object)MetricProcess.this.stmtsProcessed);
                }
            };
            this.metricThread.start();
        }

        public void notifyNewQuad(Object2Quad newQuad) throws InterruptedException {
            this.quadsToProcess.put(newQuad);
            logger.trace("Metric {}, element put into queue (to-process: {})", (Object)this.metricName, (Object)this.quadsToProcess.size());
        }

        public void stop() {
            while (!this.quadsToProcess.isEmpty()) {
                logger.trace("Waiting for items on queue: {} Metric: {}", (Object)this.quadsToProcess.size(), (Object)this.metricName);
            }
            this.stopSignal = true;
        }

        public Long getStatementProcessed() {
            return this.stmtsProcessed;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void closeAssessment() {
            this.stopSignal = true;
            this.quadsToProcess.clear();
        }
    }
}

