/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.operations.ranking;

import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import de.unibonn.iai.eis.luzzu.operations.datatypes.RankedElement;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankBy;
import de.unibonn.iai.eis.luzzu.semantics.datatypes.Observation;
import de.unibonn.iai.eis.luzzu.semantics.utilities.DAQHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDrivenRanking {
    private List<RankedElement> rankedList = new ArrayList<RankedElement>();
    private List<String> datasetsToRank;
    private Map<String, Float> weightFilter;
    private RankBy level;

    public UserDrivenRanking(List<String> datasets, Map<String, Float> weightFilter, RankBy level) {
        this.datasetsToRank = datasets;
        this.weightFilter = weightFilter;
        this.level = level;
        this.rank();
    }

    private void rank() {
        for (String dataset : this.datasetsToRank) {
            Map observations = DAQHelper.getQualityMetadataObservations((String)dataset);
            float totalMetricValue = 0.0f;
            switch (this.level) {
                case CATEGORY: {
                    totalMetricValue = this.rankByCategory(observations);
                    break;
                }
                case DIMENSION: {
                    totalMetricValue = this.rankByDimension(observations);
                    break;
                }
                case METRIC: {
                    totalMetricValue = this.rankByMetric(observations);
                }
            }
            this.rankedList.add(new RankedElement(dataset, totalMetricValue));
        }
    }

    private float rankByMetric(Map<String, List<Observation>> observations) {
        float totalMetricValue = 0.0f;
        for (String key : observations.keySet()) {
            if (!this.weightFilter.containsKey(key)) continue;
            totalMetricValue += this.getLatestObservation(observations.get(key)).getValue().floatValue() * this.weightFilter.get(key).floatValue();
        }
        return totalMetricValue;
    }

    private float rankByDimension(Map<String, List<Observation>> observations) {
        float totalMetricValue = 0.0f;
        Map dimCountMap = DAQHelper.getNumberOfMetricsInDimension();
        HashMap<String, Float> dimTotalMap = new HashMap<String, Float>();
        for (String key : observations.keySet()) {
            Observation obs = this.getLatestObservation(observations.get(key));
            String dimension = DAQHelper.getDimensionForMetric((Resource)obs.getMetricType());
            if (!this.weightFilter.containsKey(dimension)) continue;
            float value = obs.getValue().floatValue();
            if (dimTotalMap.containsKey(dimension)) {
                value = ((Float)dimTotalMap.get(dimension)).floatValue();
                value += obs.getValue().floatValue();
            }
            dimTotalMap.put(dimension, Float.valueOf(value));
        }
        for (String key : dimCountMap.keySet()) {
            if (!dimTotalMap.containsKey(key)) continue;
            totalMetricValue += ((Float)dimTotalMap.get(key)).floatValue() * this.weightFilter.get(key).floatValue() / (float)((Integer)dimCountMap.get(key)).intValue();
        }
        return totalMetricValue;
    }

    private float rankByCategory(Map<String, List<Observation>> observations) {
        float totalMetricValue = 0.0f;
        Map catCountMap = DAQHelper.getNumberOfDimensionsInCategory();
        HashMap<String, Float> dimTotalMap = new HashMap<String, Float>();
        for (String key : observations.keySet()) {
            Observation obs = this.getLatestObservation(observations.get(key));
            String dimension = DAQHelper.getDimensionForMetric((Resource)obs.getMetricType());
            String category = DAQHelper.getCategoryForDimension((Resource)ModelFactory.createDefaultModel().createResource(dimension));
            if (!this.weightFilter.containsKey(category)) continue;
            float value = obs.getValue().floatValue();
            if (dimTotalMap.containsKey(dimension)) {
                value = ((Float)dimTotalMap.get(dimension)).floatValue();
                value += obs.getValue().floatValue();
            }
            dimTotalMap.put(dimension, Float.valueOf(value));
        }
        for (String key : catCountMap.keySet()) {
            List dimensions = DAQHelper.getDimensionsInCategory((Resource)ModelFactory.createDefaultModel().createResource(key));
            for (String dim : dimensions) {
                if (!dimTotalMap.containsKey(dim)) continue;
                totalMetricValue += ((Float)dimTotalMap.get(dim)).floatValue() * this.weightFilter.get(key).floatValue() / (float)((Integer)catCountMap.get(key)).intValue();
            }
        }
        return totalMetricValue;
    }

    public List<RankedElement> getSortedList() {
        Collections.sort(this.rankedList);
        Collections.reverse(this.rankedList);
        return this.rankedList;
    }

    private Observation getLatestObservation(List<Observation> observations) {
        Collections.sort(observations);
        Collections.reverse(observations);
        return observations.get(0);
    }
}

