/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.operations.signature;

import com.hp.hpl.jena.sparql.core.Quad;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.jpountz.xxhash.StreamingXXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.commons.codec.digest.DigestUtils;

public class GraphSigning {
    private IntAVLTreeSet hashSet = new IntAVLTreeSet();
    private XXHashFactory factory = XXHashFactory.fastestJavaInstance();

    public void addHash(Quad quad) throws IOException {
        String subjectHash = "";
        if (!quad.getSubject().isBlank()) {
            subjectHash = quad.getSubject().toString();
        }
        String propertyHash = quad.getPredicate().toString();
        String objectHash = "";
        if (!quad.getObject().isBlank()) {
            objectHash = quad.getObject().toString();
        }
        String graphHash = "";
        if (quad.getGraph() != null) {
            graphHash = quad.getGraph().toString();
        }
        this.hashSet.add(this.fastHashing(subjectHash + propertyHash + objectHash + graphHash));
    }

    public String retrieveHash() {
        StringBuilder sb = new StringBuilder();
        for (Integer s : this.hashSet) {
            sb.append(s);
        }
        return DigestUtils.md5Hex((String)sb.toString());
    }

    private Integer fastHashing(String strData) throws IOException {
        int read;
        byte[] data = strData.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        int seed = -1756908916;
        StreamingXXHash32 hash32 = this.factory.newStreamingHash32(seed);
        byte[] buf = new byte[8];
        while ((read = in.read(buf)) != -1) {
            hash32.update(buf, 0, read);
        }
        Integer hash = hash32.getValue();
        return hash;
    }
}

