/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.operations.ranking;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import de.unibonn.iai.eis.luzzu.operations.datatypes.RankedElement;
import de.unibonn.iai.eis.luzzu.semantics.datatypes.Observation;
import de.unibonn.iai.eis.luzzu.semantics.utilities.DAQHelper;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.CUBE;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.riot.RDFDataMgr;

@Deprecated
public class AutomaticRanking {
    private double thetaWeight = 0.0;
    private double rhoWeight = 0.0;

    public List<RankedElement> rank(List<String> datasets, Set<String> filtersChosen) {
        return this.rank(datasets, filtersChosen, "", false);
    }

    public List<RankedElement> rank(List<String> datasets, String categoryOrDimensionUri, boolean isCategory) {
        return this.rank(datasets, new HashSet<String>(), categoryOrDimensionUri, isCategory);
    }

    private List<RankedElement> rank(List<String> datasets, Set<String> filtersChosen, String categoryOrDimensionUri, boolean isCategory) {
        ArrayList<RankedElement> sortedElements = new ArrayList<RankedElement>();
        int totMet = 0;
        totMet = categoryOrDimensionUri.equals("") ? this.getTotalNumberOfMetrics(datasets) : (isCategory ? this.getTotalNumberOfMetricsForCategory(datasets, categoryOrDimensionUri) : this.getTotalNumberOfMetricsForDimension(datasets, categoryOrDimensionUri));
        this.setWeights(totMet, filtersChosen.size());
        for (String ds : datasets) {
            float tau = 0.0f;
            float thetaTotal = 0.0f;
            float rhoTotal = 0.0f;
            Map<String, List<Observation>> observations = this.extractObservations(ds);
            for (String metricType : observations.keySet()) {
                double val;
                Observation obs = this.getLatestObservation(observations.get(metricType));
                if (!categoryOrDimensionUri.equals("")) {
                    if (isCategory) {
                        if (!DAQHelper.getCategoryResource((Resource)ModelFactory.createDefaultModel().createResource(metricType)).getURI().equals(categoryOrDimensionUri)) continue;
                        val = this.rhoWeight * (double)obs.getValue().floatValue();
                        rhoTotal = (float)((double)rhoTotal + val);
                        continue;
                    }
                    if (!DAQHelper.getDimensionResource((Resource)ModelFactory.createDefaultModel().createResource(metricType)).getURI().equals(categoryOrDimensionUri)) continue;
                    val = this.rhoWeight * (double)obs.getValue().floatValue();
                    rhoTotal = (float)((double)rhoTotal + val);
                    continue;
                }
                if (filtersChosen.contains(metricType)) {
                    val = this.thetaWeight * (double)obs.getValue().floatValue();
                    thetaTotal = (float)((double)thetaTotal + val);
                    continue;
                }
                val = this.rhoWeight * (double)obs.getValue().floatValue();
                rhoTotal = (float)((double)rhoTotal + val);
            }
            tau = thetaTotal + rhoTotal;
            sortedElements.add(new RankedElement(ds, tau));
        }
        Collections.sort(sortedElements);
        Collections.reverse(sortedElements);
        return sortedElements;
    }

    private int getTotalNumberOfMetrics(List<String> datasets) {
        int metrics = 0;
        for (String ds : datasets) {
            Resource graph;
            Dataset d = RDFDataMgr.loadDataset((String)ds);
            Model qualityMD = d.getNamedModel((graph = (Resource)d.getDefaultModel().listSubjectsWithProperty(RDF.type, (RDFNode)DAQ.QualityGraph).next()).getURI());
            int _retMetNo = DAQHelper.getNumberOfMetricsInDataSet((Model)qualityMD);
            metrics = metrics <= _retMetNo ? _retMetNo : metrics;
        }
        return metrics;
    }

    private int getTotalNumberOfMetricsForDimension(List<String> datasets, String dimensionUri) {
        int metrics = 0;
        for (String ds : datasets) {
            Resource graph;
            Dataset d = RDFDataMgr.loadDataset((String)ds);
            Model qualityMD = d.getNamedModel((graph = (Resource)d.getDefaultModel().listSubjectsWithProperty(RDF.type, (RDFNode)DAQ.QualityGraph).next()).getURI());
            int _retMetNo = DAQHelper.getNumberOfMetricsInDataSet((Model)qualityMD, (Resource)qualityMD.createResource(dimensionUri), (boolean)false);
            metrics = metrics <= _retMetNo ? _retMetNo : metrics;
        }
        return metrics;
    }

    private int getTotalNumberOfMetricsForCategory(List<String> datasets, String categoryUri) {
        int metrics = 0;
        for (String ds : datasets) {
            Resource graph;
            Dataset d = RDFDataMgr.loadDataset((String)ds);
            Model qualityMD = d.getNamedModel((graph = (Resource)d.getDefaultModel().listSubjectsWithProperty(RDF.type, (RDFNode)DAQ.QualityGraph).next()).getURI());
            int _retMetNo = DAQHelper.getNumberOfMetricsInDataSet((Model)qualityMD, (Resource)qualityMD.createResource(categoryUri), (boolean)true);
            metrics = metrics <= _retMetNo ? _retMetNo : metrics;
        }
        return metrics;
    }

    private Map<String, List<Observation>> extractObservations(String dataset) {
        Dataset d = RDFDataMgr.loadDataset((String)dataset);
        Resource graph = (Resource)d.getDefaultModel().listSubjectsWithProperty(RDF.type, (RDFNode)DAQ.QualityGraph).next();
        Model qualityMD = d.getNamedModel(graph.getURI());
        HashMap<String, List<Observation>> map = new HashMap<String, List<Observation>>();
        ResIterator iter = qualityMD.listResourcesWithProperty(RDF.type, (RDFNode)CUBE.Observation);
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            Resource metricURI = qualityMD.listObjectsOfProperty(res, DAQ.metric).next().asResource();
            String metricType = qualityMD.listObjectsOfProperty(metricURI, RDF.type).next().asResource().toString();
            Date date = null;
            try {
                date = this.toDateFormat(qualityMD.listObjectsOfProperty(res, DC.date).next().asLiteral().getValue().toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Float value = Float.valueOf(qualityMD.listObjectsOfProperty(res, DAQ.value).next().asLiteral().getFloat());
            Observation obs = new Observation(res, date, value, null);
            if (!map.containsKey(metricType)) {
                map.put(metricType, new ArrayList());
            }
            ((List)map.get(metricType)).add(obs);
        }
        return map;
    }

    private void setWeights(int totNumberMetrics, int totFilterChosen) {
        this.thetaWeight = 1.0 / ((double)totFilterChosen + 1.0);
        this.rhoWeight = 1.0 / (((double)totFilterChosen + 1.0) * ((double)totNumberMetrics - (double)totFilterChosen));
    }

    private Date toDateFormat(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS'Z'");
        return sdf.parse(date);
    }

    private Observation getLatestObservation(List<Observation> observations) {
        Collections.sort(observations);
        Collections.reverse(observations);
        return observations.get(0);
    }
}

