/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.cache;

import de.unibonn.iai.eis.luzzu.cache.CacheObject;
import de.unibonn.iai.eis.luzzu.properties.PropertyManager;
import java.io.File;
import java.io.IOException;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

class Cache {
    private DB db;
    private String name;
    private HTreeMap<Object, CacheObject> cache;

    protected Cache(String name, int maxItems) {
        File tempFile;
        this.name = name;
        File tempFolder = new File("tmp/caches/");
        if (!tempFolder.exists()) {
            tempFolder.mkdirs();
        }
        if (!(tempFile = new File("tmp/caches/luzzu_" + name)).exists()) {
            try {
                tempFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.db = DBMaker.newFileDB((File)tempFile).cacheLRUEnable().cacheSize(Integer.parseInt(PropertyManager.getInstance().getProperties("cache.properties").getProperty("CACHE_SIZE_IN_GB"))).cacheSize(maxItems).make();
        this.cache = this.db.getHashMap("cache_" + name);
    }

    protected void addToCache(Object key, CacheObject value) {
        this.cache.put(key, (Object)value);
    }

    protected CacheObject getFromCache(Object key) {
        return (CacheObject)this.cache.get(key);
    }

    protected boolean existsInCache(Object key) {
        return this.cache.containsKey(key);
    }

    protected String getName() {
        return this.name;
    }

    protected void cleanup() {
        this.db.getEngine().clearCache();
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.cache.close();
            this.db.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }
}

