/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.operations.ranking;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import de.unibonn.iai.eis.luzzu.properties.PropertyManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetLoader {
    final Logger logger = LoggerFactory.getLogger(DatasetLoader.class);
    public static DatasetLoader instance = null;
    private String metadataBaseDir = "";
    private Dataset d = DatasetFactory.createMem();
    private Map<String, String> dsToQG = new HashMap<String, String>();
    private String checksum = "";

    protected DatasetLoader() {
        PropertyManager props = PropertyManager.getInstance();
        if (props.getProperties("directories.properties") == null || props.getProperties("directories.properties").getProperty("QUALITY_METADATA_BASE_DIR") == null) {
            this.metadataBaseDir = System.getProperty("user.dir") + "/qualityMetadata";
        } else {
            this.metadataBaseDir = props.getProperties("directories.properties").getProperty("QUALITY_METADATA_BASE_DIR");
            this.metadataBaseDir = this.metadataBaseDir.replaceFirst("^~", System.getProperty("user.home"));
        }
        this.loadDatasets();
    }

    public static DatasetLoader getInstance() {
        if (instance == null) {
            instance = new DatasetLoader();
        }
        if (instance.requiresReload()) {
            instance = new DatasetLoader();
        }
        return instance;
    }

    private boolean requiresReload() {
        if (this.checksum().equals(this.checksum)) {
            return false;
        }
        return false;
    }

    public Dataset getInternalDataset() {
        return this.d;
    }

    public Map<String, String> getAllGraphs() {
        return this.dsToQG;
    }

    private void loadDatasets() {
        File fld = new File(this.metadataBaseDir);
        Object[] listOfFiles = fld.listFiles();
        Arrays.sort(listOfFiles);
        String newCheckSum = "";
        this.logger.info("Loading Quality Metadata");
        for (Object file : listOfFiles) {
            this.logger.info("Trying to load metadata for {}", (Object)((File)file).getName());
            this.loadFile((File)file);
            newCheckSum = newCheckSum + this.checksumValue((File)file);
        }
        this.checksum = Hashing.md5().hashString((CharSequence)newCheckSum, Charset.defaultCharset()).toString();
    }

    private void loadFile(File fileOrFolder) {
        if (fileOrFolder.isHidden()) {
            return;
        }
        if (fileOrFolder.getPath().endsWith(".trig")) {
            Dataset _ds = RDFDataMgr.loadDataset((String)fileOrFolder.getPath());
            String baseURI = fileOrFolder.getParent();
            baseURI = baseURI.replace(this.metadataBaseDir, "");
            Iterator iter = _ds.listNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.d.addNamedModel(name, _ds.getNamedModel(name));
                this.dsToQG.put(baseURI, name);
            }
            this.d.getDefaultModel().add(_ds.getDefaultModel());
        }
        if (fileOrFolder.isDirectory()) {
            File[] listOfFiles;
            for (File file : listOfFiles = fileOrFolder.listFiles()) {
                this.loadFile(file);
            }
        }
    }

    private String checksum() {
        File fld = new File(this.metadataBaseDir);
        Object[] listOfFiles = fld.listFiles();
        Arrays.sort(listOfFiles);
        String newCheckSum = "";
        this.logger.info("Checking Checksum");
        for (Object file : listOfFiles) {
            this.logger.info("Checksum for: {}", (Object)((File)file).getName());
            newCheckSum = newCheckSum + this.checksumValue((File)file);
        }
        return Hashing.md5().hashString((CharSequence)newCheckSum, Charset.defaultCharset()).toString();
    }

    private String checksumValue(File fileOrFolder) {
        String s = "";
        if (fileOrFolder.isHidden()) {
            return "";
        }
        if (fileOrFolder.isDirectory()) {
            File[] listOfFiles;
            for (File file : listOfFiles = fileOrFolder.listFiles()) {
                s = s + this.checksumValue(file);
            }
        } else {
            try {
                s = Files.hash((File)fileOrFolder, (HashFunction)Hashing.md5()).toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return s;
    }
}

