/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.operations.ranking;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.XSD;
import de.unibonn.iai.eis.luzzu.operations.ranking.DatasetLoader;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankBy;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankedObject;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankingConfiguration;
import de.unibonn.iai.eis.luzzu.semantics.configuration.InternalModelConf;
import de.unibonn.iai.eis.luzzu.semantics.datatypes.Observation;
import de.unibonn.iai.eis.luzzu.semantics.utilities.ObservationHelper;
import de.unibonn.iai.eis.luzzu.semantics.utilities.SPARQLHelper;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ranking {
    static final Logger logger = LoggerFactory.getLogger(Ranking.class);
    private static DatasetLoader dsLoader = DatasetLoader.getInstance();
    private static Dataset d = dsLoader.getInternalDataset();
    private static HashMap<String, String> baseToURI = new HashMap();
    private Model currentQualityMetadata;
    private String currentQMDBase;
    private String currentComputedOn;
    private String currentGraphURI;
    private Map<Resource, List<RankedObject>> metricRanking = new HashMap<Resource, List<RankedObject>>();
    private int isNaNMetrics = 0;
    private int isNaNDimension = 0;
    private Map<String, String> graphs = dsLoader.getAllGraphs();

    public List<RankedObject> rank(List<RankingConfiguration> rankingConfig) {
        return this.rank(rankingConfig, false);
    }

    public List<RankedObject> rank(List<RankingConfiguration> rankingConfig, boolean forceReloadCheck) {
        ArrayList<RankedObject> rankedObjects = new ArrayList<RankedObject>();
        if (forceReloadCheck) {
            this.graphs = dsLoader.getAllGraphs();
        }
        for (String base : this.graphs.keySet()) {
            String graph = this.graphs.get(base);
            this.currentQMDBase = base;
            this.currentQualityMetadata = d.getNamedModel(graph);
            this.currentComputedOn = base;
            Double rankedValue = 0.0;
            for (RankingConfiguration rc : rankingConfig) {
                if (rc.getType() == RankBy.CATEGORY) {
                    rankedValue = rankedValue + this.categoryValue(rc.getUriResource(), rc.getWeight());
                }
                if (rc.getType() == RankBy.DIMENSION) {
                    rankedValue = rankedValue + this.dimensionValue(rc.getUriResource(), rc.getWeight());
                }
                if (rc.getType() != RankBy.METRIC) continue;
                rankedValue = rankedValue + this.metricValue(rc.getUriResource(), rc.getWeight());
            }
            if (!rankedValue.isNaN()) {
                RankedObject ro = new RankedObject(this.currentComputedOn, rankedValue, this.currentGraphURI);
                rankedObjects.add(ro);
            }
            baseToURI.put(this.currentQMDBase, this.currentComputedOn);
        }
        Collections.sort(rankedObjects);
        Collections.reverse(rankedObjects);
        return rankedObjects;
    }

    private double metricValue(Resource metric, double weight) {
        double rankingValue = 0.0;
        logger.info("Ranking by Metric {}, with the weight of {}", (Object)metric.getURI(), (Object)weight);
        List lst = ObservationHelper.extractObservations((Model)this.currentQualityMetadata, (Resource)metric);
        if (lst.size() > 0) {
            Observation obs = ObservationHelper.getLatestObservation((List)lst);
            rankingValue = obs.getValue() * weight;
            this.currentComputedOn = obs.getComputedOn().getURI();
            this.currentGraphURI = obs.getGraphURI().getURI();
        } else {
            String graph;
            this.currentGraphURI = graph = dsLoader.getAllGraphs().get(this.currentComputedOn);
            String string = this.currentComputedOn = this.getComputedOn() != null ? this.getComputedOn() : this.currentComputedOn;
        }
        if (Double.valueOf(rankingValue).isNaN()) {
            ++this.isNaNMetrics;
            return 0.0;
        }
        return rankingValue;
    }

    private double dimensionValue(Resource dimension, double weight) {
        logger.info("Ranking by Dimension {}, with the weight of {}", (Object)dimension.getURI(), (Object)weight);
        String selectQuery = this.getSelectQuery("sparql/GetDimensionMetrics.sparql").replace("%dimension%", SPARQLHelper.toSPARQL((Resource)dimension));
        double totalNumberOfMetrics = 0.0;
        double summation = 0.0;
        this.isNaNMetrics = 0;
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Model)InternalModelConf.getFlatModel());
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            totalNumberOfMetrics += 1.0;
            Resource res = set.next().get("metric").asResource();
            RDFNode expectedType = InternalModelConf.getFlatModel().listObjectsOfProperty(res, DAQ.expectedDataType).next();
            if (expectedType.asResource().equals((Object)XSD.integer)) {
                summation += this.metricIntegerToPercentage(res, weight);
                continue;
            }
            summation += this.metricValue(res, weight);
        }
        if (totalNumberOfMetrics == 0.0) {
            logger.info("No dimensions available for the {} Dimension", (Object)dimension.getURI());
            return 0.0;
        }
        double dimensionRanking = summation / (totalNumberOfMetrics - (double)this.isNaNMetrics);
        logger.info("Ranking value for {} computed: {}", (Object)dimension.getURI(), (Object)dimensionRanking);
        if (Double.valueOf(dimensionRanking).isNaN()) {
            ++this.isNaNDimension;
            return 0.0;
        }
        return dimensionRanking;
    }

    private double categoryValue(Resource category, double weight) {
        logger.info("Ranking by Category {}, with the weight of {}", (Object)category.getURI(), (Object)weight);
        String selectQuery = this.getSelectQuery("sparql/GetCategoryDimensions.sparql").replace("%category%", SPARQLHelper.toSPARQL((Resource)category));
        double totalNumberOfDimensions = 0.0;
        double summation = 0.0;
        this.isNaNDimension = 0;
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Model)InternalModelConf.getFlatModel());
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            totalNumberOfDimensions += 1.0;
            Resource res = set.next().get("dimension").asResource();
            summation += this.dimensionValue(res, weight);
        }
        if (totalNumberOfDimensions == 0.0) {
            logger.info("No dimensions available for the {} Category", (Object)category.getURI());
            return 0.0;
        }
        double categoryRanking = summation / (totalNumberOfDimensions - (double)this.isNaNDimension);
        logger.info("Ranking value for {} computed: {}", (Object)category.getURI(), (Object)categoryRanking);
        return categoryRanking;
    }

    private String getSelectQuery(String fileName) {
        String selectQuery = "";
        URL url = Resources.getResource((String)fileName);
        try {
            selectQuery = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error: {}", (Object)e.getMessage());
        }
        return selectQuery;
    }

    private double metricIntegerToPercentage(Resource metric, double weight) {
        if (!this.metricRanking.containsKey(metric)) {
            Ranking r = new Ranking();
            ArrayList<RankingConfiguration> rankingConfig = new ArrayList<RankingConfiguration>();
            RankingConfiguration rc = new RankingConfiguration(metric, RankBy.METRIC, 1.0);
            rankingConfig.add(rc);
            List<RankedObject> ranks = r.rank(rankingConfig);
            this.metricRanking.put(metric, ranks);
        }
        List<RankedObject> ranks = this.metricRanking.get(metric);
        List<RelativePosition> relativeRanks = this.setRelativePosition(ranks);
        RelativePosition tmp = new RelativePosition(baseToURI.get(this.currentQMDBase), -1);
        int bottomPos = relativeRanks.get(relativeRanks.size() - 1).getPos();
        double val = 0.0;
        if (relativeRanks.get(relativeRanks.indexOf(tmp)).getPos() == 1) {
            val = 100.0;
        } else if (relativeRanks.get(relativeRanks.indexOf(tmp)).getPos() == bottomPos) {
            val = 0.0;
        } else {
            int thePos = relativeRanks.get(relativeRanks.indexOf(tmp)).getPos();
            val = ((double)ranks.size() + 1.0 - (double)thePos) * 100.0 / (double)ranks.size();
        }
        return val / 100.0 * weight;
    }

    public String getComputedOn() {
        String selectQuery = "SELECT ?cOn { graph <" + this.currentGraphURI + "> { ?s <" + DAQ.computedOn.getURI() + "> ?cOn } }";
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Dataset)dsLoader.getInternalDataset());
        ResultSet set = exec.execSelect();
        if (set.hasNext()) {
            QuerySolution qs = set.next();
            Resource computedOn = qs.getResource("cOn");
            return computedOn.getURI();
        }
        return null;
    }

    private List<RelativePosition> setRelativePosition(List<RankedObject> obj) {
        ArrayList<RelativePosition> lst = new ArrayList<RelativePosition>();
        int rank = 0;
        double lastValue = -1.0;
        for (RankedObject o : obj) {
            double val = o.getRankedValue();
            if (lastValue != val) {
                rank = obj.indexOf(o) + 1;
                lastValue = o.getRankedValue();
            }
            RelativePosition _rp = new RelativePosition(o.getDataset(), rank);
            lst.add(_rp);
        }
        return lst;
    }

    public List<RankedObject> rankIntegerBasedMetric(Resource metric) {
        ArrayList<RankedObject> rankedObjects = new ArrayList<RankedObject>();
        Map<String, String> graphs = dsLoader.getAllGraphs();
        for (String base : graphs.keySet()) {
            String graph = graphs.get(base);
            this.currentQMDBase = base;
            this.currentQualityMetadata = d.getNamedModel(graph);
            this.currentComputedOn = base;
            Double rankedValue = this.metricIntegerToPercentage(metric, 1.0);
            if (rankedValue.isNaN()) continue;
            RankedObject ro = new RankedObject(baseToURI.get(this.currentComputedOn), rankedValue, this.currentGraphURI);
            rankedObjects.add(ro);
        }
        Collections.sort(rankedObjects);
        Collections.reverse(rankedObjects);
        return rankedObjects;
    }

    private class RelativePosition {
        private int pos = 0;
        private String dataset = "";

        public RelativePosition(String dataset, int pos) {
            this.pos = pos;
            this.dataset = dataset;
        }

        public int getPos() {
            return this.pos;
        }

        public boolean equals(Object other) {
            if (other instanceof RelativePosition) {
                RelativePosition _other = (RelativePosition)other;
                return this.dataset.equals(_other.dataset);
            }
            return false;
        }

        public int hashCode() {
            return this.dataset.hashCode();
        }
    }
}

