/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.qml.datatypes;

import de.unibonn.iai.eis.luzzu.qml.datatypes.Action;
import de.unibonn.iai.eis.luzzu.qml.datatypes.Condition;
import de.unibonn.iai.eis.luzzu.qml.datatypes.ConditionType;
import de.unibonn.iai.eis.luzzu.qml.datatypes.Rule;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Metric {
    private static final String TYPEOF = "if ((quad.getObject().isURI()) && (quad.getObject().getURI().equals(%%VALUE%%))){ %%ACTION%% }";
    private static final String NORMAL = "if (%%VALUE%%){ %%ACTION%% }";
    private static final String IMPORT = "import %%package%%;";
    private Set<String> imports = new HashSet<String>();
    private Set<String> variables = new HashSet<String>();
    private Rule rule;
    private Action action;

    public Metric(Rule rule, Action action) {
        this.rule = rule;
        this.action = action;
    }

    public String getImports() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.imports) {
            sb.append(s);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public String getVariables() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.variables) {
            sb.append(s);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public String getComputeFunction() {
        if (this.action == Action.MAP) {
            this.imports.add("import java.util.Map;");
            this.imports.add("import java.util.HashMap;");
            this.imports.add("import com.hp.hpl.jena.graph.Node;");
            this.imports.add("import com.hp.hpl.jena.rdf.model.Resource;");
            this.imports.add("import com.hp.hpl.jena.sparql.core.Quad;");
            this.imports.add("import java.util.Set;");
            this.imports.add("import java.util.HashSet;");
            this.variables.add("private Map<Node, Set<String>> _hashMap = new HashMap<Node, Set<String>>();");
        }
        if (this.action == Action.COUNT) {
            this.variables.add("private int counter = 0;");
        }
        StringBuilder sb = new StringBuilder();
        for (List list : this.rule.getConditionList()) {
            for (Condition condition : list) {
                String s;
                if (condition.getConditionType() == ConditionType.TYPEOF) {
                    s = TYPEOF.replace("%%VALUE%%", condition.getRhs().replace("<", "\"").replace(">", "\""));
                    if (this.action == Action.MAP) {
                        s = s.replace("%%ACTION%%", "if (!(this._hashMap.containsKey(quad.getSubject()))) this._hashMap.put(quad.getSubject(), new HashSet<String>());");
                    } else if (this.action == Action.COUNT) {
                        s = s.replace("%%ACTION%%", "counter++;");
                    }
                    sb.append(s);
                }
                if (condition.getConditionType() != ConditionType.NORMAL) continue;
                s = NORMAL;
                String constraint = "";
                if (this.isIRI(condition.getRhs())) {
                    if (condition.getLhs() == "?s") {
                        constraint = constraint + "quad.getSubject().getURI()";
                    }
                    if (condition.getLhs() == "?p") {
                        constraint = constraint + "quad.getPredicate().getURI()";
                    }
                    if (condition.getLhs() == "?o") {
                        constraint = constraint + "quad.getObject().getURI()";
                    }
                } else if (condition.getLhs() == "?o") {
                    constraint = constraint + "quad.getObject().getLiteralValue()";
                }
                if (condition.getBooleanOperator().equals("==")) {
                    constraint = constraint + ".equals(%%CONSTRAINT%%)";
                }
                if (condition.getBooleanOperator().equals("!=")) {
                    constraint = "!(" + constraint + ".equals(%%CONSTRAINT%%)" + ")";
                }
                constraint = constraint.replace("%%CONSTRAINT%%", condition.getRhs().replace("<", "\"").replace(">", "\""));
                s = s.replace("%%VALUE%%", constraint);
                if (this.action == Action.MAP) {
                    s = s.replace("%%ACTION%%", "if (!(this._hashMap.containsKey(quad.getSubject()))) this._hashMap.put(quad.getSubject(), new HashSet<String>());Set<String> def = this._hashMap.get(quad.getSubject());def.add(quad.getObject().getLiteralValue().toString());this._hashMap.put(quad.getSubject(), def);");
                } else if (this.action == Action.COUNT) {
                    s = s.replace("%%ACTION%%", "counter++;");
                }
                sb.append(s);
            }
        }
        return sb.toString();
    }

    public String actionToJava() {
        StringBuilder sb = new StringBuilder();
        if (this.action == Action.MAP) {
            sb.append("int entitiesWithoutTerms = 0;");
            sb.append("for (Node n : _hashMap.keySet()){");
            sb.append("entitiesWithoutTerms += (this._hashMap.get(n).size() > 0) ? 1 : 0;");
            sb.append("}");
            sb.append("return  (double) entitiesWithoutTerms / (double) _hashMap.keySet().size();");
        }
        if (this.action == Action.COUNT) {
            sb.append("return counter;");
        }
        return sb.toString();
    }

    private boolean isIRI(String rhsCondition) {
        return rhsCondition.startsWith("<") && rhsCondition.endsWith(">");
    }
}

