/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.qml.parser;

import de.unibonn.iai.eis.luzzu.qml.datatypes.Action;
import de.unibonn.iai.eis.luzzu.qml.datatypes.Condition;
import de.unibonn.iai.eis.luzzu.qml.datatypes.ConditionType;
import de.unibonn.iai.eis.luzzu.qml.datatypes.Metric;
import de.unibonn.iai.eis.luzzu.qml.datatypes.Rule;
import de.unibonn.iai.eis.luzzu.qml.parser.LQMLParserConstants;
import de.unibonn.iai.eis.luzzu.qml.parser.LQMLParserTokenManager;
import de.unibonn.iai.eis.luzzu.qml.parser.ParseException;
import de.unibonn.iai.eis.luzzu.qml.parser.SimpleCharStream;
import de.unibonn.iai.eis.luzzu.qml.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LQMLParser
implements LQMLParserConstants {
    static Map<String, String> compilerMap;
    public LQMLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[5];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final Map<String, String> parse() throws ParseException {
        compilerMap = new HashMap<String, String>();
        this.extractHeader();
        compilerMap.put("[%%classname%%]", this.extractDefinitionName());
        compilerMap.put("[%%metricuri%%]", this.extractMetricURI());
        compilerMap.put("[%%label%%]", this.extractLabel());
        compilerMap.put("[%%description%%]", this.extractDescription());
        Rule r = this.extractRule();
        Action a = this.extractAction();
        Metric metric = new Metric(r, a);
        compilerMap.put("[%%computefunction%%]", metric.getComputeFunction());
        compilerMap.put("[%%imports%%]", metric.getImports());
        compilerMap.put("[%%variables%%]", metric.getVariables());
        compilerMap.put("[%%metricvaluefuntion%%]", metric.actionToJava());
        this.jj_consume_token(28);
        this.jj_consume_token(0);
        return compilerMap;
    }

    public final void extractHeader() throws ParseException {
        compilerMap.put("[%%author%%]", this.extractAuthor());
        compilerMap.put("[%%packagename%%]", this.extractPackage());
    }

    public final String extractAuthor() throws ParseException {
        String author = "";
        this.jj_consume_token(38);
        this.jj_consume_token(12);
        this.jj_consume_token(26);
        Token t = this.jj_consume_token(21);
        author = t.image.replace("\"", "");
        return author;
    }

    public final String extractPackage() throws ParseException {
        String pkg = "";
        this.jj_consume_token(38);
        this.jj_consume_token(13);
        this.jj_consume_token(26);
        Token t = this.jj_consume_token(21);
        pkg = t.image.replace("\"", "");
        return pkg;
    }

    public final String extractDefinitionName() throws ParseException {
        this.jj_consume_token(6);
        this.jj_consume_token(22);
        Token t = this.jj_consume_token(19);
        String s = t.image.replace("\"", "");
        this.jj_consume_token(23);
        this.jj_consume_token(26);
        return s;
    }

    public final String extractLabel() throws ParseException {
        this.jj_consume_token(7);
        this.jj_consume_token(22);
        Token t = this.jj_consume_token(21);
        String s = t.image.replace("\"", "");
        this.jj_consume_token(23);
        this.jj_consume_token(27);
        return s;
    }

    public final String extractDescription() throws ParseException {
        this.jj_consume_token(8);
        this.jj_consume_token(22);
        Token t = this.jj_consume_token(21);
        String s = t.image;
        this.jj_consume_token(23);
        this.jj_consume_token(27);
        return s;
    }

    public final Rule extractRule() throws ParseException {
        Rule r = new Rule();
        ArrayList<ArrayList<Condition>> conditionList = new ArrayList<ArrayList<Condition>>();
        this.jj_consume_token(9);
        this.jj_consume_token(22);
        ArrayList<Condition> condLst = new ArrayList<Condition>();
        this.extractCondition(condLst);
        conditionList.add(condLst);
        this.jj_consume_token(23);
        this.jj_consume_token(27);
        r.setConditionList(conditionList);
        return r;
    }

    public final void extractCondition(ArrayList<Condition> condLst) throws ParseException {
        this.jj_consume_token(24);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                Token t = this.jj_consume_token(14);
                condLst.add(this.extractTypeOf());
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                condLst.add(this.extractNonDefinedCondition());
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(37);
            this.extractCondition(condLst);
        }
        this.jj_consume_token(25);
    }

    public final Condition extractTypeOf() throws ParseException {
        Condition c = new Condition();
        this.jj_consume_token(24);
        this.jj_consume_token(39);
        this.jj_consume_token(25);
        Token t = this.jj_consume_token(30);
        c.setBooleanOperator(t.image);
        t = this.jj_consume_token(42);
        c.setConditionType(ConditionType.TYPEOF);
        c.setRhs(t.image);
        return c;
    }

    public final Condition extractNonDefinedCondition() throws ParseException {
        Token t3;
        Token t2;
        Condition c = new Condition();
        c.setConditionType(ConditionType.NORMAL);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                Token t = this.jj_consume_token(39);
                c.setLhs("?s");
                t2 = this.jj_consume_token(30);
                t3 = this.jj_consume_token(42);
                break;
            }
            case 40: {
                Token t = this.jj_consume_token(40);
                c.setLhs("?p");
                t2 = this.jj_consume_token(30);
                t3 = this.jj_consume_token(42);
                break;
            }
            case 41: {
                Token t = this.jj_consume_token(41);
                c.setLhs("?o");
                t2 = this.jj_consume_token(30);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: {
                        t3 = this.jj_consume_token(42);
                        break block0;
                    }
                    case 21: {
                        t3 = this.jj_consume_token(21);
                        break block0;
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        c.setBooleanOperator(t2.image);
        c.setRhs(t3.image);
        return c;
    }

    public final Action extractAction() throws ParseException {
        Action action;
        this.jj_consume_token(10);
        this.jj_consume_token(22);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                action = Action.MAP;
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                action = Action.COUNT;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(23);
        return action;
    }

    public final String extractMetricURI() throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(22);
        Token t = this.jj_consume_token(42);
        String s = t.image.replace("<", "").replace(">", "");
        this.jj_consume_token(23);
        this.jj_consume_token(27);
        return s;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x1000000, 0, 0x200000, 0, 98304};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 32, 1024, 896, 0};
    }

    public LQMLParser(InputStream stream) {
        this(stream, null);
    }

    public LQMLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new LQMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public LQMLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new LQMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public LQMLParser(LQMLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(LQMLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[43];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 5; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 43; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        LQMLParser.jj_la1_init_0();
        LQMLParser.jj_la1_init_1();
    }
}

